/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.owlapi3.rel.tms.model;

import eu.trowl.owlapi3.rel.tms.model.Atomic;
import eu.trowl.owlapi3.rel.tms.model.Basic;
import eu.trowl.owlapi3.rel.tms.model.Description;
import eu.trowl.owlapi3.rel.tms.model.ERestriction;
import eu.trowl.owlapi3.rel.tms.model.Individual;
import eu.trowl.owlapi3.rel.tms.model.Role;
import eu.trowl.owlapi3.rel.tms.model.Singleton;
import eu.trowl.owlapi3.rel.tms.model.Traceability;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;

public class Ontology {
    public int classNum = 0;
    public int permanentclassNum = 0;
    public int roleNum = 0;
    public int individualNum = 0;
    public HashMap<OWLClassExpression, Integer> classID = new HashMap();
    public HashMap<Integer, Description> descriptions = new HashMap();
    public HashMap<OWLObjectPropertyExpression, Integer> roleID = new HashMap();
    public HashMap<Integer, Role> roles = new HashMap();
    public HashMap<OWLIndividual, Integer> individualID = new HashMap();
    public HashMap<Integer, Individual> individuals = new HashMap();
    public HashMap<Role, HashMap<Basic, ERestriction>> simpleExistEntries = new HashMap();
    public HashSet<Basic> allconcepts = new HashSet();
    public HashSet<Role> reRoles = new HashSet();
    public boolean consistency = true;
    public HashSet<Traceability> inconsistencyJust = new HashSet();
    public boolean classified = false;
    public int tracekey = 0;

    public void write(BufferedWriter bw) {
        Atomic bot = (Atomic)this.descriptions.get(0);
        try {
            bw.write("classes as follows:\n");
            int i = 1;
            while (i < this.classNum) {
                if (!(this.descriptions.get(i) instanceof Singleton)) {
                    Atomic concept = (Atomic)this.descriptions.get(i);
                    if (concept.original) {
                        bw.write(String.valueOf(i) + " " + concept.uri.getFragment() + ": S(");
                        if (concept.subsumers.containsKey(bot)) {
                            bw.write("Nothing, ");
                            for (Basic basic : this.allconcepts) {
                                if (!(basic instanceof Atomic) || !basic.original) continue;
                                bw.write(String.valueOf(((Atomic)basic).uri.getFragment()) + ", ");
                            }
                        } else {
                            for (Basic basic : concept.subsumers.keySet()) {
                                if (!(basic instanceof Atomic) || !basic.original) continue;
                                bw.write(String.valueOf(((Atomic)basic).uri.getFragment()) + ", ");
                            }
                        }
                        bw.write(")\n");
                    }
                }
                ++i;
            }
            bw.write("\n");
            bw.write("roles as follows:\n");
            i = 0;
            while (i < this.roleNum) {
                Role role = this.roles.get(i);
                if (role.original) {
                    bw.write(String.valueOf(i) + " " + role.uri.getFragment() + ": S(");
                    for (Role role2 : role.subsumers.keySet()) {
                        if (!role2.original) continue;
                        bw.write(String.valueOf(role2.uri.getFragment()) + ", ");
                    }
                    bw.write(")\n R(");
                    for (Map.Entry entry : role.Relations.entrySet()) {
                        Basic classA = (Basic)entry.getKey();
                        if (!classA.original || classA instanceof Singleton) continue;
                        for (Basic classB : ((HashMap)entry.getValue()).keySet()) {
                            if (!classB.original || !(classB instanceof Atomic)) continue;
                            bw.write("(" + ((Atomic)classA).uri.getFragment() + ", " + ((Atomic)classB).uri.getFragment() + "), ");
                        }
                    }
                    bw.write(")\n");
                }
                ++i;
            }
            bw.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int countsubsumers() {
        int num = 0;
        Atomic bot = (Atomic)this.descriptions.get(0);
        int allnum = 0;
        allnum = this.allconcepts.size() + 1;
        int i = 1;
        while (i < this.classNum) {
            Basic concept = (Basic)this.descriptions.get(i);
            if (concept.original && !(concept instanceof Singleton)) {
                if (concept.subsumers.containsKey(bot)) {
                    num += allnum;
                } else {
                    for (Basic subsumer : concept.subsumers.keySet()) {
                        if (!subsumer.original || !(subsumer instanceof Atomic)) continue;
                        ++num;
                    }
                }
            }
            ++i;
        }
        System.out.println(num);
        return num;
    }

    public void getunsatisfiableconcepts() {
        int num = 0;
        Atomic bot = (Atomic)this.descriptions.get(0);
        ArrayList<IRI> unsatisfiables = new ArrayList<IRI>();
        int i = 2;
        while (i < this.classNum) {
            Atomic concept = (Atomic)this.descriptions.get(i);
            if (concept.original && concept.subsumers.containsKey(bot)) {
                ++num;
                unsatisfiables.add(concept.uri);
            }
            ++i;
        }
        System.out.println("There are " + num + " unsatisfiable concepts");
        for (IRI uri : unsatisfiables) {
            System.out.println(uri.getFragment());
        }
    }
}

