/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.owlapi3.rel.tms.factory.el;

import eu.trowl.owlapi3.rel.tms.factory.el.OWL2DLAxiomVisitor;
import eu.trowl.owlapi3.rel.tms.model.And;
import eu.trowl.owlapi3.rel.tms.model.Atomic;
import eu.trowl.owlapi3.rel.tms.model.Basic;
import eu.trowl.owlapi3.rel.tms.model.Description;
import eu.trowl.owlapi3.rel.tms.model.ERestriction;
import eu.trowl.owlapi3.rel.tms.model.Implies;
import eu.trowl.owlapi3.rel.tms.model.Ontology;
import eu.trowl.owlapi3.rel.tms.model.Role;
import eu.trowl.owlapi3.rel.tms.model.Some;
import eu.trowl.owlapi3.rel.tms.model.Traceability;
import eu.trowl.owlapi3.rel.util.Generator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.UnknownOWLOntologyException;

public class OntologyBuilder
extends OWL2DLAxiomVisitor {
    protected static final String CLASS_PREFIX = "RELAPPROX#RELAPPROXC";
    protected static final String ROLE_PREFIX = "RELAPPROX#RELAPPROXR";
    protected static final String CARDIN_PREFIX = "RELAPPROXQ";
    protected static final String INDI_PREFIX = "RELAPPROX#RELAPPROXI";
    protected Ontology elcontology;
    protected HashMap<OWLClassExpression, Integer> classID;
    protected HashMap<OWLObjectPropertyExpression, Integer> propertyID;
    protected HashMap<Integer, Description> descriptions;
    protected HashMap<Integer, Role> roles;
    public HashSet<OWLIndividual> constants = new HashSet();
    protected HashSet<Basic> allconcepts;
    protected HashMap<ArrayList<Role>, Role> chainName = new HashMap();
    public HashMap<Atomic, HashMap<Integer, Atomic>> CardinalityTable = new HashMap();
    protected int classindex = 0;
    protected int nonbasicindex = -2;
    protected int propertyindex = 0;
    protected int impliesID;
    public int tracekey = 0;
    protected final Map<Description, Atomic> normalisationNames = new HashMap<Description, Atomic>();
    protected Atomic top = null;
    protected Atomic bot = null;
    protected OWLDataFactory factory = null;
    public boolean output = false;
    protected String logical;
    protected String physical;
    protected OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    protected OWLDataFactory approxfactory = this.manager.getOWLDataFactory();
    protected Set<OWLAxiom> axioms = new HashSet<OWLAxiom>();

    public void startOutput(String out) throws OWLOntologyCreationException {
        this.output = true;
        this.logical = "http://www.rel.com/classified";
        this.physical = out;
    }

    public void endOutput() throws OWLOntologyChangeException, UnknownOWLOntologyException, OWLOntologyStorageException, OWLOntologyCreationException {
        for (Role role : this.elcontology.roles.values()) {
            for (Role role2 : role.subsumers.keySet()) {
                if (role.equals(role2)) continue;
                this.axioms.add((OWLAxiom)this.approxfactory.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)this.getOWL(role), (OWLObjectPropertyExpression)this.getOWL(role2)));
            }
            for (Map.Entry entry : role.RightComposition.entrySet()) {
                for (Role right : ((HashMap)entry.getValue()).keySet()) {
                    ArrayList<OWLObjectProperty> left = new ArrayList<OWLObjectProperty>();
                    left.add(this.getOWL(role));
                    left.add(this.getOWL((Role)entry.getKey()));
                    this.axioms.add((OWLAxiom)this.approxfactory.getOWLSubPropertyChainOfAxiom(left, (OWLObjectPropertyExpression)this.getOWL(right)));
                }
            }
        }
        Generator.generate(this.logical, this.physical, this.axioms);
    }

    public OntologyBuilder(Set<OWLOntology> ontologies, OWLOntologyManager manager, Ontology ELContology) {
        super(true);
        this.factory = manager.getOWLDataFactory();
        this.elcontology = ELContology;
        this.classID = this.elcontology.classID;
        this.propertyID = this.elcontology.roleID;
        this.descriptions = this.elcontology.descriptions;
        this.roles = this.elcontology.roles;
        this.allconcepts = this.elcontology.allconcepts;
        OWLClass thing = this.factory.getOWLThing();
        OWLClass nothing = this.factory.getOWLNothing();
        this.top = new Atomic(thing);
        this.top.id = 1;
        this.top.original = true;
        this.bot = new Atomic(nothing);
        this.bot.id = 0;
        this.bot.original = true;
        this.classID.put((OWLClassExpression)nothing, 0);
        this.classID.put((OWLClassExpression)thing, 1);
        this.allconcepts.add(this.top);
        this.classindex = 2;
        this.descriptions.put(0, this.bot);
        this.imply(this.bot);
        this.descriptions.put(1, this.top);
        this.imply(this.top);
        this.initialise(ontologies);
    }

    protected void initialise(Set<OWLOntology> ontologies) {
        OWLClass thing = this.factory.getOWLThing();
        OWLClass nothing = this.factory.getOWLNothing();
        OWLClass namedindividual = this.factory.getOWLClass(IRI.create((String)"http://www.w3.org/2002/07/owl#NamedIndividual"));
        for (OWLOntology ontology : ontologies) {
            for (OWLClass concept : ontology.getClassesInSignature()) {
                if (concept.equals(thing) || concept.equals(nothing) || concept.equals(namedindividual)) continue;
                Atomic newconcept = new Atomic(concept);
                ++this.classindex;
                newconcept.id = newconcept.id;
                this.classID.put((OWLClassExpression)concept, newconcept.id);
                this.descriptions.put(newconcept.id, newconcept);
                this.imply(newconcept);
                this.allconcepts.add(newconcept);
            }
        }
        for (OWLOntology ontology : ontologies) {
            for (OWLObjectProperty role : ontology.getObjectPropertiesInSignature()) {
                Role newrole = new Role(role, this.propertyindex++);
                this.propertyID.put((OWLObjectPropertyExpression)role, newrole.id);
                this.roles.put(newrole.id, newrole);
            }
        }
        for (OWLOntology ontology : ontologies) {
            for (OWLDataProperty drole : ontology.getDataPropertiesInSignature()) {
                OWLObjectProperty role = this.factory.getOWLObjectProperty(drole.getIRI());
                Role newrole = new Role(role, this.propertyindex++);
                newrole.original = false;
                this.propertyID.put((OWLObjectPropertyExpression)role, newrole.id);
                this.roles.put(newrole.id, newrole);
            }
        }
    }

    public void add(OWLOntology toAdd) {
        OWLClass thing = this.factory.getOWLThing();
        OWLClass nothing = this.factory.getOWLNothing();
        OWLClass namedindividual = this.factory.getOWLClass(IRI.create((String)"http://www.w3.org/2002/07/owl#NamedIndividual"));
        for (OWLClass concept : toAdd.getClassesInSignature()) {
            if (concept.equals(thing) || concept.equals(nothing) || concept.equals(namedindividual) || this.elcontology.classID.get(concept) != null) continue;
            Atomic newconcept = new Atomic(concept);
            ++this.classindex;
            newconcept.id = newconcept.id;
            this.classID.put((OWLClassExpression)concept, newconcept.id);
            this.descriptions.put(newconcept.id, newconcept);
            this.imply(newconcept);
            this.allconcepts.add(newconcept);
        }
        for (OWLObjectProperty role : toAdd.getObjectPropertiesInSignature()) {
            if (this.elcontology.roleID.get(role) != null) continue;
            Role newrole = new Role(role, this.propertyindex++);
            this.propertyID.put((OWLObjectPropertyExpression)role, newrole.id);
            this.roles.put(newrole.id, newrole);
        }
    }

    public Ontology getELOntology() {
        return this.elcontology;
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        OWLClassExpression sub = axiom.getSubClass();
        for (OWLObjectProperty prop : sub.getObjectPropertiesInSignature()) {
            this.getRole((OWLObjectPropertyExpression)prop).related = true;
        }
        OWLClassExpression sup = axiom.getSuperClass();
        this.approximate(this.getNNF(sub), this.getNNF(sup), (OWLLogicalAxiom)axiom);
    }

    protected void approximate(OWLClassExpression sub, OWLClassExpression sup, OWLLogicalAxiom axiom) {
        Description lhs = this.getDescription(sub);
        Description rhs = this.getDescription(sup);
        Traceability trace = new Traceability();
        trace.add(axiom);
        this.normalise(lhs, rhs, trace);
    }

    protected void tracedapproximate(OWLClassExpression sub, OWLClassExpression sup, Traceability trace) {
        Description lhs = this.getDescription(sub);
        Description rhs = this.getDescription(sup);
        this.normalise(lhs, rhs, trace);
    }

    protected Description getDescription(OWLClassExpression concept) {
        Description NC = null;
        if (this.classID.get(concept) != null) {
            NC = this.descriptions.get(this.classID.get(concept));
        } else if (concept instanceof OWLObjectIntersectionOf) {
            OWLObjectIntersectionOf intersection = (OWLObjectIntersectionOf)concept;
            HashSet<Description> interapprox = new HashSet<Description>();
            for (OWLClassExpression des : intersection.getOperands()) {
                Description desapprox = this.getDescription(des);
                interapprox.add(desapprox);
            }
            NC = new And(interapprox);
            NC.id = this.nonbasicindex--;
            this.classID.put(concept, NC.id);
            this.descriptions.put(NC.id, NC);
        } else if (concept instanceof OWLObjectSomeValuesFrom) {
            OWLObjectSomeValuesFrom some = (OWLObjectSomeValuesFrom)concept;
            OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)some.getProperty();
            Role role = this.getRole(property);
            Some someA = new Some(role, this.getDescription((OWLClassExpression)some.getFiller()));
            NC = someA;
            NC.id = this.nonbasicindex--;
            this.classID.put(concept, NC.id);
            this.descriptions.put(NC.id, NC);
        } else {
            Atomic NCA = new Atomic();
            NCA.uri = IRI.create((String)(CLASS_PREFIX + this.classindex));
            NCA.id = this.classindex++;
            NCA.original = false;
            this.classID.put(concept, NCA.id);
            this.descriptions.put(NCA.id, NCA);
            this.imply(NCA);
            NC = NCA;
        }
        return NC;
    }

    public Role getRole(OWLObjectPropertyExpression property) {
        Role RN = null;
        if (this.propertyID.get(property) != null) {
            RN = this.roles.get(this.propertyID.get(property));
        } else if (property instanceof OWLObjectProperty) {
            OWLObjectProperty atomicrole = (OWLObjectProperty)property;
            RN = new Role(atomicrole, this.propertyindex++);
            this.propertyID.put(property, RN.id);
            this.roles.put(RN.id, RN);
        }
        return RN;
    }

    public Role getRole(OWLDataPropertyExpression property) {
        Role RN = null;
        if (property instanceof OWLDataProperty) {
            OWLObjectProperty oproperty = this.factory.getOWLObjectProperty(((OWLDataProperty)property).getIRI());
            RN = this.roles.get(this.propertyID.get(oproperty));
        }
        return RN;
    }

    private void normaliseRoleChain(ArrayList<Role> lhs, Role rhs, OWLLogicalAxiom axiom) {
        if (lhs.size() > 2) {
            Role roleR2 = lhs.remove(lhs.size() - 1);
            Role roleR1 = this.getChainName(lhs);
            HashMap<Role, Traceability> superroles = roleR1.RightComposition.get(roleR2);
            if (superroles == null) {
                superroles = new HashMap();
                roleR1.RightComposition.put(roleR2, superroles);
            }
            Traceability newtrace = new Traceability();
            newtrace.add(axiom);
            superroles.put(rhs, newtrace);
            this.normaliseRoleChain(lhs, roleR1, axiom);
        } else {
            Role roleR1 = lhs.get(0);
            Role roleR2 = lhs.get(1);
            HashMap<Role, Traceability> superroles = roleR1.RightComposition.get(roleR2);
            if (superroles == null) {
                superroles = new HashMap();
                roleR1.RightComposition.put(roleR2, superroles);
            }
            Traceability newtrace = new Traceability();
            newtrace.add(axiom);
            superroles.put(rhs, newtrace);
        }
    }

    private Role getChainName(ArrayList<Role> chain) {
        Role name = this.chainName.get(chain);
        if (name == null) {
            name = new Role(this.propertyindex);
            name.uri = IRI.create((String)(ROLE_PREFIX + this.propertyindex));
            name.original = false;
            this.chainName.put(chain, name);
            this.roles.put(name.id, name);
            ++this.propertyindex;
        }
        return name;
    }

    public void OrderingCardinality() {
        if (this.constants.size() > 0) {
            OWLDifferentIndividualsAxiom axiom = this.factory.getOWLDifferentIndividualsAxiom(this.constants);
            this.visit(axiom);
        }
        this.elcontology.classNum = this.classindex;
        this.elcontology.roleNum = this.propertyindex;
        this.elcontology.tracekey = this.tracekey;
    }

    public void OrderingCardinality(OWLOntology toAdd) {
        this.elcontology.classNum = this.classindex;
        this.elcontology.roleNum = this.propertyindex;
        this.elcontology.tracekey = this.tracekey;
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        Traceability newtrace = new Traceability();
        newtrace.add((OWLLogicalAxiom)axiom);
        this.getRole((OWLObjectPropertyExpression)((OWLObjectPropertyExpression)axiom.getSubProperty())).subsumers.put(this.getRole((OWLObjectPropertyExpression)axiom.getSuperProperty()), newtrace);
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        Traceability newtrace = new Traceability();
        newtrace.add((OWLLogicalAxiom)axiom);
        this.getRole((OWLDataPropertyExpression)((OWLDataPropertyExpression)axiom.getSubProperty())).subsumers.put(this.getRole((OWLDataPropertyExpression)axiom.getSuperProperty()), newtrace);
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        ArrayList<Role> lhs = new ArrayList<Role>();
        for (OWLObjectPropertyExpression role : axiom.getPropertyChain()) {
            lhs.add(this.getRole(role));
        }
        Role rhs = this.getRole(axiom.getSuperProperty());
        this.elcontology.reRoles.addAll(lhs);
        this.elcontology.reRoles.add(rhs);
        this.normaliseRoleChain(lhs, rhs, (OWLLogicalAxiom)axiom);
    }

    public void tracedvisit(OWLSubPropertyChainOfAxiom axiom, OWLLogicalAxiom trace) {
        ArrayList<Role> lhs = new ArrayList<Role>();
        for (OWLObjectPropertyExpression role : axiom.getPropertyChain()) {
            lhs.add(this.getRole(role));
        }
        Role rhs = this.getRole(axiom.getSuperProperty());
        this.elcontology.reRoles.addAll(lhs);
        this.elcontology.reRoles.add(rhs);
        this.normaliseRoleChain(lhs, rhs, trace);
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        System.out.println("This configuration does not support individual.");
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        System.out.println("This configuration does not support individual.");
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        System.out.println("This configuration does not support individual.");
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        OWLObjectSomeValuesFrom exist = this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)this.factory.getOWLThing());
        Description lhs = this.getDescription(this.getNNF((OWLClassExpression)exist));
        this.getRole((OWLObjectPropertyExpression)((OWLObjectPropertyExpression)axiom.getProperty())).related = true;
        Description rhs = this.getDescription(this.getNNF(axiom.getDomain()));
        Traceability trace = new Traceability();
        trace.add((OWLLogicalAxiom)axiom);
        this.normalise(lhs, rhs, trace);
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        OWLObjectSomeValuesFrom exist = this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty().getIRI()), (OWLClassExpression)this.factory.getOWLThing());
        this.getRole((OWLDataPropertyExpression)((OWLDataPropertyExpression)axiom.getProperty())).related = true;
        Description lhs = this.getDescription(this.getNNF((OWLClassExpression)exist));
        Description rhs = this.getDescription(this.getNNF(axiom.getDomain()));
        Traceability trace = new Traceability();
        trace.add((OWLLogicalAxiom)axiom);
        this.normalise(lhs, rhs, trace);
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        OWLClassExpression range = (OWLClassExpression)axiom.getRange();
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        this.getRole((OWLObjectPropertyExpression)property).related = true;
        OWLObjectSomeValuesFrom some = this.factory.getOWLObjectSomeValuesFrom(property, (OWLClassExpression)this.factory.getOWLObjectComplementOf(range));
        Traceability trace = new Traceability();
        trace.add((OWLLogicalAxiom)axiom);
        this.normalise(this.getDescription(this.getNNF((OWLClassExpression)some)), this.bot, trace);
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        OWLDataRange range = (OWLDataRange)axiom.getRange();
        OWLDataPropertyExpression property = (OWLDataPropertyExpression)axiom.getProperty();
        this.getRole((OWLDataPropertyExpression)property).related = true;
        OWLDataSomeValuesFrom some = this.factory.getOWLDataSomeValuesFrom(property, (OWLDataRange)this.factory.getOWLDataComplementOf(range));
        Traceability trace = new Traceability();
        trace.add((OWLLogicalAxiom)axiom);
        this.normalise(this.getDescription(this.getNNF((OWLClassExpression)some)), this.bot, trace);
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        Traceability trace = new Traceability();
        trace.add((OWLLogicalAxiom)axiom);
        for (OWLClassExpression c : axiom.getClassExpressions()) {
            for (OWLObjectProperty prop : c.getObjectPropertiesInSignature()) {
                this.getRole((OWLObjectPropertyExpression)prop).related = true;
            }
            for (OWLClassExpression d : axiom.getClassExpressions()) {
                if (c.equals(d)) continue;
                Description cdes = this.getDescription(this.getNNF(c));
                Description ddes = this.getDescription(this.getNNF(d));
                this.normalise(cdes, ddes, trace);
            }
        }
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        Traceability trace = new Traceability();
        trace.add((OWLLogicalAxiom)axiom);
        for (OWLObjectPropertyExpression r : axiom.getProperties()) {
            for (OWLObjectPropertyExpression s : axiom.getProperties()) {
                if (r.equals(s)) continue;
                Role roler = this.getRole(r);
                Role roles = this.getRole(s);
                roler.subsumers.put(roles, trace);
            }
        }
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        Traceability trace = new Traceability();
        trace.add((OWLLogicalAxiom)axiom);
        for (OWLDataPropertyExpression r : axiom.getProperties()) {
            for (OWLDataPropertyExpression s : axiom.getProperties()) {
                if (r.equals(s)) continue;
                Role roler = this.getRole(r);
                Role roles = this.getRole(s);
                roler.subsumers.put(roles, trace);
            }
        }
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        OWLSubPropertyChainOfAxiom rewritten = this.factory.getOWLSubPropertyChainOfAxiom(Arrays.asList((OWLObjectPropertyExpression)axiom.getProperty(), (OWLObjectPropertyExpression)axiom.getProperty()), (OWLObjectPropertyExpression)axiom.getProperty());
        this.tracedvisit(rewritten, (OWLLogicalAxiom)axiom);
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        System.out.println("This configuration does not support individual.");
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        System.out.println("This configuration does not support individual.");
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        Description lhs = this.getDescription((OWLClassExpression)this.factory.getOWLObjectMinCardinality(2, property, (OWLClassExpression)this.factory.getOWLThing()));
        Traceability trace = new Traceability();
        trace.add((OWLLogicalAxiom)axiom);
        this.normalise(lhs, this.bot, trace);
        Role role = this.getRole(property);
        role.functional = true;
        role.functrace = trace;
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        OWLDataPropertyExpression property = (OWLDataPropertyExpression)axiom.getProperty();
        Description lhs = this.getDescription((OWLClassExpression)this.factory.getOWLObjectMinCardinality(2, (OWLObjectPropertyExpression)this.factory.getOWLObjectProperty(property.asOWLDataProperty().getIRI()), (OWLClassExpression)this.factory.getOWLThing()));
        Traceability trace = new Traceability();
        trace.add((OWLLogicalAxiom)axiom);
        this.normalise(lhs, this.bot, trace);
        Role role = this.getRole(property);
        role.functional = true;
        role.functrace = trace;
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        Description lhs = this.getDescription((OWLClassExpression)this.factory.getOWLObjectMinCardinality(2, property.getInverseProperty(), (OWLClassExpression)this.factory.getOWLThing()));
        Traceability trace = new Traceability();
        trace.add((OWLLogicalAxiom)axiom);
        this.normalise(lhs, this.bot, trace);
        Role role = this.getRole(property.getInverseProperty());
        role.functional = true;
        role.functrace = trace;
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        Traceability trace = new Traceability();
        trace.add((OWLLogicalAxiom)axiom);
        HashSet<OWLClassExpression> dess = new HashSet<OWLClassExpression>();
        for (OWLClassExpression des1 : axiom.getClassExpressions()) {
            for (OWLClassExpression desc : dess) {
                OWLClassExpression des2 = this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf(desc));
                Description lhs = this.getDescription(this.getNNF(des1));
                Description rhs = this.getDescription(des2);
                this.normalise(lhs, rhs, trace);
            }
            dess.add(des1);
        }
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        System.out.println("This configuration does not support inverse property.");
    }

    protected OWLClassExpression getNNF(OWLClassExpression concept) {
        Object nnf = null;
        if (concept.isOWLThing() || concept.isOWLNothing() || concept instanceof OWLClass || concept instanceof OWLObjectOneOf || concept instanceof OWLObjectHasSelf) {
            nnf = concept;
        } else if (concept instanceof OWLObjectComplementOf) {
            OWLObjectComplementOf comp = (OWLObjectComplementOf)concept;
            OWLClassExpression des = comp.getOperand();
            if (des.isOWLThing()) {
                nnf = this.factory.getOWLNothing();
            } else if (des.isOWLNothing()) {
                nnf = this.factory.getOWLThing();
            } else if (des instanceof OWLClass) {
                nnf = concept;
            } else if (des instanceof OWLObjectComplementOf) {
                OWLObjectComplementOf doublecomp = (OWLObjectComplementOf)des;
                nnf = doublecomp.getOperand();
            } else if (des instanceof OWLObjectIntersectionOf) {
                OWLObjectIntersectionOf intersection = (OWLObjectIntersectionOf)des;
                HashSet<OWLClassExpression> interNNF = new HashSet<OWLClassExpression>();
                for (OWLClassExpression inter : intersection.getOperands()) {
                    interNNF.add(this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf(inter)));
                }
                nnf = this.factory.getOWLObjectUnionOf(interNNF);
            } else if (des instanceof OWLObjectUnionOf) {
                OWLObjectUnionOf union = (OWLObjectUnionOf)des;
                HashSet<OWLClassExpression> uniNNF = new HashSet<OWLClassExpression>();
                for (OWLClassExpression uni : union.getOperands()) {
                    uniNNF.add(this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf(uni)));
                }
                nnf = this.factory.getOWLObjectIntersectionOf(uniNNF);
            } else if (des instanceof OWLObjectSomeValuesFrom) {
                OWLObjectSomeValuesFrom some = (OWLObjectSomeValuesFrom)des;
                OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)some.getProperty();
                OWLClassExpression filler = (OWLClassExpression)some.getFiller();
                nnf = this.factory.getOWLObjectAllValuesFrom(property, this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf(filler)));
            } else if (des instanceof OWLObjectAllValuesFrom) {
                OWLObjectAllValuesFrom all = (OWLObjectAllValuesFrom)des;
                OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)all.getProperty();
                OWLClassExpression filler = (OWLClassExpression)all.getFiller();
                nnf = this.factory.getOWLObjectSomeValuesFrom(property, this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf(filler)));
            } else if (des instanceof OWLObjectMinCardinality) {
                OWLObjectMinCardinality min = (OWLObjectMinCardinality)des;
                OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)min.getProperty();
                OWLClassExpression filler = (OWLClassExpression)min.getFiller();
                int card = min.getCardinality();
                nnf = card >= 1 ? this.factory.getOWLObjectMaxCardinality(card - 1, property, this.getNNF(filler)) : this.factory.getOWLNothing();
            } else if (des instanceof OWLObjectMaxCardinality) {
                OWLObjectMaxCardinality max = (OWLObjectMaxCardinality)des;
                OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)max.getProperty();
                OWLClassExpression filler = (OWLClassExpression)max.getFiller();
                int card = max.getCardinality();
                nnf = this.factory.getOWLObjectMinCardinality(card + 1, property, this.getNNF(filler));
            } else if (des instanceof OWLObjectExactCardinality) {
                OWLObjectExactCardinality exact = (OWLObjectExactCardinality)des;
                if (exact.getCardinality() >= 1) {
                    OWLObjectMaxCardinality low = this.factory.getOWLObjectMaxCardinality(exact.getCardinality() - 1, (OWLObjectPropertyExpression)exact.getProperty(), this.getNNF((OWLClassExpression)exact.getFiller()));
                    OWLObjectMinCardinality high = this.factory.getOWLObjectMinCardinality(exact.getCardinality() + 1, (OWLObjectPropertyExpression)exact.getProperty(), this.getNNF((OWLClassExpression)exact.getFiller()));
                    nnf = this.factory.getOWLObjectUnionOf(new OWLClassExpression[]{low, high});
                } else {
                    nnf = this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)exact.getProperty(), this.getNNF((OWLClassExpression)exact.getFiller()));
                }
            } else if (des instanceof OWLObjectOneOf) {
                nnf = concept;
            } else if (des instanceof OWLObjectHasValue) {
                OWLObjectHasValue value = (OWLObjectHasValue)des;
                nnf = this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)value.getProperty(), (OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)this.factory.getOWLObjectOneOf(new OWLIndividual[]{(OWLIndividual)value.getValue()})));
            } else if (des instanceof OWLDataSomeValuesFrom) {
                OWLDataSomeValuesFrom some = (OWLDataSomeValuesFrom)des;
                OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)some.getProperty()).asOWLDataProperty().getIRI());
                nnf = this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)this.factory.getOWLDataComplementOf((OWLDataRange)some.getFiller())));
            } else if (des instanceof OWLDataAllValuesFrom) {
                OWLDataAllValuesFrom all = (OWLDataAllValuesFrom)des;
                OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)all.getProperty()).asOWLDataProperty().getIRI());
                nnf = this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)this.factory.getOWLDataComplementOf((OWLDataRange)all.getFiller())));
            } else if (des instanceof OWLDataHasValue) {
                OWLDataHasValue value = (OWLDataHasValue)des;
                OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)value.getProperty()).asOWLDataProperty().getIRI());
                OWLNamedIndividual indi = this.factory.getOWLNamedIndividual(IRI.create((String)(INDI_PREFIX + ((OWLLiteral)value.getValue()).getLiteral())));
                nnf = this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)property, (OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)this.factory.getOWLObjectOneOf(new OWLIndividual[]{indi})));
            } else if (des instanceof OWLDataMinCardinality) {
                OWLDataMinCardinality min = (OWLDataMinCardinality)des;
                OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)min.getProperty()).asOWLDataProperty().getIRI());
                OWLDataRange filler = (OWLDataRange)min.getFiller();
                int card = min.getCardinality();
                nnf = card >= 1 ? this.factory.getOWLObjectMaxCardinality(card - 1, (OWLObjectPropertyExpression)property, this.getNNF(filler)) : this.factory.getOWLNothing();
            } else if (des instanceof OWLDataMaxCardinality) {
                OWLDataMaxCardinality max = (OWLDataMaxCardinality)des;
                OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)max.getProperty()).asOWLDataProperty().getIRI());
                OWLDataRange filler = (OWLDataRange)max.getFiller();
                int card = max.getCardinality();
                nnf = this.factory.getOWLObjectMinCardinality(card + 1, (OWLObjectPropertyExpression)property, this.getNNF(filler));
            } else if (des instanceof OWLDataExactCardinality) {
                OWLDataExactCardinality exact = (OWLDataExactCardinality)des;
                OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)exact.getProperty()).asOWLDataProperty().getIRI());
                if (exact.getCardinality() >= 1) {
                    OWLObjectMaxCardinality low = this.factory.getOWLObjectMaxCardinality(exact.getCardinality() - 1, (OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)exact.getFiller()));
                    OWLObjectMinCardinality high = this.factory.getOWLObjectMinCardinality(exact.getCardinality() + 1, (OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)exact.getFiller()));
                    nnf = this.factory.getOWLObjectUnionOf(new OWLClassExpression[]{low, high});
                } else {
                    nnf = this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)exact.getFiller()));
                }
            } else {
                nnf = concept;
            }
        } else if (concept instanceof OWLObjectIntersectionOf) {
            OWLObjectIntersectionOf inter = (OWLObjectIntersectionOf)concept;
            HashSet<OWLClassExpression> interNNF = new HashSet<OWLClassExpression>();
            for (OWLClassExpression des : inter.getOperands()) {
                interNNF.add(this.getNNF(des));
            }
            nnf = this.factory.getOWLObjectIntersectionOf(interNNF);
        } else if (concept instanceof OWLObjectUnionOf) {
            OWLObjectUnionOf union = (OWLObjectUnionOf)concept;
            HashSet<OWLClassExpression> unionNNF = new HashSet<OWLClassExpression>();
            for (OWLClassExpression des : union.getOperands()) {
                unionNNF.add(this.getNNF(des));
            }
            nnf = this.factory.getOWLObjectUnionOf(unionNNF);
        } else if (concept instanceof OWLObjectSomeValuesFrom) {
            OWLObjectSomeValuesFrom some = (OWLObjectSomeValuesFrom)concept;
            OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)some.getProperty();
            nnf = this.factory.getOWLObjectSomeValuesFrom(property, this.getNNF((OWLClassExpression)some.getFiller()));
        } else if (concept instanceof OWLObjectAllValuesFrom) {
            OWLObjectAllValuesFrom all = (OWLObjectAllValuesFrom)concept;
            nnf = this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)all.getProperty(), this.getNNF((OWLClassExpression)all.getFiller()));
        } else if (concept instanceof OWLObjectMinCardinality) {
            OWLObjectMinCardinality min = (OWLObjectMinCardinality)concept;
            OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)min.getProperty();
            OWLClassExpression filler = (OWLClassExpression)min.getFiller();
            int card = min.getCardinality();
            nnf = card == 0 ? this.factory.getOWLThing() : (card == 1 ? this.factory.getOWLObjectSomeValuesFrom(property, this.getNNF(filler)) : this.factory.getOWLObjectMinCardinality(card, property, this.getNNF(filler)));
        } else if (concept instanceof OWLObjectMaxCardinality) {
            OWLObjectMaxCardinality max = (OWLObjectMaxCardinality)concept;
            OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)max.getProperty();
            OWLClassExpression filler = (OWLClassExpression)max.getFiller();
            int card = max.getCardinality();
            nnf = card < 1 ? this.factory.getOWLObjectAllValuesFrom(property, this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf(filler))) : this.factory.getOWLObjectMaxCardinality(card, property, this.getNNF(filler));
        } else if (concept instanceof OWLObjectExactCardinality) {
            OWLObjectExactCardinality exact = (OWLObjectExactCardinality)concept;
            if (exact.getCardinality() >= 1) {
                OWLObjectMaxCardinality low = this.factory.getOWLObjectMaxCardinality(exact.getCardinality(), (OWLObjectPropertyExpression)exact.getProperty(), this.getNNF((OWLClassExpression)exact.getFiller()));
                OWLObjectMinCardinality high = this.factory.getOWLObjectMinCardinality(exact.getCardinality(), (OWLObjectPropertyExpression)exact.getProperty(), this.getNNF((OWLClassExpression)exact.getFiller()));
                nnf = this.factory.getOWLObjectIntersectionOf(new OWLClassExpression[]{this.getNNF((OWLClassExpression)low), this.getNNF((OWLClassExpression)high)});
            } else {
                nnf = this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)exact.getProperty(), this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)exact.getFiller())));
            }
        } else if (concept instanceof OWLObjectHasValue) {
            OWLObjectHasValue value = (OWLObjectHasValue)concept;
            OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)value.getProperty();
            OWLIndividual indi = (OWLIndividual)value.getValue();
            nnf = this.factory.getOWLObjectSomeValuesFrom(property, (OWLClassExpression)this.factory.getOWLObjectOneOf(new OWLIndividual[]{indi}));
        } else if (concept instanceof OWLDataSomeValuesFrom) {
            OWLDataSomeValuesFrom some = (OWLDataSomeValuesFrom)concept;
            OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)some.getProperty()).asOWLDataProperty().getIRI());
            nnf = this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)some.getFiller()));
        } else if (concept instanceof OWLDataAllValuesFrom) {
            OWLDataAllValuesFrom all = (OWLDataAllValuesFrom)concept;
            OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)all.getProperty()).asOWLDataProperty().getIRI());
            nnf = this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)all.getFiller()));
        } else if (concept instanceof OWLDataHasValue) {
            OWLDataHasValue value = (OWLDataHasValue)concept;
            OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)value.getProperty()).asOWLDataProperty().getIRI());
            OWLNamedIndividual indi = this.factory.getOWLNamedIndividual(IRI.create((String)(INDI_PREFIX + ((OWLLiteral)value.getValue()).getLiteral())));
            this.constants.add((OWLIndividual)indi);
            nnf = this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)property, (OWLClassExpression)this.factory.getOWLObjectOneOf(new OWLIndividual[]{indi}));
        } else if (concept instanceof OWLDataMinCardinality) {
            OWLDataMinCardinality min = (OWLDataMinCardinality)concept;
            OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)min.getProperty()).asOWLDataProperty().getIRI());
            OWLDataRange filler = (OWLDataRange)min.getFiller();
            int card = min.getCardinality();
            nnf = card == 0 ? this.factory.getOWLThing() : (card == 1 ? this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)property, this.getNNF(filler)) : this.factory.getOWLObjectMinCardinality(card, (OWLObjectPropertyExpression)property, this.getNNF(filler)));
        } else if (concept instanceof OWLDataMaxCardinality) {
            OWLDataMaxCardinality max = (OWLDataMaxCardinality)concept;
            OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)max.getProperty()).asOWLDataProperty().getIRI());
            OWLDataRange filler = (OWLDataRange)max.getFiller();
            int card = max.getCardinality();
            nnf = card < 1 ? this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)this.factory.getOWLDataComplementOf(filler))) : this.factory.getOWLObjectMaxCardinality(card, (OWLObjectPropertyExpression)property, this.getNNF(filler));
        } else if (concept instanceof OWLDataExactCardinality) {
            OWLDataExactCardinality exact = (OWLDataExactCardinality)concept;
            OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)exact.getProperty()).asOWLDataProperty().getIRI());
            if (exact.getCardinality() >= 1) {
                OWLObjectMaxCardinality low = this.factory.getOWLObjectMaxCardinality(exact.getCardinality(), (OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)exact.getFiller()));
                OWLObjectMinCardinality high = this.factory.getOWLObjectMinCardinality(exact.getCardinality(), (OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)exact.getFiller()));
                nnf = this.factory.getOWLObjectIntersectionOf(new OWLClassExpression[]{this.getNNF((OWLClassExpression)low), this.getNNF((OWLClassExpression)high)});
            } else {
                nnf = this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)this.factory.getOWLDataComplementOf((OWLDataRange)exact.getFiller())));
            }
        } else {
            System.out.println("Can't get NNF for " + concept);
            nnf = concept;
        }
        return nnf;
    }

    private OWLClassExpression getNNF(OWLDataRange data) {
        OWLClass NC = null;
        if (data.isDatatype()) {
            OWLClass dataclass;
            OWLDatatype type = data.asOWLDatatype();
            NC = dataclass = this.factory.getOWLClass(type.getIRI());
        } else if (data instanceof OWLDataComplementOf) {
            OWLDataComplementOf comp = (OWLDataComplementOf)data;
            OWLDataRange des = comp.getDataRange();
            NC = this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf(this.getNNF(des)));
        } else if (data instanceof OWLDataIntersectionOf) {
            OWLDataIntersectionOf intesect = (OWLDataIntersectionOf)data;
            HashSet<OWLClassExpression> clss = new HashSet<OWLClassExpression>();
            for (OWLDataRange rng : intesect.getOperands()) {
                clss.add(this.getNNF(rng));
            }
            NC = this.getNNF((OWLClassExpression)this.factory.getOWLObjectIntersectionOf(clss));
        } else if (data instanceof OWLDataUnionOf) {
            OWLDataUnionOf union = (OWLDataUnionOf)data;
            HashSet<OWLClassExpression> clss = new HashSet<OWLClassExpression>();
            for (OWLDataRange rng : union.getOperands()) {
                clss.add(this.getNNF(rng));
            }
            NC = this.getNNF((OWLClassExpression)this.factory.getOWLObjectUnionOf(clss));
        } else if (data instanceof OWLDataOneOf) {
            OWLDataOneOf oneof = (OWLDataOneOf)data;
            HashSet<OWLNamedIndividual> concepts = new HashSet<OWLNamedIndividual>();
            for (OWLLiteral constant : oneof.getValues()) {
                OWLNamedIndividual individual = this.factory.getOWLNamedIndividual(IRI.create((String)(INDI_PREFIX + constant.getLiteral())));
                this.constants.add((OWLIndividual)individual);
                concepts.add(individual);
            }
            NC = this.factory.getOWLObjectOneOf(concepts);
        } else if (data instanceof OWLDatatypeRestriction) {
            OWLDatatypeRestriction rest = (OWLDatatypeRestriction)data;
            HashSet<Object> exps = new HashSet<Object>();
            exps.add(this.getNNF((OWLDataRange)rest.getDatatype()));
            for (OWLFacetRestriction facet : rest.getFacetRestrictions()) {
                exps.add(this.factory.getOWLObjectHasValue((OWLObjectPropertyExpression)this.factory.getOWLObjectProperty(facet.getFacet().getIRI()), (OWLIndividual)this.factory.getOWLNamedIndividual(IRI.create((String)(INDI_PREFIX + facet.getFacetValue())))));
            }
            NC = this.factory.getOWLObjectIntersectionOf(exps);
        }
        return NC;
    }

    public void normalise(Description lhs, Description rhs, Traceability trace) {
        if (lhs instanceof And) {
            And and = (And)lhs;
            HashSet<Description> descriptions = and.operands;
            HashSet<Basic> normalised = new HashSet<Basic>();
            for (Description CHat : descriptions) {
                if (!(CHat instanceof Basic)) {
                    Atomic A = this.getNamedClass(CHat);
                    normalised.add(A);
                    this.normalise(CHat, A, null);
                    continue;
                }
                normalised.add((Basic)CHat);
            }
            Basic B = null;
            if (rhs instanceof Basic) {
                B = (Basic)rhs;
            } else {
                B = this.getNamedClass(rhs);
                this.normalise(B, rhs, null);
            }
            this.initialise(normalised, B, trace);
        } else if (lhs instanceof Some) {
            Some some = (Some)lhs;
            Role role = some.role;
            Description filler = some.concept;
            Basic A = null;
            if (!(filler instanceof Basic)) {
                A = this.getNamedClass(filler);
                this.normalise(filler, A, null);
            } else {
                A = (Basic)filler;
            }
            if (role.somes.get(A) == null) {
                role.somes.put(A, some);
            }
            if (rhs instanceof Basic) {
                this.initialise(role, A, (Basic)rhs, trace);
            } else {
                Atomic B = this.getNamedClass(rhs);
                this.initialise(role, A, (Basic)B, trace);
                this.normalise(B, rhs, null);
            }
        } else if (lhs instanceof Basic) {
            if (rhs instanceof Some) {
                Some some = (Some)rhs;
                Role role = some.role;
                Description filler = some.concept;
                Basic B = null;
                if (!(filler instanceof Basic)) {
                    B = this.getNamedClass(filler);
                    this.normalise(B, filler, null);
                } else {
                    B = (Basic)filler;
                }
                this.initialise((Basic)lhs, role, B, trace);
            } else if (rhs instanceof And) {
                And and = (And)rhs;
                for (Description operand : and.operands) {
                    if (operand instanceof Basic) {
                        this.initialise((Basic)lhs, (Basic)operand, trace);
                        continue;
                    }
                    this.normalise(lhs, operand, trace);
                }
            } else {
                this.initialise((Basic)lhs, (Basic)rhs, trace);
            }
        }
        if (this.output) {
            this.axioms.add((OWLAxiom)this.approxfactory.getOWLSubClassOfAxiom(this.getOWL(lhs), this.getOWL(rhs)));
        }
    }

    protected OWLClassExpression getOWL(Description desc) {
        if (desc instanceof Atomic) {
            Atomic atomic = (Atomic)desc;
            return this.approxfactory.getOWLClass(atomic.uri);
        }
        if (desc instanceof And) {
            And and = (And)desc;
            HashSet<OWLClassExpression> inter = new HashSet<OWLClassExpression>();
            for (Description entry : and.operands) {
                inter.add(this.getOWL(entry));
            }
            return this.approxfactory.getOWLObjectIntersectionOf(inter);
        }
        if (desc instanceof Some) {
            Some some = (Some)desc;
            return this.approxfactory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.getOWL(some.role), this.getOWL(some.concept));
        }
        return null;
    }

    protected OWLObjectProperty getOWL(Role role) {
        return this.approxfactory.getOWLObjectProperty(role.uri);
    }

    protected void initialise(Basic lhs, Basic rhs, Traceability trace) {
        lhs.Ohat.put(rhs.entry, trace);
    }

    protected void initialise(HashSet<Basic> lhs, Basic rhs, Traceability trace) {
        if (lhs.size() == 1) {
            Implies imply = rhs.entry;
            lhs.iterator().next().Ohat.put(imply, trace);
        } else {
            for (Basic desc : lhs) {
                Implies implies = new Implies();
                implies.rhs = rhs;
                for (Basic company : lhs) {
                    if (company.equals(desc)) continue;
                    implies.lhs.add(company);
                }
                ++this.impliesID;
                implies.id = implies.id;
                desc.Ohat.put(implies, trace);
            }
        }
    }

    protected void initialise(Basic A, Role role, Basic B, Traceability trace) {
        ERestriction exists;
        HashMap<Basic, ERestriction> restrictions = this.elcontology.simpleExistEntries.get(role);
        if (restrictions == null) {
            restrictions = new HashMap();
            this.elcontology.simpleExistEntries.put(role, restrictions);
        }
        if ((exists = restrictions.get(B)) == null) {
            exists = new ERestriction();
            exists.concept = B;
            exists.role = role;
            exists.id = this.impliesID++;
            restrictions.put(B, exists);
        }
        A.Ohat.put(exists, trace);
    }

    protected void initialise(Role role, Basic A, Basic B, Traceability trace) {
        Some some = this.elcontology.roles.get((Object)Integer.valueOf((int)role.id)).somes.get(A);
        if (some == null) {
            some = new Some(role, A);
            some.id = this.nonbasicindex--;
            this.descriptions.put(some.id, some);
            this.elcontology.roles.get((Object)Integer.valueOf((int)role.id)).somes.put(A, some);
        }
        some.Ohat.put(B.entry, trace);
    }

    public Atomic getNamedClass(Description desc) {
        Atomic A = this.normalisationNames.get(desc);
        if (A == null) {
            A = new Atomic();
            A.id = this.classindex;
            A.uri = IRI.create((String)(CLASS_PREFIX + this.classindex));
            A.original = false;
            ++this.classindex;
            this.descriptions.put(A.id, A);
            this.normalisationNames.put(desc, A);
            this.imply(A);
        }
        return A;
    }

    protected void imply(Basic A) {
        Implies simpleimply = new Implies();
        simpleimply.id = this.impliesID++;
        simpleimply.lhs = null;
        simpleimply.rhs = A;
        A.entry = simpleimply;
    }

    public void createInverseRoles() {
    }
}

