/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.owlapi3.rel.reasoner.dl;

import eu.trowl.owlapi3.rel.normal.classify.dl.CombinedClassifier;
import eu.trowl.owlapi3.rel.normal.factory.dl.OntologyFactory;
import eu.trowl.owlapi3.rel.normal.model.Atomic;
import eu.trowl.owlapi3.rel.normal.model.Basic;
import eu.trowl.owlapi3.rel.normal.model.Description;
import eu.trowl.owlapi3.rel.normal.model.RoleConcept;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.reasoner.FreshEntitiesException;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.Node;
import org.semanticweb.owlapi.reasoner.NodeSet;
import org.semanticweb.owlapi.reasoner.ReasonerInterruptedException;
import org.semanticweb.owlapi.reasoner.TimeOutException;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNode;
import org.semanticweb.owlapi.reasoner.impl.OWLClassNodeSet;

public class RELReasoner
extends eu.trowl.owlapi3.rel.reasoner.el.RELReasoner {
    public RELReasoner(OWLOntologyManager manager, OWLOntology ontology, boolean bgp, boolean MetaOn, boolean disjoint) {
        super(manager, ontology, bgp, MetaOn, disjoint);
    }

    @Override
    public void loadOntology() {
        OWLLiteral val;
        OWLAnnotationProperty ano = this.factory.getOWLAnnotationProperty(IRI.create((String)"http://TrOWL.eu/REL#NBox"));
        HashSet<OWLClassExpression> clscls = new HashSet<OWLClassExpression>();
        HashSet<OWLObjectPropertyExpression> clsprop = new HashSet<OWLObjectPropertyExpression>();
        for (OWLClass cls : this.ontology.getClassesInSignature()) {
            for (OWLAnnotation anno : cls.getAnnotations(this.ontology, ano)) {
                if (!(anno.getValue() instanceof OWLLiteral) || !(val = (OWLLiteral)anno.getValue()).getLiteral().equals("close")) continue;
                clscls.add((OWLClassExpression)cls);
            }
        }
        for (OWLClass cls : this.ontology.getObjectPropertiesInSignature()) {
            for (OWLAnnotation anno : cls.getAnnotations(this.ontology, ano)) {
                if (!(anno.getValue() instanceof OWLLiteral) || !(val = (OWLLiteral)anno.getValue()).getLiteral().equals("close")) continue;
                clsprop.add((OWLObjectPropertyExpression)cls);
            }
        }
        elcfactory = new OntologyFactory(this.ontology, this.bgp, this.MetaOn, this.disjoint);
        elcfactory.createbuilder();
        this.elcontology = elcfactory.createELOntology();
        if (clscls.size() > 0 || clsprop.size() > 0) {
            this.close(clscls, clsprop);
        }
    }

    @Override
    public NodeSet<OWLClass> getDisjointClasses(OWLClassExpression concept) throws ReasonerInterruptedException, TimeOutException, FreshEntitiesException, InconsistentOntologyException {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.tBox_Classified) {
            this.precomputeInferences(InferenceType.CLASS_HIERARCHY);
        }
        OWLClassNodeSet disjoints = new OWLClassNodeSet();
        Description desc = this.getDescription(concept);
        Atomic bot = (Atomic)this.elcontology.descriptions.get(0);
        boolean duo = false;
        if (desc == null || !(desc instanceof Atomic)) {
            duo = true;
            OWLClass tempclass = this.factory.getOWLClass(IRI.create((String)"http://trowl.eu/REL#tempC"));
            OWLSubClassOfAxiom axiom = this.factory.getOWLSubClassOfAxiom((OWLClassExpression)tempclass, concept);
            Map.Entry<Basic, Basic> entry = elcfactory.loadAxiom(axiom);
            Iterator classifier = new CombinedClassifier();
            ((CombinedClassifier)((Object)classifier)).ontology = this.elcontology;
            ((CombinedClassifier)((Object)classifier)).completion_duo(this.elcontology.aBox_Classified);
            desc = (Atomic)entry.getValue();
        }
        Atomic atom = (Atomic)desc;
        HashSet<Basic> subsumers = new HashSet<Basic>();
        if (atom.equivalence.contains(bot)) {
            return this.satisfiable;
        }
        for (Basic sub : atom.subsumers) {
            if (!sub.complement.original || subsumers.contains(sub.complement)) continue;
            subsumers.addAll(sub.complement.equivalence);
        }
        for (Basic sub : atom.tempSubsumers) {
            if (!sub.complement.original || subsumers.contains(sub.complement)) continue;
            subsumers.addAll(sub.complement.equivalence);
        }
        while (subsumers.size() > 0) {
            Basic sub;
            sub = (Basic)subsumers.iterator().next();
            subsumers.removeAll(sub.equivalence);
            OWLClassNode ancestor = new OWLClassNode();
            for (Basic eq : sub.equivalence) {
                if (!(eq instanceof Atomic) || !((Atomic)eq).original) continue;
                ancestor.add((OWLObject)this.factory.getOWLClass(((Atomic)eq).uri));
            }
            if (ancestor.getSize() <= 0) continue;
            disjoints.addNode((Node)ancestor);
        }
        if (duo) {
            elcfactory.clean();
        }
        return disjoints;
    }

    public void close(Set<OWLClassExpression> classes, Set<OWLObjectPropertyExpression> properties) {
        if (!this.isConsistent()) {
            throw new InconsistentOntologyException();
        }
        if (!this.elcontology.aBox_Classified) {
            this.precomputeInferences(InferenceType.CLASS_ASSERTIONS);
        }
        this.elcontology.NOnto = true;
        for (OWLClassExpression cls : classes) {
            Set indis = this.getIndividuals(cls).getFlattened();
            elcfactory.close(cls, (Set<OWLNamedIndividual>)indis);
        }
        HashSet<OWLObjectPropertyExpression> invers = new HashSet<OWLObjectPropertyExpression>();
        for (OWLObjectPropertyExpression role : properties) {
            invers.add(role.getInverseProperty());
        }
        properties.addAll(invers);
        for (OWLObjectPropertyExpression property : properties) {
            HashSet<OWLNamedIndividual> range = new HashSet<OWLNamedIndividual>();
            for (OWLNamedIndividual indi : this.ontology.getIndividualsInSignature()) {
                Set indis = this.getObjectPropertyValues(indi, property).getFlattened();
                elcfactory.close(indi, property, indis);
                range.addAll(indis);
            }
            elcfactory.close(property, range);
        }
        elcfactory.reorder();
        this.elcontology.tBox_Classified = false;
        this.elcontology.aBox_Classified = false;
        this.precomputeInferences(new InferenceType[0]);
    }

    public HashSet<OWLClass> getLeft(OWLClass cls) {
        HashSet<OWLClass> clss = new HashSet<OWLClass>();
        Atomic atomic = (Atomic)this.getDescription((OWLClassExpression)cls);
        for (RoleConcept rc : atomic.LeftConnection) {
            clss.add(this.factory.getOWLClass(rc.concept.uri));
        }
        return clss;
    }
}

