/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.owlapi3.rel.normal.factory.dl;

import eu.trowl.owlapi3.rel.normal.factory.dl.OntologyBuilder;
import eu.trowl.owlapi3.rel.normal.model.Atomic;
import eu.trowl.owlapi3.rel.normal.model.Basic;
import eu.trowl.owlapi3.rel.normal.model.CardinalityEntry;
import eu.trowl.owlapi3.rel.normal.model.Description;
import eu.trowl.owlapi3.rel.normal.model.Implies;
import eu.trowl.owlapi3.rel.normal.model.Ontology;
import eu.trowl.owlapi3.rel.normal.model.Role;
import eu.trowl.owlapi3.rel.normal.model.Some;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class TemporalOntologyBuilder
extends OntologyBuilder {
    public TemporalOntologyBuilder(Set<OWLOntology> ontologies, OWLOntologyManager manager, Ontology ELContology, OntologyBuilder builder) {
        this.factory = manager.getOWLDataFactory();
        this.elcontology = ELContology;
        this.classID = this.elcontology.classID;
        this.propertyID = this.elcontology.roleID;
        this.individualID = this.elcontology.individualID;
        this.descriptions = this.elcontology.descriptions;
        this.roles = this.elcontology.roles;
        this.allconcepts = this.elcontology.allconcepts;
        this.classindex = builder.classindex;
        this.nonbasicindex = builder.nonbasicindex;
        this.propertyindex = builder.propertyindex;
        this.impliesID = builder.impliesID;
        this.classID = builder.classID;
        this.propertyID = builder.propertyID;
        this.individualID = builder.individualID;
        this.descriptions = builder.descriptions;
        this.roles = builder.roles;
        for (Map.Entry<Atomic, HashMap<Integer, Atomic>> cardinentry : builder.CardinalityTable.entrySet()) {
            HashMap<Integer, Atomic> cardins = new HashMap<Integer, Atomic>();
            for (Map.Entry<Integer, Atomic> entry : cardinentry.getValue().entrySet()) {
                cardins.put(entry.getKey(), entry.getValue());
            }
            this.CardinalityTable.put(cardinentry.getKey(), cardins);
        }
        ELContology.classNum = this.classindex;
        this.bot = (Atomic)this.descriptions.get(0);
        this.top = (Atomic)this.descriptions.get(1);
    }

    public Map.Entry<Basic, Basic> loadTempAxiom(OWLSubClassOfAxiom axiom) {
        OWLClass thing = this.factory.getOWLThing();
        OWLClass nothing = this.factory.getOWLNothing();
        OWLClass namedindividual = this.factory.getOWLClass(IRI.create((String)"http://www.w3.org/2002/07/owl#NamedIndividual"));
        for (OWLClass concept : axiom.getClassesInSignature()) {
            if (concept.equals(thing) || concept.equals(nothing) || concept.equals(namedindividual) || this.elcontology.classID.get(concept) != null) continue;
            Atomic newconcept = new Atomic(concept);
            ++this.classindex;
            newconcept.id = newconcept.id;
            newconcept.original = false;
            this.classID.put(concept, newconcept.id);
            this.descriptions.put(newconcept.id, newconcept);
            this.imply(newconcept);
            newconcept.equivalence.add(newconcept);
            if (this.elcontology.largeT) continue;
            Atomic nA = new Atomic();
            ++this.classindex;
            nA.id = nA.id;
            nA.original = false;
            this.classID.put(this.factory.getOWLObjectComplementOf((OWLClassExpression)concept), nA.id);
            this.descriptions.put(nA.id, nA);
            this.imply(nA);
            nA.equivalence.add(nA);
            newconcept.complement = nA;
            nA.complement = newconcept;
        }
        OWLClassExpression lhs = axiom.getSubClass();
        OWLClassExpression rhs = axiom.getSuperClass();
        Description NC = this.getDescription(this.getNNF(lhs));
        Description ND = this.getDescription(this.getNNF(rhs));
        this.normalise(NC, ND);
        HashMap<Atomic, Atomic> newentry = new HashMap<Atomic, Atomic>();
        Basic LHS = this.bot;
        Basic RHS = this.top;
        if (NC instanceof Basic) {
            LHS = (Basic)NC;
        }
        if (ND instanceof Basic) {
            RHS = (Basic)ND;
        }
        newentry.put((Atomic)LHS, (Atomic)RHS);
        this.OrderingCardinality();
        return newentry.entrySet().iterator().next();
    }

    @Override
    protected void initialise(Basic lhs, Basic rhs) {
        lhs.tempOhat.add(rhs.entry);
    }

    @Override
    protected void initialise(HashSet<Basic> lhs, Basic rhs) {
        if (lhs.size() == 1) {
            Implies imply = rhs.entry;
            lhs.iterator().next().tempOhat.add(imply);
        } else {
            for (Basic desc : lhs) {
                Implies implies = new Implies();
                implies.rhs = rhs;
                for (Basic company : lhs) {
                    if (company.equals(desc)) continue;
                    implies.lhs.add(company);
                }
                ++this.impliesID;
                implies.id = implies.id;
                desc.tempOhat.add(implies);
            }
        }
    }

    @Override
    protected void initialise(Basic A, Role role, Basic B) {
        Some exists = role.somes.get(B);
        if (exists == null) {
            exists = new Some(role, B);
            exists.id = this.nonbasicindex--;
            role.somes.put(B, exists);
        }
        A.tempOhat.add(exists);
    }

    @Override
    protected void initialise(Role role, Basic A, Basic B) {
        Some some = this.elcontology.roles.get((Object)Integer.valueOf((int)role.id)).somes.get(A);
        if (some == null) {
            some = new Some(role, A);
            some.id = this.nonbasicindex--;
            this.descriptions.put(some.id, some);
            this.elcontology.roles.get((Object)Integer.valueOf((int)role.id)).somes.put(A, some);
        }
        some.tempOhat.add(B.entry);
    }

    @Override
    public void OrderingCardinality() {
        for (Map.Entry entry : this.CardinalityTable.entrySet()) {
            Atomic filler = (Atomic)entry.getKey();
            HashMap cardins = (HashMap)entry.getValue();
            CardinalityEntry[] number = new CardinalityEntry[cardins.size()];
            int size = 0;
            Iterator iterator = cardins.keySet().iterator();
            while (iterator.hasNext()) {
                CardinalityEntry newentry;
                int n = (Integer)iterator.next();
                int i = 0;
                while (i < size) {
                    if (number[i].n < n) break;
                    ++i;
                }
                int j = size;
                while (j > i) {
                    number[j] = number[j - 1];
                    --j;
                }
                number[i] = newentry = new CardinalityEntry((Atomic)cardins.get(n), n);
                ++size;
            }
            filler.tempcardins = number;
            int i = 0;
            while (i < size - 1) {
                this.normalise(number[i].basen, number[i + 1].basen);
                ++i;
            }
        }
        this.elcontology.classNum = this.classindex;
        this.elcontology.roleNum = this.propertyindex;
    }
}

