/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.owlapi3.rel.normal.factory.dl;

import eu.trowl.owlapi3.rel.normal.factory.dl.OntologyBuilder;
import eu.trowl.owlapi3.rel.normal.factory.dl.TemporalOntologyBuilder;
import eu.trowl.owlapi3.rel.normal.model.Basic;
import eu.trowl.owlapi3.rel.normal.model.Ontology;
import eu.trowl.owlapi3.rel.normal.model.Singleton;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class OntologyFactory {
    protected final OWLOntologyManager manager;
    protected final Set<OWLOntology> ontologies;
    protected OntologyBuilder builder;
    protected Ontology elcontology;
    protected boolean nominalfree;

    public void createbuilder() {
        this.builder = new OntologyBuilder(this.ontologies, this.manager, this.elcontology);
    }

    public OntologyFactory(OWLOntology ontology, boolean bgp, boolean MetaOn, boolean disjoint) {
        this.manager = ontology.getOWLOntologyManager();
        this.ontologies = ontology.getImportsClosure();
        this.elcontology = new Ontology();
        this.elcontology.BGP = bgp;
        this.elcontology.MetaOn = MetaOn || ontology.getClassesInSignature().size() < 100;
        this.elcontology.disjoint = disjoint;
    }

    public Ontology createELOntology() {
        for (OWLOntology ontology : this.ontologies) {
            for (OWLLogicalAxiom axiom : ontology.getLogicalAxioms()) {
                axiom.accept((OWLAxiomVisitor)this.builder);
            }
        }
        this.builder.OrderingCardinality();
        this.elcontology = this.builder.getELOntology();
        return this.elcontology;
    }

    public Map.Entry<Basic, Basic> loadAxiom(OWLSubClassOfAxiom axiom) {
        TemporalOntologyBuilder tempbuilder = new TemporalOntologyBuilder(this.ontologies, this.manager, this.elcontology, this.builder);
        return tempbuilder.loadTempAxiom(axiom);
    }

    public void clean() {
        this.builder.clean();
    }

    public void close(OWLClassExpression cls, Set<OWLNamedIndividual> indis) {
        OWLDataFactory factory = this.manager.getOWLDataFactory();
        OWLSubClassOfAxiom axiom = factory.getOWLSubClassOfAxiom(cls, (OWLClassExpression)factory.getOWLObjectOneOf(indis));
        axiom.accept((OWLAxiomVisitor)this.builder);
        HashSet<Singleton> individuals = new HashSet<Singleton>();
        for (OWLNamedIndividual oWLNamedIndividual : indis) {
            individuals.add((Singleton)this.elcontology.descriptions.get(this.elcontology.individualID.get(oWLNamedIndividual)));
        }
        for (Singleton singleton : individuals) {
            for (Basic type : singleton.subsumers) {
                if (type.complement == null) continue;
                type.complement.Ohat.add(singleton.complement.entry);
            }
        }
    }

    public void close(OWLNamedIndividual indi, OWLObjectPropertyExpression property, Set<OWLNamedIndividual> indis) {
        OWLDataFactory factory = this.manager.getOWLDataFactory();
        OWLSubClassOfAxiom axiom = factory.getOWLSubClassOfAxiom((OWLClassExpression)factory.getOWLObjectSomeValuesFrom(property, (OWLClassExpression)factory.getOWLObjectOneOf(new OWLIndividual[]{indi})), (OWLClassExpression)factory.getOWLObjectOneOf(indis));
        axiom.accept((OWLAxiomVisitor)this.builder);
    }

    public void close(OWLObjectPropertyExpression property, Set<OWLNamedIndividual> range) {
        OWLDataFactory factory = this.manager.getOWLDataFactory();
        OWLSubClassOfAxiom axiom = factory.getOWLSubClassOfAxiom((OWLClassExpression)factory.getOWLObjectSomeValuesFrom(property, (OWLClassExpression)factory.getOWLThing()), (OWLClassExpression)factory.getOWLObjectOneOf(range));
        axiom.accept((OWLAxiomVisitor)this.builder);
        HashSet<Singleton> individuals = new HashSet<Singleton>();
        for (OWLNamedIndividual oWLNamedIndividual : range) {
            individuals.add((Singleton)this.elcontology.descriptions.get(this.elcontology.individualID.get(oWLNamedIndividual)));
        }
        for (Singleton singleton : individuals) {
            for (Basic type : singleton.subsumers) {
                if (type.complement == null) continue;
                type.complement.Ohat.addAll(singleton.complement.Ohat);
            }
        }
    }

    public void reorder() {
        this.builder.reorder();
    }
}

