/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.owlapi3.rel.normal.factory.dl;

import eu.trowl.owlapi3.rel.normal.factory.dl.OWL2DLAxiomVisitor;
import eu.trowl.owlapi3.rel.normal.model.And;
import eu.trowl.owlapi3.rel.normal.model.Atomic;
import eu.trowl.owlapi3.rel.normal.model.Basic;
import eu.trowl.owlapi3.rel.normal.model.CardinAtomic;
import eu.trowl.owlapi3.rel.normal.model.CardinalityEntry;
import eu.trowl.owlapi3.rel.normal.model.Description;
import eu.trowl.owlapi3.rel.normal.model.Implies;
import eu.trowl.owlapi3.rel.normal.model.Ontology;
import eu.trowl.owlapi3.rel.normal.model.QueueEntry;
import eu.trowl.owlapi3.rel.normal.model.Role;
import eu.trowl.owlapi3.rel.normal.model.Singleton;
import eu.trowl.owlapi3.rel.normal.model.Some;
import eu.trowl.owlapi3.rel.util.RELReasonerConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;

public class OntologyBuilder
extends OWL2DLAxiomVisitor {
    protected static final String INDI_PREFIX = "RELAPPROX#RELAPPROXI";
    public Ontology elcontology;
    public HashMap<OWLClassExpression, Integer> classID;
    public HashMap<OWLObjectPropertyExpression, Integer> propertyID;
    protected Set<OWLOntology> ontologies;
    public HashMap<Integer, Description> descriptions;
    public HashMap<Integer, Role> roles;
    public HashSet<OWLIndividual> constants = new HashSet();
    public HashSet<Atomic> allconcepts;
    public HashMap<ArrayList<Role>, Role> chainName = new HashMap();
    public HashMap<Atomic, HashMap<Integer, Atomic>> CardinalityTable = new HashMap();
    public HashMap<Basic, HashSet<Singleton>> setTable = new HashMap();
    public HashSet<OWLObjectSomeValuesFrom> miniSet = new HashSet();
    public int classindex = 0;
    public int nonbasicindex = -2;
    public int propertyindex = 0;
    public int impliesID;
    public final Map<Description, Atomic> normalisationNames = new HashMap<Description, Atomic>();
    public Atomic top = null;
    public Atomic bot = null;
    public OWLDataFactory factory = null;
    public OWLOntologyManager manager = OWLManager.createOWLOntologyManager();
    public OWLDataFactory approxfactory = this.manager.getOWLDataFactory();
    int chain = 0;
    int trans = 0;
    HashSet<Role> chainroles = new HashSet();
    boolean disjoint = false;
    public HashMap<OWLIndividual, Integer> individualID;
    HashMap<Float, OWLIndividual> floatIndividual = new HashMap();
    HashSet<OWLClass> datatypes = new HashSet();
    HashMap<Float, OWLClass> minExclusive = new HashMap();
    HashMap<Float, OWLClass> minInclusive = new HashMap();
    HashMap<Float, OWLClass> maxExclusive = new HashMap();
    HashMap<Float, OWLClass> maxInclusive = new HashMap();

    public OntologyBuilder(Set<OWLOntology> ontologies, OWLOntologyManager manager, Ontology ELContology) {
        super(true);
        this.ontologies = ontologies;
        this.factory = manager.getOWLDataFactory();
        this.elcontology = ELContology;
        this.classID = this.elcontology.classID;
        this.propertyID = this.elcontology.roleID;
        this.descriptions = this.elcontology.descriptions;
        this.roles = this.elcontology.roles;
        this.allconcepts = this.elcontology.allconcepts;
        OWLClass thing = this.factory.getOWLThing();
        OWLClass nothing = this.factory.getOWLNothing();
        this.top = new Atomic(thing);
        this.top.id = 1;
        this.top.original = true;
        this.bot = new Atomic(nothing);
        this.bot.id = 0;
        this.bot.original = true;
        this.addClassID((OWLClassExpression)nothing, 0);
        this.addClassID((OWLClassExpression)thing, 1);
        this.allconcepts.add(this.top);
        this.classindex = 2;
        this.descriptions.put(0, this.bot);
        this.imply(this.bot);
        this.descriptions.put(1, this.top);
        this.imply(this.top);
        this.initialise(ontologies);
    }

    protected Description getDescription(OWLClassExpression concept) {
        Description NC = null;
        if (this.classID.get(concept) != null) {
            NC = this.descriptions.get(this.classID.get(concept));
        } else if (concept instanceof OWLObjectComplementOf) {
            OWLObjectComplementOf comp = (OWLObjectComplementOf)concept;
            OWLClassExpression des = comp.getOperand();
            Basic nNCA = (Basic)this.getDescription(des);
            NC = nNCA.complement;
            if (NC == null) {
                Atomic NCA = new Atomic();
                NCA.id = this.classindex++;
                NCA.original = false;
                this.addClassID(concept, NCA.id);
                this.descriptions.put(NCA.id, NCA);
                this.imply(NCA);
                NCA.complement = nNCA;
                nNCA.complement = NCA;
                NC = NCA;
            }
        } else if (concept instanceof OWLObjectIntersectionOf) {
            OWLObjectIntersectionOf intersection = (OWLObjectIntersectionOf)concept;
            HashSet<Description> interapprox = new HashSet<Description>();
            for (OWLClassExpression des : intersection.getOperands()) {
                Description desapprox = this.getDescription(des);
                interapprox.add(desapprox);
            }
            NC = new And(interapprox);
            NC.id = this.nonbasicindex--;
            this.addClassID(concept, NC.id);
            this.descriptions.put(NC.id, NC);
        } else if (concept instanceof OWLObjectUnionOf) {
            OWLObjectUnionOf union = (OWLObjectUnionOf)concept;
            OWLClassExpression complement = this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)union));
            Atomic NCA = new Atomic();
            NCA.id = this.classindex++;
            NCA.original = false;
            this.addClassID(concept, NCA.id);
            this.descriptions.put(NCA.id, NCA);
            this.imply(NCA);
            Atomic nNCA = new Atomic();
            nNCA.id = this.classindex++;
            nNCA.original = false;
            Description complementapprox = this.getDescription(complement);
            this.addClassID(complement, nNCA.id);
            this.descriptions.put(nNCA.id, nNCA);
            this.imply(nNCA);
            NCA.complement = nNCA;
            nNCA.complement = NCA;
            this.normalise(nNCA, complementapprox);
            this.normalise(complementapprox, nNCA);
            NC = NCA;
            for (OWLClassExpression exp : union.getOperands()) {
                this.normalise(this.getDescription(exp), NCA);
            }
        } else if (concept instanceof OWLObjectSomeValuesFrom) {
            OWLObjectSomeValuesFrom some = (OWLObjectSomeValuesFrom)concept;
            OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)some.getProperty();
            Role role = this.getRole(property);
            Some someA = new Some(role, this.getDescription((OWLClassExpression)some.getFiller()));
            NC = someA;
            NC.id = this.nonbasicindex--;
            if (someA.concept instanceof Basic) {
                someA.role.somes.put((Basic)someA.concept, someA);
            }
            this.addClassID(concept, NC.id);
            this.descriptions.put(NC.id, NC);
        } else if (concept instanceof OWLObjectAllValuesFrom) {
            Role invr;
            OWLObjectOneOf oneof;
            OWLObjectAllValuesFrom all = (OWLObjectAllValuesFrom)concept;
            OWLClassExpression complement = this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)all));
            Atomic NCA = new Atomic();
            NCA.id = this.classindex++;
            NCA.original = false;
            this.addClassID(concept, NCA.id);
            this.descriptions.put(NCA.id, NCA);
            this.imply(NCA);
            Atomic nNCA = new Atomic();
            nNCA.id = this.classindex++;
            nNCA.original = false;
            this.getDescription((OWLClassExpression)all.getFiller());
            Some complementapprox = (Some)this.getDescription(complement);
            this.addClassID(complement, nNCA.id);
            this.descriptions.put(nNCA.id, nNCA);
            this.imply(nNCA);
            if (complementapprox.concept instanceof Basic) {
                complementapprox.role.somes.put((Basic)complementapprox.concept, complementapprox);
            }
            NCA.complement = nNCA;
            nNCA.complement = NCA;
            this.normalise(nNCA, complementapprox);
            this.normalise(complementapprox, nNCA);
            complementapprox.role.related = true;
            NC = NCA;
            NCA.onlyLink = complementapprox;
            if (this.elcontology.BGP && all.getFiller() instanceof OWLObjectOneOf && (oneof = (OWLObjectOneOf)all.getFiller()).getIndividuals().size() == 1) {
                OWLIndividual indi = (OWLIndividual)oneof.getIndividuals().iterator().next();
                for (OWLClassExpression cls : indi.getTypes(this.ontologies)) {
                    OWLObjectMaxCardinality card = this.factory.getOWLObjectMaxCardinality(1, (OWLObjectPropertyExpression)all.getProperty(), cls);
                    Description cardesc = this.getDescription((OWLClassExpression)card);
                    this.normalise(NC, cardesc);
                    this.normalise(cardesc, NC);
                }
            }
            if ((invr = this.getRole((OWLObjectPropertyExpression)((OWLObjectPropertyExpression)all.getProperty())).inverse) != null) {
                Some some = invr.somes.get(NCA);
                if (some == null) {
                    some = new Some(invr, NCA);
                    some.id = this.nonbasicindex--;
                    this.descriptions.put(some.id, some);
                    invr.somes.put(NCA, some);
                }
                some.role.related = true;
                this.normalise(some, this.getDescription((OWLClassExpression)all.getFiller()));
            }
            if (all.getFiller() instanceof OWLObjectOneOf) {
                oneof = (OWLObjectOneOf)all.getFiller();
                this.normalise(NC, this.getDescription((OWLClassExpression)this.factory.getOWLObjectMaxCardinality(oneof.getIndividuals().size(), (OWLObjectPropertyExpression)all.getProperty(), (OWLClassExpression)this.factory.getOWLThing())));
            }
        } else if (concept instanceof OWLObjectMinCardinality) {
            Atomic newfiller;
            Atomic fillerA;
            Description fillerapprox;
            OWLObjectMinCardinality min = (OWLObjectMinCardinality)concept;
            int n = min.getCardinality();
            OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)min.getProperty();
            Role role = this.getRole(property);
            OWLClassExpression filler = (OWLClassExpression)min.getFiller();
            if (filler instanceof OWLObjectOneOf) {
                this.miniSet.add(this.factory.getOWLObjectSomeValuesFrom(property, filler));
            }
            if (!((fillerapprox = this.getDescription(filler)) instanceof Atomic)) {
                OWLClassExpression nfiller = this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf(filler));
                Atomic nfillerapporx = (Atomic)this.getDescription(nfiller);
                fillerapprox = nfillerapporx.complement;
            }
            if (this.CardinalityTable.get(fillerA = (Atomic)fillerapprox) == null) {
                HashMap<Integer, Atomic> fillerapproxentry = new HashMap<Integer, Atomic>();
                fillerapproxentry.put(1, fillerA);
                this.CardinalityTable.put(fillerA, fillerapproxentry);
            }
            if ((newfiller = this.CardinalityTable.get(fillerA).get(n)) == null) {
                CardinAtomic newcardinfiller = new CardinAtomic();
                newcardinfiller.id = this.classindex++;
                newcardinfiller.original = false;
                newcardinfiller.value = fillerA;
                newcardinfiller.cardin = n;
                newfiller = newcardinfiller;
                this.CardinalityTable.get(fillerA).put(n, newfiller);
                this.descriptions.put(newfiller.id, newfiller);
                this.imply(newfiller);
            }
            NC = new Some(role, newfiller);
            NC.id = this.nonbasicindex--;
            if (newfiller instanceof Basic) {
                role.somes.put(newfiller, (Some)NC);
            }
            this.addClassID(concept, NC.id);
            this.descriptions.put(NC.id, NC);
        } else if (concept instanceof OWLObjectMaxCardinality) {
            OWLObjectMaxCardinality max = (OWLObjectMaxCardinality)concept;
            OWLClassExpression complement = this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)max));
            Atomic NCA = new Atomic();
            NCA.id = this.classindex++;
            NCA.original = false;
            this.addClassID(concept, NCA.id);
            this.descriptions.put(NCA.id, NCA);
            this.imply(NCA);
            Atomic nNCA = new Atomic();
            nNCA.id = this.classindex++;
            nNCA.original = false;
            Some complementapprox = (Some)this.getDescription(complement);
            this.addClassID(complement, nNCA.id);
            this.descriptions.put(nNCA.id, nNCA);
            this.imply(nNCA);
            if (complementapprox.concept instanceof Basic) {
                complementapprox.role.somes.put((Basic)complementapprox.concept, complementapprox);
            }
            NCA.complement = nNCA;
            nNCA.complement = NCA;
            this.normalise(nNCA, complementapprox);
            this.normalise(complementapprox, nNCA);
            NC = NCA;
        } else if (concept instanceof OWLObjectOneOf) {
            OWLObjectOneOf oneof = (OWLObjectOneOf)concept;
            Set indis = oneof.getIndividuals();
            HashSet<OWLObjectOneOf> concepts = new HashSet<OWLObjectOneOf>();
            HashSet<Singleton> singletons = new HashSet<Singleton>();
            for (OWLIndividual individual : indis) {
                OWLObjectOneOf singleton = this.factory.getOWLObjectOneOf(new OWLIndividual[]{individual});
                concepts.add(singleton);
                singletons.add(this.getIndividual(individual));
            }
            if (indis.size() == 0) {
                NC = this.bot;
            } else if (indis.size() == 1) {
                OWLObjectOneOf singleton = (OWLObjectOneOf)concepts.iterator().next();
                NC = this.getIndividual((OWLIndividual)singleton.getIndividuals().iterator().next());
            } else {
                OWLObjectUnionOf union = this.factory.getOWLObjectUnionOf(concepts);
                NC = this.getDescription((OWLClassExpression)union);
            }
            if (NC != this.bot) {
                this.setTable.put((Basic)NC, singletons);
            }
        } else {
            Atomic NCA = new Atomic();
            NCA.id = this.classindex++;
            NCA.original = false;
            this.addClassID(concept, NCA.id);
            this.descriptions.put(NCA.id, NCA);
            this.imply(NCA);
            NC = NCA;
        }
        if (!this.elcontology.largeT && NC instanceof Basic) {
            Basic ANC = (Basic)NC;
            if (ANC.complement == null) {
                Atomic nNCA = new Atomic();
                nNCA.id = this.classindex++;
                nNCA.original = false;
                this.addClassID((OWLClassExpression)this.factory.getOWLObjectComplementOf(concept), nNCA.id);
                this.descriptions.put(nNCA.id, nNCA);
                this.imply(nNCA);
                ANC.complement = nNCA;
                nNCA.complement = ANC;
            }
        }
        return NC;
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        Description lhs = this.getDescription((OWLClassExpression)this.factory.getOWLObjectMinCardinality(2, property, (OWLClassExpression)this.factory.getOWLThing()));
        this.getRole((OWLObjectPropertyExpression)property).functional = true;
        this.normalise(lhs, this.bot);
        Description rhs = this.getDescription((OWLClassExpression)this.factory.getOWLObjectMaxCardinality(1, property, (OWLClassExpression)this.factory.getOWLThing()));
        this.normalise(this.top, rhs);
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        OWLObjectPropertyExpression inve = property.getInverseProperty();
        this.visit(this.factory.getOWLEquivalentObjectPropertiesAxiom(property, inve));
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        OWLDataPropertyExpression property = (OWLDataPropertyExpression)axiom.getProperty();
        Description lhs = this.getDescription((OWLClassExpression)this.factory.getOWLObjectMinCardinality(2, (OWLObjectPropertyExpression)this.factory.getOWLObjectProperty(property.asOWLDataProperty().getIRI()), (OWLClassExpression)this.factory.getOWLThing()));
        this.getRole((OWLDataPropertyExpression)property).functional = true;
        this.normalise(lhs, this.bot);
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        Description lhs = this.getDescription((OWLClassExpression)this.factory.getOWLObjectMinCardinality(2, property.getInverseProperty(), (OWLClassExpression)this.factory.getOWLThing()));
        this.getRole((OWLObjectPropertyExpression)property.getInverseProperty()).functional = true;
        this.normalise(lhs, this.bot);
    }

    /*
     * WARNING - void declaration
     */
    public void OrderingCardinality() {
        Iterator<Float> indi;
        if (!this.elcontology.largeA) {
            ArrayList<OWLClassExpression> arrayList = new ArrayList<OWLClassExpression>(this.classID.keySet());
            for (OWLClassExpression oWLClassExpression : arrayList) {
                OWLObjectMaxCardinality max;
                if (!(oWLClassExpression instanceof OWLObjectMaxCardinality) || (max = (OWLObjectMaxCardinality)oWLClassExpression).getCardinality() != 1) continue;
                Basic Y = (Basic)this.getDescription((OWLClassExpression)max);
                Role r = this.getRole((OWLObjectPropertyExpression)max.getProperty());
                Basic C = (Basic)this.getDescription((OWLClassExpression)max.getFiller());
                int id = 1;
                while (id < this.classindex) {
                    Description desc22 = this.descriptions.get(id);
                    if (this.allconcepts.contains(desc22) || desc22 instanceof Singleton) {
                        Basic A = (Basic)desc22;
                        if (A.Ohat.contains(Y.entry) || this.top.Ohat.contains(Y.entry)) {
                            HashSet<Description> descs = new HashSet<Description>();
                            block2: for (QueueEntry entry : A.Ohat) {
                                if (!(entry instanceof Some)) continue;
                                Some RB = (Some)entry;
                                if (RB.role != r || RB.concept == C || !RB.concept.Ohat.contains(C.entry) && C.id != 1) continue;
                                if (RB.concept instanceof Singleton) {
                                    OWLNamedIndividual indi2 = this.factory.getOWLNamedIndividual(((Singleton)RB.concept).uri);
                                    descs.add(this.getDescription(this.getNNF((OWLClassExpression)this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)this.factory.getOWLObjectProperty(r.uri), (OWLClassExpression)this.factory.getOWLObjectOneOf(new OWLIndividual[]{indi2})))));
                                    continue;
                                }
                                for (OWLClassExpression Bdesc : this.classID.keySet()) {
                                    if (this.classID.get(Bdesc) != RB.concept.id) continue;
                                    descs.add(this.getDescription(this.getNNF((OWLClassExpression)this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)this.factory.getOWLObjectProperty(r.uri), Bdesc))));
                                    continue block2;
                                }
                            }
                            for (Description Xs : descs) {
                                this.normalise(A, Xs);
                            }
                        }
                    }
                    ++id;
                }
            }
        }
        if (this.chain > this.trans) {
            this.elcontology.chains = true;
            for (Role role : this.chainroles) {
                role.related = true;
            }
        }
        for (Map.Entry<Atomic, HashMap<Integer, Atomic>> entry : this.CardinalityTable.entrySet()) {
            Atomic filler = entry.getKey();
            HashMap<Integer, Atomic> cardins = entry.getValue();
            CardinalityEntry[] number = new CardinalityEntry[cardins.size()];
            int size = 0;
            for (int n : cardins.keySet()) {
                CardinalityEntry newentry;
                int i = 0;
                while (i < size) {
                    if (number[i].n < n) break;
                    ++i;
                }
                int j = size;
                while (j > i) {
                    number[j] = number[j - 1];
                    --j;
                }
                number[i] = newentry = new CardinalityEntry(cardins.get(n), n);
                ++size;
            }
            filler.cardins = number;
            int i = 0;
            while (i < size - 1) {
                this.normalise(number[i].basen, number[i + 1].basen);
                ++i;
            }
        }
        if (this.constants.size() > 0 && this.constants.size() < 1000) {
            OWLDifferentIndividualsAxiom oWLDifferentIndividualsAxiom = this.factory.getOWLDifferentIndividualsAxiom(this.constants);
            this.visit(oWLDifferentIndividualsAxiom);
        }
        for (Map.Entry<Float, OWLIndividual> entry : this.floatIndividual.entrySet()) {
            float value = entry.getKey().floatValue();
            indi = this.getIndividual(entry.getValue());
            this.initialise((Basic)((Object)indi), (Basic)this.getDescription((OWLClassExpression)this.factory.getOWLClass(IRI.create((String)"http://www.w3.org/2001/XMLSchema#float"))));
            for (float node : this.minExclusive.keySet()) {
                if (!(node < value)) continue;
                this.initialise((Basic)((Object)indi), (Basic)this.getDescription((OWLClassExpression)this.minExclusive.get(Float.valueOf(node))));
            }
            for (float node : this.minInclusive.keySet()) {
                if (!(node <= value)) continue;
                this.initialise((Basic)((Object)indi), (Basic)this.getDescription((OWLClassExpression)this.minInclusive.get(Float.valueOf(node))));
            }
            for (float node : this.maxExclusive.keySet()) {
                if (!(node > value)) continue;
                this.initialise((Basic)((Object)indi), (Basic)this.getDescription((OWLClassExpression)this.maxExclusive.get(Float.valueOf(node))));
            }
            for (float node : this.maxInclusive.keySet()) {
                if (!(node >= value)) continue;
                this.initialise((Basic)((Object)indi), (Basic)this.getDescription((OWLClassExpression)this.maxInclusive.get(Float.valueOf(node))));
            }
        }
        for (float f : this.maxExclusive.keySet()) {
            indi = this.maxExclusive.keySet().iterator();
            while (indi.hasNext()) {
                float N = ((Float)indi.next()).floatValue();
                if (!(f <= N)) continue;
                this.normalise(this.getDescription((OWLClassExpression)this.maxExclusive.get(Float.valueOf(f))), this.getDescription((OWLClassExpression)this.maxExclusive.get(Float.valueOf(N))));
            }
            for (float N : this.maxInclusive.keySet()) {
                if (!(f <= N)) continue;
                this.normalise(this.getDescription((OWLClassExpression)this.maxExclusive.get(Float.valueOf(f))), this.getDescription((OWLClassExpression)this.maxInclusive.get(Float.valueOf(N))));
            }
            for (float N : this.minExclusive.keySet()) {
                if (!(f <= N)) continue;
                this.visit(this.factory.getOWLDisjointClassesAxiom(new OWLClassExpression[]{(OWLClassExpression)this.maxExclusive.get(Float.valueOf(f)), (OWLClassExpression)this.minExclusive.get(Float.valueOf(N))}));
            }
            for (float N : this.minInclusive.keySet()) {
                if (!(f <= N)) continue;
                this.visit(this.factory.getOWLDisjointClassesAxiom(new OWLClassExpression[]{(OWLClassExpression)this.maxExclusive.get(Float.valueOf(f)), (OWLClassExpression)this.minInclusive.get(Float.valueOf(N))}));
            }
        }
        for (float f : this.maxInclusive.keySet()) {
            for (float N : this.maxInclusive.keySet()) {
                if (!(f <= N)) continue;
                this.normalise(this.getDescription((OWLClassExpression)this.maxInclusive.get(Float.valueOf(f))), this.getDescription((OWLClassExpression)this.maxInclusive.get(Float.valueOf(N))));
            }
            for (float N : this.maxExclusive.keySet()) {
                if (!(f < N)) continue;
                this.normalise(this.getDescription((OWLClassExpression)this.maxInclusive.get(Float.valueOf(f))), this.getDescription((OWLClassExpression)this.maxExclusive.get(Float.valueOf(N))));
            }
            for (float N : this.minExclusive.keySet()) {
                if (!(f <= N)) continue;
                this.visit(this.factory.getOWLDisjointClassesAxiom(new OWLClassExpression[]{(OWLClassExpression)this.maxInclusive.get(Float.valueOf(f)), (OWLClassExpression)this.minExclusive.get(Float.valueOf(N))}));
            }
            for (float N : this.minInclusive.keySet()) {
                if (!(f < N)) continue;
                this.visit(this.factory.getOWLDisjointClassesAxiom(new OWLClassExpression[]{(OWLClassExpression)this.maxInclusive.get(Float.valueOf(f)), (OWLClassExpression)this.minInclusive.get(Float.valueOf(N))}));
            }
        }
        for (float f : this.minInclusive.keySet()) {
            for (float M : this.minInclusive.keySet()) {
                if (!(M <= f)) continue;
                this.normalise(this.getDescription((OWLClassExpression)this.minInclusive.get(Float.valueOf(f))), this.getDescription((OWLClassExpression)this.minInclusive.get(Float.valueOf(M))));
            }
            for (float M : this.minExclusive.keySet()) {
                if (!(M < f)) continue;
                this.normalise(this.getDescription((OWLClassExpression)this.minInclusive.get(Float.valueOf(f))), this.getDescription((OWLClassExpression)this.minExclusive.get(Float.valueOf(M))));
            }
        }
        for (float f : this.minExclusive.keySet()) {
            for (float M : this.minInclusive.keySet()) {
                if (!(M <= f)) continue;
                this.normalise(this.getDescription((OWLClassExpression)this.minExclusive.get(Float.valueOf(f))), this.getDescription((OWLClassExpression)this.minInclusive.get(Float.valueOf(M))));
            }
            for (float M : this.minExclusive.keySet()) {
                if (!(M <= f)) continue;
                this.normalise(this.getDescription((OWLClassExpression)this.minExclusive.get(Float.valueOf(f))), this.getDescription((OWLClassExpression)this.minExclusive.get(Float.valueOf(M))));
            }
        }
        if (this.disjoint && (this.elcontology.disjoint || this.elcontology.allconcepts.size() > 85000)) {
            void var2_44;
            ArrayList<Basic> arrayList = new ArrayList<Basic>(this.setTable.keySet());
            boolean bl = false;
            while (var2_44 < arrayList.size() - 1) {
                Basic key1 = arrayList.get((int)var2_44);
                void j = var2_44 + true;
                while (j < arrayList.size()) {
                    Basic key2 = arrayList.get((int)j);
                    boolean dis = true;
                    for (Singleton indi1 : this.setTable.get(key1)) {
                        if (indi1.differentIndividuals.containsAll((Collection)this.setTable.get(key2))) continue;
                        dis = false;
                        break;
                    }
                    if (dis) {
                        if (key2.complement != null) {
                            this.normalise(key1, key2.complement);
                        }
                        if (key1.complement != null) {
                            this.normalise(key2, key1.complement);
                        }
                    }
                    ++j;
                }
                ++var2_44;
            }
        }
        if (this.elcontology.disjoint || this.elcontology.allconcepts.size() > 85000) {
            for (OWLObjectSomeValuesFrom oWLObjectSomeValuesFrom : this.miniSet) {
                OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)oWLObjectSomeValuesFrom.getProperty();
                Set nomi = ((OWLObjectOneOf)oWLObjectSomeValuesFrom.getFiller()).getIndividuals();
                boolean union = true;
                HashSet<OWLObjectSomeValuesFrom> newsomes = new HashSet<OWLObjectSomeValuesFrom>();
                for (OWLIndividual indi3 : nomi) {
                    OWLObjectSomeValuesFrom newsome = this.factory.getOWLObjectSomeValuesFrom(prop, (OWLClassExpression)this.factory.getOWLObjectOneOf(new OWLIndividual[]{indi3}));
                    if (this.classID.containsKey(newsome)) {
                        newsomes.add(newsome);
                        continue;
                    }
                    union = false;
                    break;
                }
                if (!union) continue;
                OWLSubClassOfAxiom axiom = this.factory.getOWLSubClassOfAxiom((OWLClassExpression)oWLObjectSomeValuesFrom, (OWLClassExpression)this.factory.getOWLObjectUnionOf(newsomes));
                this.visit(axiom);
            }
        }
        for (Role role : this.elcontology.roles.values()) {
            if (!role.reflexive && (role.inverse == null || !role.inverse.reflexive) || role.somes.get(this.top) == null) continue;
            for (QueueEntry entry : role.somes.get((Object)this.top).Ohat) {
                if (!(entry instanceof Implies)) continue;
                Implies imply = (Implies)entry;
                if (imply.lhs != null) continue;
                this.normalise(this.top, imply.rhs);
            }
        }
        if (this.constants.size() < 1000) {
            this.dataDisjointness(this.factory.getOWLClass(IRI.create((String)"http://www.w3.org/2001/XMLSchema#string")), this.factory.getOWLClass(IRI.create((String)"http://www.w3.org/2001/XMLSchema#long")));
            this.dataDisjointness(this.factory.getOWLClass(IRI.create((String)"http://www.w3.org/2001/XMLSchema#string")), this.factory.getOWLClass(IRI.create((String)"http://www.w3.org/2001/XMLSchema#int")));
        }
        this.elcontology.classNum = this.classindex;
        this.elcontology.permanentclassNum = this.classindex;
        this.elcontology.roleNum = this.propertyindex;
    }

    private void dataDisjointness(OWLClass A, OWLClass B) {
        this.visit(this.factory.getOWLDisjointClassesAxiom(new OWLClassExpression[]{A, B}));
        Atomic type1 = (Atomic)this.getDescription((OWLClassExpression)A);
        Atomic type2 = (Atomic)this.getDescription((OWLClassExpression)B);
        Basic ct1 = (Basic)this.getDescription((OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)A));
        Basic ct2 = (Basic)this.getDescription((OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)B));
        type1.subsumers.add(ct2);
        type2.subsumers.add(ct1);
        for (OWLIndividual indi : this.constants) {
            Singleton single = this.getIndividual(indi);
            if (single.subsumers.contains(type1)) {
                single.subsumers.add(ct2);
                if (single.complement != null) {
                    type2.subsumers.add(single.complement);
                }
            }
            if (!single.subsumers.contains(type2)) continue;
            single.subsumers.add(ct1);
            if (single.complement == null) continue;
            type1.subsumers.add(single.complement);
        }
    }

    public OntologyBuilder() {
        super(true);
    }

    protected void initialise(Set<OWLOntology> ontologies) {
        int totalT = 0;
        int totalA = 0;
        int totalAx = 0;
        for (OWLOntology ontology : ontologies) {
            totalT += ontology.getClassesInSignature().size();
            totalA += ontology.getIndividualsInSignature().size();
            totalAx += ontology.getLogicalAxiomCount();
        }
        if (this.elcontology.profile == Ontology.Profile.OWL_2_EL || totalT > RELReasonerConfiguration.largeTThreshold) {
            this.elcontology.largeT = true;
        }
        if (this.elcontology.profile == Ontology.Profile.OWL_2_EL || totalA > RELReasonerConfiguration.largeAThreshold) {
            this.elcontology.largeA = true;
        }
        this.elcontology.disRes = RELReasonerConfiguration.applyDisRes(totalT, totalA, totalAx);
        this.individualID = this.elcontology.individualID;
        this.top.complement = this.bot;
        this.bot.complement = this.top;
        OWLClass thing = this.factory.getOWLThing();
        OWLClass nothing = this.factory.getOWLNothing();
        OWLClass namedindividual = this.factory.getOWLClass(IRI.create((String)"http://www.w3.org/2002/07/owl#NamedIndividual"));
        for (OWLOntology ontology : ontologies) {
            for (OWLClass concept : ontology.getClassesInSignature()) {
                if (concept.equals(thing) || concept.equals(nothing) || concept.equals(namedindividual)) continue;
                Atomic newconcept = new Atomic(concept);
                ++this.classindex;
                newconcept.id = newconcept.id;
                this.addClassID((OWLClassExpression)concept, newconcept.id);
                this.descriptions.put(newconcept.id, newconcept);
                this.imply(newconcept);
                this.allconcepts.add(newconcept);
                if (this.elcontology.largeT) continue;
                Atomic nA = new Atomic();
                ++this.classindex;
                nA.id = nA.id;
                nA.original = false;
                this.addClassID((OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)concept), nA.id);
                this.descriptions.put(nA.id, nA);
                this.imply(nA);
                newconcept.complement = nA;
                nA.complement = newconcept;
            }
            for (OWLObjectProperty role : ontology.getObjectPropertiesInSignature()) {
                Role newrole = new Role(role, this.propertyindex++);
                this.propertyID.put((OWLObjectPropertyExpression)role, newrole.id);
                this.roles.put(newrole.id, newrole);
                Role inv = new Role(this.propertyindex++);
                inv.original = false;
                this.propertyID.put(role.getInverseProperty(), inv.id);
                this.roles.put(inv.id, inv);
                newrole.inverse = inv;
                inv.inverse = newrole;
            }
            for (OWLDataProperty drole : ontology.getDataPropertiesInSignature()) {
                OWLObjectProperty role = this.factory.getOWLObjectProperty(drole.getIRI());
                if (this.propertyID.containsKey(role)) continue;
                Role newrole = new Role(role, this.propertyindex++);
                newrole.original = false;
                this.propertyID.put((OWLObjectPropertyExpression)role, newrole.id);
                this.roles.put(newrole.id, newrole);
            }
            for (OWLNamedIndividual individual : ontology.getIndividualsInSignature()) {
                Singleton newindividual = new Singleton((OWLIndividual)individual);
                ++this.classindex;
                newindividual.id = newindividual.id;
                this.imply(newindividual);
                this.individualID.put((OWLIndividual)individual, newindividual.id);
                this.descriptions.put(newindividual.id, newindividual);
            }
        }
    }

    public Role getRole(OWLObjectPropertyExpression property) {
        Role RN = null;
        if (this.propertyID.get(property) != null) {
            RN = this.roles.get(this.propertyID.get(property));
        } else if (property instanceof OWLObjectProperty) {
            OWLObjectProperty atomicrole = (OWLObjectProperty)property;
            RN = new Role(atomicrole, this.propertyindex++);
            this.propertyID.put(property, RN.id);
            this.roles.put(RN.id, RN);
        } else if (property instanceof OWLObjectInverseOf) {
            OWLObjectInverseOf inverse = (OWLObjectInverseOf)property;
            Role iRN = this.getRole(inverse.getInverse());
            RN = iRN.inverse;
            if (RN == null) {
                RN = new Role(this.propertyindex++);
                RN.original = false;
                this.propertyID.put(property, RN.id);
                this.roles.put(RN.id, RN);
                RN.inverse = iRN;
                iRN.inverse = RN;
            }
        }
        return RN;
    }

    public Singleton getIndividual(OWLIndividual individual1) {
        Singleton IN = null;
        if (this.individualID.get(individual1) != null) {
            IN = (Singleton)this.descriptions.get(this.individualID.get(individual1));
        } else {
            IN = new Singleton(individual1);
            if (this.floatIndividual.containsValue(individual1)) {
                IN.id = this.classindex++;
            } else if (this.constants.contains(individual1)) {
                IN.id = this.nonbasicindex--;
                IN.subsumers.add(this.top);
            } else {
                IN.id = this.classindex++;
            }
            IN.original = false;
            this.imply(IN);
            this.individualID.put(individual1, IN.id);
            this.descriptions.put(IN.id, IN);
        }
        return IN;
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        OWLIndividual sub = axiom.getSubject();
        OWLIndividual obj = (OWLIndividual)axiom.getObject();
        Singleton subject = this.getIndividual(sub);
        Singleton object = this.getIndividual(obj);
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        Role role = this.getRole(property);
        this.initialise(subject, role, (Basic)object);
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        OWLIndividual sub = axiom.getSubject();
        OWLNamedIndividual obj = this.factory.getOWLNamedIndividual(IRI.create((String)(INDI_PREFIX + ((OWLLiteral)axiom.getObject()).getLiteral())));
        this.constants.add((OWLIndividual)obj);
        if (((OWLLiteral)axiom.getObject()).isFloat()) {
            this.floatIndividual.put(Float.valueOf(((OWLLiteral)axiom.getObject()).parseFloat()), (OWLIndividual)obj);
        }
        Singleton subject = this.getIndividual(sub);
        Singleton object = this.getIndividual((OWLIndividual)obj);
        OWLDataPropertyExpression property = (OWLDataPropertyExpression)axiom.getProperty();
        Role role = this.getRole(property);
        this.initialise(subject, role, (Basic)object);
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        Singleton indi = this.getIndividual(axiom.getIndividual());
        Description classification = this.getDescription(this.getNNF(axiom.getClassExpression()));
        this.normalise(indi, classification);
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.disjoint = true;
        Set individuals = axiom.getIndividuals();
        for (OWLIndividual individual1 : individuals) {
            Singleton indi1 = this.getIndividual(individual1);
            for (OWLIndividual individual2 : individuals) {
                if (individual1.equals(individual2)) continue;
                Singleton indi2 = this.getIndividual(individual2);
                indi1.differentIndividuals.add(indi2);
                indi2.differentIndividuals.add(indi1);
            }
        }
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        Set individuals = axiom.getIndividuals();
        for (OWLIndividual individual1 : individuals) {
            Singleton indi1 = this.getIndividual(individual1);
            for (OWLIndividual individual2 : individuals) {
                if (individual1.equals(individual2)) continue;
                Singleton indi2 = this.getIndividual(individual2);
                this.normalise(indi1, indi2);
                this.normalise(indi2, indi1);
            }
        }
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        Role role1 = this.getRole(axiom.getFirstProperty());
        Role role2 = this.getRole(axiom.getSecondProperty());
        role1.subsumers.add(role2.inverse);
        role2.subsumers.add(role1.inverse);
        role1.inverse.subsumers.add(role2);
        role2.inverse.subsumers.add(role1);
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        OWLClassExpression range = (OWLClassExpression)axiom.getRange();
        OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)axiom.getProperty();
        this.getRole((OWLObjectPropertyExpression)property).related = true;
        OWLObjectSomeValuesFrom some = this.factory.getOWLObjectSomeValuesFrom(property, (OWLClassExpression)this.factory.getOWLObjectComplementOf(range));
        this.normalise(this.getDescription(this.getNNF((OWLClassExpression)some)), this.bot);
        OWLObjectSomeValuesFrom exist = this.factory.getOWLObjectSomeValuesFrom(property.getInverseProperty(), (OWLClassExpression)this.factory.getOWLThing());
        this.normalise(this.getDescription(this.getNNF((OWLClassExpression)exist)), this.getDescription(this.getNNF(range)));
        Role inverse = this.getRole(property.getInverseProperty());
        if (inverse != null) {
            inverse.related = true;
        }
    }

    public Atomic getNamedClass(Description desc) {
        Atomic A = this.normalisationNames.get(desc);
        if (A == null) {
            A = new Atomic();
            A.id = this.classindex++;
            A.original = false;
            this.descriptions.put(A.id, A);
            this.normalisationNames.put(desc, A);
            this.imply(A);
            if (!this.elcontology.largeT) {
                Atomic Acomp = new Atomic();
                Acomp.id = this.classindex++;
                Acomp.original = false;
                this.descriptions.put(Acomp.id, Acomp);
                this.imply(Acomp);
                A.complement = Acomp;
                Acomp.complement = A;
            }
        }
        return A;
    }

    public Ontology getELOntology() {
        return this.elcontology;
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        OWLClassExpression sub = axiom.getSubClass();
        for (OWLObjectProperty prop : sub.getObjectPropertiesInSignature()) {
            this.getRole((OWLObjectPropertyExpression)prop).related = true;
        }
        OWLClassExpression sup = axiom.getSuperClass();
        this.approximate(this.getNNF(sub), this.getNNF(sup));
    }

    protected void approximate(OWLClassExpression sub, OWLClassExpression sup) {
        OWLObjectSomeValuesFrom some;
        Description lhs = this.getDescription(sub);
        Description rhs = this.getDescription(sup);
        if (this.elcontology.largeT && lhs instanceof Basic && rhs instanceof Basic) {
            Basic lbasic = (Basic)lhs;
            Basic rbasic = (Basic)rhs;
            if (rbasic.originalSubsumee == null) {
                rbasic.originalSubsumee = new HashSet();
            }
            rbasic.originalSubsumee.add(lbasic);
        }
        if (lhs instanceof Basic && sup instanceof OWLObjectSomeValuesFrom && (some = (OWLObjectSomeValuesFrom)sup).getFiller() instanceof OWLObjectUnionOf) {
            HashSet<OWLObjectSomeValuesFrom> somes = new HashSet<OWLObjectSomeValuesFrom>();
            for (OWLClassExpression exp : ((OWLObjectUnionOf)some.getFiller()).getOperands()) {
                somes.add(this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)some.getProperty(), exp));
            }
            Basic rewriting = (Basic)this.getDescription((OWLClassExpression)this.factory.getOWLObjectUnionOf(somes));
            this.normalise(lhs, rewriting);
            if (this.elcontology.largeT) {
                if (rewriting.originalSubsumee == null) {
                    rewriting.originalSubsumee = new HashSet();
                }
                rewriting.originalSubsumee.add((Basic)lhs);
            }
        }
        this.normalise(lhs, rhs);
        if (this.elcontology.MetaOn && sub instanceof OWLObjectSomeValuesFrom) {
            some = (OWLObjectSomeValuesFrom)sub;
            OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)some.getProperty();
            this.approximate((OWLClassExpression)some.getFiller(), (OWLClassExpression)this.factory.getOWLObjectAllValuesFrom(prop.getInverseProperty(), sup));
        }
    }

    public Role getRole(OWLDataPropertyExpression property) {
        Role RN = null;
        if (property instanceof OWLDataProperty) {
            OWLObjectProperty oproperty = this.factory.getOWLObjectProperty(((OWLDataProperty)property).getIRI());
            RN = this.roles.get(this.propertyID.get(oproperty));
        }
        return RN;
    }

    private void normaliseRoleChain(ArrayList<Role> lhs, Role rhs) {
        this.chainroles.add(rhs);
        this.chainroles.add(rhs.inverse);
        if (lhs.size() > 2) {
            Role roleR2 = lhs.remove(lhs.size() - 1);
            Role roleR1 = this.getChainName(lhs);
            HashSet<Role> superroles = roleR1.RightComposition.get(roleR2);
            if (superroles == null) {
                superroles = new HashSet();
                roleR1.RightComposition.put(roleR2, superroles);
            }
            superroles.add(rhs);
            this.normaliseRoleChain(lhs, roleR1);
        } else {
            Role roleR1 = lhs.get(0);
            Role roleR2 = lhs.get(1);
            this.chainroles.add(roleR1);
            this.chainroles.add(roleR1.inverse);
            this.chainroles.add(roleR2);
            this.chainroles.add(roleR2.inverse);
            HashSet<Role> superroles = roleR1.RightComposition.get(roleR2);
            if (superroles == null) {
                superroles = new HashSet();
                roleR1.RightComposition.put(roleR2, superroles);
            }
            superroles.add(rhs);
        }
    }

    private Role getChainName(ArrayList<Role> chain) {
        Role name = this.chainName.get(chain);
        if (name == null) {
            name = new Role(this.propertyindex++);
            name.original = false;
            this.chainName.put(chain, name);
            this.roles.put(name.id, name);
            Role inv = new Role(this.propertyindex++);
            inv.original = false;
            this.roles.put(inv.id, inv);
            name.inverse = inv;
            inv.inverse = name;
        }
        return name;
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.getRole((OWLObjectPropertyExpression)((OWLObjectPropertyExpression)axiom.getSubProperty())).subsumers.add(this.getRole((OWLObjectPropertyExpression)axiom.getSuperProperty()));
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.getRole((OWLDataPropertyExpression)((OWLDataPropertyExpression)axiom.getSubProperty())).subsumers.add(this.getRole((OWLDataPropertyExpression)axiom.getSuperProperty()));
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        ++this.chain;
        ArrayList<Role> lhs = new ArrayList<Role>();
        for (OWLObjectPropertyExpression role : axiom.getPropertyChain()) {
            lhs.add(this.getRole(role));
        }
        Role rhs = this.getRole(axiom.getSuperProperty());
        this.normaliseRoleChain(lhs, rhs);
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        OWLObjectSomeValuesFrom exist = this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)axiom.getProperty(), (OWLClassExpression)this.factory.getOWLThing());
        Description lhs = this.getDescription(this.getNNF((OWLClassExpression)exist));
        this.getRole((OWLObjectPropertyExpression)((OWLObjectPropertyExpression)axiom.getProperty())).related = true;
        Description rhs = this.getDescription(this.getNNF(axiom.getDomain()));
        this.normalise(lhs, rhs);
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        OWLObjectSomeValuesFrom exist = this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)axiom.getProperty()).asOWLDataProperty().getIRI()), (OWLClassExpression)this.factory.getOWLThing());
        this.getRole((OWLDataPropertyExpression)((OWLDataPropertyExpression)axiom.getProperty())).related = true;
        Description lhs = this.getDescription(this.getNNF((OWLClassExpression)exist));
        Description rhs = this.getDescription(this.getNNF(axiom.getDomain()));
        this.normalise(lhs, rhs);
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        OWLDataRange range = (OWLDataRange)axiom.getRange();
        OWLDataPropertyExpression property = (OWLDataPropertyExpression)axiom.getProperty();
        this.getRole((OWLDataPropertyExpression)property).related = true;
        OWLDataSomeValuesFrom some = this.factory.getOWLDataSomeValuesFrom(property, (OWLDataRange)this.factory.getOWLDataComplementOf(range));
        this.normalise(this.getDescription(this.getNNF((OWLClassExpression)some)), this.bot);
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        for (OWLClassExpression c : axiom.getClassExpressions()) {
            for (OWLObjectProperty prop : c.getObjectPropertiesInSignature()) {
                this.getRole((OWLObjectPropertyExpression)prop).related = true;
            }
            for (OWLClassExpression d : axiom.getClassExpressions()) {
                if (c.equals(d)) continue;
                Description ddes = this.getDescription(this.getNNF(d));
                if (c instanceof OWLObjectUnionOf) {
                    for (OWLClassExpression sub : c.asDisjunctSet()) {
                        this.normalise(this.getDescription(this.getNNF(sub)), ddes);
                        if (!this.elcontology.MetaOn || !(sub instanceof OWLObjectSomeValuesFrom)) continue;
                        OWLObjectSomeValuesFrom some = (OWLObjectSomeValuesFrom)sub;
                        OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)some.getProperty();
                        this.approximate((OWLClassExpression)some.getFiller(), (OWLClassExpression)this.factory.getOWLObjectAllValuesFrom(prop.getInverseProperty(), d));
                    }
                    continue;
                }
                Description cdes = this.getDescription(this.getNNF(c));
                this.normalise(cdes, ddes);
                if (!this.elcontology.MetaOn || !(this.getNNF(c) instanceof OWLObjectSomeValuesFrom)) continue;
                OWLObjectSomeValuesFrom some = (OWLObjectSomeValuesFrom)this.getNNF(c);
                OWLObjectPropertyExpression prop = (OWLObjectPropertyExpression)some.getProperty();
                this.approximate((OWLClassExpression)some.getFiller(), (OWLClassExpression)this.factory.getOWLObjectAllValuesFrom(prop.getInverseProperty(), d));
            }
        }
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        for (OWLObjectPropertyExpression r : axiom.getProperties()) {
            for (OWLObjectPropertyExpression s : axiom.getProperties()) {
                if (r.equals(s)) continue;
                Role roler = this.getRole(r);
                Role roles = this.getRole(s);
                roler.subsumers.add(roles);
            }
        }
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        for (OWLDataPropertyExpression r : axiom.getProperties()) {
            for (OWLDataPropertyExpression s : axiom.getProperties()) {
                if (r.equals(s)) continue;
                Role roler = this.getRole(r);
                Role roles = this.getRole(s);
                roler.subsumers.add(roles);
            }
        }
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        ++this.trans;
        OWLSubPropertyChainOfAxiom rewritten = this.factory.getOWLSubPropertyChainOfAxiom(Arrays.asList((OWLObjectPropertyExpression)axiom.getProperty(), (OWLObjectPropertyExpression)axiom.getProperty()), (OWLObjectPropertyExpression)axiom.getProperty());
        this.visit(rewritten);
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        if (this.elcontology.largeT) {
            HashSet<OWLClassExpression> dess = new HashSet<OWLClassExpression>();
            for (OWLClassExpression des1 : axiom.getClassExpressions()) {
                for (OWLClassExpression desc : dess) {
                    OWLObjectIntersectionOf inter = this.factory.getOWLObjectIntersectionOf(new OWLClassExpression[]{des1, desc});
                    OWLSubClassOfAxiom ax = this.factory.getOWLSubClassOfAxiom((OWLClassExpression)inter, (OWLClassExpression)this.factory.getOWLNothing());
                    ax.accept((OWLAxiomVisitor)this);
                }
                dess.add(des1);
            }
        } else {
            HashSet<Basic> dess = new HashSet<Basic>();
            for (OWLClassExpression des1 : axiom.getClassExpressions()) {
                Description desc1 = this.getDescription(this.getNNF(des1));
                Basic desc = desc1 instanceof Basic ? (Basic)desc1 : this.getNamedClass(desc1);
                for (Basic basic : dess) {
                    basic.Ohat.add(this.getA2Bot(desc));
                    desc.Ohat.add(this.getA2Bot(basic));
                }
                dess.add(desc);
            }
        }
    }

    Implies getA2Bot(Basic basic) {
        return basic.complement.entry;
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        Role role = this.getRole((OWLObjectPropertyExpression)axiom.getProperty());
        role.reflexive = true;
        role.inverse.reflexive = true;
    }

    protected OWLClassExpression getNNF(OWLClassExpression concept) {
        Object nnf = null;
        if (concept.isOWLThing() || concept.isOWLNothing() || concept instanceof OWLClass || concept instanceof OWLObjectOneOf) {
            nnf = concept;
        } else if (concept instanceof OWLObjectComplementOf) {
            OWLObjectComplementOf comp = (OWLObjectComplementOf)concept;
            OWLClassExpression des = comp.getOperand();
            if (des.isOWLThing()) {
                nnf = this.factory.getOWLNothing();
            } else if (des.isOWLNothing()) {
                nnf = this.factory.getOWLThing();
            } else if (des instanceof OWLClass) {
                nnf = concept;
            } else if (des instanceof OWLObjectComplementOf) {
                OWLObjectComplementOf doublecomp = (OWLObjectComplementOf)des;
                nnf = doublecomp.getOperand();
            } else if (des instanceof OWLObjectIntersectionOf) {
                OWLObjectIntersectionOf intersection = (OWLObjectIntersectionOf)des;
                HashSet<OWLClassExpression> interNNF = new HashSet<OWLClassExpression>();
                for (OWLClassExpression inter : intersection.getOperands()) {
                    interNNF.add(this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf(inter)));
                }
                nnf = this.factory.getOWLObjectUnionOf(interNNF);
            } else if (des instanceof OWLObjectUnionOf) {
                OWLObjectUnionOf union = (OWLObjectUnionOf)des;
                HashSet<OWLClassExpression> uniNNF = new HashSet<OWLClassExpression>();
                for (OWLClassExpression uni : union.getOperands()) {
                    uniNNF.add(this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf(uni)));
                }
                nnf = this.factory.getOWLObjectIntersectionOf(uniNNF);
            } else if (des instanceof OWLObjectSomeValuesFrom) {
                OWLObjectSomeValuesFrom some = (OWLObjectSomeValuesFrom)des;
                OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)some.getProperty();
                OWLClassExpression filler = (OWLClassExpression)some.getFiller();
                nnf = this.factory.getOWLObjectAllValuesFrom(property, this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf(filler)));
            } else if (des instanceof OWLObjectAllValuesFrom) {
                OWLObjectAllValuesFrom all = (OWLObjectAllValuesFrom)des;
                OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)all.getProperty();
                OWLClassExpression filler = (OWLClassExpression)all.getFiller();
                nnf = this.factory.getOWLObjectSomeValuesFrom(property, this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf(filler)));
            } else if (des instanceof OWLObjectMinCardinality) {
                OWLObjectMinCardinality min = (OWLObjectMinCardinality)des;
                OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)min.getProperty();
                OWLClassExpression filler = (OWLClassExpression)min.getFiller();
                int card = min.getCardinality();
                nnf = card >= 1 ? this.factory.getOWLObjectMaxCardinality(card - 1, property, this.getNNF(filler)) : this.factory.getOWLNothing();
            } else if (des instanceof OWLObjectMaxCardinality) {
                OWLObjectMaxCardinality max = (OWLObjectMaxCardinality)des;
                OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)max.getProperty();
                OWLClassExpression filler = (OWLClassExpression)max.getFiller();
                int card = max.getCardinality();
                nnf = this.factory.getOWLObjectMinCardinality(card + 1, property, this.getNNF(filler));
            } else if (des instanceof OWLObjectExactCardinality) {
                OWLObjectExactCardinality exact = (OWLObjectExactCardinality)des;
                if (exact.getCardinality() >= 1) {
                    OWLObjectMaxCardinality low = this.factory.getOWLObjectMaxCardinality(exact.getCardinality() - 1, (OWLObjectPropertyExpression)exact.getProperty(), this.getNNF((OWLClassExpression)exact.getFiller()));
                    OWLObjectMinCardinality high = this.factory.getOWLObjectMinCardinality(exact.getCardinality() + 1, (OWLObjectPropertyExpression)exact.getProperty(), this.getNNF((OWLClassExpression)exact.getFiller()));
                    nnf = this.factory.getOWLObjectUnionOf(new OWLClassExpression[]{low, high});
                } else {
                    nnf = this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)exact.getProperty(), this.getNNF((OWLClassExpression)exact.getFiller()));
                }
            } else if (des instanceof OWLObjectOneOf) {
                OWLObjectOneOf oneof = (OWLObjectOneOf)des;
                HashSet<OWLObjectComplementOf> compinter = new HashSet<OWLObjectComplementOf>();
                for (OWLIndividual indi : oneof.getIndividuals()) {
                    compinter.add(this.factory.getOWLObjectComplementOf((OWLClassExpression)this.factory.getOWLObjectOneOf(new OWLIndividual[]{indi})));
                }
                nnf = this.factory.getOWLObjectIntersectionOf(compinter);
            } else if (des instanceof OWLObjectHasValue) {
                OWLObjectHasValue value = (OWLObjectHasValue)des;
                nnf = this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)value.getProperty(), (OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)this.factory.getOWLObjectOneOf(new OWLIndividual[]{(OWLIndividual)value.getValue()})));
            } else if (des instanceof OWLDataSomeValuesFrom) {
                OWLDataSomeValuesFrom some = (OWLDataSomeValuesFrom)des;
                OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)some.getProperty()).asOWLDataProperty().getIRI());
                nnf = this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)this.factory.getOWLDataComplementOf((OWLDataRange)some.getFiller())));
            } else if (des instanceof OWLDataAllValuesFrom) {
                OWLDataAllValuesFrom all = (OWLDataAllValuesFrom)des;
                OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)all.getProperty()).asOWLDataProperty().getIRI());
                nnf = this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)this.factory.getOWLDataComplementOf((OWLDataRange)all.getFiller())));
            } else if (des instanceof OWLDataHasValue) {
                OWLDataHasValue value = (OWLDataHasValue)des;
                OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)value.getProperty()).asOWLDataProperty().getIRI());
                OWLNamedIndividual indi = this.factory.getOWLNamedIndividual(IRI.create((String)(INDI_PREFIX + ((OWLLiteral)value.getValue()).getLiteral())));
                this.constants.add((OWLIndividual)indi);
                if (((OWLLiteral)value.getValue()).isFloat()) {
                    this.floatIndividual.put(Float.valueOf(((OWLLiteral)value.getValue()).parseFloat()), (OWLIndividual)indi);
                }
                nnf = this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)property, (OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)this.factory.getOWLObjectOneOf(new OWLIndividual[]{indi})));
            } else if (des instanceof OWLDataMinCardinality) {
                OWLDataMinCardinality min = (OWLDataMinCardinality)des;
                OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)min.getProperty()).asOWLDataProperty().getIRI());
                OWLDataRange filler = (OWLDataRange)min.getFiller();
                int card = min.getCardinality();
                nnf = card >= 1 ? this.factory.getOWLObjectMaxCardinality(card - 1, (OWLObjectPropertyExpression)property, this.getNNF(filler)) : this.factory.getOWLNothing();
            } else if (des instanceof OWLDataMaxCardinality) {
                OWLDataMaxCardinality max = (OWLDataMaxCardinality)des;
                OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)max.getProperty()).asOWLDataProperty().getIRI());
                OWLDataRange filler = (OWLDataRange)max.getFiller();
                int card = max.getCardinality();
                nnf = this.factory.getOWLObjectMinCardinality(card + 1, (OWLObjectPropertyExpression)property, this.getNNF(filler));
            } else if (des instanceof OWLDataExactCardinality) {
                OWLDataExactCardinality exact = (OWLDataExactCardinality)des;
                OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)exact.getProperty()).asOWLDataProperty().getIRI());
                if (exact.getCardinality() >= 1) {
                    OWLObjectMaxCardinality low = this.factory.getOWLObjectMaxCardinality(exact.getCardinality() - 1, (OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)exact.getFiller()));
                    OWLObjectMinCardinality high = this.factory.getOWLObjectMinCardinality(exact.getCardinality() + 1, (OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)exact.getFiller()));
                    nnf = this.factory.getOWLObjectUnionOf(new OWLClassExpression[]{low, high});
                } else {
                    nnf = this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)exact.getFiller()));
                }
            } else {
                nnf = concept;
            }
        } else if (concept instanceof OWLObjectIntersectionOf) {
            OWLObjectIntersectionOf inter = (OWLObjectIntersectionOf)concept;
            HashSet<OWLClassExpression> interNNF = new HashSet<OWLClassExpression>();
            for (OWLClassExpression des : inter.getOperands()) {
                interNNF.add(this.getNNF(des));
            }
            nnf = this.factory.getOWLObjectIntersectionOf(interNNF);
        } else if (concept instanceof OWLObjectUnionOf) {
            OWLObjectUnionOf union = (OWLObjectUnionOf)concept;
            HashSet<OWLClassExpression> unionNNF = new HashSet<OWLClassExpression>();
            for (OWLClassExpression des : union.getOperands()) {
                unionNNF.add(this.getNNF(des));
            }
            nnf = this.factory.getOWLObjectUnionOf(unionNNF);
        } else if (concept instanceof OWLObjectSomeValuesFrom) {
            OWLObjectSomeValuesFrom some = (OWLObjectSomeValuesFrom)concept;
            OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)some.getProperty();
            nnf = this.factory.getOWLObjectSomeValuesFrom(property, this.getNNF((OWLClassExpression)some.getFiller()));
        } else if (concept instanceof OWLObjectAllValuesFrom) {
            OWLObjectAllValuesFrom all = (OWLObjectAllValuesFrom)concept;
            nnf = this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)all.getProperty(), this.getNNF((OWLClassExpression)all.getFiller()));
        } else if (concept instanceof OWLObjectMinCardinality) {
            OWLObjectMinCardinality min = (OWLObjectMinCardinality)concept;
            OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)min.getProperty();
            OWLClassExpression filler = (OWLClassExpression)min.getFiller();
            int card = min.getCardinality();
            nnf = card == 0 ? this.factory.getOWLThing() : (card == 1 ? this.factory.getOWLObjectSomeValuesFrom(property, this.getNNF(filler)) : this.factory.getOWLObjectMinCardinality(card, property, this.getNNF(filler)));
        } else if (concept instanceof OWLObjectMaxCardinality) {
            OWLObjectMaxCardinality max = (OWLObjectMaxCardinality)concept;
            OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)max.getProperty();
            OWLClassExpression filler = (OWLClassExpression)max.getFiller();
            int card = max.getCardinality();
            nnf = card < 1 ? this.factory.getOWLObjectAllValuesFrom(property, this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf(filler))) : this.factory.getOWLObjectMaxCardinality(card, property, this.getNNF(filler));
        } else if (concept instanceof OWLObjectExactCardinality) {
            OWLObjectExactCardinality exact = (OWLObjectExactCardinality)concept;
            if (exact.getCardinality() >= 1) {
                OWLObjectMaxCardinality low = this.factory.getOWLObjectMaxCardinality(exact.getCardinality(), (OWLObjectPropertyExpression)exact.getProperty(), this.getNNF((OWLClassExpression)exact.getFiller()));
                OWLObjectMinCardinality high = this.factory.getOWLObjectMinCardinality(exact.getCardinality(), (OWLObjectPropertyExpression)exact.getProperty(), this.getNNF((OWLClassExpression)exact.getFiller()));
                nnf = this.factory.getOWLObjectIntersectionOf(new OWLClassExpression[]{this.getNNF((OWLClassExpression)low), this.getNNF((OWLClassExpression)high)});
            } else {
                nnf = this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)exact.getProperty(), this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf((OWLClassExpression)exact.getFiller())));
            }
        } else if (concept instanceof OWLObjectHasValue) {
            OWLObjectHasValue value = (OWLObjectHasValue)concept;
            OWLObjectPropertyExpression property = (OWLObjectPropertyExpression)value.getProperty();
            OWLIndividual indi = (OWLIndividual)value.getValue();
            nnf = this.factory.getOWLObjectSomeValuesFrom(property, (OWLClassExpression)this.factory.getOWLObjectOneOf(new OWLIndividual[]{indi}));
        } else if (concept instanceof OWLDataSomeValuesFrom) {
            OWLDataSomeValuesFrom some = (OWLDataSomeValuesFrom)concept;
            OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)some.getProperty()).asOWLDataProperty().getIRI());
            nnf = this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)some.getFiller()));
        } else if (concept instanceof OWLDataAllValuesFrom) {
            OWLDataAllValuesFrom all = (OWLDataAllValuesFrom)concept;
            OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)all.getProperty()).asOWLDataProperty().getIRI());
            nnf = this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)all.getFiller()));
        } else if (concept instanceof OWLDataHasValue) {
            OWLDataHasValue value = (OWLDataHasValue)concept;
            OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)value.getProperty()).asOWLDataProperty().getIRI());
            OWLNamedIndividual indi = this.factory.getOWLNamedIndividual(IRI.create((String)(INDI_PREFIX + ((OWLLiteral)value.getValue()).getLiteral())));
            OWLClass cls = this.factory.getOWLClass(((OWLLiteral)value.getValue()).getDatatype().getIRI());
            this.constants.add((OWLIndividual)indi);
            if (((OWLLiteral)value.getValue()).isFloat()) {
                this.floatIndividual.put(Float.valueOf(((OWLLiteral)value.getValue()).parseFloat()), (OWLIndividual)indi);
            }
            nnf = this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)property, (OWLClassExpression)this.factory.getOWLObjectOneOf(new OWLIndividual[]{indi}));
            this.getIndividual((OWLIndividual)indi).subsumers.add((Basic)this.getDescription((OWLClassExpression)cls));
        } else if (concept instanceof OWLDataMinCardinality) {
            OWLDataMinCardinality min = (OWLDataMinCardinality)concept;
            OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)min.getProperty()).asOWLDataProperty().getIRI());
            OWLDataRange filler = (OWLDataRange)min.getFiller();
            int card = min.getCardinality();
            nnf = card == 0 ? this.factory.getOWLThing() : (card == 1 ? this.factory.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)property, this.getNNF(filler)) : this.factory.getOWLObjectMinCardinality(card, (OWLObjectPropertyExpression)property, this.getNNF(filler)));
        } else if (concept instanceof OWLDataMaxCardinality) {
            OWLDataMaxCardinality max = (OWLDataMaxCardinality)concept;
            OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)max.getProperty()).asOWLDataProperty().getIRI());
            OWLDataRange filler = (OWLDataRange)max.getFiller();
            int card = max.getCardinality();
            nnf = card < 1 ? this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)this.factory.getOWLDataComplementOf(filler))) : this.factory.getOWLObjectMaxCardinality(card, (OWLObjectPropertyExpression)property, this.getNNF(filler));
        } else if (concept instanceof OWLDataExactCardinality) {
            OWLDataExactCardinality exact = (OWLDataExactCardinality)concept;
            OWLObjectProperty property = this.factory.getOWLObjectProperty(((OWLDataPropertyExpression)exact.getProperty()).asOWLDataProperty().getIRI());
            if (exact.getCardinality() >= 1) {
                OWLObjectMaxCardinality low = this.factory.getOWLObjectMaxCardinality(exact.getCardinality(), (OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)exact.getFiller()));
                OWLObjectMinCardinality high = this.factory.getOWLObjectMinCardinality(exact.getCardinality(), (OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)exact.getFiller()));
                nnf = this.factory.getOWLObjectIntersectionOf(new OWLClassExpression[]{this.getNNF((OWLClassExpression)low), this.getNNF((OWLClassExpression)high)});
            } else {
                nnf = this.factory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)property, this.getNNF((OWLDataRange)this.factory.getOWLDataComplementOf((OWLDataRange)exact.getFiller())));
            }
        } else {
            nnf = concept;
        }
        return nnf;
    }

    private OWLClassExpression getNNF(OWLDataRange data) {
        OWLClass NC = null;
        if (data.isDatatype()) {
            OWLDatatype type = data.asOWLDatatype();
            OWLClass dataclass = this.factory.getOWLClass(type.getIRI());
            this.datatypes.add(dataclass);
            NC = dataclass;
        } else if (data instanceof OWLDataComplementOf) {
            OWLDataComplementOf comp = (OWLDataComplementOf)data;
            OWLDataRange des = comp.getDataRange();
            NC = this.getNNF((OWLClassExpression)this.factory.getOWLObjectComplementOf(this.getNNF(des)));
        } else if (data instanceof OWLDataIntersectionOf) {
            OWLDataIntersectionOf intesect = (OWLDataIntersectionOf)data;
            HashSet<OWLClassExpression> clss = new HashSet<OWLClassExpression>();
            for (OWLDataRange rng : intesect.getOperands()) {
                clss.add(this.getNNF(rng));
            }
            NC = this.getNNF((OWLClassExpression)this.factory.getOWLObjectIntersectionOf(clss));
        } else if (data instanceof OWLDataUnionOf) {
            OWLDataUnionOf union = (OWLDataUnionOf)data;
            HashSet<OWLClassExpression> clss = new HashSet<OWLClassExpression>();
            for (OWLDataRange rng : union.getOperands()) {
                clss.add(this.getNNF(rng));
            }
            NC = this.getNNF((OWLClassExpression)this.factory.getOWLObjectUnionOf(clss));
        } else if (data instanceof OWLDataOneOf) {
            OWLDataOneOf oneof = (OWLDataOneOf)data;
            HashSet<OWLNamedIndividual> concepts = new HashSet<OWLNamedIndividual>();
            for (OWLLiteral constant : oneof.getValues()) {
                OWLNamedIndividual individual = this.factory.getOWLNamedIndividual(IRI.create((String)(INDI_PREFIX + constant.getLiteral())));
                this.constants.add((OWLIndividual)individual);
                if (constant.isFloat()) {
                    this.floatIndividual.put(Float.valueOf(constant.parseFloat()), (OWLIndividual)individual);
                }
                concepts.add(individual);
                OWLClass cls = this.factory.getOWLClass(constant.getDatatype().getIRI());
                this.getIndividual((OWLIndividual)individual).subsumers.add((Basic)this.getDescription((OWLClassExpression)cls));
            }
            NC = this.factory.getOWLObjectOneOf(concepts);
        } else if (data instanceof OWLDatatypeRestriction) {
            OWLDatatypeRestriction rest = (OWLDatatypeRestriction)data;
            HashSet<Object> exps = new HashSet<Object>();
            exps.add(this.getNNF((OWLDataRange)rest.getDatatype()));
            for (OWLFacetRestriction facet : rest.getFacetRestrictions()) {
                if (facet.getFacetValue().isFloat()) {
                    OWLClass cls;
                    float value = facet.getFacetValue().parseFloat();
                    String restriction = facet.getFacet().getIRI().getFragment();
                    if (restriction.contains("minInclusive")) {
                        cls = this.factory.getOWLClass(IRI.create((String)("http://trowl.eu/minInclusive/" + value)));
                        this.minInclusive.put(Float.valueOf(value), cls);
                        exps.add(cls);
                        continue;
                    }
                    if (restriction.contains("minExclusive")) {
                        cls = this.factory.getOWLClass(IRI.create((String)("http://trowl.eu/minExclusive/" + value)));
                        this.minExclusive.put(Float.valueOf(value), cls);
                        exps.add(cls);
                        continue;
                    }
                    if (restriction.contains("maxInclusive")) {
                        cls = this.factory.getOWLClass(IRI.create((String)("http://trowl.eu/maxInclusive/" + value)));
                        this.maxInclusive.put(Float.valueOf(value), cls);
                        exps.add(cls);
                        continue;
                    }
                    if (restriction.contains("maxExclusive")) {
                        cls = this.factory.getOWLClass(IRI.create((String)("http://trowl.eu/maxExclusive/" + value)));
                        this.maxExclusive.put(Float.valueOf(value), cls);
                        exps.add(cls);
                        continue;
                    }
                    OWLNamedIndividual individual = this.factory.getOWLNamedIndividual(IRI.create((String)(INDI_PREFIX + facet.getFacetValue().parseFloat())));
                    exps.add(this.factory.getOWLObjectHasValue((OWLObjectPropertyExpression)this.factory.getOWLObjectProperty(facet.getFacet().getIRI()), (OWLIndividual)individual));
                    continue;
                }
                exps.add(this.factory.getOWLObjectHasValue((OWLObjectPropertyExpression)this.factory.getOWLObjectProperty(facet.getFacet().getIRI()), (OWLIndividual)this.factory.getOWLNamedIndividual(IRI.create((String)(INDI_PREFIX + facet.getFacetValue())))));
            }
            NC = this.factory.getOWLObjectIntersectionOf(exps);
        }
        return NC;
    }

    public void normalise(Description lhs, Description rhs) {
        if (lhs instanceof And) {
            And and = (And)lhs;
            HashSet<Description> descriptions = and.operands;
            HashSet<Basic> normalised = new HashSet<Basic>();
            for (Description CHat : descriptions) {
                if (!(CHat instanceof Basic)) {
                    Atomic A = this.getNamedClass(CHat);
                    normalised.add(A);
                    this.normalise(CHat, A);
                    continue;
                }
                normalised.add((Basic)CHat);
            }
            Basic B = null;
            if (rhs instanceof Basic) {
                B = (Basic)rhs;
            } else {
                B = this.getNamedClass(rhs);
                this.normalise(B, rhs);
            }
            this.initialise(normalised, B);
        } else if (lhs instanceof Some) {
            Some some = (Some)lhs;
            Role role = some.role;
            Description filler = some.concept;
            Basic A = null;
            if (!(filler instanceof Basic)) {
                A = this.getNamedClass(filler);
                this.normalise(filler, A);
                some = new Some(role, A);
                some.id = this.nonbasicindex--;
            } else {
                A = (Basic)filler;
            }
            if (role.somes.get(A) == null) {
                role.somes.put(A, some);
            }
            if (rhs instanceof Basic) {
                this.initialise(role, A, (Basic)rhs);
            } else {
                Atomic B = this.getNamedClass(rhs);
                this.initialise(role, A, (Basic)B);
                this.normalise(B, rhs);
            }
        } else if (lhs instanceof Basic) {
            if (rhs instanceof Some) {
                Some some = (Some)rhs;
                Role role = some.role;
                Description filler = some.concept;
                Basic B = null;
                if (!(filler instanceof Basic)) {
                    B = this.getNamedClass(filler);
                    this.normalise(B, filler);
                } else {
                    B = (Basic)filler;
                }
                this.initialise((Basic)lhs, role, B);
            } else if (rhs instanceof And) {
                And and = (And)rhs;
                for (Description operand : and.operands) {
                    if (operand instanceof Basic) {
                        this.initialise((Basic)lhs, (Basic)operand);
                        continue;
                    }
                    this.normalise(lhs, operand);
                }
            } else {
                this.initialise((Basic)lhs, (Basic)rhs);
            }
        }
    }

    protected void initialise(Basic lhs, Basic rhs) {
        lhs.Ohat.add(rhs.entry);
    }

    protected void initialise(HashSet<Basic> lhs, Basic rhs) {
        if (lhs.size() == 1) {
            Implies imply = rhs.entry;
            lhs.iterator().next().Ohat.add(imply);
        } else {
            for (Basic desc : lhs) {
                Implies implies = new Implies();
                implies.rhs = rhs;
                for (Basic company : lhs) {
                    if (company.equals(desc)) continue;
                    implies.lhs.add(company);
                }
                ++this.impliesID;
                implies.id = implies.id;
                desc.Ohat.add(implies);
            }
        }
    }

    protected void initialise(Basic A, Role role, Basic B) {
        Some exists = role.somes.get(B);
        if (exists == null) {
            exists = new Some(role, B);
            exists.id = this.nonbasicindex--;
            role.somes.put(B, exists);
        }
        A.Ohat.add(exists);
    }

    protected void initialise(Role role, Basic A, Basic B) {
        Some some = this.elcontology.roles.get((Object)Integer.valueOf((int)role.id)).somes.get(A);
        if (some == null) {
            some = new Some(role, A);
            some.id = this.nonbasicindex--;
            this.descriptions.put(some.id, some);
            role.somes.put(A, some);
        }
        some.Ohat.add(B.entry);
        if (!this.elcontology.largeT && !this.elcontology.largeA && A instanceof CardinAtomic && ((CardinAtomic)A).cardin <= RELReasonerConfiguration.cardinThreshold) {
            role.cardiAtomics.add((CardinAtomic)A);
        }
    }

    protected void imply(Basic A) {
        Implies simpleimply = new Implies();
        simpleimply.id = this.impliesID++;
        simpleimply.lhs = null;
        simpleimply.rhs = A;
        A.entry = simpleimply;
    }

    public void clean() {
        this.elcontology.classNum = this.classindex;
        HashSet<OWLClassExpression> IDtodelete = new HashSet<OWLClassExpression>();
        for (Map.Entry<OWLClassExpression, Integer> entry : this.elcontology.classID.entrySet()) {
            if (entry.getValue() < this.classindex && entry.getValue() > this.nonbasicindex) continue;
            IDtodelete.add(entry.getKey());
        }
        for (OWLClassExpression desc : IDtodelete) {
            this.elcontology.classID.remove(desc);
        }
        HashSet<Integer> descriptiontodelete = new HashSet<Integer>();
        for (Map.Entry<Integer, Description> entry : this.elcontology.descriptions.entrySet()) {
            if (entry.getKey() >= this.classindex || entry.getKey() <= this.nonbasicindex) {
                descriptiontodelete.add(entry.getKey());
                if (!(entry.getValue() instanceof Some)) continue;
                Some some = (Some)entry.getValue();
                Role r = some.role;
                if (!(some.concept instanceof Basic)) continue;
                Basic basic = (Basic)some.concept;
                r.somes.remove(basic);
                continue;
            }
            entry.getValue().tempOhat.clear();
            if (!(entry.getValue() instanceof Basic)) continue;
            Basic basic = (Basic)entry.getValue();
            if (basic.complement != null && basic.complement.id >= this.classindex) {
                basic.complement = null;
            }
            basic.tempcardins = null;
            basic.tempLeftConnection.clear();
            basic.tempSubsumers.clear();
        }
        int i = 0;
        while (i < this.elcontology.roleNum) {
            Role role = this.elcontology.roles.get(i);
            role.tempRelations.clear();
            HashSet<Basic> removeKey = new HashSet<Basic>();
            HashMap<Basic, Some> somes = role.somes;
            for (Basic key : somes.keySet()) {
                if (key.id < this.classindex) continue;
                removeKey.add(key);
            }
            for (Basic key : removeKey) {
                somes.remove(key);
            }
            ++i;
        }
        Iterator<Map.Entry<Integer, Description>> iterator = descriptiontodelete.iterator();
        while (iterator.hasNext()) {
            i = (Integer)((Object)iterator.next());
            this.elcontology.descriptions.remove(i);
        }
    }

    public void reorder() {
        this.elcontology.classNum = this.classindex;
    }

    private void addClassID(OWLClassExpression A, int B) {
        this.classID.put(A, B);
    }
}

