/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.owl.syntax;

import eu.trowl.owl.syntax.OWLLanguage;
import eu.trowl.owl.syntax.OWLLanguageGroupChecker;
import eu.trowl.util.Types;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLAxiom;

public abstract class AbstractOWLLanguageGroupChecker
implements OWLLanguageGroupChecker {
    private final Map<OWLLanguage, Set<OWLAxiom>> unsupportedAxioms = new HashMap<OWLLanguage, Set<OWLAxiom>>();
    private final Set<OWLLanguage> valid = Types.newSet();
    private Set<OWLAxiom> allUnsupported = null;
    protected final Set<OWLLanguage> languages = Types.newSet();
    protected boolean lazyMode = false;

    public AbstractOWLLanguageGroupChecker(OWLLanguage ... languages) {
        this.valid.addAll(Arrays.asList(languages));
        this.initaliseCollections();
    }

    private void initaliseCollections() {
        this.allUnsupported = null;
        for (OWLLanguage f : this.languages) {
            this.unsupportedAxioms.put(f, new HashSet());
            this.valid.add(f);
        }
    }

    @Override
    public void reset() {
        this.initaliseCollections();
    }

    @Override
    public void close() {
        this.reset();
    }

    @Override
    public void setLazyMode(boolean lazyMode) {
        this.lazyMode = lazyMode;
    }

    @Override
    public boolean isLazyMode() {
        return this.lazyMode;
    }

    @Override
    public Set<OWLLanguage> getLanguages() {
        return this.languages;
    }

    @Override
    public String getLanguageNames() {
        return Arrays.toString(this.getLanguages().toArray());
    }

    @Override
    public String getLanguageName() {
        return this.getGroupName();
    }

    protected void unsupported(OWLAxiom axiom, OWLLanguage language) {
        if (!this.lazyMode) {
            this.unsupportedAxioms.get((Object)language).add(axiom);
            this.allUnsupported = null;
        }
        this.valid.remove((Object)language);
    }

    @Override
    public Set<OWLAxiom> getUnsupportedAxioms(OWLLanguage language) {
        return this.unsupportedAxioms.get((Object)language);
    }

    @Override
    public Set<OWLAxiom> getUnsupportedAxioms() {
        if (this.allUnsupported == null) {
            this.allUnsupported = new HashSet<OWLAxiom>();
            for (Set<OWLAxiom> s : this.unsupportedAxioms.values()) {
                this.allUnsupported.addAll(s);
            }
            for (Set<OWLAxiom> s : this.unsupportedAxioms.values()) {
                this.allUnsupported.retainAll(s);
            }
        }
        return this.allUnsupported;
    }

    @Override
    public boolean isValid(OWLLanguage language) {
        return this.valid.contains((Object)language);
    }

    @Override
    public boolean hasValidLanguage() {
        return !this.valid.isEmpty();
    }

    @Override
    public boolean isValid() {
        return this.hasValidLanguage();
    }

    @Override
    public Set<OWLLanguage> getValidLanguages() {
        return Collections.unmodifiableSet(this.languages);
    }
}

