/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.owl.api3;

import eu.trowl.owl.InvalidReasonerException;
import eu.trowl.owl.OntologyLoadException;
import eu.trowl.owl.api3.AutoReasoner;
import eu.trowl.owl.api3.TrOWLReasonerFactory;
import eu.trowl.owl.syntax.OWL2ProfileChecker;
import eu.trowl.owl.syntax.OWLLanguage;
import eu.trowl.util.Settings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.IllegalConfigurationException;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerConfiguration;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class ReasonerFactory
implements TrOWLReasonerFactory {
    private static final String reasonerName = "TrOWL";
    private static final Class defaultType = AutoReasoner.class;
    Class type = defaultType;

    private OWLReasoner getReasoner(OWLOntologyManager man) throws OntologyLoadException {
        OWLReasoner r = null;
        if (this.type == AutoReasoner.class) {
            OWLReasonerFactory rf;
            String factoryName;
            OWL2ProfileChecker pc = new OWL2ProfileChecker();
            pc.setLazyMode(true);
            pc.check(man);
            Set<OWLLanguage> languages = pc.getValidLanguages();
            if (languages.contains((Object)OWLLanguage.OWL2QL)) {
                factoryName = Settings.get("ReasonerFactory.api3.QL");
                System.out.println("QL Ontology Detected");
            } else if (languages.contains((Object)OWLLanguage.OWL2EL)) {
                factoryName = Settings.get("ReasonerFactory.api3.EL");
                System.out.println("EL Ontology Detected");
            } else {
                System.out.println("DL Ontology Detected");
                factoryName = Settings.get("ReasonerFactory.api3.DL");
            }
            try {
                rf = (OWLReasonerFactory)Class.forName(factoryName).newInstance();
            }
            catch (Exception ex) {
                InvalidReasonerException e = new InvalidReasonerException("Reasoner class not found from configuration: " + factoryName);
                e.initCause(ex);
                throw e;
            }
            r = rf.createReasoner((OWLOntology)man.getOntologies().iterator().next());
        } else {
            try {
                r = (OWLReasoner)this.type.newInstance();
            }
            catch (InstantiationException ex) {
                Logger.getLogger(ReasonerFactory.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(ReasonerFactory.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return r;
    }

    @Override
    public void setType(Class type) {
        if (!OWLReasoner.class.isAssignableFrom(type)) {
            throw new InvalidReasonerException("Reasoner type incorrect");
        }
        this.type = type;
    }

    @Override
    public OWLReasoner load(IRI iri) throws OntologyLoadException {
        try {
            System.out.println("Loading: " + iri);
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            man.loadOntology(iri);
            return this.getReasoner(man);
        }
        catch (Exception ex) {
            OntologyLoadException e2 = new OntologyLoadException();
            e2.initCause(ex);
            throw e2;
        }
    }

    @Override
    public OWLReasoner load(OWLOntologyManager man) throws OntologyLoadException {
        OWLReasoner r = this.getReasoner(man);
        return r;
    }

    @Override
    public OWLReasoner createReasoner(OWLOntologyManager man) {
        try {
            return this.load(man);
        }
        catch (OntologyLoadException ex) {
            Logger.getLogger(ReasonerFactory.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    @Override
    public OWLReasoner load(Reader input) throws OntologyLoadException {
        if (input.getClass().isAssignableFrom(BufferedReader.class)) {
            BufferedReader bufInput = (BufferedReader)input;
        } else {
            BufferedReader bufInput = new BufferedReader(input);
        }
        OWLOntologyManager man = OWLManager.createOWLOntologyManager();
        return this.getReasoner(man);
    }

    private String readToString(URI what) throws IOException {
        int readCount;
        URL in = what.toURL();
        InputStream is = in.openStream();
        BufferedReader input = new BufferedReader(new InputStreamReader(is));
        StringBuilder data = new StringBuilder(1000);
        char[] buf = new char[1024];
        while ((readCount = input.read(buf)) != -1) {
            data.append(buf, 0, readCount);
        }
        return data.toString();
    }

    @Override
    public String getReasonerName() {
        return reasonerName;
    }

    public OWLReasoner createReasoner(OWLOntology owlo) {
        return this.createReasoner(owlo.getOWLOntologyManager());
    }

    public OWLReasoner createReasoner(OWLOntology owlo, OWLReasonerConfiguration owlrc) throws IllegalConfigurationException {
        return this.createReasoner(owlo);
    }

    public OWLReasoner createNonBufferingReasoner(OWLOntology owlo) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public OWLReasoner createNonBufferingReasoner(OWLOntology owlo, OWLReasonerConfiguration owlrc) throws IllegalConfigurationException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public OWLReasoner load(String content) throws OntologyLoadException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

