/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.owl.api3;

import eu.trowl.util.Types;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public abstract class ReasonerBase {
    protected boolean isClassified = false;
    protected OWLOntologyManager manager;
    protected Set<OWLOntology> ontologies;
    protected Set<OWLOntology> groundOntologies;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    static final Class promoteTo = null;

    protected void _init() {
        this.ontologies = Types.newSet();
        this.groundOntologies = Types.newSet();
    }

    public boolean isClassified() {
        return this.isClassified;
    }

    protected <T> Set<T> flattenSetOfSets(Set<Set<T>> in) {
        HashSet<T> out = new HashSet<T>();
        for (Set<T> candidate : in) {
            out.addAll(candidate);
        }
        return out;
    }

    public Set<OWLClass> getClasses() {
        Set<OWLClass> out = Types.newSet();
        for (OWLOntology o : this.ontologies) {
            out.addAll(o.getClassesInSignature());
        }
        return out;
    }

    public Set<OWLObjectProperty> getObjectProperties() {
        Set<OWLObjectProperty> out = Types.newSet();
        for (OWLOntology o : this.ontologies) {
            out.addAll(o.getObjectPropertiesInSignature());
        }
        return out;
    }

    public Set<OWLDataProperty> getDataProperties() {
        Set<OWLDataProperty> out = Types.newSet();
        for (OWLOntology o : this.ontologies) {
            out.addAll(o.getDataPropertiesInSignature());
        }
        return out;
    }

    public Set<OWLIndividual> getIndividuals() {
        Set<OWLIndividual> out = Types.newSet();
        for (OWLOntology o : this.ontologies) {
            out.addAll(o.getIndividualsInSignature());
        }
        return out;
    }
}

