/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.loader;

import eu.trowl.loader.LoaderInitException;
import eu.trowl.loader.RDFLoader;
import eu.trowl.rdf.Node;
import eu.trowl.rdf.Resource;
import eu.trowl.rdf.Triple;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.rdf.syntax.RDFConsumer;
import org.semanticweb.owlapi.rdf.syntax.RDFParser;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.ac.manchester.cs.owl.owlapi.turtle.parser.TripleHandler;

public class RDFXMLLoader
extends RDFLoader
implements TripleHandler {
    public static final String ID = "TROWL_LOADER_TURTLE";
    private URI base;
    public static final boolean THREAD_SAFE = true;
    private RDFParser parser;
    private InputSource saxin;
    private RDFConsumer consumer;

    @Override
    public void init() throws LoaderInitException {
        this.saxin = new InputSource(this.in);
        this.saxin.setSystemId(this.loaderBase.toString());
        this.consumer = new Consumer(this);
        this.parser = new RDFParser();
    }

    @Override
    public void run() {
        try {
            this.parser.parse(this.saxin, this.consumer);
        }
        catch (SAXException ex) {
            Logger.getLogger(RDFXMLLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(RDFXMLLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @Override
    public void finish() {
        this.out.close();
    }

    @Override
    public void setBase(URI base) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void handlePrefixDirective(String string, String string1) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void handleBaseDirective(String string) {
    }

    public void handleComment(String string) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void handleTriple(IRI uri, IRI uri1, IRI uri2) {
        Triple t = new Triple(Resource.fromIRI(uri), Resource.fromIRI(uri1), (Node)Resource.fromIRI(uri2));
        this.processTriple(t);
    }

    public void handleTriple(IRI uri, IRI uri1, String string) {
        try {
            Triple t = new Triple(Resource.fromIRI(uri), Resource.fromIRI(uri1), Resource.fromString(string));
            this.processTriple(t);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(RDFXMLLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void handleTriple(IRI uri, IRI uri1, String string, String string1) {
        try {
            Triple t = new Triple(Resource.fromIRI(uri), Resource.fromIRI(uri1), Resource.fromString(string));
            this.processTriple(t);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(RDFXMLLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void handleTriple(IRI uri, IRI uri1, String string, IRI uri2) {
        try {
            Triple t = new Triple(Resource.fromIRI(uri), Resource.fromIRI(uri1), Resource.fromString(string));
            this.processTriple(t);
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(RDFXMLLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void handleEnd() {
    }

    private class Consumer
    implements RDFConsumer {
        private TripleHandler source;

        public Consumer(TripleHandler source) {
            this.source = source;
        }

        public void startModel(String string) throws SAXException {
        }

        public void endModel() throws SAXException {
        }

        public void statementWithResourceValue(String s, String p, String o) throws SAXException {
            this.source.handleTriple(IRI.create((String)s), IRI.create((String)p), IRI.create((String)o));
        }

        public void statementWithLiteralValue(String s, String p, String o, String lang, String type) throws SAXException {
            IRI typeIRI = null;
            if (type != null) {
                typeIRI = IRI.create((String)type);
            }
            this.source.handleTriple(IRI.create((String)s), IRI.create((String)p), o, typeIRI);
        }

        public void logicalURI(String string) throws SAXException {
        }

        public void includeModel(String string, String string1) throws SAXException {
        }

        public void addModelAttribte(String string, String string1) throws SAXException {
        }
    }
}

