/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.loader;

import eu.trowl.loader.ThreadSafeLoader;
import eu.trowl.rdf.RDFHandler;
import eu.trowl.rdf.Triple;
import eu.trowl.vocab.OWLRDF;
import eu.trowl.vocab.RDF;
import eu.trowl.vocab.RDFS;

public abstract class RDFLoader
extends ThreadSafeLoader
implements RDFHandler {
    @Override
    public void processTriple(Triple t) {
        if (t.isType()) {
            if (t.getObject().sameAs(RDFS.CLASS) || t.getObject().equals(OWLRDF.CLASS)) {
                this.out.createClass(t.getSubject().getURI());
            } else if (!(t.getObject().sameAs(RDF.PROPERTY) || t.getObject().sameAs(OWLRDF.OBJECT_PROPERTY) || t.getObject().sameAs(OWLRDF.DATATYPE_PROPERTY))) {
                this.out.createIndividual(t.getSubject().getURI(), t.getObject().getURI());
            }
        } else if (t.isSubClass()) {
            this.out.setSubClassOf(t.getSubject().getURI(), t.getObject().getURI());
        } else if (t.isSubProperty()) {
            this.out.setSubPropertyOf(t.getSubject().getURI(), t.getObject().getURI());
        } else if (!t.isTBox()) {
            if (t.getObject().isResource()) {
                this.out.createObjectPropertyInstance(t.getSubject().getURI(), t.getPredicate().getURI(), t.getObject().getURI());
            } else {
                this.out.createDatatypePropertyInstance(t.getSubject().getURI(), t.getPredicate().getURI(), t.getObject().toString(), t.getObject().getLang());
            }
        }
    }
}

