/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.jena;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.OntModelSpec;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFReader;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.reasoner.BaseInfGraph;
import com.hp.hpl.jena.reasoner.Finder;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.UniqueExtendedIterator;
import eu.trowl.jena.TrOWLJenaReasoner;
import eu.trowl.owlapi3.rel.reasoner.dl.RELReasoner;
import eu.trowl.owlapi3.rel.reasoner.dl.RELReasonerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.io.StreamDocumentTarget;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class TrOWLInfGraph
extends BaseInfGraph
implements InfGraph {
    private Graph deductionsGraph;
    private Graph g;
    private OntModel ontm;
    private int size;

    public TrOWLInfGraph(Graph data, Reasoner reasoner) {
        super(data, reasoner);
        this.g = data;
        this.ontm = ModelFactory.createOntologyModel((OntModelSpec)OntModelSpec.OWL_MEM);
        this.deductionsGraph = this.ontm.getGraph();
    }

    public Graph getRawGraph() {
        return this.g;
    }

    public Graph getSchemaGraph() {
        return ((TrOWLJenaReasoner)this.getReasoner()).getSchema();
    }

    public Graph getDeductionsGraph() {
        this.deductionsGraph = this.ontm.getGraph();
        return this.deductionsGraph;
    }

    public void rebind() {
        if (!this.g.isEmpty()) {
            try {
                this.loadOntology();
            }
            catch (OWLOntologyCreationException e) {
                e.printStackTrace();
            }
            catch (OWLOntologyStorageException e) {
                e.printStackTrace();
            }
        }
    }

    public void loadOntology() throws OWLOntologyCreationException, OWLOntologyStorageException {
        if (this.g.size() > this.size) {
            OWLSubClassOfAxiom axiom;
            this.size = this.g.size();
            Model _m = ModelFactory.createModelForGraph((Graph)this.g);
            RDFWriter writer = _m.getWriter("RDF/XML");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            writer.setProperty("allowBadURIs", (Object)"true");
            writer.setProperty("relativeURIs", (Object)"");
            writer.setProperty("tab", (Object)"0");
            writer.write(_m, (OutputStream)out, "http://example.org/");
            OWLOntologyManager m = OWLManager.createOWLOntologyManager();
            OWLOntology o = m.loadOntologyFromOntologyDocument((InputStream)new ByteArrayInputStream(out.toByteArray()));
            Set org = o.getAxioms();
            RELReasonerFactory relfactory = new RELReasonerFactory();
            RELReasoner reasoner = relfactory.createReasoner(o);
            reasoner.classify(true, false);
            ArrayList<AddAxiom> addaxiom = new ArrayList<AddAxiom>();
            OWLDataFactory factory = m.getOWLDataFactory();
            for (OWLClass cls : o.getClassesInSignature()) {
                for (OWLClass sup : reasoner.getSuperClasses((OWLClassExpression)cls, false).getFlattened()) {
                    axiom = factory.getOWLSubClassOfAxiom((OWLClassExpression)cls, (OWLClassExpression)sup);
                    addaxiom.add(new AddAxiom(o, (OWLAxiom)axiom));
                }
                for (OWLClass eqc : reasoner.getEquivalentClasses((OWLClassExpression)cls)) {
                    axiom = factory.getOWLEquivalentClassesAxiom((OWLClassExpression)cls, (OWLClassExpression)eqc);
                    addaxiom.add(new AddAxiom(o, (OWLAxiom)axiom));
                }
            }
            for (OWLNamedIndividual indi : o.getIndividualsInSignature()) {
                OWLObjectPropertyAssertionAxiom axiom2;
                for (OWLClass type : reasoner.getTypes(indi, false).getFlattened()) {
                    axiom = factory.getOWLClassAssertionAxiom((OWLClassExpression)type, (OWLIndividual)indi);
                    addaxiom.add(new AddAxiom(o, (OWLAxiom)axiom));
                }
                for (OWLObjectProperty prop : o.getObjectPropertiesInSignature()) {
                    for (OWLNamedIndividual indi2 : reasoner.getObjectPropertyValues(indi, (OWLObjectPropertyExpression)prop).getFlattened()) {
                        axiom2 = factory.getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)prop, (OWLIndividual)indi, (OWLIndividual)indi2);
                        addaxiom.add(new AddAxiom(o, (OWLAxiom)axiom2));
                    }
                }
                for (OWLDataProperty dprop : o.getDataPropertiesInSignature()) {
                    for (OWLNamedIndividual indi2 : reasoner.getDataPropertyValues(indi, dprop)) {
                        axiom2 = factory.getOWLDataPropertyAssertionAxiom((OWLDataPropertyExpression)dprop, (OWLIndividual)indi, (OWLLiteral)indi2);
                        addaxiom.add(new AddAxiom(o, (OWLAxiom)axiom2));
                    }
                }
                Set ind = reasoner.getSameIndividuals(indi).getEntities();
                Iterator axiom3 = factory.getOWLSameIndividualAxiom(ind);
                addaxiom.add(new AddAxiom(o, (OWLAxiom)axiom3));
            }
            for (OWLObjectProperty prop : o.getObjectPropertiesInSignature()) {
                for (OWLClass sup : reasoner.getSuperObjectProperties((OWLObjectPropertyExpression)prop, false).getFlattened()) {
                    axiom = factory.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)prop, (OWLObjectPropertyExpression)sup);
                    addaxiom.add(new AddAxiom(o, (OWLAxiom)axiom));
                }
                for (OWLObjectPropertyExpression eqo : reasoner.getEquivalentObjectProperties((OWLObjectPropertyExpression)prop)) {
                    axiom = factory.getOWLEquivalentObjectPropertiesAxiom((OWLObjectPropertyExpression)prop, eqo);
                    addaxiom.add(new AddAxiom(o, (OWLAxiom)axiom));
                }
            }
            for (OWLObjectProperty prop : o.getDataPropertiesInSignature()) {
                for (OWLClass sup : reasoner.getSuperDataProperties((OWLDataProperty)prop, false).getFlattened()) {
                    axiom = factory.getOWLSubDataPropertyOfAxiom((OWLDataPropertyExpression)prop, (OWLDataPropertyExpression)sup);
                    addaxiom.add(new AddAxiom(o, (OWLAxiom)axiom));
                }
                for (OWLDataProperty eqd : reasoner.getEquivalentDataProperties((OWLDataProperty)prop)) {
                    axiom = factory.getOWLEquivalentDataPropertiesAxiom((OWLDataPropertyExpression)prop, (OWLDataPropertyExpression)eqd);
                    addaxiom.add(new AddAxiom(o, (OWLAxiom)axiom));
                }
            }
            m.applyChanges(addaxiom);
            m.removeAxioms(o, org);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            StreamDocumentTarget out2 = new StreamDocumentTarget((OutputStream)baos);
            m.saveOntology(o, (OWLOntologyFormat)new RDFXMLOntologyFormat(), (OWLOntologyDocumentTarget)out2);
            try {
                Model infm = ModelFactory.createDefaultModel();
                RDFReader reader = infm.getReader("RDF/XML");
                this.ontm.add(infm);
                reader.setProperty("WARN_RELATIVE_NAMESPACE_URI_DEPRECATED", (Object)"EM_IGNORE");
                reader.read((Model)this.ontm, (InputStream)new ByteArrayInputStream(baos.toByteArray()), "http://example.org/");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public ExtendedIterator<Triple> find(Node subject, Node property, Node object, Graph param) {
        ExtendedIterator result = this.graphBaseFind(subject, property, object);
        return result;
    }

    public ExtendedIterator<Triple> findWithContinuation(TriplePattern pattern, Finder finder) {
        Node subject = pattern.getSubject();
        Node predicate = pattern.getPredicate();
        Node object = pattern.getObject();
        ExtendedIterator i = this.deductionsGraph.find(subject, predicate, object);
        if (finder != null) {
            TriplePattern tp = new TriplePattern(subject, predicate, object);
            i = i.andThen((Iterator)finder.find(tp));
        }
        return UniqueExtendedIterator.create((Iterator)i);
    }
}

