/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.db;

import eu.trowl.db.DB;
import eu.trowl.db.OntologyMeta;
import eu.trowl.db.Queries;
import eu.trowl.hashing.FNV;
import eu.trowl.loader.TreeThing;
import eu.trowl.util.Settings;
import eu.trowl.util.Types;
import eu.trowl.vocab.OWLRDF;
import eu.trowl.vocab.RDFS;
import java.net.URI;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SQLBuilder {
    private Outputter out;
    private URI ontologyURI;
    private Long ontologyId;
    protected OntologyMeta m;
    int i = 0;

    public SQLBuilder(DB db, URI uri, OntologyMeta meta) {
        try {
            db.connect();
            this.m = meta;
            this.out = new Outputter(db);
            this.ontologyURI = uri;
            this.ontologyId = FNV.hash(this.ontologyURI);
        }
        catch (Exception ex) {
            System.out.println("Error preparing statements for insert");
            ex.printStackTrace();
            System.exit(1);
        }
    }

    public void init() {
        this.cleanup();
        this.createOntology(this.ontologyURI);
    }

    public void setURI(URI uri) {
        if (this.ontologyURI != uri) {
            this.createOntology(uri);
        }
        this.ontologyURI = uri;
        this.ontologyId = FNV.hash(this.ontologyURI);
        System.out.println("SETURI: " + uri);
    }

    private void cleanup() {
        String[] tables;
        String[] stringArray = tables = Queries.TABLES;
        int n = tables.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            if (!t.equals("ontologies")) {
                try {
                    this.out.db.execute("DELETE FROM " + t + " WHERE ontology=" + FNV.hash(this.ontologyURI));
                }
                catch (Exception e) {
                    System.out.print(e.getMessage());
                }
            }
            ++n2;
        }
        try {
            this.out.db.execute("DELETE FROM ontologies WHERE uri='" + this.ontologyURI + "'");
        }
        catch (Exception e) {
            System.out.print(e.getMessage());
        }
        if (Boolean.valueOf(Settings.get("DB.DropIndexes")).booleanValue()) {
            System.out.println("Dropping indices");
            stringArray = Queries.DROP_INDEXES;
            n = Queries.DROP_INDEXES.length;
            n2 = 0;
            while (n2 < n) {
                String q = stringArray[n2];
                try {
                    this.out.db.execute(q);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    public void createOntology(URI uri) {
        if (!this.m.getOntologies().contains(uri)) {
            Object[] args = new Object[]{FNV.hash(uri), uri};
            this.out.execute(this.out.insertOntology, args);
            this.m.getOntologies().add(uri);
        }
    }

    public TreeThing createClass(URI uri) {
        if (!this.m.getClasses().containsKey(uri)) {
            Object[] args = new Object[]{FNV.hash(uri.toString()), uri.toString(), this.ontologyId};
            this.out.execute(this.out.insertClass, args);
            TreeThing out = new TreeThing(uri);
            this.m.getClasses().put(uri, new TreeThing(uri));
            this.m.getTopClasses().add(uri);
            return out;
        }
        return this.m.getClasses().get(uri);
    }

    public TreeThing createObjectProperty(URI uri) {
        if (!this.m.getObjectProperties().containsKey(uri)) {
            this.createIndividual(uri, OWLRDF.OBJECT_PROPERTY);
            Object[] args = new Object[]{FNV.hash(uri), uri, this.ontologyId};
            this.out.execute(this.out.insertObjectProperty, args);
            TreeThing which = new TreeThing(uri);
            this.m.getObjectProperties().put(uri, which);
            this.m.getTopObjectProperties().add(uri);
            return which;
        }
        return this.m.getObjectProperties().get(uri);
    }

    public TreeThing createDatatypeProperty(URI uri) {
        if (!this.m.getDataProperties().containsKey(uri)) {
            this.createIndividual(uri, OWLRDF.DATATYPE_PROPERTY);
            Object[] args = new Object[]{FNV.hash(uri), uri, this.ontologyId};
            this.out.execute(this.out.insertDataProperty, args);
            TreeThing which = new TreeThing(uri);
            this.m.getDataProperties().put(uri, which);
            this.m.getTopDataProperties().add(uri);
            return which;
        }
        return this.m.getDataProperties().get(uri);
    }

    public void setDomain(URI propertyURI, URI domainURI) {
        this.createObjectPropertyInstance(propertyURI, RDFS.DOMAIN, domainURI);
    }

    public void setRange(URI propertyURI, URI rangeURI) {
        this.createObjectPropertyInstance(propertyURI, RDFS.RANGE, rangeURI);
    }

    public void createInverseFunctionalProperty(URI uri) {
        this.createIndividual(uri, OWLRDF.INVERSE_FUNCTIONAL_PROPERTY);
    }

    public void createFunctionalProperty(URI uri) {
        this.createIndividual(uri, OWLRDF.FUNCTIONAL_PROPERTY);
    }

    public void createReflexiveProperty(URI uri) {
        this.createIndividual(uri, OWLRDF.REFLEXIVE_PROPERTY);
    }

    public void createTransitiveProperty(URI uri) {
        this.createIndividual(uri, OWLRDF.TRANSITIVE_PROPERTY);
    }

    public void createSymmetricProperty(URI uri) {
        this.createIndividual(uri, OWLRDF.SYMMETRIC_PROPERTY);
    }

    public void createClassPath(URI uri, String path) {
        Object[] args = new Object[]{FNV.hash(uri), path, this.ontologyId};
        this.out.execute(this.out.insertClassPath, args);
    }

    public void setSubClassOf(URI sub, URI sup) {
        this.createClass(sub);
        this.createClass(sup);
        this.m.getClasses().get(sup).addSubThing(this.m.getClasses().get(sub));
        this.m.getTopClasses().remove(sub);
    }

    public void storePaths() {
        this.storeClassPaths();
        this.storePropertyPaths();
    }

    private void storePropertyPaths() {
        for (Map.Entry<URI, Set<URI>> entry : this.m.getSubProperty().entrySet()) {
            URI sub = entry.getKey();
            for (URI sup : entry.getValue()) {
                if (this.m.getObjectProperties().containsKey(sub) || this.m.getObjectProperties().containsKey(sup)) {
                    this.createObjectProperty(sup).addSubThing(this.createObjectProperty(sub));
                    this.m.getTopObjectProperties().remove(sub);
                }
                if (!this.m.getDataProperties().containsKey(sub) && !this.m.getObjectProperties().containsKey(sup)) continue;
                this.createDatatypeProperty(sup).addSubThing(this.createDatatypeProperty(sub));
                this.m.getTopDataProperties().remove(sub);
            }
        }
        TreeThing top = this.createObjectProperty(OWLRDF.TOP_OBJECT_PROPERTY);
        for (URI uri : this.m.getTopObjectProperties()) {
            if (uri == top.getUri()) continue;
            top.addSubThing(this.m.getObjectProperties().get(uri));
        }
        this.traversePropertyPaths(top, "");
        top = this.createDatatypeProperty(OWLRDF.TOP_DATA_PROPERTY);
        for (URI uri : this.m.getTopDataProperties()) {
            if (uri == top.getUri()) continue;
            top.addSubThing(this.m.getDataProperties().get(uri));
        }
        this.traversePropertyPaths(top, "");
    }

    public void traversePropertyPaths(TreeThing base, String currentPath) {
        if (base.getUri() != null) {
            currentPath = String.valueOf(currentPath) + SQLBuilder.getPathHash(base.getUri());
            this.createPropertyPath(base.getUri(), currentPath);
            for (TreeThing child : base.getSubThings()) {
                if (child == null || child.getUri() == null || child.equals(base) || currentPath.contains(SQLBuilder.getPathHash(child.getUri()))) continue;
                this.traversePropertyPaths(child, currentPath);
            }
        }
    }

    private void storeClassPaths() {
        TreeThing top = this.createClass(OWLRDF.THING);
        for (URI uri : this.m.getTopClasses()) {
            top.addSubThing(this.m.getClasses().get(uri));
        }
        this.traverseClassPaths(top, "");
    }

    public void traverseClassPaths(TreeThing base, String currentPath) {
        if (base.getUri() != null) {
            String newPath = String.valueOf(currentPath) + SQLBuilder.getPathHash(base.getUri());
            this.createClassPath(base.getUri(), newPath);
            for (TreeThing child : base.getSubThings()) {
                if (child.getUri() == null || child.equals(base) || currentPath.contains(SQLBuilder.getPathHash(child.getUri()))) continue;
                this.traverseClassPaths(child, newPath);
            }
        }
    }

    public void setSubPropertyOf(URI sub, URI sup) {
        if (!this.m.getSubProperty().containsKey(sub)) {
            this.m.getSubProperty().put(sub, new HashSet());
        }
        this.m.getSubProperty().get(sub).add(sup);
    }

    public void createPropertyPath(URI uri, String path) {
        String type = "";
        if (this.m.getDataProperties().containsKey(uri)) {
            if (this.m.getDataProperties().containsKey(uri)) {
                type = "b";
            }
            type = "d";
        } else {
            type = "o";
        }
        Object[] args = new Object[]{FNV.hash(uri), path, type, this.ontologyId};
        this.out.execute(this.out.insertPropertyPath, args);
    }

    public void createIndividual(URI uri, URI classURI) {
        Object[] args = new Object[]{FNV.hash(uri), FNV.hash(classURI), uri, this.ontologyId};
        this.out.execute(this.out.insertIndividual, args);
        this.createClass(classURI);
    }

    public void createObjectPropertyInstance(URI subject, URI predicate, URI object) {
        Object[] args = new Object[]{FNV.hash(subject), FNV.hash(predicate), FNV.hash(object), this.ontologyId};
        this.out.execute(this.out.insertOPropertyInstance, args);
        this.createObjectProperty(predicate);
    }

    public void createDatatypePropertyInstance(URI subject, URI predicate, String object, String lang) {
        Object[] args = new Object[]{FNV.hash(subject), FNV.hash(predicate), object, lang, this.ontologyId};
        this.out.execute(this.out.insertDPropertyInstance, args);
        this.createDatatypeProperty(predicate);
    }

    public void rebuildIndices() {
        try {
            this.out.executeAll();
        }
        catch (SQLException ex) {
            System.out.println("SQL Error Occured: " + ex.getMessage());
            System.out.println("Cause: " + ex.getNextException().getMessage());
        }
        if (Boolean.valueOf(Settings.get("DB.DropIndexes")).booleanValue()) {
            System.out.println("Rebuilding indices");
            String[] stringArray = Queries.CREATE_INDEXES;
            int n = Queries.CREATE_INDEXES.length;
            int n2 = 0;
            while (n2 < n) {
                String q = stringArray[n2];
                try {
                    this.out.db.execute(q);
                }
                catch (SQLException ex) {
                    System.out.println("Could not create index");
                    System.out.println(ex.getMessage());
                }
                ++n2;
            }
        }
    }

    public void close() {
        this.storePaths();
        this.rebuildIndices();
        this.out.close();
        System.out.println();
    }

    public static String getPathHash(Object uri) {
        String hashed = FNV.hash32(uri);
        return hashed;
    }

    private class Outputter {
        private Map<PreparedStatement, Boolean> preparedStatements;
        private DB db;
        private static final int PER_BATCH = 1000;
        private int statementsExecuted = 0;
        private PreparedStatement insertIndividual;
        private PreparedStatement insertClass;
        private PreparedStatement insertOPropertyInstance;
        private PreparedStatement insertDPropertyInstance;
        private PreparedStatement insertObjectProperty;
        private PreparedStatement insertDataProperty;
        private PreparedStatement insertOntology;
        private PreparedStatement insertPropertyPath;
        private PreparedStatement insertClassPath;
        private long executed = 0L;

        public Outputter(DB db) throws SQLException {
            this.db = db;
            this.insertOntology = db.prepareStatement("INSERT INTO ontologies (id,uri) VALUES (?, ?)");
            this.insertIndividual = db.prepareStatement("INSERT INTO individuals (id, class_id, uri, ontology) VALUES (?, ?, ?, ?)");
            this.insertClass = db.prepareStatement("INSERT INTO classes (id, uri, ontology) VALUES (?, ?, ?)");
            this.insertOPropertyInstance = db.prepareStatement("INSERT INTO oproperty_instances (subject_id, property_id, object_id, ontology) VALUES (?, ?, ?, ?)");
            this.insertDPropertyInstance = db.prepareStatement("INSERT INTO dproperty_instances (subject_id, property_id, object, language, ontology) VALUES (?, ?, ?, ?, ?)");
            this.insertClassPath = db.prepareStatement("INSERT INTO classpaths (class_id, path, ontology) VALUES (?, ?, ?)");
            this.insertPropertyPath = db.prepareStatement("INSERT INTO propertypaths (property_id, path, type, ontology) VALUES (?, ?, ?, ?)");
            this.insertObjectProperty = db.prepareStatement("INSERT INTO oproperties (id, uri, ontology) VALUES (?, ?, ?)");
            this.insertDataProperty = db.prepareStatement("INSERT INTO dproperties (id, uri, ontology) VALUES (?, ?, ?)");
            this.preparedStatements = Types.newMap();
            this.preparedStatements.put(this.insertOntology, false);
            this.preparedStatements.put(this.insertIndividual, false);
            this.preparedStatements.put(this.insertClass, false);
            this.preparedStatements.put(this.insertObjectProperty, false);
            this.preparedStatements.put(this.insertDataProperty, false);
            this.preparedStatements.put(this.insertPropertyPath, false);
            this.preparedStatements.put(this.insertOPropertyInstance, false);
            this.preparedStatements.put(this.insertDPropertyInstance, false);
            this.preparedStatements.put(this.insertClassPath, false);
        }

        public void execute(PreparedStatement s, Object[] args) {
            int i = 1;
            try {
                Object[] objectArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    Object a = objectArray[n2];
                    if (a instanceof URI) {
                        a = a.toString();
                    }
                    s.setObject(i++, a);
                    ++n2;
                }
                s.addBatch();
                this.preparedStatements.put(s, true);
                ++this.statementsExecuted;
                if (this.statementsExecuted >= 1000) {
                    this.executeAll();
                    this.statementsExecuted = 0;
                }
            }
            catch (SQLException ex) {
                System.out.println("SQL Error Occured: " + ex.getMessage());
                System.out.println("Cause: " + ex.getNextException().getMessage());
            }
        }

        public void executeAll() throws SQLException {
            for (PreparedStatement p : this.preparedStatements.keySet()) {
                if (!this.preparedStatements.get(p).booleanValue()) continue;
                p.executeBatch();
                p.clearBatch();
                this.preparedStatements.put(p, false);
            }
            this.executed += (long)this.statementsExecuted;
            System.out.print("Statements processed: ");
            System.out.print(this.executed);
            System.out.print("\r");
        }

        public void close() {
            try {
                this.executeAll();
                this.db.commit();
            }
            catch (SQLException ex) {
                System.out.println("SQL Error Occured: " + ex.getMessage());
            }
        }
    }
}

