/*
 * Decompiled with CFR 0.152.
 */
package eu.trowl.db;

import eu.trowl.db.DB;
import eu.trowl.db.H2DB;
import eu.trowl.util.Settings;

public class DBFactory {
    public static final int POSTGRES = 1;
    public static final int H2 = 1;

    public static DB construct(String repository) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (Settings.get("Database.Driver") != null) {
            Class<?> driver = Class.forName(Settings.get("Database.Driver"));
            DB database = (DB)driver.newInstance();
            database.setRepository(repository);
            return database;
        }
        return new H2DB(repository);
    }

    public static DB construct() throws InstantiationException, ClassNotFoundException, IllegalAccessException {
        if (Settings.get("Database.Driver") != null) {
            Class<?> driver = Class.forName(Settings.get("Database.Driver"));
            DB database = (DB)driver.newInstance();
            database.setRepository(Settings.get("Database.DefaultRepository"));
            return database;
        }
        return new H2DB();
    }
}

