/*
 * Decompiled with CFR 0.152.
 */
package com.truemesh.squiggle.criteria;

import com.truemesh.squiggle.Criteria;
import com.truemesh.squiggle.Table;
import com.truemesh.squiggle.criteria.AND;
import com.truemesh.squiggle.criteria.OR;
import com.truemesh.squiggle.output.Output;
import java.util.List;
import java.util.Set;

public class CriteriaExpression
extends Criteria {
    private CriteriaExpression expression;
    private int operator;
    private Criteria term;

    public CriteriaExpression(Criteria term) {
        this.term = term;
    }

    public CriteriaExpression(Criteria term, int operator, CriteriaExpression expression) {
        this(term);
        this.operator = operator;
        this.expression = expression;
    }

    public CriteriaExpression(List<Criteria> terms, int operator) {
        this.operator = operator;
        if (terms.size() != 0) {
            this.term = terms.get(0);
            if (terms.size() > 1) {
                this.expression = new CriteriaExpression(terms.subList(1, terms.size()), operator);
            }
        }
    }

    public CriteriaExpression getExpression() {
        return this.expression;
    }

    public int getOperator() {
        return this.operator;
    }

    public Criteria getTerm() {
        return this.term;
    }

    @Override
    public void write(Output out) {
        if (this.term != null || this.expression != null) {
            if (this.expression == null) {
                this.term.write(out);
            } else if (this.operator == 0) {
                new AND(this.term, this.expression).write(out);
            } else if (this.operator == 1) {
                new OR(this.term, this.expression).write(out);
            }
        }
    }

    @Override
    public void addReferencedTablesTo(Set<Table> tables) {
        this.term.addReferencedTablesTo(tables);
        if (this.expression != null) {
            this.expression.addReferencedTablesTo(tables);
        }
    }

    public static interface Operator {
        public static final int AND = 0;
        public static final int OR = 1;
    }
}

