/*
 * Decompiled with CFR 0.152.
 */
package com.truemesh.squiggle.criteria;

import com.truemesh.squiggle.Criteria;
import com.truemesh.squiggle.Matchable;
import com.truemesh.squiggle.Table;
import com.truemesh.squiggle.literal.BigDecimalLiteral;
import com.truemesh.squiggle.literal.DateTimeLiteral;
import com.truemesh.squiggle.literal.FloatLiteral;
import com.truemesh.squiggle.literal.IntegerLiteral;
import com.truemesh.squiggle.output.Output;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Set;

public class BetweenCriteria
extends Criteria {
    private final Matchable column;
    private final Matchable lower;
    private final Matchable upper;

    public BetweenCriteria(Matchable operand, Matchable lower, Matchable upper) {
        this.column = operand;
        this.lower = lower;
        this.upper = upper;
    }

    public BetweenCriteria(Matchable operand, BigDecimal lower, BigDecimal upper) {
        this(operand, new BigDecimalLiteral(lower), new BigDecimalLiteral(upper));
    }

    public BetweenCriteria(Matchable column, Date upper, Date lower) {
        this(column, new DateTimeLiteral(upper), new DateTimeLiteral(lower));
    }

    public BetweenCriteria(Matchable column, double lower, double upper) {
        this(column, new FloatLiteral(lower), new FloatLiteral(upper));
    }

    public BetweenCriteria(Matchable column, long lower, long upper) {
        this(column, new IntegerLiteral(lower), new IntegerLiteral(upper));
    }

    @Override
    public void write(Output out) {
        this.column.write(out);
        out.print(" BETWEEN ");
        this.lower.write(out);
        out.print(" AND ");
        this.upper.write(out);
    }

    @Override
    public void addReferencedTablesTo(Set<Table> tables) {
        this.column.addReferencedTablesTo(tables);
    }
}

