/*
 * Decompiled with CFR 0.152.
 */
package com.truemesh.squiggle;

import com.truemesh.squiggle.Column;
import com.truemesh.squiggle.WildCardColumn;
import com.truemesh.squiggle.output.Output;
import com.truemesh.squiggle.output.Outputable;

public class Table
implements Outputable {
    private final String name;
    private final String alias;
    private static int count = 0;
    private static final String prefix = "tab";

    public Table(String name) {
        this(name, prefix + count);
    }

    public Table(String name, String alias) {
        this.name = name;
        this.alias = alias;
        ++count;
    }

    public String getName() {
        return this.name;
    }

    private boolean hasAlias() {
        return this.alias != null;
    }

    public String getAlias() {
        return this.alias != null ? this.alias : this.name;
    }

    public Column getColumn(String columnName) {
        return new Column(this, columnName);
    }

    public WildCardColumn getWildcard() {
        return new WildCardColumn(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        Table that = (Table)o;
        return this.getAlias().equals(that.getAlias());
    }

    public int hashCode() {
        return this.getAlias().hashCode();
    }

    @Override
    public void write(Output out) {
        out.print(this.getName());
        if (this.hasAlias()) {
            out.print(' ');
            out.print(this.getAlias());
        }
    }
}

