/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.visitor;

import EDU.purdue.jtb.misc.ClassInfo;
import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FieldNameGenerator;
import EDU.purdue.jtb.syntaxtree.BNFProduction;
import EDU.purdue.jtb.syntaxtree.Expansion;
import EDU.purdue.jtb.syntaxtree.ExpansionChoices;
import EDU.purdue.jtb.syntaxtree.ExpansionUnit;
import EDU.purdue.jtb.syntaxtree.ExpansionUnitTerm;
import EDU.purdue.jtb.syntaxtree.JavaCCInput;
import EDU.purdue.jtb.syntaxtree.JavaCodeProduction;
import EDU.purdue.jtb.syntaxtree.LocalLookahead;
import EDU.purdue.jtb.syntaxtree.NodeChoice;
import EDU.purdue.jtb.syntaxtree.NodeOptional;
import EDU.purdue.jtb.syntaxtree.NodeSequence;
import EDU.purdue.jtb.syntaxtree.NodeToken;
import EDU.purdue.jtb.syntaxtree.RegularExprProduction;
import EDU.purdue.jtb.syntaxtree.RegularExpression;
import EDU.purdue.jtb.syntaxtree.TokenManagerDecls;
import EDU.purdue.jtb.visitor.DepthFirstVisitor;
import EDU.purdue.jtb.visitor.TokenTableBuilder;
import java.util.Hashtable;
import java.util.Vector;

public class ClassGenerator
extends DepthFirstVisitor {
    private boolean printToken = false;
    private Hashtable tokenTable;
    private ClassInfo curClass;
    private Vector classList = new Vector();
    private FieldNameGenerator nameGen = new FieldNameGenerator();

    public Vector getClassList() {
        return this.classList;
    }

    public void visit(JavaCCInput n) {
        TokenTableBuilder builder = new TokenTableBuilder();
        n.accept(builder);
        this.tokenTable = builder.getTokenTable();
        n.f10.accept(this);
    }

    public void visit(JavaCodeProduction n) {
    }

    public void visit(BNFProduction n) {
        this.nameGen.resetFieldNum();
        this.printToken = true;
        this.curClass = new ClassInfo(n.f8, n.f1.toString());
        this.classList.addElement(this.curClass);
        n.f8.accept(this);
        this.printToken = false;
    }

    public void visit(RegularExprProduction n) {
    }

    public void visit(TokenManagerDecls n) {
    }

    public void visit(ExpansionChoices n) {
        if (!n.f1.present()) {
            n.f0.accept(this);
        } else {
            this.curClass.addField("NodeChoice", this.nameGen.curFieldName("NodeChoice"));
        }
    }

    public void visit(Expansion n) {
        n.f0.accept(this);
    }

    public void visit(ExpansionUnit n) {
        switch (n.f0.which) {
            case 0: {
                return;
            }
            case 1: {
                return;
            }
            case 2: {
                NodeSequence seq = (NodeSequence)n.f0.choice;
                NodeOptional ebnfMod = (NodeOptional)seq.elementAt(3);
                if (ebnfMod.present()) {
                    NodeChoice modChoice = (NodeChoice)ebnfMod.node;
                    String mod = ((NodeToken)modChoice.choice).tokenImage;
                    String name = this.getNameForMod(mod);
                    this.curClass.addField(name, this.nameGen.curFieldName(name));
                    break;
                }
                ExpansionChoices ec = (ExpansionChoices)seq.elementAt(1);
                if (ec.f1.present()) {
                    this.curClass.addField("NodeChoice", this.nameGen.curFieldName("NodeChoice"));
                    break;
                }
                this.curClass.addField("NodeSequence", this.nameGen.curFieldName("NodeSequence"));
                break;
            }
            case 3: {
                this.curClass.addField("NodeOptional", this.nameGen.curFieldName("NodeOptional"));
                break;
            }
            case 4: {
                n.f0.accept(this);
                break;
            }
            default: {
                Errors.hardErr("n.f0.which = " + String.valueOf(n.f0.which));
            }
        }
    }

    private String getNameForMod(String mod) {
        if (mod.equals("+")) {
            return "NodeList";
        }
        if (mod.equals("*")) {
            return "NodeListOptional";
        }
        if (mod.equals("?")) {
            return "NodeOptional";
        }
        Errors.hardErr("Illegal EBNF modifier in ExpansionUnit: mod = " + mod);
        return "";
    }

    public void visit(ExpansionUnitTerm n) {
        switch (n.f0.which) {
            case 0: {
                n.f0.accept(this);
                break;
            }
            case 1: {
                NodeSequence seq = (NodeSequence)n.f0.choice;
                String ident = ((NodeToken)seq.elementAt((int)0)).tokenImage;
                this.curClass.addField(ident, this.nameGen.curFieldName(ident));
                break;
            }
            default: {
                Errors.hardErr("n.f0.which = " + String.valueOf(n.f0.which));
            }
        }
    }

    public void visit(LocalLookahead n) {
    }

    public void visit(RegularExpression n) {
        String regExpr = "";
        String initialValue = null;
        boolean isEOF = false;
        if (!this.printToken) {
            return;
        }
        switch (n.f0.which) {
            case 0: {
                regExpr = ((NodeToken)n.f0.choice).tokenImage;
                break;
            }
            case 1: {
                regExpr = "";
                break;
            }
            case 2: {
                NodeSequence seq = (NodeSequence)n.f0.choice;
                NodeToken ident = (NodeToken)seq.elementAt(1);
                regExpr = (String)this.tokenTable.get(ident.tokenImage);
                if (regExpr != null) break;
                Errors.softErr("Undefined token \"" + ident + "\".", ident.beginLine);
                regExpr = "";
                break;
            }
            case 3: {
                regExpr = "";
                isEOF = true;
                break;
            }
            default: {
                Errors.hardErr("Unreachable code executed!");
            }
        }
        if (isEOF) {
            initialValue = "new NodeToken(\"\")";
        } else if (regExpr != "") {
            initialValue = "new NodeToken(" + regExpr + ")";
        }
        this.curClass.addField("NodeToken", this.nameGen.curFieldName("NodeToken"), initialValue);
    }
}

