/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.jtb.visitor;

import EDU.purdue.jtb.misc.Errors;
import EDU.purdue.jtb.misc.FileExistsException;
import EDU.purdue.jtb.misc.Globals;
import EDU.purdue.jtb.misc.VarInfo;
import EDU.purdue.jtb.syntaxtree.BNFProduction;
import EDU.purdue.jtb.syntaxtree.Expansion;
import EDU.purdue.jtb.syntaxtree.ExpansionChoices;
import EDU.purdue.jtb.syntaxtree.ExpansionUnit;
import EDU.purdue.jtb.syntaxtree.ExpansionUnitTerm;
import EDU.purdue.jtb.syntaxtree.JavaCCInput;
import EDU.purdue.jtb.syntaxtree.JavaCodeProduction;
import EDU.purdue.jtb.syntaxtree.LocalLookahead;
import EDU.purdue.jtb.syntaxtree.Node;
import EDU.purdue.jtb.syntaxtree.NodeChoice;
import EDU.purdue.jtb.syntaxtree.NodeListOptional;
import EDU.purdue.jtb.syntaxtree.NodeOptional;
import EDU.purdue.jtb.syntaxtree.NodeSequence;
import EDU.purdue.jtb.syntaxtree.NodeToken;
import EDU.purdue.jtb.syntaxtree.RegularExprProduction;
import EDU.purdue.jtb.syntaxtree.RegularExpression;
import EDU.purdue.jtb.visitor.ExpansionUnitTypeCounter;
import EDU.purdue.jtb.visitor.ImportInserter;
import EDU.purdue.jtb.visitor.Printer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;

public class Annotator
extends Printer {
    private Printer plainPrinter;
    private int varNum;
    private Vector varList;
    private Vector outerVars;
    private VarInfo prevVar;
    private boolean annotateNode;
    private String curProduction;
    private Vector specialList = null;

    public Annotator() throws FileExistsException {
        this(Globals.outFilename);
    }

    public Annotator(String filename) throws FileExistsException {
        try {
            File file = new File(filename);
            if (Globals.noOverwrite && file.exists()) {
                throw new FileExistsException(filename);
            }
            this.out = new PrintWriter(new FileOutputStream(file));
            this.plainPrinter = new Printer(this.out, this.spc);
        }
        catch (IOException e) {
            Errors.hardErr(e);
        }
    }

    public Annotator(Writer w) {
        super(w);
        this.out = new PrintWriter(w);
        this.plainPrinter = new Printer(this.out, this.spc);
    }

    public Annotator(OutputStream o) {
        super(o);
        this.out = new PrintWriter(o);
        this.plainPrinter = new Printer(this.out, this.spc);
    }

    private String curVarName() {
        return "n" + String.valueOf(this.varNum++);
    }

    private void resetVarNum() {
        this.varNum = 0;
    }

    private void finalActions(VarInfo info) {
        if (this.nestLevel == 0) {
            this.outerVars.addElement(info);
        } else {
            this.prevVar = info;
            this.annotateNode = true;
        }
    }

    public void visit(JavaCCInput n) {
        this.out.println(this.spc.spc + Globals.fileHeader(this.spc));
        this.out.println();
        this.out.print(this.spc.spc);
        n.f0.accept(this.plainPrinter);
        this.out.println("\n");
        this.out.println(this.spc.spc + n.f1 + n.f2 + n.f3 + n.f4);
        this.out.println(this.spc.spc + ImportInserter.unitAddImport(n.f5));
        this.out.println(this.spc.spc + n.f6 + n.f7 + n.f8 + n.f9 + "\n");
        this.out.print(this.spc.spc);
        this.visit(n.f10, "\n\n" + this.spc.spc);
        this.out.println();
        this.flushWriter();
    }

    public void visit(JavaCodeProduction n) {
        n.accept(this.plainPrinter);
    }

    public void visit(BNFProduction n) {
        this.curProduction = n.f1.toString();
        this.out.println(n.f1 + " " + n.f1 + this.javaString(n.f2) + " " + n.f3);
        this.varList = new Vector();
        this.outerVars = new Vector();
        this.prevVar = null;
        this.resetVarNum();
        this.nestLevel = 0;
        this.annotateNode = true;
        String rhs = this.generateRHS(n);
        this.out.println(this.spc.spc + "{");
        this.spc.updateSpc(1);
        Enumeration e = this.varList.elements();
        while (e.hasMoreElements()) {
            this.out.println(this.spc.spc + ((VarInfo)e.nextElement()).getVarDeclString());
        }
        this.out.println();
        this.out.println(this.spc.spc + this.javaString(n.f5));
        this.spc.updateSpc(-1);
        this.out.println(this.spc.spc + "}");
        this.out.print(this.spc.spc + rhs);
    }

    private String generateRHS(BNFProduction n) {
        PrintWriter temp = this.out;
        StringWriter buf = new StringWriter();
        this.out = new PrintWriter(buf);
        this.plainPrinter.setOut(this.out);
        this.out.println(n.f7);
        this.spc.updateSpc(1);
        this.out.print(this.spc.spc);
        n.f8.accept(this);
        this.out.println();
        this.out.print(this.spc.spc + "{ return new " + n.f1 + "(");
        Enumeration e = this.outerVars.elements();
        if (e.hasMoreElements()) {
            this.out.print(((VarInfo)e.nextElement()).getName());
            while (e.hasMoreElements()) {
                this.out.print("," + ((VarInfo)e.nextElement()).getName());
            }
        }
        this.out.println("); }");
        this.spc.updateSpc(-1);
        this.out.print(this.spc.spc + n.f9);
        this.out.flush();
        this.out.close();
        this.out = temp;
        this.plainPrinter.setOut(this.out);
        return buf.toString();
    }

    public void visit(RegularExprProduction n) {
        n.accept(this.plainPrinter);
    }

    public void visit(ExpansionChoices n) {
        if (!n.f1.present()) {
            n.f0.accept(this);
        } else {
            String name = this.curVarName();
            VarInfo info = new VarInfo("NodeChoice", name);
            this.varList.addElement(info);
            this.generateChoices(n, name);
            this.out.println();
            this.out.print(this.spc.spc);
            this.finalActions(info);
        }
    }

    private void generateChoices(ExpansionChoices n, String ident) {
        int whichVal = 0;
        this.out.println("(");
        this.spc.updateSpc(1);
        this.out.print(this.spc.spc);
        ++this.nestLevel;
        n.f0.accept(this);
        --this.nestLevel;
        if (!this.annotateNode) {
            Errors.softErr("Empty NodeChoice in " + this.curProduction + "()");
        } else {
            this.out.println("{ " + ident + " = new NodeChoice(" + this.prevVar.getName() + ", " + String.valueOf(whichVal) + "); }");
            ++whichVal;
        }
        Enumeration<Node> e = n.f1.elements();
        while (e.hasMoreElements()) {
            NodeSequence seq = (NodeSequence)e.nextElement();
            ++this.nestLevel;
            this.spc.updateSpc(-1);
            this.out.println(this.spc.spc + seq.elementAt(0));
            this.spc.updateSpc(1);
            this.out.print(this.spc.spc);
            seq.elementAt(1).accept(this);
            --this.nestLevel;
            if (!this.annotateNode) {
                Errors.softErr("Empty NodeChoice in " + this.curProduction + "()");
                continue;
            }
            this.out.println("{ " + ident + " = new NodeChoice(" + this.prevVar.getName() + ", " + String.valueOf(whichVal) + "); }");
            ++whichVal;
        }
        this.spc.updateSpc(-1);
        this.out.print(this.spc.spc + ")");
    }

    public void visit(Expansion n) {
        if (this.nestLevel == 0) {
            n.f0.accept(this);
        } else {
            ExpansionUnitTypeCounter v = new ExpansionUnitTypeCounter();
            n.accept(v);
            if (v.getNumNormals() == 0) {
                this.annotateNode = false;
            } else if (v.getNumNormals() == 1) {
                n.f0.accept(this);
                this.annotateNode = true;
            } else {
                String name = this.curVarName();
                VarInfo info = new VarInfo("NodeSequence", name);
                this.varList.addElement(info);
                this.generateSequence(n, name);
                this.prevVar = info;
                this.annotateNode = true;
            }
        }
    }

    private void generateSequence(Expansion n, String ident) {
        Enumeration<Node> e = n.f0.elements();
        if (!e.hasMoreElements()) {
            Errors.warning("Generating empty NodeSequence in " + this.curProduction + "()");
            this.out.println("{ " + ident + " = new NodeSequence(); }");
            this.out.print(this.spc.spc);
        } else {
            ExpansionUnit unit = (ExpansionUnit)e.nextElement();
            String sizeStr = Integer.toString(n.f0.size());
            if (unit.f0.which == 0) {
                unit.accept(this);
                this.out.println("{ " + ident + " = new NodeSequence(" + sizeStr + "); }");
                this.out.print(this.spc.spc);
            } else {
                this.out.println("{ " + ident + " = new NodeSequence(" + sizeStr + "); }");
                this.out.print(this.spc.spc);
                ++this.nestLevel;
                unit.accept(this);
                --this.nestLevel;
                if (this.annotateNode) {
                    this.out.println(this.addNodeString(ident, this.prevVar.getName()));
                    this.out.print(this.spc.spc);
                }
            }
            while (e.hasMoreElements()) {
                ++this.nestLevel;
                e.nextElement().accept(this);
                --this.nestLevel;
                if (!this.annotateNode) continue;
                this.out.println(this.addNodeString(ident, this.prevVar.getName()));
                this.out.print(this.spc.spc);
            }
        }
    }

    private String addNodeString(String parentName, String varName) {
        return "{ " + parentName + ".addNode(" + varName + "); }";
    }

    public void visit(ExpansionUnit n) {
        switch (n.f0.which) {
            case 0: 
            case 1: {
                n.accept(this.plainPrinter);
                this.out.println();
                this.out.print(this.spc.spc);
                this.annotateNode = false;
                break;
            }
            case 2: {
                this.parenExprCode(n);
                break;
            }
            case 3: {
                NodeOptional optHook = new NodeOptional();
                NodeSequence parenSeq = new NodeSequence(4);
                NodeSequence seq = (NodeSequence)n.f0.choice;
                parenSeq.addNode(new NodeToken("("));
                parenSeq.addNode((ExpansionChoices)seq.elementAt(1));
                parenSeq.addNode(new NodeToken(")"));
                NodeChoice choice1 = new NodeChoice(new NodeToken("?"), 2);
                optHook.addNode(choice1);
                parenSeq.addNode(optHook);
                NodeChoice choice2 = new NodeChoice(parenSeq, 2);
                this.parenExprCode(new ExpansionUnit(choice2));
                break;
            }
            case 4: {
                NodeSequence seq = (NodeSequence)n.f0.choice;
                NodeOptional opt = (NodeOptional)seq.elementAt(0);
                if (opt.present()) {
                    NodeSequence seq1 = (NodeSequence)opt.node;
                    this.out.print(this.javaString(seq1.elementAt(0)) + seq1.elementAt(1));
                }
                seq.elementAt(1).accept(this);
                break;
            }
            default: {
                Errors.hardErr("n.f0.which = " + String.valueOf(n.f0.which));
            }
        }
    }

    private void parenExprCode(ExpansionUnit n) {
        NodeSequence seq = (NodeSequence)n.f0.choice;
        ExpansionChoices ec = (ExpansionChoices)seq.elementAt(1);
        this.out.println(seq.elementAt(0));
        this.spc.updateSpc(1);
        this.out.print(this.spc.spc);
        if (!((NodeOptional)seq.elementAt(3)).present()) {
            if (ec.f1.present()) {
                ec.accept(this);
            } else {
                ExpansionUnitTypeCounter v = new ExpansionUnitTypeCounter();
                ec.accept(v);
                if (v.getNumNormals() == 0) {
                    Errors.warning("Empty parentheses in " + this.curProduction + "()", ((NodeToken)seq.elementAt((int)0)).beginLine);
                }
                String name = this.curVarName();
                VarInfo info = new VarInfo("NodeSequence", name);
                this.varList.addElement(info);
                this.generateSequence(ec.f0, name);
                this.finalActions(info);
            }
            this.out.println();
            this.spc.updateSpc(-1);
            this.out.print(this.spc.spc);
            seq.elementAt(2).accept(this.plainPrinter);
            seq.elementAt(3).accept(this.plainPrinter);
            this.out.println();
        } else {
            String mod = ((NodeChoice)((NodeOptional)seq.elementAt((int)3)).node).choice.toString();
            String name = this.curVarName();
            NodeListOptional list = ec.f0.f0;
            ExpansionUnitTypeCounter vc = new ExpansionUnitTypeCounter();
            ec.accept(vc);
            if (!list.present() || vc.getNumNormals() == 0) {
                Errors.softErr("Empty EBNF expansion in " + this.curProduction + "()", ((NodeToken)seq.elementAt((int)0)).beginLine);
            } else {
                VarInfo info;
                ExpansionUnit firstUnit = (ExpansionUnit)list.nodes.elementAt(0);
                if (this.specialList == null) {
                    info = this.infoForMod(name, mod, true);
                } else {
                    info = this.infoForMod(name, mod, false);
                    this.specialList.addElement(info);
                }
                this.varList.addElement(info);
                if (ec.f1.present() || firstUnit.f0.which != 0) {
                    this.generateSpecial(n, name);
                } else {
                    Vector<Node> v = list.nodes;
                    firstUnit.accept(this.plainPrinter);
                    this.out.println();
                    this.out.print(this.spc.spc);
                    v.removeElementAt(0);
                    this.generateSpecial(n, name);
                    v.insertElementAt(firstUnit, 0);
                }
                if (this.annotateNode) {
                    this.out.print(this.addNodeString(name, this.prevVar.getName()));
                }
                this.finalActions(info);
            }
            this.out.println();
            this.spc.updateSpc(-1);
            this.out.print(this.spc.spc);
            seq.elementAt(2).accept(this.plainPrinter);
            seq.elementAt(3).accept(this.plainPrinter);
            this.out.println();
            if (((NodeOptional)seq.elementAt(3)).present() && (mod.equals("*") || mod.equals("+"))) {
                this.out.println(this.spc.spc + "{ " + name + ".nodes.trimToSize(); }");
            }
        }
        this.out.print(this.spc.spc);
    }

    private void generateSpecial(ExpansionUnit n, String ident) {
        NodeSequence seq = (NodeSequence)n.f0.choice;
        ExpansionChoices ec = (ExpansionChoices)seq.elementAt(1);
        PrintWriter tempOut = this.out;
        StringWriter buf = new StringWriter();
        this.out = new PrintWriter(buf);
        this.plainPrinter.setOut(this.out);
        Vector tempSpecialList = this.specialList;
        this.specialList = new Vector();
        ++this.nestLevel;
        ec.accept(this);
        --this.nestLevel;
        if (this.specialList.size() > 0) {
            Enumeration e = this.specialList.elements();
            while (e.hasMoreElements()) {
                VarInfo vi = (VarInfo)e.nextElement();
                tempOut.println("{ " + vi.getName() + " = new " + vi.getType() + "(); }");
                tempOut.print(this.spc.spc);
            }
        }
        this.out.flush();
        this.out = tempOut;
        this.plainPrinter.setOut(this.out);
        this.specialList = tempSpecialList;
        this.out.print(buf.toString());
    }

    private VarInfo infoForMod(String ident, String mod, boolean initializer) {
        if (initializer) {
            if (mod.equals("+")) {
                return new VarInfo("NodeList", ident, "new NodeList()");
            }
            if (mod.equals("*")) {
                return new VarInfo("NodeListOptional", ident, "new NodeListOptional()");
            }
            if (mod.equals("?")) {
                return new VarInfo("NodeOptional", ident, "new NodeOptional()");
            }
            Errors.hardErr("Illegal EBNF modifier: " + mod);
        } else {
            if (mod.equals("+")) {
                return new VarInfo("NodeList", ident);
            }
            if (mod.equals("*")) {
                return new VarInfo("NodeListOptional", ident);
            }
            if (mod.equals("?")) {
                return new VarInfo("NodeOptional", ident);
            }
            Errors.hardErr("Illegal EBNF modifier: " + mod);
        }
        return null;
    }

    public void visit(ExpansionUnitTerm n) {
        if (n.f0.which == 0) {
            n.f0.accept(this);
        } else {
            NodeSequence seq = (NodeSequence)n.f0.choice;
            String name = this.curVarName();
            VarInfo info = new VarInfo(seq.elementAt(0).toString(), name);
            this.varList.addElement(info);
            this.out.print(name + "=");
            seq.elementAt(0).accept(this.plainPrinter);
            seq.elementAt(1).accept(this.plainPrinter);
            this.out.println();
            this.out.print(this.spc.spc);
            this.finalActions(info);
        }
    }

    public void visit(LocalLookahead n) {
        n.accept(this.plainPrinter);
    }

    public void visit(RegularExpression n) {
        String nodeName = this.curVarName();
        String tokenName = this.curVarName();
        VarInfo nodeInfo = new VarInfo("NodeToken", nodeName);
        VarInfo tokenInfo = new VarInfo("Token", tokenName);
        this.varList.addElement(nodeInfo);
        this.varList.addElement(tokenInfo);
        this.out.print(tokenName + "=");
        n.f0.accept(this.plainPrinter);
        if (n.f0.which == 3) {
            this.out.println(" { ");
            this.spc.updateSpc(1);
            this.out.println(this.spc.spc + tokenName + ".beginColumn++; " + tokenName + ".endColumn++;");
            this.out.println(this.spc.spc + nodeName + " = JTBToolkit.makeNodeToken(" + tokenName + ");");
            this.spc.updateSpc(-1);
            this.out.println(this.spc.spc + "}");
        } else {
            this.out.println(" { " + nodeName + " = JTBToolkit.makeNodeToken(" + tokenName + "); }");
        }
        this.out.print(this.spc.spc);
        this.finalActions(nodeInfo);
    }
}

