/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.CharEncUtils;
import edu.berkeley.nlp.util.Exceptions;
import edu.berkeley.nlp.util.IOUtils;
import edu.berkeley.nlp.util.LogInfo;
import edu.berkeley.nlp.util.StrUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;
import java.util.Random;

public class Utils {
    public static Random randRandom(Random random) {
        return new Random(random.nextInt(Integer.MAX_VALUE));
    }

    public static boolean equals(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        return o1.equals(o2);
    }

    public static int setEqual(int oldValue, int newValue) {
        return Utils.setEqual(oldValue, newValue, -1);
    }

    public static int setEqual(int oldValue, int newValue, int nullValue) {
        if (oldValue == nullValue) {
            return newValue;
        }
        if (newValue == nullValue) {
            return oldValue;
        }
        if (oldValue != newValue) {
            throw Exceptions.bad("Mis-match: %d %d", oldValue, newValue);
        }
        return newValue;
    }

    public static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Properties loadProperties(String path) {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(path));
            return properties;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot open " + path);
        }
    }

    public static boolean createSymLink(String src, String dest) {
        try {
            String cmd = String.format("ln -sn '%s' '%s'", src, dest);
            try {
                return Runtime.getRuntime().exec(cmd).waitFor() == 0;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String getStackTrace(Throwable t, int max, String stopClassPrefix) {
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement e : t.getStackTrace()) {
            if (max-- <= 0 || stopClassPrefix != null && e.getClassName().startsWith(stopClassPrefix)) break;
            sb.append(e);
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String getStackTrace(Throwable t) {
        return Utils.getStackTrace(t, Integer.MAX_VALUE, null);
    }

    public static String getStackTrace(Throwable t, int max) {
        return Utils.getStackTrace(t, max, null);
    }

    public static String getStackTrace(Throwable t, String classPrefix) {
        return Utils.getStackTrace(t, Integer.MAX_VALUE, classPrefix);
    }

    public static int parseIntEasy(String s, int defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long parseLongEasy(String s, long defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static double parseDoubleEasy(String s) {
        return Utils.parseDoubleEasy(s, Double.NaN);
    }

    public static double parseDoubleEasy(String s, double defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static boolean parseBooleanEasy(String s, boolean defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        try {
            return Boolean.parseBoolean(s);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static int parseIntHard(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid format: " + s);
        }
    }

    public static double parseDoubleHard(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid format: " + s);
        }
    }

    public static boolean parseBooleanHard(String s) {
        try {
            return Boolean.parseBoolean(s);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid format: " + s);
        }
    }

    public static Object parseEnum(Class c, String s) {
        s = s.toLowerCase();
        for (Object o : c.getEnumConstants()) {
            if (!o.toString().toLowerCase().equals(s)) continue;
            return o;
        }
        return null;
    }

    public static double toDouble(Object o) {
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).intValue();
        }
        throw Exceptions.bad("Can't convert to double: " + o);
    }

    public static int parseTimeLength(String s) {
        if (StrUtils.isEmpty(s)) {
            return 0;
        }
        int sum = 0;
        int n = 0;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c)) {
                n = n * 10 + Integer.parseInt(c + "");
                continue;
            }
            if (c == 'd') {
                sum += n * 60 * 60 * 24;
                n = 0;
                continue;
            }
            if (c == 'h') {
                sum += n * 60 * 60;
                n = 0;
                continue;
            }
            if (c == 'm') {
                sum += n * 60;
                n = 0;
                continue;
            }
            if (c != 's') continue;
            sum += n;
            n = 0;
        }
        return sum;
    }

    public static Process openSystem(String cmd) throws IOException {
        return Runtime.getRuntime().exec(new String[]{"sh", "-c", cmd});
    }

    public static Process openSystemLogin(String cmd) throws IOException {
        return Runtime.getRuntime().exec(new String[]{"bash", "--login", "-c", cmd});
    }

    public static int closeSystem(String cmd, Process p) throws InterruptedException {
        return p.waitFor();
    }

    public static int closeSystemEasy(String cmd, Process p) {
        try {
            return Utils.closeSystem(cmd, p);
        }
        catch (InterruptedException e) {
            return -1;
        }
    }

    public static void closeSystemHard(String cmd, Process p) {
        try {
            int status = Utils.closeSystem(cmd, p);
            if (status != 0) {
                throw new RuntimeException("Failed: '" + cmd + "' returned status " + status);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean system(String cmd, Writer finalOut, Writer finalErr) throws IOException, InterruptedException {
        Process p = Utils.openSystem(cmd);
        p.getOutputStream().close();
        BufferedReader in = CharEncUtils.getReader(p.getInputStream());
        if (finalOut != null) {
            IOUtils.copy(in, finalOut);
        }
        in.close();
        BufferedReader err = CharEncUtils.getReader(p.getErrorStream());
        if (finalErr != null) {
            IOUtils.copy(err, finalErr);
        }
        err.close();
        return Utils.closeSystem(cmd, p) == 0;
    }

    public static boolean system(String cmd, OutputStream finalOut, OutputStream finalErr) throws IOException, InterruptedException {
        Process p = Utils.openSystem(cmd);
        p.getOutputStream().close();
        InputStream in = p.getInputStream();
        if (finalOut != null) {
            IOUtils.copy(in, finalOut);
        }
        in.close();
        InputStream err = p.getErrorStream();
        if (finalErr != null) {
            IOUtils.copy(err, finalErr);
        }
        err.close();
        return Utils.closeSystem(cmd, p) == 0;
    }

    public static boolean system(String cmd) throws IOException, InterruptedException {
        return Utils.system(cmd, System.out, System.err);
    }

    public static boolean systemLogin(String cmd, OutputStream finalOut, OutputStream finalErr) throws IOException, InterruptedException {
        Process p = Utils.openSystemLogin(cmd);
        p.getOutputStream().close();
        InputStream in = p.getInputStream();
        if (finalOut != null) {
            IOUtils.copy(in, finalOut);
        }
        in.close();
        InputStream err = p.getErrorStream();
        if (finalErr != null) {
            IOUtils.copy(err, finalErr);
        }
        err.close();
        return Utils.closeSystem(cmd, p) == 0;
    }

    public static boolean systemLogin(String cmd) throws IOException, InterruptedException {
        return Utils.systemLogin(cmd, System.out, System.err);
    }

    public static void systemHard(String cmd, Writer finalOut, Writer finalErr) {
        try {
            if (!Utils.system(cmd, finalOut, finalErr)) {
                throw new RuntimeException(cmd + " had non-zero exit status");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void systemHard(String cmd, OutputStream finalOut, OutputStream finalErr) {
        try {
            if (!Utils.system(cmd, finalOut, finalErr)) {
                throw new RuntimeException(cmd + " had non-zero exit status");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void systemHard(String cmd) {
        Utils.systemHard(cmd, System.out, System.err);
    }

    public static boolean systemEasy(String cmd, Writer finalOut, Writer finalErr) {
        try {
            return Utils.system(cmd, finalOut, finalErr);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean systemEasy(String cmd, OutputStream finalOut, OutputStream finalErr) {
        try {
            return Utils.system(cmd, finalOut, finalErr);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean systemEasy(String cmd) {
        return Utils.systemEasy(cmd, System.out, System.err);
    }

    public static String systemGetStringOutput(String cmd) throws IOException, InterruptedException {
        StringWriter sw = new StringWriter();
        if (!Utils.system(cmd, sw, LogInfo.stderr)) {
            return null;
        }
        return sw.toString();
    }

    public static String systemGetStringOutputEasy(String cmd) {
        try {
            return Utils.systemGetStringOutput(cmd);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String makeRunCommandInDir(String cmd, String dir) {
        return String.format("cd %s && (%s)", dir, cmd);
    }
}

