/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.Iterators;
import edu.berkeley.nlp.util.MapFactory;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Trie<K, V>
implements Map<List<K>, V> {
    private Map<K, Trie<K, V>> map;
    private V v;
    private int size;
    private final boolean useIdentity;
    public static int id = 0;

    public Trie(boolean useIdentity) {
        this(useIdentity, null, null, null);
    }

    public Trie() {
        this(false, null, null, null);
    }

    protected Trie(boolean useIdentity, K k, V v, Trie<K, V> backPointer) {
        this.useIdentity = useIdentity;
        this.v = v;
        this.map = useIdentity ? new IdentityHashMap() : new HashMap(3);
        ++id;
    }

    public Trie<K, V> getNextTrie(K k) {
        return this.map.get(k);
    }

    public Trie<K, V> getPartialList(List<K> ts) {
        if (ts.isEmpty()) {
            return null;
        }
        K t = ts.get(0);
        Trie<K, V> trie = this.map.get(t);
        if (trie == null) {
            return null;
        }
        if (ts.size() == 1) {
            return trie;
        }
        return trie.getPartialList(ts.subList(1, ts.size()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        boolean added = false;
        for (List<K> t : this.keySet()) {
            if (added) {
                sb.append(",");
            }
            sb.append(t);
            sb.append("=");
            sb.append(this.get(t));
            added = true;
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public V put(List<K> k, V v) {
        this.put(k, v, 0);
        return null;
    }

    private void put(List<K> k, V v, int start) {
        K first = k.get(start);
        Trie<K, Object> trie = this.map.get(first);
        if (trie == null) {
            if (k.size() - start == 1) {
                this.map.put(first, this.newTrie(this.useIdentity, first, v, this));
            } else {
                trie = this.newTrie(this.useIdentity, first, null, this);
                this.map.put(first, trie);
                super.put(k, v, start + 1);
            }
        } else if (k.size() - start == 1) {
            trie.v = v;
        } else {
            super.put(k, v, start + 1);
        }
    }

    protected Trie<K, V> newTrie(boolean useIdentity2, K first, V v2, Trie<K, V> trie) {
        return new Trie<K, V>(useIdentity2, first, v2, trie);
    }

    @Override
    public void putAll(Map<? extends List<K>, ? extends V> c) {
        for (List<K> e : c.keySet()) {
            this.put(e, c.get(e));
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        this.size = 0;
    }

    public Iterable<K> nextElements() {
        return Iterators.able(this.map.keySet().iterator());
    }

    @Override
    public boolean containsKey(Object o) {
        return this.get(o) != null;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    private MyIterator setIterator() {
        return new MyIterator();
    }

    public Iterable<List<K>> bySuffixLength(int suffixLength) {
        return new SuffixLengthIterable(suffixLength);
    }

    @Override
    public V remove(Object o) {
        if (!(o instanceof List)) {
            return null;
        }
        List k = (List)o;
        Object first = k.get(0);
        if (k.size() == 1) {
            Trie<K, V> remove = this.map.get(first);
            if (remove == null) {
                return null;
            }
            remove.v = null;
            if (remove.isEmpty()) {
                this.map.remove(first);
            }
            return null;
        }
        Trie<K, V> trie = this.map.get(first);
        if (trie == null) {
            return null;
        }
        trie.remove(k.subList(1, k.size()));
        if (trie.isEmpty() && trie.v == null) {
            this.map.remove(first);
        }
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    public <E> E[] toArray(E[] a) {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] argv) {
        Trie<String, Boolean> tree = new Trie<String, Boolean>();
        tree.put(Arrays.asList("c", "a"), Boolean.valueOf(true));
        tree.put(Arrays.asList("c"), Boolean.valueOf(true));
        tree.put(Arrays.asList("a", "b", "c"), Boolean.valueOf(true));
        tree.put(Arrays.asList("a", "b"), Boolean.valueOf(true));
        tree.put(Arrays.asList("a", "b", "c"), Boolean.valueOf(true));
        tree.put(Arrays.asList("a", "b", "x", "y", "z", "c"), Boolean.valueOf(true));
        tree.put(Arrays.asList("a", "b", "y", "c"), Boolean.valueOf(true));
        tree.put(Arrays.asList("a", "d", "c"), Boolean.valueOf(true));
        tree.put(Arrays.asList("a", "d", "e"), Boolean.valueOf(true));
        tree.put(Arrays.asList("1", "2", "3", "4", "t", "v"), Boolean.valueOf(true));
        tree.put(Arrays.asList("1", "2", "3"), Boolean.valueOf(true));
        tree.put(Arrays.asList("1", "2", "3", "4"), Boolean.valueOf(true));
        tree.put(Arrays.asList("1", "2", "3", "4", "t"), Boolean.valueOf(true));
        tree.put(Arrays.asList("4", "5", "6"), Boolean.valueOf(true));
        for (List list : tree.keySet()) {
            System.out.println(list);
        }
        tree.remove(Arrays.asList("1", "2", "3", "4", "t"));
        System.out.println();
        for (List list : tree.keySet()) {
            System.out.println(list);
        }
        tree.remove(Arrays.asList("1", "2", "3", "4"));
        System.out.println();
        for (List list : tree.keySet()) {
            System.out.println(list);
        }
        tree.remove(Arrays.asList("1", "2", "3", "4", "t", "v"));
        System.out.println();
        for (List list : tree.keySet()) {
            System.out.println(list);
        }
    }

    public boolean containsElement(K t) {
        return this.map.containsKey(t);
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<List<K>, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public V get(Object key) {
        if (!(key instanceof List)) {
            return null;
        }
        List l = (List)key;
        return this.get(l, 0);
    }

    private V get(List<K> l, int start) {
        K first = l.get(start);
        Trie<K, V> trie = this.map.get(first);
        if (trie == null) {
            return null;
        }
        if (start == l.size() - 1) {
            return trie.v;
        }
        return super.get(l, start + 1);
    }

    @Override
    public Set<List<K>> keySet() {
        return new AbstractSet<List<K>>(){

            @Override
            public Iterator<List<K>> iterator() {
                return Trie.this.setIterator();
            }

            @Override
            public int size() {
                return Trie.this.size;
            }
        };
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    public V getNodeValue() {
        return this.v;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyIterator
    implements Iterator<List<K>> {
        private boolean hasNext;
        private boolean activeTokenAlreadyReturned = true;
        private boolean alreadyAdvanced;
        private K currToken;
        private MyIterator currSuffixIter;
        private final Iterator<K> tokenIter;

        private Map getMap() {
            return Trie.this.map;
        }

        public MyIterator() {
            this.tokenIter = Trie.this.map.keySet().iterator();
            this.advanceIter();
            this.alreadyAdvanced = true;
        }

        private void advanceIter() {
            Trie trie;
            if (this.currToken == null) {
                if (!this.tokenIter.hasNext()) {
                    this.alreadyAdvanced = true;
                    this.hasNext = false;
                    return;
                }
                this.currToken = this.tokenIter.next();
                trie = (Trie)Trie.this.map.get(this.currToken);
                MyIterator myIterator = this.currSuffixIter = trie == null ? null : trie.setIterator();
                if (trie.v != null) {
                    this.activeTokenAlreadyReturned = false;
                    this.hasNext = true;
                    this.alreadyAdvanced = true;
                    return;
                }
            }
            trie = (Trie)Trie.this.map.get(this.currToken);
            if (this.currSuffixIter == null) {
                MyIterator myIterator = this.currSuffixIter = trie == null ? null : trie.setIterator();
            }
            if (this.currSuffixIter == null || !this.currSuffixIter.hasNext()) {
                this.currToken = null;
                this.advanceIter();
            } else {
                this.hasNext = true;
            }
            this.alreadyAdvanced = true;
        }

        @Override
        public boolean hasNext() {
            if (!this.alreadyAdvanced) {
                this.advanceIter();
            }
            return this.hasNext;
        }

        @Override
        public List<K> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.alreadyAdvanced = false;
            ArrayList retVal = null;
            if (!this.activeTokenAlreadyReturned) {
                this.activeTokenAlreadyReturned = true;
                return Collections.singletonList(this.currToken);
            }
            retVal = new ArrayList();
            retVal.add(this.currToken);
            retVal.addAll((Collection)this.currSuffixIter.next());
            return retVal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SuffixLengthIterable
    implements Iterable<List<K>> {
        private final int suffixLength;

        public SuffixLengthIterable(int suffixLength) {
            this.suffixLength = suffixLength;
        }

        @Override
        public Iterator<List<K>> iterator() {
            return new SuffixLengthIterator();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class SuffixLengthIterator
        implements Iterator<List<K>> {
            private final Iterator<List<K>> allIter;
            private List<K> next;
            private List<K> curr;

            public SuffixLengthIterator() {
                this.allIter = Trie.this.setIterator();
                this.advanceIter();
                this.curr = this.next;
            }

            private void advanceIter() {
                this.curr = this.next;
                while (this.allIter.hasNext()) {
                    List currNext = this.allIter.next();
                    if (currNext.size() != SuffixLengthIterable.this.suffixLength) continue;
                    this.next = currNext;
                }
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public List<K> next() {
                if (!this.hasNext()) {
                    throw new UnsupportedOperationException();
                }
                this.advanceIter();
                return this.curr;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TrieMapFactory<K, V>
    extends MapFactory<List<K>, V> {
        private boolean identity;

        public TrieMapFactory(boolean identity) {
            this.identity = identity;
        }

        @Override
        public Map<List<K>, V> buildMap() {
            return new Trie(this.identity);
        }
    }
}

