/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubIndexer<E>
extends AbstractList<E> {
    List<E> objects = new ArrayList();
    Map<E, Integer> indexes = new HashMap<E, Integer>();
    List<Integer> subindexes = new ArrayList<Integer>();

    @Override
    public E get(int index) {
        return this.objects.get(index);
    }

    @Override
    public int size() {
        return this.objects.size();
    }

    public int totalSize() {
        return this.subindexes.get(this.subindexes.size() - 1);
    }

    @Override
    public int indexOf(Object o) {
        Integer index = this.indexes.get(o);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public int subindexBegin(int index) {
        return this.subindexes.get(index);
    }

    public int subindexEnd(int index) {
        return this.subindexes.get(index + 1);
    }

    @Override
    public boolean contains(Object o) {
        return this.indexes.keySet().contains(o);
    }

    public boolean add(E e, int numSubstates) {
        if (this.contains(e)) {
            return false;
        }
        this.objects.add(e);
        this.indexes.put(e, this.size() - 1);
        Integer previousSubindex = this.subindexes.get(this.subindexes.size() - 1);
        this.subindexes.add(previousSubindex + numSubstates);
        return true;
    }

    public SubIndexer() {
        this.subindexes.add(0);
    }
}

