/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.Indexer;
import java.io.Serializable;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SparseArray<T>
implements Serializable {
    private static final long serialVersionUID = 42L;
    T[] values = new Object[0];
    int[] indices = new int[0];
    int length = 0;

    private void grow() {
        int curSize = this.values.length;
        int newSize = curSize + 10;
        Object[] newData = new Object[newSize];
        System.arraycopy(this.values, 0, newData, 0, curSize);
        this.values = newData;
        int[] newIndices = new int[newSize];
        System.arraycopy(this.indices, 0, newIndices, 0, curSize);
        for (int i = curSize; i < newIndices.length; ++i) {
            newIndices[i] = Integer.MAX_VALUE;
        }
        this.indices = newIndices;
    }

    public T get(int index) {
        int res = Arrays.binarySearch(this.indices, index);
        if (res >= 0 && res < this.length) {
            return this.values[res];
        }
        return null;
    }

    public int size() {
        return this.length;
    }

    public void put(int index0, T x) {
        int res = Arrays.binarySearch(this.indices, index0);
        if (res >= 0 && res < this.length) {
            this.values[res] = x;
            return;
        }
        if (this.length + 1 >= this.values.length) {
            this.grow();
        }
        int insertionPoint = -(res + 1);
        assert (insertionPoint >= 0 && insertionPoint <= this.length) : String.format("length: %d insertion: %d", this.length, insertionPoint);
        System.arraycopy(this.values, insertionPoint, this.values, insertionPoint + 1, this.length - insertionPoint);
        System.arraycopy(this.indices, insertionPoint, this.indices, insertionPoint + 1, this.length - insertionPoint);
        this.indices[insertionPoint] = index0;
        this.values[insertionPoint] = x;
        ++this.length;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        for (int i = 0; i < this.length; ++i) {
            builder.append(String.format("%d : %.5f", this.indices[i], this.values[i]));
            builder.append(" ");
        }
        builder.append(" }");
        return builder.toString();
    }

    public String toString(Indexer<?> indexer) {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        for (int i = 0; i < this.length; ++i) {
            builder.append(String.format("%s : %.5f", indexer.getObject(this.indices[i]), this.values[i]));
            builder.append(" ");
        }
        builder.append("}");
        return builder.toString();
    }

    public static void main(String[] args) {
        SparseArray<Double> sv = new SparseArray<Double>();
        sv.put(0, 1.0);
        sv.put(1, 2.0);
        sv.put(4, -2.0);
        System.out.println(sv);
    }
}

