/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.math.DoubleArrays;
import edu.berkeley.nlp.math.SloppyMath;
import java.util.Arrays;

public class ScalingTools {
    public static final int LOGSCALE = 100;
    public static final double SCALE = Math.exp(100.0);

    public static double calcScaleFactor(double logScale) {
        return ScalingTools.calcScaleFactor(logScale, SCALE);
    }

    public static double calcScaleFactor(double logScale, double scale) {
        if (logScale == -2.147483648E9) {
            return 0.0;
        }
        if (logScale == 0.0) {
            return 1.0;
        }
        if (logScale == 1.0) {
            return scale;
        }
        if (logScale == 2.0) {
            return scale * scale;
        }
        if (logScale == 3.0) {
            return scale * scale * scale;
        }
        if (logScale == -1.0) {
            return 1.0 / scale;
        }
        if (logScale == -2.0) {
            return 1.0 / scale / scale;
        }
        if (logScale == -3.0) {
            return 1.0 / scale / scale / scale;
        }
        return Math.pow(scale, logScale);
    }

    public static int scaleArray(double[] scores, int previousScale) {
        if (previousScale == Integer.MIN_VALUE) {
            return previousScale;
        }
        int logScale = 0;
        double scale = 1.0;
        double max = DoubleArrays.max(scores);
        if (max == Double.POSITIVE_INFINITY) {
            return 0;
        }
        if (max == 0.0) {
            return previousScale;
        }
        while (max > SCALE) {
            max /= SCALE;
            scale *= SCALE;
            ++logScale;
        }
        while (max > 0.0 && max < 1.0 / SCALE) {
            max *= SCALE;
            scale /= SCALE;
            --logScale;
        }
        if (logScale != 0) {
            int i = 0;
            while (i < scores.length) {
                int n = i++;
                scores[n] = scores[n] / scale;
            }
        }
        return previousScale + logScale;
    }

    public static void scaleArrayToScale(double[] scores, int previousScale, int newScale) {
        int scaleDiff = previousScale - newScale;
        if (scaleDiff == 0) {
            return;
        }
        double max = DoubleArrays.max(scores);
        if (SloppyMath.isDangerous(max)) {
            return;
        }
        double scale = ScalingTools.calcScaleFactor(scaleDiff);
        if (Math.abs(scaleDiff) >= 800) {
            Arrays.fill(scores, 0.0);
            return;
        }
        int i = 0;
        while (i < scores.length) {
            int n = i++;
            scores[n] = scores[n] * scale;
        }
    }

    public static double scaleToScale(double score, int previousScale, int newScale) {
        int scaleDiff = previousScale - newScale;
        if (scaleDiff == 0) {
            return score;
        }
        double max = score;
        if (SloppyMath.isDangerous(max)) {
            return 0.0;
        }
        double scale = ScalingTools.calcScaleFactor(scaleDiff);
        if (Math.abs(scaleDiff) >= 800) {
            return 0.0;
        }
        return score *= scale;
    }

    public static boolean isBadScale(int scale) {
        return scale == Integer.MIN_VALUE || scale == Integer.MAX_VALUE || scale == 0x7FFFFFFE || scale == -2147483647 || scale == 0x7FFFFFFD || scale == -2147483646;
    }
}

