/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.IOUtils;
import edu.berkeley.nlp.util.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectReader<T extends Serializable> {
    private final File folder;
    private final String[] files;
    private ObjectInputStream currentStream = null;
    private int currentIndex = -1;
    private boolean currentStreamHasNext = false;

    public ObjectReader(File folder, final String filenameFilter) {
        this.folder = folder;
        this.files = folder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.contains(filenameFilter);
            }
        });
        Arrays.sort(this.files);
        this.openNextStream();
    }

    public void reset() {
        this.currentIndex = -1;
        this.openNextStream();
    }

    private void openNextStream() {
        try {
            if (this.currentStream != null) {
                this.currentStream.close();
                this.currentStream = null;
            }
            ++this.currentIndex;
            if (this.currentIndex < this.files.length) {
                this.currentStream = IOUtils.openObjIn(new File(this.folder, this.files[this.currentIndex]));
                this.currentStreamHasNext = this.currentStream.readBoolean();
            }
        }
        catch (IOException e) {
            Logger.err("Error opening forest file: " + e);
            this.currentStream = null;
        }
    }

    public T getNextObject() {
        try {
            while (!this.currentStreamHasNext && this.currentStream != null) {
                this.openNextStream();
            }
            if (this.currentStream == null) {
                return null;
            }
            Serializable nextObject = (Serializable)this.currentStream.readObject();
            this.currentStreamHasNext = this.currentStream.readBoolean();
            return (T)nextObject;
        }
        catch (Exception e) {
            Logger.err("Error reading object: " + e);
            return null;
        }
    }
}

