/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MapFactory<K, V>
implements Serializable {
    public abstract Map<K, V> buildMap();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WeakHashMapFactory<K, V>
    extends MapFactory<K, V> {
        private static final long serialVersionUID = 1L;

        @Override
        public Map<K, V> buildMap() {
            return new WeakHashMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TreeMapFactory<K, V>
    extends MapFactory<K, V> {
        private static final long serialVersionUID = 1L;

        @Override
        public Map<K, V> buildMap() {
            return new TreeMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IdentityHashMapFactory<K, V>
    extends MapFactory<K, V> {
        private static final long serialVersionUID = 1L;

        @Override
        public Map<K, V> buildMap() {
            return new IdentityHashMap();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HashMapFactory<K, V>
    extends MapFactory<K, V> {
        private static final long serialVersionUID = 1L;

        @Override
        public Map<K, V> buildMap() {
            return new HashMap();
        }
    }
}

