/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.util.CollectionUtils;
import edu.berkeley.nlp.util.functional.Function;
import edu.berkeley.nlp.util.functional.Predicate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazyIterable<T, I>
implements Iterable<T> {
    private Iterable<I> inputIterable;
    private Function<I, ? extends T> factory;
    private int cacheSize;
    private Predicate<T> outputPred;
    private Set<I> rejectedInputs;

    public LazyIterable(Iterable<I> inputIterable, Function<I, ? extends T> factory, Predicate<T> outputPred, int cacheSize) {
        this.inputIterable = inputIterable;
        this.factory = factory;
        this.cacheSize = cacheSize;
        this.outputPred = outputPred;
        this.rejectedInputs = new HashSet<I>();
    }

    @Override
    public Iterator<T> iterator() {
        return new MyIterator();
    }

    public static void main(String[] args) {
        List<String> arr = CollectionUtils.makeList("Aria is cool", "Isn't he");
        Function<String, String[]> factory = new Function<String, String[]>(){

            @Override
            public String[] apply(String input) {
                return input.split("\\s+");
            }
        };
        LazyIterable<String[], String> iterable = new LazyIterable<String[], String>(arr, factory, null, 10);
        for (Object[] strings : iterable) {
            System.out.println(Arrays.deepToString(strings));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyIterator
    implements Iterator<T> {
        private Iterator<I> inputIt;
        private Queue<T> cache;

        void ensure() {
            if (!this.cache.isEmpty()) {
                return;
            }
            while (this.cache.size() < LazyIterable.this.cacheSize && this.inputIt.hasNext()) {
                Object next = this.nextInternal();
                this.cache.add(next);
            }
        }

        T nextInternal() {
            while (this.inputIt.hasNext()) {
                Object input = this.inputIt.next();
                if (LazyIterable.this.rejectedInputs.contains(input)) continue;
                Object output = LazyIterable.this.factory.apply(input);
                if (((Boolean)LazyIterable.this.outputPred.apply(output)).booleanValue()) {
                    return output;
                }
                LazyIterable.this.rejectedInputs.add(input);
            }
            return null;
        }

        MyIterator() {
            this.inputIt = LazyIterable.this.inputIterable.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.inputIt.hasNext() || !this.cache.isEmpty();
        }

        @Override
        public T next() {
            this.ensure();
            return this.cache.poll();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

