/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import java.util.AbstractList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcatenationList<K>
extends AbstractList<K> {
    private List<List<K>> lists;
    private int size = 0;
    private int[] cumulativeSize;

    public ConcatenationList(List<List<K>> lists) {
        this.lists = lists;
        this.cumulativeSize = new int[lists.size()];
        int i = 0;
        for (List<K> set : lists) {
            this.cumulativeSize[i++] = i == 0 ? 0 : this.cumulativeSize[i - 1] + set.size();
            this.size += set.size();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public K get(int arg0) {
        K k = this.binarySearch(this.lists.size() / 2, arg0);
        return k;
    }

    private K binarySearch(int listIndex, int i) {
        if (i >= this.cumulativeSize[listIndex] && (listIndex == this.lists.size() || i < this.cumulativeSize[listIndex + 1])) {
            return this.lists.get(listIndex).get(i - this.cumulativeSize[listIndex]);
        }
        if (i >= this.cumulativeSize[listIndex + 1]) {
            return this.binarySearch((this.lists.size() - listIndex) / 2, i);
        }
        assert (i < this.cumulativeSize[listIndex]);
        return this.binarySearch(listIndex / 2, i);
    }
}

