/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.util;

import edu.berkeley.nlp.math.SloppyMath;
import edu.berkeley.nlp.util.ListUtils;
import edu.berkeley.nlp.util.StringUtils;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayUtil {
    public static double[] add(double[] a, double c) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] + c;
        }
        return result;
    }

    public static double[] add(double[] a, double[] b) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] + b[i];
        }
        return result;
    }

    public static int[] add(int[] a, int c) {
        int[] result = new int[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] + c;
        }
        return result;
    }

    public static float[] add(float[] a, float[] b) {
        float[] result = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] + b[i];
        }
        return result;
    }

    public static void addInPlace(double[] a, double b) {
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] + b;
        }
    }

    public static void addInPlace(double[] a, double[] b) {
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] + b[i];
        }
    }

    public static void addInPlace(double[][] a, double[][] b) {
        if (a == null || b == null) {
            return;
        }
        if (a.length != b.length) {
            return;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null || b[i] == null) continue;
            ArrayUtil.addInPlace(a[i], b[i]);
        }
    }

    public static void addInPlace(double[][][] a, double[][][] b) {
        if (a == null || b == null) {
            return;
        }
        if (a.length != b.length) {
            return;
        }
        for (int i = 0; i < a.length; ++i) {
            ArrayUtil.addInPlace(a[i], b[i]);
        }
    }

    public static void addInPlace(double[][][][] a, double[][][][] b) {
        if (a == null || b == null) {
            return;
        }
        if (a.length != b.length) {
            return;
        }
        for (int i = 0; i < a.length; ++i) {
            ArrayUtil.addInPlace(a[i], b[i]);
        }
    }

    public static void addInPlace(int[] a, int[] b) {
        if (a == null || b == null) {
            return;
        }
        if (a.length != b.length) {
            return;
        }
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] + b[i];
        }
    }

    public static void addInPlace(int[][] a, int[][] b) {
        if (a == null || b == null) {
            return;
        }
        if (a.length != b.length) {
            return;
        }
        for (int i = 0; i < a.length; ++i) {
            ArrayUtil.addInPlace(a[i], b[i]);
        }
    }

    public static void addInPlace(long[] a, long[] b) {
        if (a == null || b == null) {
            return;
        }
        if (a.length != b.length) {
            return;
        }
        for (int i = 0; i < a.length; ++i) {
            int n = i;
            a[n] = a[n] + b[i];
        }
    }

    public static double approxLogSum(double[] logInputs, int leng) {
        if (leng == 0) {
            throw new IllegalArgumentException();
        }
        int maxIdx = 0;
        double max = logInputs[0];
        for (int i = 1; i < leng; ++i) {
            if (!(logInputs[i] > max)) continue;
            maxIdx = i;
            max = logInputs[i];
        }
        boolean haveTerms = false;
        double intermediate = 0.0;
        double cutoff = max - 30.0;
        for (int i = 0; i < leng; ++i) {
            if (i == maxIdx || !(logInputs[i] > cutoff)) continue;
            haveTerms = true;
            intermediate += SloppyMath.approxExp(logInputs[i] - max);
        }
        if (haveTerms) {
            return max + SloppyMath.approxLog(1.0 + intermediate);
        }
        return max;
    }

    public static int argmax(double[] a) {
        double max = Double.NEGATIVE_INFINITY;
        int argmax = 0;
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] > max)) continue;
            max = a[i];
            argmax = i;
        }
        return argmax;
    }

    public static int argmax(float[] a) {
        float max = Float.NEGATIVE_INFINITY;
        int argmax = 0;
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] > max)) continue;
            max = a[i];
            argmax = i;
        }
        return argmax;
    }

    public static int argmax(short[] a) {
        float max = -32768.0f;
        int argmax = 0;
        for (int i = 0; i < a.length; ++i) {
            if (!((float)a[i] > max)) continue;
            max = a[i];
            argmax = i;
        }
        return argmax;
    }

    public static int argmin(double[] a) {
        double min = Double.POSITIVE_INFINITY;
        int argmin = 0;
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] < min)) continue;
            min = a[i];
            argmin = i;
        }
        return argmin;
    }

    public static int argmin(float[] a) {
        float min = Float.POSITIVE_INFINITY;
        int argmin = 0;
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] < min)) continue;
            min = a[i];
            argmin = i;
        }
        return argmin;
    }

    public static int argmin(int[] a) {
        int min = Integer.MAX_VALUE;
        int argmin = 0;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] >= min) continue;
            min = a[i];
            argmin = i;
        }
        return argmin;
    }

    public static double average(double[] a) {
        double total = ArrayUtil.sum(a);
        return total / (double)a.length;
    }

    public static void booleanAndInPlace(boolean[] array, boolean[] other) {
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            int n = i;
            array[n] = array[n] & other[i];
        }
    }

    public static void booleanAndInPlace(boolean[][] array, boolean[][] other) {
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            ArrayUtil.booleanAndInPlace(array[i], other[i]);
        }
    }

    public static void booleanAndInPlace(boolean[][][] array, boolean[][][] other) {
        if (array == null) {
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            ArrayUtil.booleanAndInPlace(array[i], other[i]);
        }
    }

    public static boolean[][] clone(boolean[][] a) {
        boolean[][] res = new boolean[a.length][];
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            res[i] = (boolean[])a[i].clone();
        }
        return res;
    }

    public static boolean[][][] clone(boolean[][][] a) {
        boolean[][][] res = new boolean[a.length][][];
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            res[i] = ArrayUtil.clone(a[i]);
        }
        return res;
    }

    public static boolean[][][][] clone(boolean[][][][] a) {
        boolean[][][][] res = new boolean[a.length][][][];
        for (int i = 0; i < a.length; ++i) {
            res[i] = ArrayUtil.clone(a[i]);
        }
        return res;
    }

    public static double[][] clone(double[][] a) {
        double[][] res = new double[a.length][];
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            res[i] = (double[])a[i].clone();
        }
        return res;
    }

    public static int[][][] clone(int[][][] a) {
        int[][][] res = new int[a.length][][];
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            res[i] = ArrayUtil.clone(a[i]);
        }
        return res;
    }

    public static double[][][] clone(double[][][] a) {
        double[][][] res = new double[a.length][][];
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            res[i] = ArrayUtil.clone(a[i]);
        }
        return res;
    }

    public static double[][][][] clone(double[][][][] a) {
        double[][][][] res = new double[a.length][][][];
        for (int i = 0; i < a.length; ++i) {
            res[i] = ArrayUtil.clone(a[i]);
        }
        return res;
    }

    public static int[] clone(int[] original) {
        int[] copy = new int[original.length];
        System.arraycopy(original, 0, copy, 0, original.length);
        return copy;
    }

    public static int[][] clone(int[][] a) {
        int[][] res = new int[a.length][];
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            res[i] = ArrayUtil.clone(a[i]);
        }
        return res;
    }

    public static short[] clone(short[] original) {
        short[] copy = new short[original.length];
        System.arraycopy(original, 0, copy, 0, original.length);
        return copy;
    }

    public static double[] clone(double[] original) {
        double[] copy = new double[original.length];
        System.arraycopy(original, 0, copy, 0, original.length);
        return copy;
    }

    public static double[] copy(double[] mat) {
        if (mat == null) {
            return null;
        }
        int m = mat.length;
        double[] newMat = new double[m];
        System.arraycopy(mat, 0, newMat, 0, mat.length);
        return newMat;
    }

    public static double[][] copy(double[][] mat) {
        int m = mat.length;
        double[][] newMat = new double[m][];
        for (int r = 0; r < m; ++r) {
            newMat[r] = ArrayUtil.copy(mat[r]);
        }
        return newMat;
    }

    public static double[][][] copy(double[][][] mat) {
        int m = mat.length;
        double[][][] newMat = new double[m][][];
        for (int r = 0; r < m; ++r) {
            newMat[r] = ArrayUtil.copy(mat[r]);
        }
        return newMat;
    }

    public static double[][][][] copy(double[][][][] mat) {
        int m = mat.length;
        double[][][][] newMat = new double[m][][][];
        for (int r = 0; r < m; ++r) {
            newMat[r] = ArrayUtil.copy(mat[r]);
        }
        return newMat;
    }

    public static float[] doubleArrayToFloatArray(double[] a) {
        float[] result = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = (float)a[i];
        }
        return result;
    }

    public static float[][] doubleArrayToFloatArray(double[][] a) {
        float[][] result = new float[a.length][];
        for (int i = 0; i < a.length; ++i) {
            result[i] = new float[a[i].length];
            for (int j = 0; j < a[i].length; ++j) {
                result[i][j] = (float)a[i][j];
            }
        }
        return result;
    }

    public static double[] exp(double[] a) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = Math.exp(a[i]);
        }
        return result;
    }

    public static void expInPlace(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = Math.exp(a[i]);
        }
    }

    public static void fill(boolean[][] a, boolean val) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            Arrays.fill(a[i], val);
        }
    }

    public static void fill(boolean[][] a, int until1, int until2, boolean val) {
        for (int i = 0; i < until1; ++i) {
            Arrays.fill(a[i], 0, until2 == Integer.MAX_VALUE ? a[i].length : until2, val);
        }
    }

    public static void fill(boolean[][][] a, boolean val) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == null) continue;
            ArrayUtil.fill(a[i], val);
        }
    }

    public static void fill(boolean[][][] a, int until, boolean val) {
        for (int i = 0; i < until; ++i) {
            ArrayUtil.fill(a[i], val);
        }
    }

    public static void fill(boolean[][][] a, int until1, int until2, boolean val) {
        for (int i = 0; i < until1; ++i) {
            ArrayUtil.fill(a[i], until2, Integer.MAX_VALUE, val);
        }
    }

    public static void fill(boolean[][][] a, int until1, int until2, int until3, boolean val) {
        for (int i = 0; i < until1; ++i) {
            ArrayUtil.fill(a[i], until2, until3, val);
        }
    }

    public static void fill(boolean[][][][] a, boolean val) {
        for (int i = 0; i < a.length; ++i) {
            ArrayUtil.fill(a[i], val);
        }
    }

    public static void fill(boolean[][][][] a, int until1, int until2, int until3, int until4, boolean val) {
        for (int i = 0; i < until1; ++i) {
            ArrayUtil.fill(a[i], until2, until3, until4, val);
        }
    }

    public static void fill(double[][] a, double val) {
        for (int i = 0; i < a.length; ++i) {
            Arrays.fill(a[i], val);
        }
    }

    public static void fill(double[][] a, int until1, int until2, double val) {
        for (int i = 0; i < until1; ++i) {
            Arrays.fill(a[i], 0, until2 == Integer.MAX_VALUE ? a[i].length : until2, val);
        }
    }

    public static void fill(double[][][] a, double val) {
        for (int i = 0; i < a.length; ++i) {
            ArrayUtil.fill(a[i], val);
        }
    }

    public static void fill(double[][][] a, int until1, int until2, double val) {
        for (int i = 0; i < until1; ++i) {
            ArrayUtil.fill(a[i], until2, Integer.MAX_VALUE, val);
        }
    }

    public static void fill(double[][][] a, int until1, int until2, int until3, double val) {
        for (int i = 0; i < until1; ++i) {
            ArrayUtil.fill(a[i], until2, until3, val);
        }
    }

    public static void fill(double[][][][] a, double val) {
        for (int i = 0; i < a.length; ++i) {
            ArrayUtil.fill(a[i], val);
        }
    }

    public static void fill(double[][][][] a, int until1, int until2, int until3, int until4, double val) {
        for (int i = 0; i < until1; ++i) {
            ArrayUtil.fill(a[i], until2, until3, until4, val);
        }
    }

    public static void fill(double[][][][][] a, double val) {
        for (int i = 0; i < a.length; ++i) {
            ArrayUtil.fill(a[i], val);
        }
    }

    public static void fill(float[][] a, float val) {
        for (int i = 0; i < a.length; ++i) {
            Arrays.fill(a[i], val);
        }
    }

    public static void fill(float[][][] a, float val) {
        for (int i = 0; i < a.length; ++i) {
            ArrayUtil.fill(a[i], val);
        }
    }

    public static void fill(float[][][][] a, float val) {
        for (int i = 0; i < a.length; ++i) {
            ArrayUtil.fill(a[i], val);
        }
    }

    public static void fill(float[][][][][] a, float val) {
        for (int i = 0; i < a.length; ++i) {
            ArrayUtil.fill(a[i], val);
        }
    }

    public static void fill(int[][] a, int val) {
        ArrayUtil.fill(a, a.length, a[0].length, val);
    }

    public static void fill(int[][] a, int until1, int until2, int val) {
        for (int i = 0; i < until1; ++i) {
            Arrays.fill(a[i], 0, until2, val);
        }
    }

    public static void fill(int[][][] a, int until1, int until2, int until3, int val) {
        for (int i = 0; i < until1; ++i) {
            ArrayUtil.fill(a[i], until2, until3, val);
        }
    }

    public static void fill(double[][][] a, int until, double val) {
        for (int i = 0; i < until; ++i) {
            ArrayUtil.fill(a[i], val);
        }
    }

    public static void fill(int[][][] a, int until, int val) {
        for (int i = 0; i < until; ++i) {
            ArrayUtil.fill(a[i], val);
        }
    }

    public static void fill(int[][][] a, int val) {
        for (int i = 0; i < a.length; ++i) {
            ArrayUtil.fill(a[i], val);
        }
    }

    public static void fill(int[][][][] a, int until1, int until2, int until3, int until4, int val) {
        for (int i = 0; i < until1; ++i) {
            ArrayUtil.fill(a[i], until2, until3, until4, val);
        }
    }

    public static void fill(Object[][] a, int until1, int until2, Object val) {
        for (int i = 0; i < until1; ++i) {
            Arrays.fill(a[i], 0, until2 == Integer.MAX_VALUE ? a[i].length : until2, val);
        }
    }

    public static void fill(Object[][][] a, int until1, int until2, int until3, Object val) {
        for (int i = 0; i < until1; ++i) {
            ArrayUtil.fill(a[i], until2 == Integer.MAX_VALUE ? a[i].length : until2, until3, val);
        }
    }

    public static void fill(Object[][][][] a, int until1, int until2, int until3, int until4, Object val) {
        for (int i = 0; i < until1; ++i) {
            ArrayUtil.fill(a[i], until2 == Integer.MAX_VALUE ? a[i].length : until2, until3, until4, val);
        }
    }

    public static <T> void fill(T[] array, ListUtils.Generator<T> gen) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = gen.generate(i);
        }
    }

    public static <T> void fill(T[][] array, ListUtils.Generator<T> gen) {
        for (int i = 0; i < array.length; ++i) {
            ArrayUtil.fill(array[i], gen);
        }
    }

    public static <T> void fill(T[][][] array, ListUtils.Generator<T> gen) {
        for (int i = 0; i < array.length; ++i) {
            ArrayUtil.fill(array[i], gen);
        }
    }

    public static double[] floatArrayToDoubleArray(float[] a) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i];
        }
        return result;
    }

    public static double[][] floatArrayToDoubleArray(float[][] a) {
        double[][] result = new double[a.length][];
        for (int i = 0; i < a.length; ++i) {
            result[i] = new double[a[i].length];
            for (int j = 0; j < a[i].length; ++j) {
                result[i][j] = a[i][j];
            }
        }
        return result;
    }

    public static boolean hasInfinite(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (!Double.isInfinite(a[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNaN(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            if (!Double.isNaN(a[i])) continue;
            return true;
        }
        return false;
    }

    public static double innerProduct(double[] a, double[] b) {
        double result = 0.0;
        for (int i = 0; i < a.length; ++i) {
            result += a[i] * b[i];
        }
        return result;
    }

    public static double innerProduct(float[] a, float[] b) {
        double result = 0.0;
        for (int i = 0; i < a.length; ++i) {
            result += (double)(a[i] * b[i]);
        }
        return result;
    }

    public static double[] inverse(double[] a) {
        double[] retVal = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            retVal[i] = a[i] == 0.0 ? 0.0 : 1.0 / a[i];
        }
        return retVal;
    }

    public static double klDivergence(double[] from, double[] to) {
        double kl = 0.0;
        double tot = ArrayUtil.sum(from);
        double tot2 = ArrayUtil.sum(to);
        for (int i = 0; i < from.length; ++i) {
            if (from[i] == 0.0) continue;
            double num = from[i] / tot;
            double num2 = to[i] / tot2;
            kl += num * (Math.log(num / num2) / Math.log(2.0));
        }
        return kl;
    }

    public static double[][] load2DMatrixFromFile(String filename) throws IOException {
        String s = StringUtils.slurpFile(filename);
        String[] rows = s.split("[\r\n]+");
        double[][] result = new double[rows.length][];
        for (int i = 0; i < result.length; ++i) {
            String[] columns = rows[i].split("\\s+");
            result[i] = new double[columns.length];
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = Double.parseDouble(columns[j]);
            }
        }
        return result;
    }

    public static double[] log(double[] a) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = Math.log(a[i]);
        }
        return result;
    }

    public static void logInPlace(double[] a) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = Math.log(a[i]);
        }
    }

    public static void logNormalize(double[] a) {
        double logTotal = ArrayUtil.logSum(a);
        if (logTotal == Double.NEGATIVE_INFINITY) {
            double v = -Math.log(a.length);
            for (int i = 0; i < a.length; ++i) {
                a[i] = v;
            }
            return;
        }
        ArrayUtil.shift(a, -logTotal);
    }

    public static double logSum(double[] logInputs) {
        return ArrayUtil.logSum(logInputs, logInputs.length);
    }

    public static double logSum(double[] logInputs, int leng) {
        if (leng == 0) {
            throw new IllegalArgumentException();
        }
        int maxIdx = 0;
        double max = logInputs[0];
        for (int i = 1; i < leng; ++i) {
            if (!(logInputs[i] > max)) continue;
            maxIdx = i;
            max = logInputs[i];
        }
        boolean haveTerms = false;
        double intermediate = 0.0;
        double cutoff = max - 30.0;
        for (int i = 0; i < leng; ++i) {
            if (i == maxIdx || !(logInputs[i] > cutoff)) continue;
            haveTerms = true;
            intermediate += Math.exp(logInputs[i] - max);
        }
        if (haveTerms) {
            return max + Math.log(1.0 + intermediate);
        }
        return max;
    }

    public static float logSum(float[] logInputs) {
        int leng = logInputs.length;
        if (leng == 0) {
            throw new IllegalArgumentException();
        }
        int maxIdx = 0;
        float max = logInputs[0];
        for (int i = 1; i < leng; ++i) {
            if (!(logInputs[i] > max)) continue;
            maxIdx = i;
            max = logInputs[i];
        }
        boolean haveTerms = false;
        double intermediate = 0.0;
        float cutoff = (float)((double)max - 30.0);
        for (int i = 0; i < leng; ++i) {
            if (i == maxIdx || !(logInputs[i] > cutoff)) continue;
            haveTerms = true;
            intermediate += Math.exp(logInputs[i] - max);
        }
        if (haveTerms) {
            return max + (float)Math.log(1.0 + intermediate);
        }
        return max;
    }

    public static double max(double[] a) {
        return a[ArrayUtil.argmax(a)];
    }

    public static float max(float[] a) {
        return a[ArrayUtil.argmax(a)];
    }

    public static float max(short[] a) {
        return a[ArrayUtil.argmax(a)];
    }

    public static int max(int[] a) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
        }
        return max;
    }

    public static int max(Integer[] a) {
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < a.length; ++i) {
            if (a[i] <= max) continue;
            max = a[i];
        }
        return max;
    }

    public static double mean(double[] a) {
        return ArrayUtil.sum(a) / (double)a.length;
    }

    public static double min(double[] a) {
        return a[ArrayUtil.argmin(a)];
    }

    public static float min(float[] a) {
        return a[ArrayUtil.argmin(a)];
    }

    public static int min(int[] a) {
        return a[ArrayUtil.argmin(a)];
    }

    public static double[] multiply(double[] a, double c) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] * c;
        }
        return result;
    }

    public static double[][] multiply(double[][] a, double c) {
        double[][] result = new double[a.length][a[0].length];
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a[0].length; ++j) {
                result[i][j] = a[i][j] * c;
            }
        }
        return result;
    }

    public static float[] multiply(float[] a, float c) {
        float[] result = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] * c;
        }
        return result;
    }

    public static void multiplyInPlace(double[] a, double c) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i] * c;
        }
    }

    public static double norm(double[] a) {
        double squaredSum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            squaredSum += a[i] * a[i];
        }
        return Math.sqrt(squaredSum);
    }

    public static double norm(float[] a) {
        double squaredSum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            squaredSum += (double)(a[i] * a[i]);
        }
        return Math.sqrt(squaredSum);
    }

    public static double norm_1(double[] a) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i] < 0.0 ? -a[i] : a[i];
        }
        return sum;
    }

    public static double norm_1(float[] a) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += (double)(a[i] < 0.0f ? -a[i] : a[i]);
        }
        return sum;
    }

    public static double norm_inf(double[] a) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < a.length; ++i) {
            if (!(Math.abs(a[i]) > max)) continue;
            max = Math.abs(a[i]);
        }
        return max;
    }

    public static double norm_inf(float[] a) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < a.length; ++i) {
            if (!((double)Math.abs(a[i]) > max)) continue;
            max = Math.abs(a[i]);
        }
        return max;
    }

    public static void normalize(double[] a) {
        double total = ArrayUtil.sum(a);
        if (total == 0.0) {
            throw new RuntimeException("Can't normalize an array with sum 0.0");
        }
        ArrayUtil.scale(a, 1.0 / total);
    }

    public static void normalize(double[][] a) {
        double total = ArrayUtil.sum(a);
        if (total == 0.0) {
            throw new RuntimeException("Can't normalize an array with sum 0.0");
        }
        for (int i = 0; i < a.length; ++i) {
            ArrayUtil.scale(a[i], 1.0 / total);
        }
    }

    public static void normalize(float[] a) {
        float total = ArrayUtil.sum(a);
        if ((double)total == 0.0) {
            throw new RuntimeException("Can't normalize an array with sum 0.0");
        }
        ArrayUtil.scale(a, (double)(1.0f / total));
    }

    public static double[][] outerProduct(double[] a, double[] b) {
        if (a.length != b.length) {
            return null;
        }
        double[][] retVal = new double[a.length][a.length];
        for (int i = 0; i < a.length; ++i) {
            for (int j = 0; j < a.length; ++j) {
                retVal[i][j] = a[i] * b[j];
            }
        }
        return retVal;
    }

    public static double[] pairwiseAdd(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new RuntimeException();
        }
        double[] result = new double[a.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = a[i] + b[i];
        }
        return result;
    }

    public static double[] pairwiseMultiply(double[] a, double[] b) {
        if (a.length != b.length) {
            throw new RuntimeException();
        }
        double[] result = new double[a.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = a[i] * b[i];
        }
        return result;
    }

    public static void pairwiseMultiply(double[] a, double[] b, double[] result) {
        if (a.length != b.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = a[i] * b[i];
        }
    }

    public static float[] pairwiseMultiply(float[] a, float[] b) {
        if (a.length != b.length) {
            throw new RuntimeException();
        }
        float[] result = new float[a.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = a[i] * b[i];
        }
        return result;
    }

    public static void pairwiseMultiply(float[] a, float[] b, float[] result) {
        if (a.length != b.length) {
            throw new RuntimeException();
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = a[i] * b[i];
        }
    }

    public static double[] pow(double[] a, double c) {
        double[] result = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = Math.pow(a[i], c);
        }
        return result;
    }

    public static float[] pow(float[] a, float c) {
        float[] result = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = (float)Math.pow(a[i], c);
        }
        return result;
    }

    public static void powInPlace(double[] a, double c) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = Math.pow(a[i], c);
        }
    }

    public static void powInPlace(float[] a, float c) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = (float)Math.pow(a[i], c);
        }
    }

    public static double product(double[] a) {
        double retVal = 1.0;
        for (double d : a) {
            retVal *= d;
        }
        return retVal;
    }

    public static boolean[] reallocArray(boolean[] array, int minLength) {
        if (array == null || array.length < minLength) {
            return new boolean[minLength];
        }
        return array;
    }

    public static boolean[] reallocArray(boolean[] array, int minLength, boolean fillVal) {
        boolean[] newArray = ArrayUtil.reallocArray(array, minLength);
        Arrays.fill(newArray, fillVal);
        return newArray;
    }

    public static boolean[][] reallocArray(boolean[][] array, int minLength1, int minLength2) {
        if (array == null || array.length < minLength1) {
            return new boolean[minLength1][minLength2];
        }
        return array;
    }

    public static boolean[][] reallocArray(boolean[][] array, int minLength1, int minLength2, boolean fillVal) {
        boolean[][] newArray = ArrayUtil.reallocArray(array, minLength1, minLength2);
        ArrayUtil.fill(newArray, minLength1, minLength2, fillVal);
        return newArray;
    }

    public static boolean[][][] reallocArray(boolean[][][] array, int minLength1, int minLength2, int minLength3) {
        if (array == null || array.length < minLength1) {
            return new boolean[minLength1][minLength2][minLength3];
        }
        return array;
    }

    public static boolean[][][] reallocArray(boolean[][][] array, int minLength1, int minLength2, int minLength3, boolean fillVal) {
        boolean[][][] newArray = ArrayUtil.reallocArray(array, minLength1, minLength2, minLength3);
        ArrayUtil.fill(newArray, minLength1, minLength2, minLength3, fillVal);
        return newArray;
    }

    public static boolean[][][][] reallocArray(boolean[][][][] array, int minLength1, int minLength2, int minLength3, int minLength4) {
        if (array == null || array.length < minLength1 || array[0].length < minLength2 || array[0][0].length < minLength3 || array[0][0][0].length < minLength4) {
            return new boolean[minLength1][minLength2][minLength3][minLength4];
        }
        return array;
    }

    public static boolean[][][][] reallocArray(boolean[][][][] array, int minLength1, int minLength2, int minLength3, int minLength4, boolean fillVal) {
        boolean[][][][] newArray = ArrayUtil.reallocArray(array, minLength1, minLength2, minLength3, minLength4);
        ArrayUtil.fill(newArray, minLength1, minLength2, minLength3, minLength4, fillVal);
        return newArray;
    }

    public static double[] reallocArray(double[] array, int minLength) {
        if (array == null || array.length < minLength) {
            return new double[minLength];
        }
        return array;
    }

    public static double[] reallocArray(double[] array, int minLength, double fillVal) {
        double[] newArray = ArrayUtil.reallocArray(array, minLength);
        Arrays.fill(newArray, fillVal);
        return newArray;
    }

    public static double[][] reallocArray(double[][] array, int minLength1, int minLength2) {
        if (array == null || array.length < minLength1) {
            return new double[minLength1][minLength2];
        }
        return array;
    }

    public static double[][] reallocArray(double[][] array, int minLength1, int minLength2, double fillVal) {
        double[][] newArray = ArrayUtil.reallocArray(array, minLength1, minLength2);
        ArrayUtil.fill(newArray, minLength1, minLength2, fillVal);
        return newArray;
    }

    public static double[][][] reallocArray(double[][][] array, int minLength1, int minLength2, int minLength3) {
        if (array == null || array.length < minLength1) {
            return new double[minLength1][minLength2][minLength3];
        }
        return array;
    }

    public static double[][][] reallocArray(double[][][] array, int minLength1, int minLength2, int minLength3, double fillVal) {
        double[][][] newArray = ArrayUtil.reallocArray(array, minLength1, minLength2, minLength3);
        ArrayUtil.fill(newArray, minLength1, minLength2, minLength3, fillVal);
        return newArray;
    }

    public static double[][][][] reallocArray(double[][][][] array, int minLength1, int minLength2, int minLength3, int minLength4) {
        if (array == null || array.length < minLength1 || array[0].length < minLength2 || array[0][0].length < minLength3 || array[0][0][0].length < minLength4) {
            return new double[minLength1][minLength2][minLength3][minLength4];
        }
        return array;
    }

    public static double[][][][] reallocArray(double[][][][] array, int minLength1, int minLength2, int minLength3, int minLength4, double fillVal) {
        double[][][][] newArray = ArrayUtil.reallocArray(array, minLength1, minLength2, minLength3, minLength4);
        ArrayUtil.fill(newArray, minLength1, minLength2, minLength3, minLength4, fillVal);
        return newArray;
    }

    public static int[] reallocArray(int[] array, int minLength) {
        if (array == null || array.length < minLength) {
            return new int[minLength];
        }
        return array;
    }

    public static int[] reallocArray(int[] array, int minLength, int fillVal) {
        int[] newArray = ArrayUtil.reallocArray(array, minLength);
        Arrays.fill(newArray, fillVal);
        return newArray;
    }

    public static int[][] reallocArray(int[][] array, int minLength1, int minLength2) {
        if (array == null || array.length < minLength1) {
            return new int[minLength1][minLength2];
        }
        return array;
    }

    public static int[][] reallocArray(int[][] array, int minLength1, int minLength2, int fillVal) {
        int[][] newArray = ArrayUtil.reallocArray(array, minLength1, minLength2);
        ArrayUtil.fill(newArray, minLength1, minLength2, fillVal);
        return newArray;
    }

    public static int[][][] reallocArray(int[][][] array, int minLength1, int minLength2, int minLength3) {
        if (array == null || array.length < minLength1) {
            return new int[minLength1][minLength2][minLength3];
        }
        return array;
    }

    public static int[][][] reallocArray(int[][][] array, int minLength1, int minLength2, int minLength3, int fillVal) {
        int[][][] newArray = ArrayUtil.reallocArray(array, minLength1, minLength2, minLength3);
        ArrayUtil.fill(newArray, minLength1, minLength2, minLength3, fillVal);
        return newArray;
    }

    public static int[][][][] reallocArray(int[][][][] array, int minLength1, int minLength2, int minLength3, int minLength4) {
        if (array == null || array.length < minLength1 || array[0].length < minLength2 || array[0][0].length < minLength3 || array[0][0][0].length < minLength4) {
            return new int[minLength1][minLength2][minLength3][minLength4];
        }
        return array;
    }

    public static int[][][][] reallocArray(int[][][][] array, int minLength1, int minLength2, int minLength3, int minLength4, int fillVal) {
        int[][][][] newArray = ArrayUtil.reallocArray(array, minLength1, minLength2, minLength3, minLength4);
        ArrayUtil.fill(newArray, minLength1, minLength2, minLength3, minLength4, fillVal);
        return newArray;
    }

    public static <T> T[] reallocArray(T[] array, int minLength, Class<T> klass, ListUtils.Generator<T> gen) {
        if (array == null || array.length < minLength) {
            array = ListUtils.newArray(minLength, klass, gen);
        }
        ArrayUtil.fill(array, gen);
        return array;
    }

    public static <T> T[][] reallocArray(T[][] array, int minLength1, final int minLength2, final Class<T> klass, final ListUtils.Generator<T> gen) {
        if (array == null || ((T[][])array).length < minLength1 || array[0].length < minLength2) {
            array = ListUtils.newArray(minLength1, ListUtils.newArray(minLength2, klass, gen));
        }
        ArrayUtil.fill(array, new ListUtils.Generator<T[]>(){

            @Override
            public T[] generate(int i) {
                return ListUtils.newArray(minLength2, klass, gen);
            }
        });
        return array;
    }

    public static void scale(double[] a, double b) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i] * b;
        }
    }

    public static void scale(float[] a, double b) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = (float)((double)a[i] * b);
        }
    }

    public static void setToLogDeterministic(double[] a, int i) {
        for (int j = 0; j < a.length; ++j) {
            a[j] = j == i ? 0.0 : Double.NEGATIVE_INFINITY;
        }
    }

    public static void setToLogDeterministic(float[] a, int i) {
        for (int j = 0; j < a.length; ++j) {
            a[j] = j == i ? 0.0f : Float.NEGATIVE_INFINITY;
        }
    }

    public static void shift(double[] a, double b) {
        for (int i = 0; i < a.length; ++i) {
            a[i] = a[i] + b;
        }
    }

    public static double standardErrorOfMean(double[] a) {
        return ArrayUtil.stdev(a) / Math.sqrt(a.length);
    }

    public static double stdev(double[] a) {
        return Math.sqrt(ArrayUtil.variance(a));
    }

    public static int[] subArray(int[] a, int from, int to) {
        int[] result = new int[to - from];
        System.arraycopy(a, from, result, 0, to - from);
        return result;
    }

    public static double[] subArray(double[] a, int from, int to) {
        double[] result = new double[to - from];
        System.arraycopy(a, from, result, 0, to - from);
        return result;
    }

    public static double[][] subMatrix(double[][] ds, int i, int ni, int j, int nj) {
        double[][] retVal = new double[ni][nj];
        for (int k = i; k < i + ni; ++k) {
            for (int l = j; l < j + nj; ++l) {
                retVal[k - i][l - j] = ds[k][l];
            }
        }
        return retVal;
    }

    public static double[] subtract(double[] a, double[] b) {
        double[] c = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] - b[i];
        }
        return c;
    }

    public static void subtract(double[] a, double[] b, double[] scratch) {
        assert (b != null);
        assert (a.length == b.length);
        for (int i = 0; i < a.length; ++i) {
            scratch[i] = a[i] - b[i];
        }
    }

    public static void multiply(double[] a, double b, double[] scratch) {
        assert (a != null);
        for (int i = 0; i < a.length; ++i) {
            scratch[i] = a[i] * b;
        }
    }

    public static float[] subtract(float[] a, float[] b) {
        float[] c = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = a[i] - b[i];
        }
        return c;
    }

    public static double sum(double[] a) {
        if (a == null) {
            return 0.0;
        }
        double result = 0.0;
        for (int i = 0; i < a.length; ++i) {
            result += a[i];
        }
        return result;
    }

    public static double sum(double[][] a) {
        if (a == null) {
            return 0.0;
        }
        double result = 0.0;
        for (int i = 0; i < a.length; ++i) {
            result += ArrayUtil.sum(a[i]);
        }
        return result;
    }

    public static double sum(double[][][] a) {
        if (a == null) {
            return 0.0;
        }
        double result = 0.0;
        for (int i = 0; i < a.length; ++i) {
            result += ArrayUtil.sum(a[i]);
        }
        return result;
    }

    public static double sum(double[] a, int len) {
        double result = 0.0;
        for (int i = 0; i < len; ++i) {
            result += a[i];
        }
        return result;
    }

    public static float sum(float[] a) {
        float result = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            result += a[i];
        }
        return result;
    }

    public static int sum(int[] a) {
        int result = 0;
        for (int i = 0; i < a.length; ++i) {
            result += a[i];
        }
        return result;
    }

    public static long sum(long[] a) {
        int result = 0;
        for (int i = 0; i < a.length; ++i) {
            result = (int)((long)result + a[i]);
        }
        return result;
    }

    public static double sumSquaredError(double[] a) {
        double mean = ArrayUtil.mean(a);
        double result = 0.0;
        for (int i = 0; i < a.length; ++i) {
            double diff = a[i] - mean;
            result += diff * diff;
        }
        return result;
    }

    public static String toString(boolean[][] a) {
        String s = "[";
        for (int i = 0; i < a.length; ++i) {
            s = s.concat(Arrays.toString(a[i]) + ", ");
        }
        return s + "]";
    }

    public static String toString(byte[] a) {
        return ArrayUtil.toString(a, null);
    }

    public static String toString(byte[] a, NumberFormat nf) {
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer b = new StringBuffer();
        b.append("[");
        for (int i = 0; i < a.length - 1; ++i) {
            String s = nf == null ? String.valueOf(a[i]) : nf.format(a[i]);
            b.append(s);
            b.append(", ");
        }
        String s = nf == null ? String.valueOf(a[a.length - 1]) : nf.format(a[a.length - 1]);
        b.append(s);
        b.append(']');
        return b.toString();
    }

    public static String toString(double[] a) {
        return ArrayUtil.toString(a, null);
    }

    public static String toString(double[] a, NumberFormat nf) {
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer b = new StringBuffer();
        b.append("[");
        for (int i = 0; i < a.length - 1; ++i) {
            String s = nf == null ? String.valueOf(a[i]) : nf.format(a[i]);
            b.append(s);
            b.append(", ");
        }
        String s = nf == null ? String.valueOf(a[a.length - 1]) : nf.format(a[a.length - 1]);
        b.append(s);
        b.append(']');
        return b.toString();
    }

    public static String toString(double[][] counts) {
        return ArrayUtil.toString(counts, 10, null, null, NumberFormat.getInstance(), false);
    }

    public static String toString(double[][] counts, int cellSize, Object[] rowLabels, Object[] colLabels, NumberFormat nf, boolean printTotals) {
        int j;
        if (counts == null) {
            return null;
        }
        double[] rowTotals = new double[counts.length];
        double[] colTotals = new double[counts[0].length];
        double total = 0.0;
        for (int i = 0; i < counts.length; ++i) {
            for (j = 0; j < counts[i].length; ++j) {
                int n = i;
                rowTotals[n] = rowTotals[n] + counts[i][j];
                int n2 = j;
                colTotals[n2] = colTotals[n2] + counts[i][j];
                total += counts[i][j];
            }
        }
        StringBuffer result = new StringBuffer();
        if (colLabels != null) {
            result.append(StringUtils.padLeft("", cellSize));
            for (j = 0; j < counts[0].length; ++j) {
                String s = colLabels[j].toString();
                if (s.length() > cellSize - 1) {
                    s = s.substring(0, cellSize - 1);
                }
                s = StringUtils.padLeft(s, cellSize);
                result.append(s);
            }
            if (printTotals) {
                result.append(StringUtils.padLeft("Total", cellSize));
            }
            result.append("\n\n");
        }
        for (int i = 0; i < counts.length; ++i) {
            if (rowLabels != null) {
                String s = rowLabels[i].toString();
                s = StringUtils.pad(s, cellSize);
                result.append(s);
            }
            for (int j2 = 0; j2 < counts[i].length; ++j2) {
                result.append(StringUtils.padLeft(nf.format(counts[i][j2]), cellSize));
            }
            if (printTotals) {
                result.append(StringUtils.padLeft(nf.format(rowTotals[i]), cellSize));
            }
            result.append("\n");
        }
        result.append("\n");
        if (printTotals) {
            result.append(StringUtils.pad("Total", cellSize));
            for (j = 0; j < colTotals.length; ++j) {
                result.append(StringUtils.padLeft(nf.format(colTotals[j]), cellSize));
            }
            result.append(StringUtils.padLeft(nf.format(total), cellSize));
        }
        result.append("\n");
        return result.toString();
    }

    public static String toString(double[][][] a) {
        String s = "[";
        for (int i = 0; i < a.length; ++i) {
            s = s.concat(ArrayUtil.toString(a[i]) + ", ");
        }
        return s + "]";
    }

    public static String toString(float[] a) {
        return ArrayUtil.toString(a, null);
    }

    public static String toString(float[] a, NumberFormat nf) {
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer b = new StringBuffer();
        b.append("[");
        for (int i = 0; i < a.length - 1; ++i) {
            String s = nf == null ? String.valueOf(a[i]) : nf.format(a[i]);
            b.append(s);
            b.append(", ");
        }
        String s = nf == null ? String.valueOf(a[a.length - 1]) : nf.format(a[a.length - 1]);
        b.append(s);
        b.append(']');
        return b.toString();
    }

    public static String toString(float[][] counts) {
        return ArrayUtil.toString(counts, 10, null, null, NumberFormat.getIntegerInstance(), false);
    }

    public static String toString(float[][] counts, int cellSize, Object[] rowLabels, Object[] colLabels, NumberFormat nf, boolean printTotals) {
        int j;
        double[] rowTotals = new double[counts.length];
        double[] colTotals = new double[counts[0].length];
        double total = 0.0;
        for (int i = 0; i < counts.length; ++i) {
            for (j = 0; j < counts[i].length; ++j) {
                int n = i;
                rowTotals[n] = rowTotals[n] + (double)counts[i][j];
                int n2 = j;
                colTotals[n2] = colTotals[n2] + (double)counts[i][j];
                total += (double)counts[i][j];
            }
        }
        StringBuffer result = new StringBuffer();
        if (colLabels != null) {
            result.append(StringUtils.padLeft("", cellSize));
            for (j = 0; j < counts[0].length; ++j) {
                String s = colLabels[j].toString();
                if (s.length() > cellSize - 1) {
                    s = s.substring(0, cellSize - 1);
                }
                s = StringUtils.padLeft(s, cellSize);
                result.append(s);
            }
            if (printTotals) {
                result.append(StringUtils.padLeft("Total", cellSize));
            }
            result.append("\n\n");
        }
        for (int i = 0; i < counts.length; ++i) {
            if (rowLabels != null) {
                String s = rowLabels[i].toString();
                s = StringUtils.pad(s, cellSize);
                result.append(s);
            }
            for (int j2 = 0; j2 < counts[i].length; ++j2) {
                result.append(StringUtils.padLeft(nf.format(counts[i][j2]), cellSize));
            }
            if (printTotals) {
                result.append(StringUtils.padLeft(nf.format(rowTotals[i]), cellSize));
            }
            result.append("\n");
        }
        result.append("\n");
        if (printTotals) {
            result.append(StringUtils.pad("Total", cellSize));
            for (j = 0; j < colTotals.length; ++j) {
                result.append(StringUtils.padLeft(nf.format(colTotals[j]), cellSize));
            }
            result.append(StringUtils.padLeft(nf.format(total), cellSize));
        }
        result.append("\n");
        return result.toString();
    }

    public static String toString(float[][][] a) {
        String s = "[";
        for (int i = 0; i < a.length; ++i) {
            s = s.concat(ArrayUtil.toString(a[i]) + ", ");
        }
        return s + "]";
    }

    public static String toString(int[] a) {
        return ArrayUtil.toString(a, null);
    }

    public static String toString(int[] a, NumberFormat nf) {
        if (a == null) {
            return null;
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer b = new StringBuffer();
        b.append("[");
        for (int i = 0; i < a.length - 1; ++i) {
            String s = nf == null ? String.valueOf(a[i]) : nf.format(a[i]);
            b.append(s);
            b.append(", ");
        }
        String s = nf == null ? String.valueOf(a[a.length - 1]) : nf.format(a[a.length - 1]);
        b.append(s);
        b.append(']');
        return b.toString();
    }

    public static String toString(int[][] counts) {
        return ArrayUtil.toString(counts, 10, null, null, NumberFormat.getInstance(), false);
    }

    public static String toString(int[][] counts, int cellSize, Object[] rowLabels, Object[] colLabels, NumberFormat nf, boolean printTotals) {
        int j;
        int[] rowTotals = new int[counts.length];
        int[] colTotals = new int[counts[0].length];
        int total = 0;
        for (int i = 0; i < counts.length; ++i) {
            for (j = 0; j < counts[i].length; ++j) {
                int n = i;
                rowTotals[n] = rowTotals[n] + counts[i][j];
                int n2 = j;
                colTotals[n2] = colTotals[n2] + counts[i][j];
                total += counts[i][j];
            }
        }
        StringBuffer result = new StringBuffer();
        if (colLabels != null) {
            result.append(StringUtils.padLeft("", cellSize));
            for (j = 0; j < counts[0].length; ++j) {
                String s = colLabels[j].toString();
                if (s.length() > cellSize - 1) {
                    s = s.substring(0, cellSize - 1);
                }
                s = StringUtils.padLeft(s, cellSize);
                result.append(s);
            }
            if (printTotals) {
                result.append(StringUtils.padLeft("Total", cellSize));
            }
            result.append("\n\n");
        }
        for (int i = 0; i < counts.length; ++i) {
            if (rowLabels != null) {
                String s = rowLabels[i].toString();
                s = StringUtils.padOrTrim(s, cellSize);
                result.append(s);
            }
            for (int j2 = 0; j2 < counts[i].length; ++j2) {
                result.append(StringUtils.padLeft(nf.format(counts[i][j2]), cellSize));
            }
            if (printTotals) {
                result.append(StringUtils.padLeft(nf.format(rowTotals[i]), cellSize));
            }
            result.append("\n");
        }
        result.append("\n");
        if (printTotals) {
            result.append(StringUtils.pad("Total", cellSize));
            for (j = 0; j < colTotals.length; ++j) {
                result.append(StringUtils.padLeft(nf.format(colTotals[j]), cellSize));
            }
            result.append(StringUtils.padLeft(nf.format(total), cellSize));
        }
        result.append("\n");
        return result.toString();
    }

    public static double variance(double[] a) {
        return ArrayUtil.sumSquaredError(a) / (double)(a.length - 1);
    }

    private static void printMatrix(double[][] a) {
        int len = 5;
        for (int i = 0; i < 5; ++i) {
            System.out.print("[");
            for (int j = 0; j < 5; ++j) {
                System.out.print(a[i][j] + "\t,");
            }
            System.out.println("]");
        }
    }

    public static <T> boolean hasNull(T[] array) {
        for (T t : array) {
            if (t != null) continue;
            return true;
        }
        return false;
    }
}

