/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.ui;

import edu.berkeley.nlp.ui.EasyFormat;
import edu.berkeley.nlp.util.Counter;
import edu.berkeley.nlp.util.Pair;
import edu.berkeley.nlp.util.StrUtils;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public class Table {
    private final Map<Pair<Integer, Integer>, String[]> entries = new HashMap<Pair<Integer, Integer>, String[]>();
    private final Counter<Integer> maxHeights = new Counter();
    private final Counter<Integer> maxWidths = new Counter();
    private int nColumns;
    private int nRows;
    private boolean borderDefault = true;
    public static final String css = "table.with-borders {border-width: 1px 1px 1px 1px;border-spacing: 2px;border-style: solid solid solid solid;border-color: black black black black;border-collapse: collapse;background-color: white;}table.with-borders td {border-width: 1px 1px 1px 1px;padding: 1px 1px 1px 1px;border-style: dotted dotted dotted dotted;border-color: gray gray gray gray;background-color: white;-moz-border-radius: 0px 0px 0px 0px;}table.without-borders {border-width: 1px 1px 1px 1px;border-spacing: 2px;border-style: none none none none;border-collapse: collapse;background-color: white;}table.without-borders td {border-width: 1px 1px 1px 1px;padding: 1px 1px 1px 1px;border-style: none none none none;background-color: white;-moz-border-radius: 0px 0px 0px 0px;}";

    public Table(Populator populator) {
        populator.setTable(this);
        populator.populate();
    }

    public void setBorder(boolean value) {
        this.borderDefault = value;
    }

    public String toString() {
        return this.toString(this.borderDefault);
    }

    public String toHTML() {
        return this.toHTML(this.borderDefault);
    }

    public String toHTML(boolean printBorders) {
        StringBuilder builder = new StringBuilder();
        builder.append("<table class=\"" + (printBorders ? "with-borders" : "without-borders") + "\">");
        for (int row = 0; row < this.nRows; ++row) {
            builder.append("<tr>");
            for (int col = 0; col < this.nColumns; ++col) {
                builder.append("<td>");
                Pair<Integer, Integer> key = new Pair<Integer, Integer>(row, col);
                String[] entry = this.entries.get(key);
                if (entry != null) {
                    for (int i = 0; i < entry.length; ++i) {
                        builder.append(entry[i] + (i < entry.length - 1 ? "<br/>" : "") + "");
                    }
                }
                builder.append("</td>");
            }
            builder.append("</tr>");
        }
        builder.append("</table>\n");
        return builder.toString();
    }

    public String toString(boolean printBorders) {
        StringBuilder builder = new StringBuilder();
        if (printBorders) {
            builder.append(this.horizontalSeparator() + "\n");
        }
        for (int row = 0; row < this.nRows; ++row) {
            int rowLine = 0;
            while ((double)rowLine < this.maxHeights.getCount(row)) {
                if (printBorders) {
                    builder.append("|");
                }
                for (int col = 0; col < this.nColumns; ++col) {
                    Pair<Integer, Integer> key = new Pair<Integer, Integer>(row, col);
                    String text = this.entries.get(key) == null || rowLine >= this.entries.get(key).length ? "" : this.entries.get(key)[rowLine];
                    builder.append(this.pad(text, (int)this.maxWidths.getCount(col), " "));
                    if (!printBorders) continue;
                    builder.append("|");
                }
                if ((double)rowLine != this.maxHeights.getCount(row) - 1.0) {
                    builder.append("\n");
                }
                ++rowLine;
            }
            if (printBorders) {
                builder.append("\n" + this.horizontalSeparator());
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    private StringBuilder horizontalSeparator() {
        StringBuilder builder = new StringBuilder();
        builder.append("+");
        for (int col = 0; col < this.nColumns; ++col) {
            builder.append(this.pad("", (int)this.maxWidths.getCount(col), "-") + "+");
        }
        return builder;
    }

    private String pad(String s, int finalLength, String pad) {
        if (s.length() > finalLength) {
            throw new RuntimeException();
        }
        StringBuilder b = new StringBuilder();
        b.append(s);
        while (b.length() < finalLength) {
            b.append(pad);
        }
        return b.toString();
    }

    public static void main(String[] args) {
        Table table = new Table(new Populator(){

            public void populate() {
                int j;
                int i;
                for (i = 0; i < 10; ++i) {
                    for (j = 0; j < 10; ++j) {
                        if (i > j) continue;
                        this.addLines(i, j, "Sum:" + (i + j));
                    }
                }
                for (i = 0; i < 10; ++i) {
                    for (j = 0; j < 10; ++j) {
                        if (i > j) continue;
                        this.addLines(i, j, "Prod:" + i * j);
                    }
                }
            }
        });
        System.out.println(table.toString());
    }

    public static abstract class Populator {
        private Table table;
        private DecimalFormat fmt = EasyFormat.getStdFormat();

        private void setTable(Table table) {
            this.table = table;
        }

        public Populator() {
        }

        public Populator(DecimalFormat fmt) {
            this.fmt = fmt;
        }

        public abstract void populate();

        public final void set(int row, int column, double number) {
            this.set(row, column, this.fmt.format(number));
        }

        public final void set(int row, int column, String text) {
            this.table.nColumns = Math.max(this.table.nColumns, column + 1);
            this.table.nRows = Math.max(this.table.nRows, row + 1);
            String[] lines = text.split("\\n");
            this.table.maxHeights.setCount(row, Math.max(this.table.maxHeights.getCount(row), (double)lines.length));
            for (String line : lines) {
                this.table.maxWidths.setCount(column, Math.max(this.table.maxWidths.getCount(column), (double)line.length()));
            }
            this.table.entries.put(new Pair<Integer, Integer>(row, column), lines);
        }

        public final void append(int row, int column, String text) {
            String[] entries = (String[])this.table.entries.get(new Pair<Integer, Integer>(row, column));
            String lastEntry = entries != null ? entries[entries.length - 1] : null;
            this.set(row, column, (lastEntry != null ? lastEntry : "") + text);
        }

        public final void addLines(int row, int column, String text) {
            Pair<Integer, Integer> key = new Pair<Integer, Integer>(row, column);
            String currentString = StrUtils.join((Object[])this.table.entries.get(key), "\n");
            if (!currentString.equals("")) {
                currentString = currentString + "\n";
            }
            currentString = currentString + text;
            this.set(row, column, currentString);
        }
    }
}

