/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.treebank;

import java.io.File;
import java.io.FileFilter;

class NumberRangeFileFilter
implements FileFilter {
    int highFileNum;
    int lowFileNum;
    String extension;
    boolean recurse;

    public boolean accept(File pathname) {
        if (pathname.isDirectory()) {
            return this.recurse;
        }
        String name = pathname.getName();
        if (!name.endsWith(this.extension)) {
            return false;
        }
        int lastNumberIndex = this.getLastNumberIndex(name);
        if (lastNumberIndex == -1) {
            return false;
        }
        int numEndLoc = lastNumberIndex + 1;
        int numStartLoc = this.getLastNonNumberIndex(name, lastNumberIndex) + 1;
        int fileNum = Integer.parseInt(name.substring(numStartLoc, numEndLoc));
        return fileNum >= this.lowFileNum && fileNum <= this.highFileNum;
    }

    private int getLastNonNumberIndex(String name, int lastNumberIndex) {
        int index;
        for (index = lastNumberIndex - 1; index >= 0 && Character.isDigit(name.charAt(index)); --index) {
        }
        if (index < -1) {
            return -1;
        }
        return index;
    }

    private int getLastNumberIndex(String name) {
        int index;
        for (index = name.length() - 1; index >= 0 && !Character.isDigit(name.charAt(index)); --index) {
        }
        return index;
    }

    public NumberRangeFileFilter(String extension, int lowFileNum, int highFileNum, boolean recurse) {
        this.highFileNum = highFileNum;
        this.lowFileNum = lowFileNum;
        this.extension = extension;
        this.recurse = recurse;
    }
}

