/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.syntax;

import edu.berkeley.nlp.util.CollectionUtils;
import edu.berkeley.nlp.util.Counter;
import edu.berkeley.nlp.util.Factory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnaryClosureComputer<V> {
    private Factory<Edge> unaryRuleFactory = new Factory<Edge>(){

        @Override
        public Edge newInstance(Object ... args) {
            return new Edge(args[0], args[1]);
        }
    };
    Map<V, List<Edge<V>>> closedUnaryRulesByChild = new HashMap<V, List<Edge<V>>>();
    Map<V, List<Edge<V>>> closedUnaryRulesByParent = new HashMap<V, List<Edge<V>>>();
    Map<Edge<V>, List<V>> pathMap = new HashMap<Edge<V>, List<V>>();
    Set<Edge<V>> unaryRules = new HashSet<Edge<V>>();
    private boolean sumInsteadOfMultipy;

    public Map<V, List<Edge<V>>> getAllClosedRulesByChildren() {
        return this.closedUnaryRulesByChild;
    }

    public List<Edge<V>> getClosedUnaryRulesByChild(V child) {
        return CollectionUtils.getValueList(this.closedUnaryRulesByChild, child);
    }

    public List<Edge<V>> getClosedUnaryRulesByParent(V parent) {
        return CollectionUtils.getValueList(this.closedUnaryRulesByParent, parent);
    }

    public List<V> getPath(Edge unaryRule) {
        return this.pathMap.get(unaryRule);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (V parent : this.closedUnaryRulesByParent.keySet()) {
            for (Edge<V> unaryRule : this.getClosedUnaryRulesByParent(parent)) {
                List<V> path = this.getPath(unaryRule);
                sb.append(unaryRule);
                sb.append("  ");
                sb.append(path);
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public UnaryClosureComputer(boolean sumInsteadOfMultiply) {
        this.sumInsteadOfMultipy = sumInsteadOfMultiply;
    }

    public void add(V parent, V child, double score) {
        Edge edge = new Edge(parent, child);
        edge.setScore(score);
        this.unaryRules.add(edge);
    }

    public void solve() {
        Map<Edge<V>, List<V>> closureMap = this.computeUnaryClosure(this.unaryRules);
        for (Edge<V> unaryRule : closureMap.keySet()) {
            this.addUnary(unaryRule, closureMap.get(unaryRule));
        }
    }

    private void addUnary(Edge<V> unaryRule, List<V> path) {
        CollectionUtils.addToValueList(this.closedUnaryRulesByChild, unaryRule.getChild(), unaryRule);
        CollectionUtils.addToValueList(this.closedUnaryRulesByParent, unaryRule.getParent(), unaryRule);
        this.pathMap.put(unaryRule, path);
    }

    private Map<Edge<V>, List<V>> computeUnaryClosure(Collection<Edge<V>> unaryRules) {
        HashMap intermediateStates = new HashMap();
        Counter<Edge<V>> pathCosts = new Counter<Edge<V>>();
        HashMap closedUnaryRulesByChild = new HashMap();
        HashMap closedUnaryRulesByParent = new HashMap();
        HashSet<V> states = new HashSet<V>();
        for (Edge<V> unaryRule : unaryRules) {
            this.relax(pathCosts, intermediateStates, closedUnaryRulesByChild, closedUnaryRulesByParent, unaryRule, null, unaryRule.getScore());
            states.add(unaryRule.getParent());
            states.add(unaryRule.getChild());
        }
        for (Edge<Object> intermediateState : states) {
            List incomingRules = (List)closedUnaryRulesByChild.get(intermediateState);
            List outgoingRules = (List)closedUnaryRulesByParent.get(intermediateState);
            if (incomingRules == null || outgoingRules == null) continue;
            for (Edge incomingRule : incomingRules) {
                for (Edge outgoingRule : outgoingRules) {
                    Edge rule = this.unaryRuleFactory.newInstance(incomingRule.getParent(), outgoingRule.getChild());
                    double newScore = this.combinePathCosts(pathCosts, incomingRule, outgoingRule);
                    this.relax(pathCosts, intermediateStates, closedUnaryRulesByChild, closedUnaryRulesByParent, rule, intermediateState, newScore);
                }
            }
        }
        for (Edge<Object> state : states) {
            Edge selfLoopRule = this.unaryRuleFactory.newInstance(state, state);
            this.relax(pathCosts, intermediateStates, closedUnaryRulesByChild, closedUnaryRulesByParent, selfLoopRule, null, 0.0);
        }
        HashMap<Edge<List<V>>, List<List<V>>> closureMap = new HashMap<Edge<List<V>>, List<List<V>>>();
        for (Edge<V> unaryRule : pathCosts.keySet()) {
            unaryRule.setScore(pathCosts.getCount(unaryRule));
            List<V> path = this.extractPath(unaryRule, intermediateStates);
            closureMap.put(unaryRule, path);
        }
        return closureMap;
    }

    private double combinePathCosts(Counter<Edge<V>> pathCosts, Edge<V> incomingRule, Edge<V> outgoingRule) {
        return this.sumInsteadOfMultipy ? pathCosts.getCount(incomingRule) + pathCosts.getCount(outgoingRule) : pathCosts.getCount(incomingRule) * pathCosts.getCount(outgoingRule);
    }

    private List<V> extractPath(Edge<V> unaryRule, Map<Edge<V>, V> intermediateStates) {
        ArrayList<V> path = new ArrayList<V>();
        path.add(unaryRule.getParent());
        V intermediateState = intermediateStates.get(unaryRule);
        if (intermediateState != null) {
            List<V> parentPath = this.extractPath(this.unaryRuleFactory.newInstance(unaryRule.getParent(), intermediateState), intermediateStates);
            for (int i = 1; i < parentPath.size() - 1; ++i) {
                V state = parentPath.get(i);
                path.add(state);
            }
            path.add(intermediateState);
            List<V> childPath = this.extractPath(this.unaryRuleFactory.newInstance(intermediateState, unaryRule.getChild()), intermediateStates);
            for (int i = 1; i < childPath.size() - 1; ++i) {
                V state = childPath.get(i);
                path.add(state);
            }
        }
        if (path.size() == 1 && unaryRule.getParent() == unaryRule.getChild()) {
            return path;
        }
        path.add(unaryRule.getChild());
        return path;
    }

    private void relax(Counter<Edge<V>> pathCosts, Map<Edge<V>, V> intermediateStates, Map<V, List<Edge<V>>> closedUnaryRulesByChild, Map<V, List<Edge<V>>> closedUnaryRulesByParent, Edge<V> unaryRule, V intermediateState, double newScore) {
        double oldScore;
        if (intermediateState != null && (intermediateState.equals(unaryRule.getParent()) || intermediateState.equals(unaryRule.getChild()))) {
            return;
        }
        boolean isNewRule = !pathCosts.containsKey(unaryRule);
        double d = oldScore = isNewRule ? Double.NEGATIVE_INFINITY : pathCosts.getCount(unaryRule);
        if (oldScore > newScore) {
            return;
        }
        if (isNewRule) {
            CollectionUtils.addToValueList(closedUnaryRulesByChild, unaryRule.getChild(), unaryRule);
            CollectionUtils.addToValueList(closedUnaryRulesByParent, unaryRule.getParent(), unaryRule);
        }
        pathCosts.setCount(unaryRule, newScore);
        intermediateStates.put(unaryRule, intermediateState);
    }

    public double getProb(V parent, V child) {
        if (parent == child) {
            return 0.0;
        }
        List<Edge<V>> byParent = this.closedUnaryRulesByParent.get(parent);
        if (byParent == null) {
            return Double.POSITIVE_INFINITY;
        }
        int childIndex = byParent.indexOf(this.unaryRuleFactory.newInstance(parent, child));
        if (childIndex < 0) {
            return Double.POSITIVE_INFINITY;
        }
        Edge<V> unaryRule = byParent.get(childIndex);
        return unaryRule.getScore();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Edge<V> {
        private V parent;
        private V child;
        private double score;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.child == null ? 0 : this.child.hashCode());
            result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Edge other = (Edge)obj;
            if (this.child == null ? other.child != null : !this.child.equals(other.child)) {
                return false;
            }
            return !(this.parent == null ? other.parent != null : !this.parent.equals(other.parent));
        }

        public void setParent(V parent) {
            this.parent = parent;
        }

        public void setChild(V child) {
            this.child = child;
        }

        private Edge(V parent, V child) {
            this.parent = parent;
            this.child = child;
        }

        public V getParent() {
            return this.parent;
        }

        public V getChild() {
            return this.child;
        }

        public double getScore() {
            return this.score;
        }

        public void setScore(double d) {
            this.score = d;
        }
    }
}

