/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.syntax;

import edu.berkeley.nlp.ling.CollinsHeadFinder;
import edu.berkeley.nlp.ling.HeadFinder;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import edu.berkeley.nlp.util.Pair;
import java.io.StringReader;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RichLabel {
    private String headWord;
    private String headTag;
    private int start;
    private int stop;
    private int headIndex;
    private String label;
    private Tree<String> origNode;
    private static final CollinsHeadFinder cf = new CollinsHeadFinder();

    public int getSpanSize() {
        return this.stop - this.start;
    }

    public int getHeadIndex() {
        return this.headIndex;
    }

    public void setHeadIndex(int headIndex) {
        this.headIndex = headIndex;
    }

    public String getHeadWord() {
        return this.headWord;
    }

    public void setHeadWord(String headWord) {
        this.headWord = headWord;
    }

    public String getHeadTag() {
        return this.headTag;
    }

    public void setHeadTag(String headTag) {
        this.headTag = headTag;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getStop() {
        return this.stop;
    }

    public void setStop(int stop) {
        this.stop = stop;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Tree<String> getOriginalNode() {
        return this.origNode;
    }

    public void setOriginalNode(Tree<String> origNode) {
        this.origNode = origNode;
    }

    public String toString() {
        return String.format("%s(%s[%d]-%s)[%d,%d]", this.label, this.headWord, this.headIndex, this.headTag, this.start, this.stop);
    }

    public static Tree<RichLabel> getRichTree(Tree<String> tree) {
        return RichLabel.getRichTree(tree, cf);
    }

    public static Tree<RichLabel> getRichTree(Tree<String> tree, HeadFinder headFinder) {
        return RichLabel.buildRecursive(tree, headFinder, 0);
    }

    private static Pair<String, String> getHeadWordTag(Tree<String> tree, HeadFinder headFinder) {
        if (tree.isPreTerminal()) {
            Tree<String> term = tree.getChildren().get(0);
            return Pair.newPair(term.getLabel(), tree.getLabel());
        }
        if (tree.isLeaf()) {
            return Pair.newPair(tree.getLabel(), null);
        }
        Tree<String> head = headFinder.determineHead(tree);
        return RichLabel.getHeadWordTag(head, headFinder);
    }

    private static Tree<RichLabel> buildRecursive(Tree<String> tree, HeadFinder headFinder, int start) {
        RichLabel label = new RichLabel();
        label.setStart(start);
        label.setStop(start + tree.getYield().size());
        label.setLabel(tree.getLabel());
        label.setOriginalNode(tree);
        Pair<String, String> headWordTagPair = RichLabel.getHeadWordTag(tree, headFinder);
        label.setHeadWord(headWordTagPair.getFirst());
        label.setHeadTag(headWordTagPair.getSecond());
        int offset = start;
        ArrayList richChildren = new ArrayList();
        for (Tree<String> child : tree.getChildren()) {
            Tree<RichLabel> tree2 = RichLabel.buildRecursive(child, headFinder, offset);
            richChildren.add(tree2);
            offset += child.getYield().size();
        }
        if (tree.isPhrasal()) {
            Tree<String> headChild = headFinder.determineHead(tree);
            for (Tree tree3 : richChildren) {
                if (((RichLabel)tree3.getLabel()).origNode != headChild) continue;
                label.setHeadIndex(((RichLabel)tree3.getLabel()).getHeadIndex());
            }
        } else {
            label.setHeadIndex(label.start);
        }
        return new Tree<RichLabel>(label, richChildren);
    }

    public static void main(String[] args) {
        String tStr = "((S (NP (DT The) (NN man)) (VP (VBD ran) (PP (IN down) (NP (DT the) (NNS stairs))))))";
        Object t = new Trees.PennTreeReader(new StringReader(tStr)).next();
        System.out.println("Rich Tree: " + RichLabel.getRichTree((Tree<String>)t, new CollinsHeadFinder()));
    }
}

