/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.math;

import edu.berkeley.nlp.math.BacktrackingLineSearcher;
import edu.berkeley.nlp.math.DifferentiableRegularizableFunction;
import edu.berkeley.nlp.math.DoubleArrays;
import edu.berkeley.nlp.math.GradientMinimizer;
import edu.berkeley.nlp.math.LBFGSMinimizer;

public class OW_LBFGSMinimizer
extends LBFGSMinimizer
implements GradientMinimizer {
    public OW_LBFGSMinimizer(int iterations) {
        super(iterations);
    }

    public double[] minimize(DifferentiableRegularizableFunction function, double[] initial, double tolerance) {
        BacktrackingLineSearcher lineSearcher = new BacktrackingLineSearcher();
        lineSearcher.sufficientDecreaseConstant = 0.0;
        double[] guess = DoubleArrays.clone(initial);
        for (int iteration = 0; iteration < this.maxIterations; ++iteration) {
            double[] derivative = function.derivativeAt(guess);
            double value = function.valueAt(guess);
            double[] direction = this.getSearchDirection(function.dimension(), derivative);
            double[] unregularizedDerivative = function.unregularizedDerivativeAt(guess);
            double[] orthant = this.getOrthant(initial, derivative);
            DoubleArrays.project(direction, derivative);
            DoubleArrays.scale(direction, -1.0);
            lineSearcher.stepSizeMultiplier = iteration == 0 ? this.initialStepSizeMultiplier : this.stepSizeMultiplier;
            double[] nextGuess = lineSearcher.minimize(function, guess, direction, true);
            double nextValue = function.valueAt(nextGuess);
            double[] unregularizedNextDerivative = function.unregularizedDerivativeAt(nextGuess);
            System.out.printf("Iteration %d ended with value %.6f\n", iteration, nextValue);
            if (iteration >= this.minIterations && this.converged(value, nextValue, tolerance)) {
                return nextGuess;
            }
            this.updateHistories(guess, nextGuess, unregularizedDerivative, unregularizedNextDerivative);
            guess = nextGuess;
            value = nextValue;
            unregularizedDerivative = unregularizedNextDerivative;
            if (this.iterCallbackFunction == null) continue;
            this.iterCallbackFunction.callback(guess, iteration);
        }
        return guess;
    }

    private double[] getOrthant(double[] initial, double[] derivative) {
        double[] orthant = new double[initial.length];
        for (int i = 0; i < initial.length; ++i) {
            orthant[i] = initial[i] != 0.0 ? Math.signum(initial[i]) : Math.signum(-derivative[i]);
        }
        return orthant;
    }
}

