/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.math;

import edu.berkeley.nlp.math.DifferentiableFunction;
import edu.berkeley.nlp.math.DoubleArrays;
import edu.berkeley.nlp.util.Pair;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CachingDifferentiableFunction
implements DifferentiableFunction {
    double[] lastX;
    double[] lastGradient;
    double lastValue;

    protected abstract Pair<Double, double[]> calculate(double[] var1);

    private void ensureCache(double[] x) {
        if (!this.isCached(x)) {
            Pair<Double, double[]> result = this.calculate(x);
            this.lastValue = result.getFirst();
            this.lastX = DoubleArrays.clone(x);
            this.lastGradient = DoubleArrays.clone(result.getSecond());
        }
    }

    protected boolean isCached(double[] x) {
        if (this.lastX == null) {
            return false;
        }
        return Arrays.equals(x, this.lastX);
    }

    public void clearCache() {
        this.lastX = null;
        this.lastGradient = null;
    }

    @Override
    public double[] derivativeAt(double[] x) {
        this.ensureCache(x);
        return this.lastGradient;
    }

    @Override
    public double valueAt(double[] x) {
        this.ensureCache(x);
        return this.lastValue;
    }

    @Override
    public abstract int dimension();
}

