/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.mapper;

import edu.berkeley.nlp.mapper.MapWorker;
import edu.berkeley.nlp.mapper.MapWorkerFactory;
import edu.berkeley.nlp.mapper.Mapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Mapper<Item> {
    private int numWorkers;
    private MapWorkerFactory<Item> factory;

    public Mapper(MapWorkerFactory<Item> factory) {
        this.factory = factory;
        this.numWorkers = Runtime.getRuntime().availableProcessors();
    }

    public Mapper(final Class c) {
        this(new MapWorkerFactory<Item>(){

            @Override
            public MapWorker<Item> newMapWorker() {
                try {
                    return (MapWorker)c.newInstance();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
    }

    public void setNumWorkers(int numWorkers) {
        this.numWorkers = numWorkers;
    }

    public List<MapWorker<Item>> doMapping(List<Item> items) {
        ArrayList<MapWorker<Item>> workers = new ArrayList<MapWorker<Item>>();
        for (int i = 0; i < this.numWorkers; ++i) {
            MapWorker<Item> worker = this.factory.newMapWorker();
            workers.add(worker);
        }
        this.doMapping(items, workers);
        return workers;
    }

    private void doMapping(List<Item> items, List<MapWorker<Item>> workers) {
        ExecutorService executor = Executors.newFixedThreadPool(workers.size());
        for (int i = 0; i < workers.size(); ++i) {
            int start = (int)((double)i / (double)workers.size() * (double)items.size());
            int end = (int)((double)(i + 1) / (double)workers.size() * (double)items.size());
            List<Item> localItems = items.subList(start, end);
            MapWorker<Item> worker = workers.get(i);
            worker.setItems(localItems);
            executor.execute(worker);
        }
        this.execute(executor);
        for (MapWorker<Item> worker : workers) {
            worker.reduce();
        }
    }

    private void execute(ExecutorService executor) {
        executor.shutdown();
        try {
            executor.awaitTermination(10000L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public List<MapWorker<Item>> doMapping(Iterator<Item> itemIt) {
        return this.doMapping(itemIt, 10000);
    }

    public List<MapWorker<Item>> doMapping(Iterator<Item> itemIt, int bufSize) {
        ArrayList<MapWorker<Item>> workers = new ArrayList<MapWorker<Item>>();
        int numProcessed = 0;
        for (int i = 0; i < this.numWorkers; ++i) {
            MapWorker<Item> worker = this.factory.newMapWorker();
            workers.add(worker);
        }
        while (itemIt.hasNext()) {
            ArrayList<Item> items = new ArrayList<Item>();
            for (int i = 0; i < bufSize && itemIt.hasNext(); ++i) {
                items.add(itemIt.next());
            }
            this.doMapping(items, workers);
            System.gc();
            numProcessed += bufSize;
        }
        return workers;
    }

    public Object getNumWorkers() {
        return this.numWorkers;
    }

    public static void main(String[] args) {
        MapWorkerFactory<Integer> factory = new MapWorkerFactory<Integer>(){

            @Override
            public MapWorker<Integer> newMapWorker() {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class MyMapper
                extends MapWorker<Integer> {
                    MyMapper() {
                    }

                    public void map(Integer item) {
                        System.out.println("\tProcessing " + item);
                    }
                }
                return new MyMapper();
            }
        };
        Mapper<Integer> mapper = new Mapper<Integer>(factory);
        ArrayList<Integer> items = new ArrayList<Integer>();
        for (int i = 0; i < 10000; ++i) {
            items.add(i);
        }
        mapper.doMapping(items.iterator(), 10);
    }
}

