/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.io;

import edu.berkeley.nlp.io.AbstractTokenizer;
import edu.berkeley.nlp.io.FeatureLabel;
import edu.berkeley.nlp.io.PTB2TextLexer;
import edu.berkeley.nlp.io.PTBLexer;
import edu.berkeley.nlp.io.Tokenizer;
import edu.berkeley.nlp.io.TokenizerFactory;
import edu.berkeley.nlp.util.StringUtils;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;

public class PTBTokenizer
extends AbstractTokenizer {
    private boolean tokenizeCRs;
    PTBLexer lexer;

    public PTBTokenizer() {
        this(false);
    }

    public PTBTokenizer(boolean tokenizeCRs) {
        this.tokenizeCRs = tokenizeCRs;
    }

    public PTBTokenizer(Reader r) {
        this(r, false);
    }

    public PTBTokenizer(Reader r, boolean tokenizeCRs) {
        this.tokenizeCRs = tokenizeCRs;
        this.setSource(r);
    }

    protected Object getNext() {
        if (this.lexer == null) {
            return null;
        }
        FeatureLabel token = null;
        try {
            token = this.lexer.next();
            while (!this.tokenizeCRs && "*CR*".equals((String)((Object)token))) {
                token = this.lexer.next();
            }
        }
        catch (Exception e) {
            this.nextToken = null;
        }
        return token;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            System.err.println("usage: java edu.berkeley.nlp.io.PTBTokenizer [-cr] filename");
            return;
        }
        PTBTokenizer tokenizer = new PTBTokenizer(new FileReader(args[args.length - 1]), "-cr".equals(args[0]));
        List words = tokenizer.tokenize();
        for (int i = 0; i < words.size(); ++i) {
            System.out.println(words.get(i));
        }
    }

    public void setSource(Reader r) {
        this.lexer = new PTBLexer(r);
    }

    public static String ptb2Text(String ptbText) {
        StringBuffer sb = new StringBuffer(ptbText.length());
        PTB2TextLexer lexer = new PTB2TextLexer(new StringReader(ptbText));
        try {
            String token;
            while ((token = lexer.next()) != null) {
                sb.append(token);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static String ptb2Text(List ptbWords) {
        for (int i = 0; i < ptbWords.size(); ++i) {
            if (!(ptbWords.get(i) instanceof String)) continue;
            ptbWords.set(i, (String)ptbWords.get(i));
        }
        return PTBTokenizer.ptb2Text(StringUtils.join(ptbWords));
    }

    public static TokenizerFactory factory() {
        return new PTBTokenizerFactory();
    }

    public static TokenizerFactory factory(boolean tokenizeCRs) {
        return new PTBTokenizerFactory(tokenizeCRs);
    }

    static class PTBTokenizerFactory
    implements TokenizerFactory {
        protected boolean tokenizeCRs;

        public PTBTokenizerFactory() {
            this(false);
        }

        public PTBTokenizerFactory(boolean tokenizeCRs) {
            this.tokenizeCRs = tokenizeCRs;
        }

        public Iterator getIterator(Reader r) {
            return this.getTokenizer(r);
        }

        public Tokenizer getTokenizer(Reader r) {
            return new PTBTokenizer(r, this.tokenizeCRs);
        }
    }
}

