/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.discPCFG;

import edu.berkeley.nlp.classify.FeatureExtractor;
import edu.berkeley.nlp.discPCFG.LexiconFeature;
import edu.berkeley.nlp.discPCFG.WordInSentence;
import edu.berkeley.nlp.util.Counter;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LexiconFeatureExtractor
implements FeatureExtractor<WordInSentence, LexiconFeature> {
    @Override
    public Counter<LexiconFeature> extractFeatures(WordInSentence sentence) {
        int loc = (Integer)sentence.getSecond();
        String word = (String)((List)sentence.getFirst()).get(loc);
        Counter<LexiconFeature> counter = new Counter<LexiconFeature>();
        counter.incrementCount(new LexiconFeature(word), 1.0);
        int wlen = word.length();
        int numCaps = 0;
        boolean hasDigit = false;
        boolean hasDash = false;
        boolean hasLower = false;
        for (int i = 0; i < wlen; ++i) {
            char ch = word.charAt(i);
            if (Character.isDigit(ch)) {
                hasDigit = true;
                continue;
            }
            if (ch == '-') {
                hasDash = true;
                continue;
            }
            if (!Character.isLetter(ch)) continue;
            if (Character.isLowerCase(ch)) {
                hasLower = true;
                continue;
            }
            if (Character.isTitleCase(ch)) {
                hasLower = true;
                ++numCaps;
                continue;
            }
            ++numCaps;
        }
        char ch0 = word.charAt(0);
        String lowered = word.toLowerCase();
        if (Character.isUpperCase(ch0) || Character.isTitleCase(ch0)) {
            if (loc == 0 && numCaps == 1) {
                counter.incrementCount(new LexiconFeature(LexiconFeature.MorphFeature.INIT_CAP), 1.0);
            } else {
                counter.incrementCount(new LexiconFeature(LexiconFeature.MorphFeature.ALL_CAPS), 1.0);
            }
        } else if (!Character.isLetter(ch0) && numCaps > 0) {
            counter.incrementCount(new LexiconFeature(LexiconFeature.MorphFeature.ALL_CAPS), 1.0);
        } else if (hasLower) {
            counter.incrementCount(new LexiconFeature(LexiconFeature.MorphFeature.LOWER_CASE), 1.0);
        }
        if (hasDigit) {
            counter.incrementCount(new LexiconFeature(LexiconFeature.MorphFeature.HAS_DIGIT), 1.0);
        }
        if (hasDash) {
            counter.incrementCount(new LexiconFeature(LexiconFeature.MorphFeature.HAS_DASH), 1.0);
        }
        if (lowered.endsWith("s") && wlen >= 3) {
            char ch2 = lowered.charAt(wlen - 2);
            if (ch2 != 's' && ch2 != 'i' && ch2 != 'u') {
                counter.incrementCount(new LexiconFeature(LexiconFeature.MorphFeature.SUFF_S), 1.0);
            }
        } else if (!(word.length() < 5 || hasDash || hasDigit && numCaps > 0)) {
            if (lowered.endsWith("ed")) {
                counter.incrementCount(new LexiconFeature(LexiconFeature.MorphFeature.SUFF_ED), 1.0);
            } else if (lowered.endsWith("ing")) {
                counter.incrementCount(new LexiconFeature(LexiconFeature.MorphFeature.SUFF_ING), 1.0);
            } else if (lowered.endsWith("ion")) {
                counter.incrementCount(new LexiconFeature(LexiconFeature.MorphFeature.SUFF_ION), 1.0);
            } else if (lowered.endsWith("er")) {
                counter.incrementCount(new LexiconFeature(LexiconFeature.MorphFeature.SUFF_ER), 1.0);
            } else if (lowered.endsWith("est")) {
                counter.incrementCount(new LexiconFeature(LexiconFeature.MorphFeature.SUFF_EST), 1.0);
            } else if (lowered.endsWith("ly")) {
                counter.incrementCount(new LexiconFeature(LexiconFeature.MorphFeature.SUFF_LY), 1.0);
            } else if (lowered.endsWith("ity")) {
                counter.incrementCount(new LexiconFeature(LexiconFeature.MorphFeature.SUFF_ITY), 1.0);
            } else if (lowered.endsWith("y")) {
                counter.incrementCount(new LexiconFeature(LexiconFeature.MorphFeature.SUFF_Y), 1.0);
            } else if (lowered.endsWith("al")) {
                counter.incrementCount(new LexiconFeature(LexiconFeature.MorphFeature.SUFF_AL), 1.0);
            }
        }
        return counter;
    }
}

