/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.discPCFG;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.HierarchicalBinaryRule;
import edu.berkeley.nlp.PCFGLA.HierarchicalGrammar;
import edu.berkeley.nlp.PCFGLA.HierarchicalLexicon;
import edu.berkeley.nlp.PCFGLA.HierarchicalUnaryRule;
import edu.berkeley.nlp.PCFGLA.Rule;
import edu.berkeley.nlp.PCFGLA.SimpleLexicon;
import edu.berkeley.nlp.PCFGLA.SpanPredictor;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.discPCFG.DefaultLinearizer;
import edu.berkeley.nlp.math.SloppyMath;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.util.ArrayUtil;

public class HierarchicalLinearizer
extends DefaultLinearizer {
    private static final long serialVersionUID = 1L;
    HierarchicalGrammar grammar;
    HierarchicalLexicon lexicon;
    int finalLevel;
    int[][] lexiconMapping;
    int[][][] unaryMapping;
    int[][][][] binaryMapping;

    public HierarchicalLinearizer() {
    }

    public HierarchicalLinearizer(Grammar grammar, SimpleLexicon lexicon, SpanPredictor sp, int fLevel) {
        this.grammar = (HierarchicalGrammar)grammar;
        this.lexicon = (HierarchicalLexicon)lexicon;
        this.spanPredictor = sp;
        this.finalLevel = fLevel;
        this.nSubstates = (int)ArrayUtil.max(grammar.numSubStates);
        this.init();
        this.computeMappings();
    }

    protected void computeMappings() {
        this.lexiconMapping = new int[this.finalLevel + 1][this.nSubstates];
        this.unaryMapping = new int[this.finalLevel + 1][this.nSubstates][this.nSubstates];
        this.binaryMapping = new int[this.finalLevel + 1][this.nSubstates][this.nSubstates][this.nSubstates];
        int[] divisors = new int[this.finalLevel + 1];
        for (int i = 0; i <= this.finalLevel; ++i) {
            divisors[i] = (int)Math.pow(2.0, this.finalLevel - i);
        }
        for (int level = 1; level <= this.finalLevel; ++level) {
            int k;
            int j;
            int i;
            int div = divisors[level];
            int l = (int)Math.pow(2.0, level);
            int[][] tmpU = new int[l][l];
            int[][][] tmpB = new int[l][l][l];
            int indU = 0;
            int indB = 0;
            for (i = 0; i < l; ++i) {
                for (j = 0; j < l; ++j) {
                    tmpU[i][j] = indU++;
                    for (k = 0; k < l; ++k) {
                        tmpB[i][j][k] = indB++;
                    }
                }
            }
            for (i = 0; i < this.nSubstates; ++i) {
                this.lexiconMapping[level][i] = i / div;
                for (j = 0; j < this.nSubstates; ++j) {
                    this.unaryMapping[level][i][j] = tmpU[i / div][j / div];
                    for (k = 0; k < this.nSubstates; ++k) {
                        this.binaryMapping[level][i][j][k] = tmpB[i / div][j / div][k / div];
                    }
                }
            }
        }
    }

    public void delinearizeGrammar(double[] probs) {
        int k;
        int j;
        Object scores;
        int ind;
        Rule hRule;
        int nDangerous = 0;
        for (BinaryRule bRule : this.grammar.binaryRuleMap.keySet()) {
            hRule = (HierarchicalBinaryRule)bRule;
            ind = ((HierarchicalBinaryRule)hRule).identifier;
            scores = ((HierarchicalBinaryRule)hRule).getLastLevel();
            for (j = 0; j < ((double[][][])scores).length; ++j) {
                for (k = 0; k < scores[j].length; ++k) {
                    if (scores[j][k] == null) continue;
                    for (int l = 0; l < scores[j][k].length; ++l) {
                        double val;
                        if (SloppyMath.isVeryDangerous(val = probs[ind++])) {
                            ++nDangerous;
                            continue;
                        }
                        scores[j][k][l] = val;
                    }
                }
            }
        }
        if (nDangerous > 0) {
            System.out.println("Left " + nDangerous + " binary rule weights unchanged since the proposed weight was dangerous.");
        }
        nDangerous = 0;
        for (UnaryRule uRule : this.grammar.unaryRuleMap.keySet()) {
            hRule = (HierarchicalUnaryRule)uRule;
            ind = ((HierarchicalUnaryRule)hRule).identifier;
            if (uRule.childState == uRule.parentState) continue;
            scores = ((HierarchicalUnaryRule)hRule).getLastLevel();
            for (j = 0; j < ((double[][][])scores).length; ++j) {
                if (scores[j] == null) continue;
                for (k = 0; k < scores[j].length; ++k) {
                    double val;
                    if (SloppyMath.isVeryDangerous(val = probs[ind++])) {
                        ++nDangerous;
                        continue;
                    }
                    scores[j][k] = (double[])val;
                }
            }
        }
        if (nDangerous > 0) {
            System.out.println("Left " + nDangerous + " unary rule weights unchanged since the proposed weight was dangerous.");
        }
        this.grammar.explicitlyComputeScores(this.finalLevel);
        this.grammar.closedViterbiRulesWithParent = this.grammar.unaryRulesWithParent;
        this.grammar.closedSumRulesWithParent = this.grammar.unaryRulesWithParent;
        this.grammar.closedViterbiRulesWithChild = this.grammar.unaryRulesWithC;
        this.grammar.closedSumRulesWithChild = this.grammar.unaryRulesWithC;
        this.grammar.clearUnaryIntermediates();
        this.grammar.makeCRArrays();
    }

    public void delinearizeLexicon(double[] logProbs) {
        int nDangerous = 0;
        for (int tag = 0; tag < this.lexicon.hierarchicalScores.length; tag = (int)((short)(tag + 1))) {
            for (int word = 0; word < this.lexicon.hierarchicalScores[tag].length; ++word) {
                int index = this.linearIndex[tag][word];
                double[] vals = this.lexicon.getLastLevel(tag, word);
                for (int substate = 0; substate < vals.length; ++substate) {
                    double val;
                    if (SloppyMath.isVeryDangerous(val = logProbs[index++])) {
                        ++nDangerous;
                        continue;
                    }
                    vals[substate] = val;
                }
            }
        }
        if (nDangerous > 0) {
            System.out.println("Left " + nDangerous + " lexicon weights unchanged since the proposed weight was dangerous.");
        }
        this.lexicon.explicitlyComputeScores(this.finalLevel);
    }

    public double[] getLinearizedGrammar(boolean update) {
        int k;
        int j;
        int ind;
        Rule hRule;
        if (update) {
            int j2;
            Object scores;
            Rule hRule2;
            this.nGrammarWeights = 0;
            for (BinaryRule bRule : this.grammar.binaryRuleMap.keySet()) {
                hRule2 = (HierarchicalBinaryRule)bRule;
                if (!this.grammar.isGrammarTag[bRule.parentState]) {
                    System.out.println("Incorrect grammar tag");
                }
                bRule.identifier = this.nGrammarWeights;
                scores = ((HierarchicalBinaryRule)hRule2).getLastLevel();
                for (j2 = 0; j2 < ((double[][][])scores).length; ++j2) {
                    for (int k2 = 0; k2 < scores[j2].length; ++k2) {
                        if (scores[j2][k2] == null) continue;
                        this.nGrammarWeights += scores[j2][k2].length;
                    }
                }
            }
            for (UnaryRule uRule : this.grammar.unaryRuleMap.keySet()) {
                hRule2 = (HierarchicalUnaryRule)uRule;
                uRule.identifier = this.nGrammarWeights;
                scores = ((HierarchicalUnaryRule)hRule2).getLastLevel();
                for (j2 = 0; j2 < ((double[][][])scores).length; ++j2) {
                    if (scores[j2] == null) continue;
                    this.nGrammarWeights += scores[j2].length;
                }
            }
        }
        double[] logProbs = new double[this.nGrammarWeights];
        for (BinaryRule bRule : this.grammar.binaryRuleMap.keySet()) {
            hRule = (HierarchicalBinaryRule)bRule;
            ind = ((HierarchicalBinaryRule)hRule).identifier;
            double[][][] scores = ((HierarchicalBinaryRule)hRule).getLastLevel();
            for (j = 0; j < scores.length; ++j) {
                for (k = 0; k < scores[j].length; ++k) {
                    if (scores[j][k] == null) continue;
                    for (int l = 0; l < scores[j][k].length; ++l) {
                        double val = scores[j][k][l];
                        logProbs[ind++] = val;
                    }
                }
            }
        }
        for (UnaryRule uRule : this.grammar.unaryRuleMap.keySet()) {
            hRule = (HierarchicalUnaryRule)uRule;
            ind = ((HierarchicalUnaryRule)hRule).identifier;
            if (uRule.childState == uRule.parentState) continue;
            double[][] scores = ((HierarchicalUnaryRule)hRule).getLastLevel();
            for (j = 0; j < scores.length; ++j) {
                if (scores[j] == null) continue;
                for (k = 0; k < scores[j].length; ++k) {
                    double val = scores[j][k];
                    logProbs[ind++] = val;
                }
            }
        }
        return logProbs;
    }

    public double[] getLinearizedLexicon(boolean update) {
        if (update) {
            this.nLexiconWeights = 0;
            int[] substates = new int[this.finalLevel + 1];
            for (int i = 0; i <= this.finalLevel; ++i) {
                substates[i] = (int)Math.pow(2.0, i);
            }
            for (int tag = 0; tag < this.lexicon.hierarchicalScores.length; tag = (int)((short)(tag + 1))) {
                for (int word = 0; word < this.lexicon.hierarchicalScores[tag].length; ++word) {
                    this.nLexiconWeights += this.lexicon.getLastLevel(tag, word).length;
                }
            }
        }
        double[] logProbs = new double[this.nLexiconWeights];
        if (update) {
            this.linearIndex = new int[this.lexicon.hierarchicalScores.length][];
        }
        int index = 0;
        for (int tag = 0; tag < this.lexicon.hierarchicalScores.length; tag = (int)((short)(tag + 1))) {
            if (update) {
                this.linearIndex[tag] = new int[this.lexicon.hierarchicalScores[tag].length];
            }
            for (int word = 0; word < this.lexicon.hierarchicalScores[tag].length; ++word) {
                if (update) {
                    this.linearIndex[tag][word] = index + this.nGrammarWeights;
                }
                double[] vals = this.lexicon.getLastLevel(tag, word);
                for (int substate = 0; substate < vals.length; ++substate) {
                    double val = vals[substate];
                    logProbs[index++] = val;
                }
            }
        }
        if (index != logProbs.length) {
            System.out.println("unequal length in lexicon");
        }
        return logProbs;
    }

    public int getLinearIndex(int globalWordIndex, int tag) {
        int tagSpecificWordIndex = this.lexicon.tagWordIndexer[tag].indexOf(globalWordIndex);
        if (tagSpecificWordIndex == -1) {
            return -1;
        }
        return this.linearIndex[tag][tagSpecificWordIndex];
    }

    public int dimension() {
        return this.nGrammarWeights + this.nLexiconWeights + this.nSpanWeights;
    }

    public void increment(double[] counts, StateSet stateSet, int tag, double[] weights, boolean isGold) {
        int globalWordIndex;
        int startIndexWord;
        int i;
        int startIndexWord2;
        int globalSigIndex = stateSet.sigIndex;
        if (globalSigIndex != -1 && (startIndexWord2 = this.getLinearIndex(globalSigIndex, tag)) >= 0) {
            int finalLevel = this.lexicon.getFinalLevel(globalSigIndex, tag);
            for (i = 0; i < this.nSubstates; ++i) {
                if (isGold) {
                    int n = startIndexWord2 + this.lexiconMapping[finalLevel][i];
                    counts[n] = counts[n] + weights[i];
                    continue;
                }
                int n = startIndexWord2 + this.lexiconMapping[finalLevel][i];
                counts[n] = counts[n] - weights[i];
            }
        }
        if ((startIndexWord = this.getLinearIndex(globalWordIndex = stateSet.wordIndex, tag)) >= 0) {
            int finalLevel = this.lexicon.getFinalLevel(globalWordIndex, tag);
            for (int i2 = 0; i2 < this.nSubstates; ++i2) {
                if (isGold) {
                    int n = startIndexWord + this.lexiconMapping[finalLevel][i2];
                    counts[n] = counts[n] + weights[i2];
                } else {
                    int n = startIndexWord + this.lexiconMapping[finalLevel][i2];
                    counts[n] = counts[n] - weights[i2];
                }
                weights[i2] = 0.0;
            }
        } else {
            for (i = 0; i < this.nSubstates; ++i) {
                weights[i] = 0.0;
            }
        }
    }

    public void increment(double[] counts, UnaryRule rule, double[] weights, boolean isGold) {
        HierarchicalUnaryRule hr = (HierarchicalUnaryRule)rule;
        int thisStartIndex = hr.identifier;
        int finalLevel = hr.lastLevel;
        int curInd = 0;
        if (rule.parentState == 0) {
            for (int cp = 0; cp < this.nSubstates; ++cp) {
                double val = weights[curInd];
                if (val > 0.0) {
                    if (isGold) {
                        int n = thisStartIndex + this.lexiconMapping[finalLevel][cp];
                        counts[n] = counts[n] + val;
                    } else {
                        int n = thisStartIndex + this.lexiconMapping[finalLevel][cp];
                        counts[n] = counts[n] - val;
                    }
                    weights[curInd] = 0.0;
                }
                ++curInd;
            }
            return;
        }
        for (int cp = 0; cp < this.nSubstates; ++cp) {
            for (int np = 0; np < this.nSubstates; ++np) {
                double val = weights[curInd];
                if (val > 0.0) {
                    if (isGold) {
                        int n = thisStartIndex + this.unaryMapping[finalLevel][cp][np];
                        counts[n] = counts[n] + val;
                    } else {
                        int n = thisStartIndex + this.unaryMapping[finalLevel][cp][np];
                        counts[n] = counts[n] - val;
                    }
                    weights[curInd] = 0.0;
                }
                ++curInd;
            }
        }
    }

    public void increment(double[] counts, BinaryRule rule, double[] weights, boolean isGold) {
        HierarchicalBinaryRule hr = (HierarchicalBinaryRule)rule;
        int thisStartIndex = hr.identifier;
        int finalLevel = hr.lastLevel;
        int curInd = 0;
        for (int lp = 0; lp < this.nSubstates; ++lp) {
            for (int rp = 0; rp < this.nSubstates; ++rp) {
                for (int np = 0; np < this.nSubstates; ++np) {
                    double val = weights[curInd];
                    if (val > 0.0) {
                        if (isGold) {
                            int n = thisStartIndex + this.binaryMapping[finalLevel][lp][rp][np];
                            counts[n] = counts[n] + val;
                        } else {
                            int n = thisStartIndex + this.binaryMapping[finalLevel][lp][rp][np];
                            counts[n] = counts[n] - val;
                        }
                        weights[curInd] = 0.0;
                    }
                    ++curInd;
                }
            }
        }
    }

    public Grammar getGrammar() {
        return this.grammar;
    }

    public SimpleLexicon getLexicon() {
        return this.lexicon;
    }

    public SpanPredictor getSpanPredictor() {
        return this.spanPredictor;
    }
}

