/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.discPCFG;

import edu.berkeley.nlp.discPCFG.Encoding;
import edu.berkeley.nlp.util.Counter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EncodedDatum {
    int labelIndex;
    int[] featureIndexes;
    double[] featureCounts;
    double[] weights;

    public static <F, L> EncodedDatum encodeDatum(Encoding<F, L> encoding, Counter<F> features) {
        return EncodedDatum.encodeLabeledDatum(encoding, features, null, null);
    }

    public static <F, L> EncodedDatum encodeLabeledDatum(Encoding<F, L> encoding, Counter<F> features, L label, double[] weights) {
        Counter<Object> knownFeatures = new Counter<Object>();
        for (F feature : features.keySet()) {
            if (encoding.getFeatureIndex(feature) < 0) continue;
            knownFeatures.incrementCount(feature, features.getCount(feature));
        }
        int numActiveFeatures = knownFeatures.keySet().size();
        int[] featureIndexes = new int[numActiveFeatures];
        double[] featureCounts = new double[knownFeatures.keySet().size()];
        int i = 0;
        for (Object feature : knownFeatures.keySet()) {
            int index = encoding.getFeatureIndex(feature);
            double count = knownFeatures.getCount(feature);
            featureIndexes[i] = index;
            featureCounts[i] = count;
            ++i;
        }
        int labelIndex = encoding.getLabelIndex(label);
        EncodedDatum encodedDatum = new EncodedDatum(labelIndex, featureIndexes, featureCounts, weights);
        return encodedDatum;
    }

    public int getLabelIndex() {
        return this.labelIndex;
    }

    public double[] getWeights() {
        return this.weights;
    }

    public int getNumActiveFeatures() {
        return this.featureCounts.length;
    }

    public int getFeatureIndex(int num) {
        return this.featureIndexes[num];
    }

    public double getFeatureCount(int num) {
        return this.featureCounts[num];
    }

    public EncodedDatum(int labelIndex, int[] featureIndexes, double[] featureCounts, double[] weights) {
        this.labelIndex = labelIndex;
        this.featureIndexes = featureIndexes;
        this.featureCounts = featureCounts;
        this.weights = weights;
    }
}

