/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.conll;

import edu.berkeley.nlp.PCFGLA.Option;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.syntax.Tree;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DepToPTB {
    public static void main(String[] args) {
        OptionParser optParser = new OptionParser(Options.class);
        Options opts = (Options)optParser.parse(args, true);
        BufferedReader input = null;
        String fileName = opts.inFileName;
        try {
            input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), Charset.forName("UTF-8")));
            String line = "";
            AbstractList sentence = new ArrayList<String>();
            while ((line = input.readLine()) != null) {
                System.out.println(line);
                if (line.equals("")) {
                    Tree<String> tree = DepToPTB.turnIntoTree(sentence, opts.useFinePOS);
                    System.out.println("( " + tree + ")");
                    sentence = new LinkedList();
                    continue;
                }
                sentence.add(line);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static Tree<String> turnIntoTree(List<String> sentence, boolean useFinePOS) {
        int i;
        int posIndex = useFinePOS ? 4 : 3;
        int nWords = sentence.size();
        Tree[] trees = new Tree[nWords];
        List[] childIndices = new List[nWords];
        int[] freeKids = new int[nWords];
        int[] parentIndices = new int[nWords];
        int rootIndex = -1;
        for (i = 0; i < nWords; ++i) {
            childIndices[i] = new LinkedList();
        }
        for (i = 0; i < nWords; ++i) {
            int pIndex;
            String[] fields = sentence.get(i).split("\t");
            String word = fields[1];
            if (word.equals("(") || word.equals(")")) {
                word = "LRB";
            }
            Tree<String> child = new Tree<String>(word);
            ArrayList childList = new ArrayList(1);
            childList.add(child);
            String tag = fields[posIndex];
            if (tag.equals("(") || tag.equals(")")) {
                tag = "LRB";
            }
            trees[i] = new Tree<String>(tag, childList);
            parentIndices[i] = pIndex = Integer.parseInt(fields[6]) - 1;
            if (pIndex == -1) {
                rootIndex = i;
            } else {
                childIndices[pIndex].add(i);
            }
            childIndices[i].add(i);
        }
        if (nWords == 1) {
            return trees[0];
        }
        i = 0;
        while (i < nWords) {
            for (Integer c : childIndices[i]) {
                if (childIndices[c].size() != 1) continue;
                int n = i;
                freeKids[n] = freeKids[n] + 1;
            }
            int n = i++;
            freeKids[n] = freeKids[n] + 1;
        }
        while (childIndices[rootIndex].size() > 0) {
            for (i = 0; i < nWords; ++i) {
                Tree<String> newTree;
                if (childIndices[i].size() <= 1 || freeKids[i] != childIndices[i].size()) continue;
                ArrayList childList = new ArrayList();
                for (Integer c : childIndices[i]) {
                    childList.add(trees[c]);
                }
                trees[i] = newTree = new Tree<String>(trees[i].getLabel() + "*", childList);
                if (parentIndices[i] >= 0) {
                    int n = parentIndices[i];
                    freeKids[n] = freeKids[n] + 1;
                }
                childIndices[i] = new LinkedList();
            }
        }
        return trees[rootIndex];
    }

    public static class Options {
        @Option(name="-in", required=true, usage="Input File for Grammar (Required)")
        public String inFileName;
        @Option(name="-finePOStags", usage="Use fine POS tags (Default: false=coarse")
        public boolean useFinePOS = false;
    }
}

