/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.classify;

import edu.berkeley.nlp.classify.Feature;
import edu.berkeley.nlp.classify.FeatureManager;
import edu.berkeley.nlp.util.Counter;
import edu.berkeley.nlp.util.Indexer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabelFeatureWeightsManager<L> {
    private FeatureManager featManager;
    private Indexer<L> labels;

    public LabelFeatureWeightsManager(FeatureManager featManager, Indexer<L> labels) {
        this.featManager = featManager;
        this.labels = labels;
        if (!featManager.isLocked()) {
            throw new IllegalArgumentException("Feature manager must be locked");
        }
    }

    public int getFeatureLabelWeightIndex(int featureIndex, int labelIndex) {
        assert (labelIndex < this.labels.size() && labelIndex >= 0);
        assert (featureIndex < this.featManager.getNumFeatures() && featureIndex >= 0);
        return featureIndex + this.featManager.getNumFeatures() * labelIndex;
    }

    public int getWeightIndex(Feature feat, L label) {
        return this.getFeatureLabelWeightIndex(feat.getIndex(), this.labels.indexOf(label));
    }

    public int getWeightIndex(String feat, L label) {
        int featIndex = this.featManager.getFeature(feat).getIndex();
        int labelIndex = this.labels.indexOf(label);
        return this.getFeatureLabelWeightIndex(featIndex, labelIndex);
    }

    public int getNumWeights() {
        return this.featManager.getNumFeatures() * this.labels.size();
    }

    public Feature getBaseFeature(int weightIndex) {
        return this.featManager.getFeature(weightIndex % this.featManager.getNumFeatures());
    }

    public L getLabel(int weightIndex) {
        return this.labels.getObject(weightIndex / this.featManager.getNumFeatures());
    }

    public Counter<String> getWeightsCounter(double[] weights) {
        Counter<String> counts = new Counter<String>();
        for (Object label : this.labels) {
            for (int i = 0; i < this.featManager.getNumFeatures(); ++i) {
                Feature feat = this.featManager.getFeature(i);
                int index = this.getWeightIndex(feat, label);
                String labelFeat = String.format("%s && %s", label, feat);
                counts.setCount(labelFeat, weights[index]);
            }
        }
        return counts;
    }
}

