/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.ArrayParser;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Option;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.PCFGLA.SophisticatedLexicon;
import edu.berkeley.nlp.PCFGLA.StateSetTreeList;
import edu.berkeley.nlp.PCFGLA.TreeAnnotations;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import edu.berkeley.nlp.util.Numberer;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeScorer {
    public static void main(String[] args) {
        OptionParser optParser = new OptionParser(Options.class);
        Options opts = (Options)optParser.parse(args, true);
        System.err.println("Calling with " + optParser.getPassedInOptions());
        String inFileName = opts.inFileName;
        if (inFileName == null) {
            throw new Error("Did not provide a grammar.");
        }
        System.err.println("Loading grammar from " + inFileName + ".");
        ParserData pData = ParserData.Load(inFileName);
        if (pData == null) {
            System.out.println("Failed to load grammar from file" + inFileName + ".");
            System.exit(1);
        }
        Grammar grammar = pData.getGrammar();
        grammar.splitRules();
        SophisticatedLexicon lexicon = (SophisticatedLexicon)pData.getLexicon();
        ArrayParser parser = new ArrayParser(grammar, lexicon);
        Numberer.setNumberers(pData.getNumbs());
        Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
        short[] numSubstates = grammar.numSubStates;
        Object cumulativePosteriors = null;
        if (opts.printStats) {
            cumulativePosteriors = new double[numSubstates.length][];
            for (int state = 0; state < numSubstates.length; ++state) {
                cumulativePosteriors[state] = new double[numSubstates[state]];
            }
        }
        try {
            BufferedReader inputData = opts.inputFile == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(opts.inputFile), "UTF-8"));
            PrintWriter outputData = opts.outputFile == null ? new PrintWriter(new OutputStreamWriter(System.out)) : new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(opts.outputFile), "UTF-8"), true);
            Tree<String> tree = null;
            String line = "";
            while ((line = inputData.readLine()) != null) {
                if (line.equals("")) {
                    outputData.write("\n");
                    continue;
                }
                tree = Trees.PennTreeReader.parseEasy(line);
                if (tree.getYield().get(0).equals("")) {
                    outputData.write("()\n");
                    continue;
                }
                tree = TreeAnnotations.processTree(tree, pData.v_markov, pData.h_markov, pData.bin, false);
                Tree<StateSet> stateSetTree = StateSetTreeList.stringTreeToStatesetTree(tree, numSubstates, false, tagNumberer);
                TreeScorer.allocate(stateSetTree);
                if (opts.printStats) {
                    parser.doInsideOutsideScores(stateSetTree, false, false);
                    parser.countPosteriors((double[][])cumulativePosteriors, stateSetTree, stateSetTree.getLabel().getIScore(0), stateSetTree.getLabel().getIScale());
                } else {
                    try {
                        parser.doInsideScores(stateSetTree, false, false, null);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                double logScore = Math.log(stateSetTree.getLabel().getIScore(0)) + (double)(stateSetTree.getLabel().getIScale() * 100);
                outputData.write(logScore + "\n");
                outputData.flush();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (opts.printStats) {
            for (int state = 0; state < numSubstates.length; ++state) {
                String tagname = (String)tagNumberer.object(state);
                if (tagname.endsWith("^g")) {
                    tagname = tagname.substring(0, tagname.length() - 2);
                }
                Arrays.sort(cumulativePosteriors[state]);
                System.out.print(tagname);
                for (int substate = cumulativePosteriors[state].length - 1; substate >= 0; --substate) {
                    System.out.print("\t" + cumulativePosteriors[state][substate]);
                }
                System.out.print("\n");
            }
        }
        System.exit(0);
    }

    static void allocate(Tree<StateSet> tree) {
        tree.getLabel().allocate();
        for (Tree<StateSet> child : tree.getChildren()) {
            TreeScorer.allocate(child);
        }
    }

    public static class Options {
        @Option(name="-gr", required=true, usage="Input File for Grammar (Required)\n")
        public String inFileName;
        @Option(name="-inputFile", usage="Read input from this file instead of reading it from STDIN.")
        public String inputFile;
        @Option(name="-outputFile", usage="Store output in this file instead of printing it to STDOUT.")
        public String outputFile;
        @Option(name="-printStats", usage="Compute and print subcategory usage statistics")
        public boolean printStats;
    }
}

