/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.GrammarTrainer;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.PCFGLA.SophisticatedLexicon;
import edu.berkeley.nlp.PCFGLA.TreeAnnotations;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import edu.berkeley.nlp.util.Numberer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeGenerator {
    static Grammar grammar;
    static SophisticatedLexicon lexicon;
    static Numberer tagNumberer;

    public static void main(String[] args) {
        if (args.length < 3) {
            System.out.println("usage: java TreeGenerator <input file for grammar> <maxLength> <nTrees>\n");
            System.exit(2);
        }
        String inFileName = args[0];
        int maxLength = Integer.parseInt(args[1]);
        int nTrees = Integer.parseInt(args[2]);
        System.out.println("Loading grammar from " + inFileName + ".");
        ParserData pData = ParserData.Load(inFileName);
        if (pData == null) {
            System.out.println("Failed to load grammar from file" + inFileName + ".");
            System.exit(1);
        }
        grammar = pData.getGrammar();
        lexicon = (SophisticatedLexicon)pData.getLexicon();
        Numberer.setNumberers(pData.getNumbs());
        tagNumberer = Numberer.getGlobalNumberer("tags");
        grammar.splitRules();
        int nGen = 0;
        while (nGen < nTrees) {
            Tree<String> artTree = TreeGenerator.generateTree(0, 0);
            System.out.println(artTree.getYield().toString());
            Tree<String> tree = TreeAnnotations.unAnnotateTree(artTree, false);
            if (tree.getYield().size() > maxLength) continue;
            System.out.println("Generated tree of length " + tree.getYield().size() + ".\n" + Trees.PennTreeRenderer.render(tree) + "\n");
            ++nGen;
        }
    }

    private static Tree<String> generateTree(int pState, int pSubState) {
        String root = (String)tagNumberer.object(pState);
        BinaryRule[] bRules = grammar.splitRulesWithP(pState);
        double randval = GrammarTrainer.RANDOM.nextDouble();
        double sum = 0.0;
        ArrayList children = new ArrayList();
        for (int i = 0; i < bRules.length; ++i) {
            double[][][] scores = bRules[i].scores;
            for (int lC = 0; lC < scores.length; ++lC) {
                for (int rC = 0; rC < scores[lC].length; ++rC) {
                    if (scores[lC][rC] != null) {
                        sum += scores[lC][rC][pSubState];
                    }
                    if (!(sum > randval)) continue;
                    children.add(TreeGenerator.generateTree(bRules[i].leftChildState, lC));
                    children.add(TreeGenerator.generateTree(bRules[i].rightChildState, rC));
                    return new Tree<String>(root, children);
                }
            }
        }
        List<UnaryRule> uRulesList = grammar.getUnaryRulesByParent(pState);
        for (UnaryRule uRule : uRulesList) {
            double[][] scores = uRule.scores;
            for (int uC = 0; uC < scores.length; ++uC) {
                if (uRule.parentState == uRule.childState) continue;
                if (scores[uC] != null) {
                    sum += scores[uC][pSubState];
                }
                if (!(sum > randval)) continue;
                children.add(TreeGenerator.generateTree(uRule.childState, uC));
                return new Tree<String>(root, children);
            }
        }
        if (sum == 0.0) {
            String word = TreeGenerator.sampleWord(pState, pSubState);
            List child = Collections.singletonList(new Tree<String>(word));
            return new Tree<String>(root, child);
        }
        throw new Error("rule probability sum " + sum + " is more than 1!");
    }

    private static String sampleWord(int tag, int substate) {
        String w = (String)tagNumberer.object(tag);
        double randval = GrammarTrainer.RANDOM.nextDouble();
        double sum = 0.0;
        HashMap<String, double[]> wordToTagCounter = TreeGenerator.lexicon.wordToTagCounters[tag];
        for (String word : wordToTagCounter.keySet()) {
            double c_T;
            double p_T;
            double total;
            double p_W;
            double c_W;
            double pb_T_W;
            double pb_W_T;
            double c_TW = 0.0;
            if (TreeGenerator.lexicon.wordToTagCounters[tag] != null && TreeGenerator.lexicon.wordToTagCounters[tag].get(word) != null) {
                c_TW = wordToTagCounter.get(word)[substate];
            }
            if (!((sum += (pb_W_T = (pb_T_W = c_TW / (c_W = TreeGenerator.lexicon.wordCounter.getCount(word))) * (p_W = c_W / (total = TreeGenerator.lexicon.totalTokens)) / (p_T = (c_T = TreeGenerator.lexicon.tagCounter[tag][substate]) / total))) > randval)) continue;
            return word;
        }
        return w;
    }
}

