/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.Binarization;
import edu.berkeley.nlp.ling.CollinsHeadFinder;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.syntax.Trees;
import edu.berkeley.nlp.util.Filter;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeAnnotations
implements Serializable {
    private static final long serialVersionUID = 1L;
    static CollinsHeadFinder headFinder = new CollinsHeadFinder();

    public static Tree<String> processTree(Tree<String> unAnnotatedTree, int nVerticalAnnotations, int nHorizontalAnnotations, Binarization binarization, boolean manualAnnotation) {
        return TreeAnnotations.processTree(unAnnotatedTree, nVerticalAnnotations, nHorizontalAnnotations, binarization, manualAnnotation, false, true);
    }

    public static Tree<String> processTree(Tree<String> unAnnotatedTree, int nVerticalAnnotations, int nHorizontalAnnotations, Binarization binarization, boolean manualAnnotation, boolean annotateUnaryParents, boolean markGrammarSymbols) {
        Tree<String> verticallyAnnotated = unAnnotatedTree;
        if (nVerticalAnnotations == 3) {
            verticallyAnnotated = TreeAnnotations.annotateVerticallyTwice(unAnnotatedTree, "", "");
        } else if (nVerticalAnnotations == 2) {
            verticallyAnnotated = manualAnnotation ? TreeAnnotations.annotateManuallyVertically(unAnnotatedTree, "") : TreeAnnotations.annotateVertically(unAnnotatedTree, "");
        } else if (nVerticalAnnotations == 1) {
            if (markGrammarSymbols) {
                verticallyAnnotated = TreeAnnotations.markGrammarNonterminals(unAnnotatedTree, "");
            }
            if (annotateUnaryParents) {
                verticallyAnnotated = TreeAnnotations.markUnaryParents(verticallyAnnotated);
            }
        } else {
            throw new Error("the code does not exist to annotate vertically " + nVerticalAnnotations + " times");
        }
        Tree<String> binarizedTree = TreeAnnotations.binarizeTree(verticallyAnnotated, binarization);
        return TreeAnnotations.forgetLabels(binarizedTree, nHorizontalAnnotations);
    }

    public static Tree<String> binarizeTree(Tree<String> tree, Binarization binarization) {
        switch (binarization) {
            case LEFT: {
                return TreeAnnotations.leftBinarizeTree(tree);
            }
            case RIGHT: {
                return TreeAnnotations.rightBinarizeTree(tree);
            }
            case PARENT: {
                return TreeAnnotations.parentBinarizeTree(tree);
            }
            case HEAD: {
                return TreeAnnotations.headBinarizeTree(tree);
            }
        }
        return null;
    }

    private static Tree<String> annotateVerticallyTwice(Tree<String> tree, String parentLabel1, String parentLabel2) {
        Tree<String> verticallyMarkovizatedTree;
        if (tree.isLeaf()) {
            verticallyMarkovizatedTree = tree;
        } else {
            ArrayList children = new ArrayList();
            for (Tree<String> child : tree.getChildren()) {
                children.add(TreeAnnotations.annotateVerticallyTwice(child, "^" + tree.getLabel(), parentLabel1));
            }
            verticallyMarkovizatedTree = new Tree<String>(tree.getLabel() + parentLabel1 + parentLabel2, children);
        }
        return verticallyMarkovizatedTree;
    }

    private static Tree<String> annotateVertically(Tree<String> tree, String parentLabel) {
        Tree<String> verticallyMarkovizatedTree;
        if (tree.isLeaf()) {
            verticallyMarkovizatedTree = tree;
        } else {
            ArrayList children = new ArrayList();
            for (Tree<String> child : tree.getChildren()) {
                children.add(TreeAnnotations.annotateVertically(child, "^" + tree.getLabel()));
            }
            verticallyMarkovizatedTree = new Tree<String>(tree.getLabel() + parentLabel, children);
        }
        return verticallyMarkovizatedTree;
    }

    private static Tree<String> markGrammarNonterminals(Tree<String> tree, String parentLabel) {
        Tree<String> verticallyMarkovizatedTree;
        if (tree.isPreTerminal()) {
            verticallyMarkovizatedTree = tree;
        } else {
            ArrayList children = new ArrayList();
            for (Tree<String> child : tree.getChildren()) {
                children.add(TreeAnnotations.markGrammarNonterminals(child, "^g"));
            }
            verticallyMarkovizatedTree = new Tree<String>(tree.getLabel() + parentLabel, children);
        }
        return verticallyMarkovizatedTree;
    }

    private static Tree<String> markUnaryParents(Tree<String> tree) {
        Tree<String> verticallyMarkovizatedTree;
        if (tree.isPreTerminal()) {
            verticallyMarkovizatedTree = tree;
        } else {
            ArrayList children = new ArrayList();
            for (Tree<String> child : tree.getChildren()) {
                children.add(TreeAnnotations.markUnaryParents(child));
            }
            String add = "";
            if (!tree.getLabel().equals("ROOT")) {
                add = children.size() == 1 ? "^u" : "";
            }
            verticallyMarkovizatedTree = new Tree<String>(tree.getLabel() + add, children);
        }
        return verticallyMarkovizatedTree;
    }

    private static Tree<String> annotateManuallyVertically(Tree<String> tree, String parentLabel) {
        Tree<String> verticallyMarkovizatedTree;
        if (tree.isPreTerminal()) {
            String label = tree.getLabel();
            verticallyMarkovizatedTree = label.contains("DT") || label.contains("RB") || label.contains("IN") || label.contains("AUX") || label.contains("CC") || label.contains("%") ? new Tree<String>(tree.getLabel() + parentLabel, tree.getChildren()) : tree;
        } else {
            ArrayList children = new ArrayList();
            for (Tree<String> child : tree.getChildren()) {
                children.add(TreeAnnotations.annotateManuallyVertically(child, "^" + tree.getLabel()));
            }
            verticallyMarkovizatedTree = new Tree<String>(tree.getLabel() + parentLabel, children);
        }
        return verticallyMarkovizatedTree;
    }

    private static Tree<String> deleteLabels(Tree<String> tree, boolean isRoot) {
        String label = tree.getLabel();
        String newLabel = "";
        if (isRoot) {
            newLabel = label;
        } else {
            if (tree.isPreTerminal()) {
                newLabel = "Z";
                return new Tree<String>(newLabel, tree.getChildren());
            }
            newLabel = label.charAt(0) == '@' ? "@X" : "X";
        }
        ArrayList transformedChildren = new ArrayList();
        for (Tree<String> child : tree.getChildren()) {
            transformedChildren.add(TreeAnnotations.deleteLabels(child, false));
        }
        return new Tree<String>(newLabel, transformedChildren);
    }

    private static Tree<String> deletePC(Tree<String> tree, boolean isRoot) {
        String label = tree.getLabel();
        String newLabel = "";
        if (isRoot) {
            newLabel = label;
        } else {
            if (tree.isPreTerminal()) {
                return tree;
            }
            newLabel = label.charAt(0) == '@' ? "@X" : "X";
        }
        ArrayList transformedChildren = new ArrayList();
        for (Tree<String> child : tree.getChildren()) {
            transformedChildren.add(TreeAnnotations.deletePC(child, false));
        }
        return new Tree<String>(newLabel, transformedChildren);
    }

    private static Tree<String> forgetLabels(Tree<String> tree, int nHorizontalAnnotation) {
        int secondCutIndex;
        int firstCutIndex;
        if (nHorizontalAnnotation == -1) {
            return tree;
        }
        String transformedLabel = tree.getLabel();
        if (tree.isLeaf()) {
            return new Tree<String>(transformedLabel);
        }
        int keepBeginning = firstCutIndex = transformedLabel.indexOf(95);
        int cutIndex = secondCutIndex = transformedLabel.indexOf(95, firstCutIndex + 1);
        while (secondCutIndex != -1) {
            cutIndex = firstCutIndex;
            firstCutIndex = secondCutIndex;
            secondCutIndex = transformedLabel.indexOf(95, firstCutIndex + 1);
        }
        if (nHorizontalAnnotation == 0) {
            cutIndex = transformedLabel.indexOf(62) - 1;
            if (cutIndex > 0) {
                transformedLabel = transformedLabel.substring(0, cutIndex);
            }
        } else if (cutIndex > 0 && !tree.isLeaf()) {
            if (nHorizontalAnnotation == 2) {
                transformedLabel = transformedLabel.substring(0, keepBeginning) + transformedLabel.substring(cutIndex);
            } else if (nHorizontalAnnotation == 1) {
                transformedLabel = transformedLabel.substring(0, keepBeginning) + transformedLabel.substring(firstCutIndex);
            } else {
                throw new Error("code does not exist to horizontally annotate at level " + nHorizontalAnnotation);
            }
        }
        ArrayList transformedChildren = new ArrayList();
        for (Tree<String> child : tree.getChildren()) {
            transformedChildren.add(TreeAnnotations.forgetLabels(child, nHorizontalAnnotation));
        }
        return new Tree<String>(transformedLabel, transformedChildren);
    }

    static Tree<String> leftBinarizeTree(Tree<String> tree) {
        String label = tree.getLabel();
        List<Tree<String>> children = tree.getChildren();
        if (tree.isLeaf()) {
            return new Tree<String>(label);
        }
        if (children.size() == 1) {
            return new Tree<String>(label, Collections.singletonList(TreeAnnotations.leftBinarizeTree(children.get(0))));
        }
        String intermediateLabel = "@" + label + "->";
        Tree<String> intermediateTree = TreeAnnotations.leftBinarizeTreeHelper(tree, 0, intermediateLabel);
        return new Tree<String>(label, intermediateTree.getChildren());
    }

    private static Tree<String> leftBinarizeTreeHelper(Tree<String> tree, int numChildrenGenerated, String intermediateLabel) {
        Tree<String> leftTree = tree.getChildren().get(numChildrenGenerated);
        ArrayList children = new ArrayList(2);
        children.add(TreeAnnotations.leftBinarizeTree(leftTree));
        if (numChildrenGenerated == tree.getChildren().size() - 2) {
            children.add(TreeAnnotations.leftBinarizeTree(tree.getChildren().get(numChildrenGenerated + 1)));
        } else if (numChildrenGenerated < tree.getChildren().size() - 2) {
            Tree<String> rightTree = TreeAnnotations.leftBinarizeTreeHelper(tree, numChildrenGenerated + 1, intermediateLabel + "_" + leftTree.getLabel());
            children.add(rightTree);
        }
        return new Tree<String>(intermediateLabel, children);
    }

    static Tree<String> rightBinarizeTree(Tree<String> tree) {
        String label = tree.getLabel();
        List<Tree<String>> children = tree.getChildren();
        if (tree.isLeaf()) {
            return new Tree<String>(label);
        }
        if (children.size() == 1) {
            return new Tree<String>(label, Collections.singletonList(TreeAnnotations.rightBinarizeTree(children.get(0))));
        }
        String intermediateLabel = "@" + label + "->";
        Tree<String> intermediateTree = TreeAnnotations.rightBinarizeTreeHelper(tree, children.size() - 1, intermediateLabel);
        return new Tree<String>(label, intermediateTree.getChildren());
    }

    private static Tree<String> rightBinarizeTreeHelper(Tree<String> tree, int numChildrenLeft, String intermediateLabel) {
        Tree<String> rightTree = tree.getChildren().get(numChildrenLeft);
        ArrayList children = new ArrayList(2);
        if (numChildrenLeft == 1) {
            children.add(TreeAnnotations.rightBinarizeTree(tree.getChildren().get(numChildrenLeft - 1)));
        } else if (numChildrenLeft > 1) {
            Tree<String> leftTree = TreeAnnotations.rightBinarizeTreeHelper(tree, numChildrenLeft - 1, intermediateLabel + "_" + rightTree.getLabel());
            children.add(leftTree);
        }
        children.add(TreeAnnotations.rightBinarizeTree(rightTree));
        return new Tree<String>(intermediateLabel, children);
    }

    static Tree<String> headBinarizeTree(Tree<String> tree) {
        return TreeAnnotations.headParentBinarizeTree(Binarization.HEAD, tree);
    }

    static Tree<String> parentBinarizeTree(Tree<String> tree) {
        return TreeAnnotations.headParentBinarizeTree(Binarization.PARENT, tree);
    }

    private static Tree<String> headParentBinarizeTree(Binarization binarization, Tree<String> tree) {
        List<Tree<String>> children = tree.getChildren();
        if (children.size() == 0) {
            return tree;
        }
        if (children.size() == 1) {
            ArrayList kids = new ArrayList(1);
            kids.add(TreeAnnotations.headParentBinarizeTree(binarization, children.get(0)));
            return new Tree<String>(tree.getLabel(), kids);
        }
        if (children.size() == 2) {
            ArrayList kids = new ArrayList(2);
            kids.add(TreeAnnotations.headParentBinarizeTree(binarization, children.get(0)));
            kids.add(TreeAnnotations.headParentBinarizeTree(binarization, children.get(1)));
            return new Tree<String>(tree.getLabel(), kids);
        }
        ArrayList kids = new ArrayList(1);
        kids.add(TreeAnnotations.headParentBinarizeTreeHelper(binarization, tree, 0, children.size() - 1, headFinder.determineHead(tree), false, ""));
        return new Tree<String>(tree.getLabel(), kids);
    }

    static Tree<String> headParentBinarizeTreeHelper(Binarization binarization, Tree<String> tree, int leftChild, int rightChild, Tree<String> head, boolean right, String productionHistory) {
        if (head == null) {
            throw new Error("head is null");
        }
        List<Tree<String>> children = tree.getChildren();
        if (!right && children.get(leftChild) == head) {
            right = true;
        }
        String label = null;
        if (binarization == Binarization.HEAD) {
            label = head.getLabel();
        } else if (binarization == Binarization.PARENT) {
            label = tree.getLabel();
        }
        String parentLabel = "@" + label + (right ? "-R" : "-L") + "->" + productionHistory;
        if (leftChild == rightChild) {
            ArrayList kids = new ArrayList(1);
            kids.add(TreeAnnotations.headParentBinarizeTree(binarization, children.get(leftChild)));
            return new Tree<String>(parentLabel, kids);
        }
        if (!right) {
            ArrayList kids = new ArrayList(2);
            Tree<String> child = children.get(leftChild);
            kids.add(TreeAnnotations.headParentBinarizeTree(binarization, child));
            kids.add(TreeAnnotations.headParentBinarizeTreeHelper(binarization, tree, leftChild + 1, rightChild, head, right, productionHistory + "_" + child.getLabel()));
            return new Tree<String>(parentLabel, kids);
        }
        ArrayList kids = new ArrayList(2);
        Tree<String> child = children.get(rightChild);
        kids.add(TreeAnnotations.headParentBinarizeTreeHelper(binarization, tree, leftChild, rightChild - 1, head, right, productionHistory + "_" + child.getLabel()));
        kids.add(TreeAnnotations.headParentBinarizeTree(binarization, child));
        return new Tree<String>(parentLabel, kids);
    }

    public static Tree<String> unAnnotateTreeSpecial(Tree<String> annotatedTree) {
        Tree<String> debinarizedTree = Trees.spliceNodes(annotatedTree, new Filter<String>(){

            @Override
            public boolean accept(String s) {
                return s.startsWith("Y");
            }
        });
        Tree<String> unAnnotatedTree = new Trees.FunctionNodeStripper().transformTree(debinarizedTree);
        return unAnnotatedTree;
    }

    public static Tree<String> debinarizeTree(Tree<String> annotatedTree) {
        Tree<String> debinarizedTree = Trees.spliceNodes(annotatedTree, new Filter<String>(){

            @Override
            public boolean accept(String s) {
                return s.startsWith("@") && !s.equals("@");
            }
        });
        return debinarizedTree;
    }

    public static Tree<String> unAnnotateTree(Tree<String> annotatedTree, boolean keepFunctionLabel) {
        Tree<String> debinarizedTree = Trees.spliceNodes(annotatedTree, new Filter<String>(){

            @Override
            public boolean accept(String s) {
                return s.startsWith("@") && !s.equals("@");
            }
        });
        if (keepFunctionLabel) {
            return debinarizedTree;
        }
        Tree<String> unAnnotatedTree = new Trees.FunctionNodeStripper().transformTree(debinarizedTree);
        return unAnnotatedTree;
    }

    public static void main(String[] args) {
        Trees.PennTreeReader reader = new Trees.PennTreeReader(new StringReader("((S (NP (DT the) (JJ quick) (JJ (AA (BB (CC brown)))) (NN fox)) (VP (VBD jumped) (PP (IN over) (NP (DT the) (JJ lazy) (NN dog)))) (. .)))"));
        Object tree = reader.next();
        System.out.println("tree");
        System.out.println(Trees.PennTreeRenderer.render(tree));
        for (Binarization binarization : Binarization.values()) {
            System.out.println("binarization type " + binarization.name());
            try {
                Tree<String> binarizedTree = TreeAnnotations.binarizeTree((Tree<String>)tree, binarization);
                System.out.println(Trees.PennTreeRenderer.render(binarizedTree));
                System.out.println("unbinarized");
                Tree<String> unBinarizedTree = TreeAnnotations.unAnnotateTree(binarizedTree, false);
                System.out.println(Trees.PennTreeRenderer.render(unBinarizedTree));
                System.out.println("------------");
            }
            catch (Error e) {
                System.out.println("binarization not implemented");
            }
        }
    }

    public static Tree<String> removeSuperfluousNodes(Tree<String> tree) {
        if (tree.isPreTerminal()) {
            return tree;
        }
        if (tree.isLeaf()) {
            return tree;
        }
        List<Tree<String>> gChildren = tree.getChildren();
        if (gChildren.size() != 1) {
            ArrayList children = new ArrayList();
            for (int i = 0; i < gChildren.size(); ++i) {
                Tree<String> cChild = TreeAnnotations.removeSuperfluousNodes(tree.getChildren().get(i));
                children.add(cChild);
            }
            tree.setChildren(children);
            return tree;
        }
        Tree<String> result = null;
        String parent = tree.getLabel();
        HashSet<String> nodesInChain = new HashSet<String>();
        tree = tree.getChildren().get(0);
        while (!tree.isPreTerminal() && tree.getChildren().size() == 1) {
            if (!nodesInChain.contains(tree.getLabel())) {
                nodesInChain.add(tree.getLabel());
            }
            tree = tree.getChildren().get(0);
        }
        Tree<String> child = TreeAnnotations.removeSuperfluousNodes(tree);
        String cLabel = child.getLabel();
        ArrayList childs = new ArrayList();
        childs.add(child);
        result = cLabel.equals(parent) ? child : new Tree<String>(parent, childs);
        for (String node : nodesInChain) {
            if (node.equals(parent) || node.equals(cLabel)) continue;
            Tree<String> intermediate = new Tree<String>(node, result.getChildren());
            childs = new ArrayList();
            childs.add(intermediate);
            result.setChildren(childs);
        }
        return result;
    }

    public static void displayUnaryChains(Tree<String> tree, String parent) {
        if (tree.getChildren().size() == 1) {
            if (!parent.equals("") && !tree.isPreTerminal()) {
                System.out.println("Unary chain: " + parent + " -> " + tree.getLabel() + " -> " + tree.getChildren().get(0).getLabel());
            }
            if (!tree.isPreTerminal()) {
                TreeAnnotations.displayUnaryChains(tree.getChildren().get(0), tree.getLabel());
            }
        } else {
            for (Tree<String> child : tree.getChildren()) {
                if (child.isPreTerminal()) continue;
                TreeAnnotations.displayUnaryChains(child, "");
            }
        }
    }

    public static void removeUnaryChains(Tree<String> tree) {
        if (tree.isPreTerminal()) {
            return;
        }
        if (tree.getChildren().size() == 1 && tree.getChildren().get(0).getChildren().size() == 1) {
            if (tree.getChildren().get(0).isPreTerminal()) {
                return;
            }
            ArrayList newChildren = new ArrayList();
            newChildren.add(tree.getChildren().get(0).getChildren().get(0));
            tree.setChildren(newChildren);
        }
        for (Tree<String> child : tree.getChildren()) {
            TreeAnnotations.removeUnaryChains(child);
        }
    }
}

