/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.ConditionalTrainer;
import edu.berkeley.nlp.PCFGLA.StateSetTreeList;
import edu.berkeley.nlp.math.SloppyMath;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Counter;
import edu.berkeley.nlp.util.Indexer;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.Pair;
import edu.berkeley.nlp.util.PriorityQueue;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpanPredictor
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final boolean useFirstAndLast;
    public final boolean usePreviousAndNext;
    public final boolean useBeginAndEndPairs;
    public final boolean useSyntheticClass;
    public final boolean usePunctuation;
    Indexer<String> punctuationSignatures;
    boolean[] isPunctuation;
    public final boolean useOnlyWords = true;
    public final int minFeatureFrequency;
    public final int minSpanLength = 3;
    public double[][] firstWordScore;
    public double[][] lastWordScore;
    public double[][] previousWordScore;
    public double[][] nextWordScore;
    public double[][] beginPairScore;
    public double[][] endPairScore;
    private HashMap<Pair<Integer, Integer>, Integer> beginMap;
    private HashMap<Pair<Integer, Integer>, Integer> endMap;
    public double[][] punctuationScores;
    public int nWords;
    public int nFeatures;
    private int[] stateClass;
    private int nClasses;
    private Indexer<String> wordIndexer;
    private final String X = "x".intern();

    public SpanPredictor(int nWords, StateSetTreeList trainTrees, Numberer tagNumberer, Indexer<String> wordIndexer) {
        this.useFirstAndLast = ConditionalTrainer.Options.useFirstAndLast;
        this.usePreviousAndNext = ConditionalTrainer.Options.usePreviousAndNext;
        this.useBeginAndEndPairs = ConditionalTrainer.Options.useBeginAndEndPairs;
        this.useSyntheticClass = ConditionalTrainer.Options.useSyntheticClass;
        this.usePunctuation = ConditionalTrainer.Options.usePunctuation;
        this.minFeatureFrequency = ConditionalTrainer.Options.minFeatureFrequency;
        this.wordIndexer = wordIndexer;
        this.nWords = nWords;
        this.nFeatures = 0;
        if (this.useSyntheticClass) {
            System.out.println("Distinguishing between real and synthetic classes.");
            this.stateClass = new int[tagNumberer.total()];
            for (int i = 0; i < tagNumberer.total(); ++i) {
                String state = (String)tagNumberer.object(i);
                if (state.charAt(0) != '@') continue;
                this.stateClass[i] = 1;
            }
            this.nClasses = 2;
        } else {
            this.stateClass = new int[tagNumberer.total()];
            this.nClasses = 1;
        }
        if (this.useFirstAndLast) {
            this.firstWordScore = new double[nWords][this.nClasses];
            this.lastWordScore = new double[nWords][this.nClasses];
            ArrayUtil.fill(this.firstWordScore, 1.0);
            ArrayUtil.fill(this.lastWordScore, 1.0);
            this.nFeatures += 2 * nWords * this.nClasses;
        }
        if (this.usePreviousAndNext) {
            this.previousWordScore = new double[nWords][this.nClasses];
            this.nextWordScore = new double[nWords][this.nClasses];
            ArrayUtil.fill(this.previousWordScore, 1.0);
            ArrayUtil.fill(this.nextWordScore, 1.0);
            this.nFeatures += 2 * nWords * this.nClasses;
        }
        if (this.useBeginAndEndPairs) {
            this.initPairs(trainTrees);
        }
        if (this.usePunctuation) {
            this.initPunctuations(trainTrees);
        }
    }

    private void initPairs(StateSetTreeList trainTrees) {
        this.beginMap = new HashMap();
        this.endMap = new HashMap();
        Counter<Pair<Integer, Integer>> beginPairCounter = new Counter<Pair<Integer, Integer>>();
        Counter<Pair<Integer, Integer>> endPairCounter = new Counter<Pair<Integer, Integer>>();
        int beginPairs = 0;
        int endPairs = 0;
        for (Tree<StateSet> tree : trainTrees) {
            Pair<Integer, Integer> pair;
            int i;
            List<StateSet> words = tree.getYield();
            StateSet stateSet = words.get(0);
            int prevIndex = stateSet.sigIndex < 0 ? stateSet.wordIndex : stateSet.sigIndex;
            prevIndex = stateSet.wordIndex;
            int currIndex = -1;
            for (i = 1; i <= words.size() - 3; ++i) {
                stateSet = words.get(i);
                currIndex = stateSet.sigIndex < 0 ? stateSet.wordIndex : stateSet.sigIndex;
                currIndex = stateSet.wordIndex;
                pair = new Pair<Integer, Integer>(prevIndex, currIndex);
                beginPairCounter.incrementCount(pair, 1.0);
                if (!this.beginMap.containsKey(pair)) {
                    this.beginMap.put(pair, beginPairs++);
                }
                prevIndex = currIndex;
            }
            if (words.size() < 3) continue;
            stateSet = words.get(2);
            prevIndex = stateSet.sigIndex < 0 ? stateSet.wordIndex : stateSet.sigIndex;
            currIndex = stateSet.wordIndex;
            for (i = 3; i < words.size(); ++i) {
                stateSet = words.get(i);
                currIndex = stateSet.sigIndex < 0 ? stateSet.wordIndex : stateSet.sigIndex;
                currIndex = stateSet.wordIndex;
                pair = new Pair<Integer, Integer>(prevIndex, currIndex);
                endPairCounter.incrementCount(pair, 1.0);
                if (!this.endMap.containsKey(pair)) {
                    this.endMap.put(pair, endPairs++);
                }
                prevIndex = currIndex;
            }
        }
        HashMap<Pair<Integer, Integer>, Integer> newBeginMap = new HashMap<Pair<Integer, Integer>, Integer>();
        HashMap<Pair<Integer, Integer>, Integer> newEndMap = new HashMap<Pair<Integer, Integer>, Integer>();
        int newBeginPairs = 0;
        for (Pair<Integer, Integer> pair : this.beginMap.keySet()) {
            if (!(beginPairCounter.getCount(pair) >= (double)this.minFeatureFrequency)) continue;
            newBeginMap.put(pair, newBeginPairs++);
        }
        this.beginMap = newBeginMap;
        beginPairs = newBeginPairs;
        int newEndPairs = 0;
        for (Pair<Integer, Integer> pair : this.endMap.keySet()) {
            if (!(endPairCounter.getCount(pair) >= (double)this.minFeatureFrequency)) continue;
            newEndMap.put(pair, newEndPairs++);
        }
        this.endMap = newEndMap;
        endPairs = newEndPairs;
        this.beginPairScore = new double[beginPairs][this.nClasses];
        this.endPairScore = new double[endPairs][this.nClasses];
        this.nFeatures += (beginPairs + endPairs) * this.nClasses;
        System.out.println("There were " + beginPairs + " begin-pair types and " + endPairs + " end-pair types.");
    }

    public double[] scoreSpan(int previousIndex, int firstIndex, int lastIndex, int followingIndex) {
        double[] result = new double[this.nClasses];
        Arrays.fill(result, 1.0);
        if (firstIndex < 0 || lastIndex < 0) {
            return result;
        }
        for (int c = 0; c < this.nClasses; ++c) {
            if (this.useFirstAndLast) {
                int n = c;
                result[n] = result[n] * (this.firstWordScore[firstIndex][c] * this.lastWordScore[lastIndex][c]);
            }
            if (this.usePreviousAndNext) {
                if (previousIndex >= 0) {
                    int n = c;
                    result[n] = result[n] * this.previousWordScore[previousIndex][c];
                }
                if (followingIndex >= 0) {
                    int n = c;
                    result[n] = result[n] * this.nextWordScore[followingIndex][c];
                }
            }
            if (this.useBeginAndEndPairs) {
                int index;
                if (previousIndex >= 0 && (index = this.getBeginIndex(previousIndex, firstIndex)) >= 0) {
                    int n = c;
                    result[n] = result[n] * this.beginPairScore[index][c];
                }
                if (followingIndex >= 0 && (index = this.getEndIndex(lastIndex, followingIndex)) >= 0) {
                    int n = c;
                    result[n] = result[n] * this.endPairScore[index][c];
                }
            }
            if (!SloppyMath.isDangerous(result[c])) continue;
            System.out.println("Dangerous span prediction set to 1, since it was " + result);
            result[c] = 1.0;
        }
        return result;
    }

    public double[][][] predictSpans(List<StateSet> sentence) {
        int end;
        int start;
        int previousIndex = -1;
        int followingIndex = -1;
        int length = sentence.size();
        double[][][] spanScores = new double[length][length + 1][this.nClasses];
        for (start = 0; start < length; ++start) {
            for (int end2 = start + 1; end2 < start + 3 && end2 <= length; ++end2) {
                for (int clas = 0; clas < this.nClasses; ++clas) {
                    spanScores[start][end2][clas] = 1.0;
                }
            }
        }
        for (start = 0; start <= length - 3; ++start) {
            StateSet stateSet = sentence.get(start);
            int firstIndex = stateSet.sigIndex < 0 ? stateSet.wordIndex : stateSet.sigIndex;
            firstIndex = stateSet.wordIndex;
            for (end = start + 3; end <= length; ++end) {
                stateSet = sentence.get(end - 1);
                int lastIndex = stateSet.sigIndex < 0 ? stateSet.wordIndex : stateSet.sigIndex;
                lastIndex = stateSet.wordIndex;
                if (end < length) {
                    stateSet = sentence.get(end);
                    followingIndex = stateSet.sigIndex < 0 ? stateSet.wordIndex : stateSet.sigIndex;
                    followingIndex = stateSet.wordIndex;
                } else {
                    followingIndex = -1;
                }
                spanScores[start][end] = this.scoreSpan(previousIndex, firstIndex, lastIndex, followingIndex);
            }
            previousIndex = firstIndex;
        }
        if (this.usePunctuation) {
            int[][] punctSignatures = this.getPunctuationSignatures(sentence);
            for (int start2 = 0; start2 <= length - 3; ++start2) {
                for (end = start2 + 3; end <= length; ++end) {
                    int sig = punctSignatures[start2][end];
                    if (sig == -1) continue;
                    for (int c = 0; c < this.nClasses; ++c) {
                        double[] dArray = spanScores[start2][end];
                        int n = c;
                        dArray[n] = dArray[n] * this.punctuationScores[sig][c];
                    }
                }
            }
        }
        return spanScores;
    }

    public double[] countGoldSpanFeatures(StateSetTreeList trainTrees) {
        int c;
        int i;
        int c2;
        int[][] firstWordCount = null;
        int[][] lastWordCount = null;
        int[][] previousWordCount = null;
        int[][] nextWordCount = null;
        int[][] beginPairsCount = null;
        int[][] endPairsCount = null;
        int[][] punctuationCount = null;
        int[][] punctuationSig = null;
        if (this.useFirstAndLast) {
            firstWordCount = new int[this.nWords][this.nClasses];
            lastWordCount = new int[this.nWords][this.nClasses];
        }
        if (this.usePreviousAndNext) {
            previousWordCount = new int[this.nWords][this.nClasses];
            nextWordCount = new int[this.nWords][this.nClasses];
        }
        if (this.useBeginAndEndPairs) {
            beginPairsCount = new int[this.beginPairScore.length][this.nClasses];
            endPairsCount = new int[this.endPairScore.length][this.nClasses];
        }
        if (this.usePunctuation) {
            punctuationCount = new int[this.punctuationSignatures.size()][this.nClasses];
        }
        for (Tree<StateSet> tree : trainTrees) {
            List<StateSet> words = tree.getYield();
            if (this.usePunctuation) {
                punctuationSig = this.getPunctuationSignatures(words);
            }
            this.countGoldSpanFeaturesHelper(tree, words, firstWordCount, lastWordCount, previousWordCount, nextWordCount, beginPairsCount, endPairsCount, punctuationCount, punctuationSig);
        }
        double[] res = new double[this.nFeatures];
        int index = 0;
        if (this.useFirstAndLast) {
            int firstSum = 0;
            int lastSum = 0;
            for (c2 = 0; c2 < this.nWords; ++c2) {
                firstSum += ArrayUtil.sum(firstWordCount[c2]);
                lastSum += ArrayUtil.sum(lastWordCount[c2]);
            }
            System.out.println("Number of first words: " + firstSum);
            System.out.println("Number of last words: " + lastSum);
            for (i = 0; i < this.nWords; ++i) {
                for (c = 0; c < this.nClasses; ++c) {
                    res[index++] = firstWordCount[i][c];
                }
            }
            for (i = 0; i < this.nWords; ++i) {
                for (c = 0; c < this.nClasses; ++c) {
                    res[index++] = lastWordCount[i][c];
                }
            }
        }
        if (this.usePreviousAndNext) {
            int prevSum = 0;
            int nextSum = 0;
            for (c2 = 0; c2 < this.nWords; ++c2) {
                prevSum += ArrayUtil.sum(previousWordCount[c2]);
                nextSum += ArrayUtil.sum(nextWordCount[c2]);
            }
            System.out.println("Number of previous words: " + prevSum);
            System.out.println("Number of next words: " + nextSum);
            for (i = 0; i < this.nWords; ++i) {
                for (c = 0; c < this.nClasses; ++c) {
                    res[index++] = previousWordCount[i][c];
                }
            }
            for (i = 0; i < this.nWords; ++i) {
                for (c = 0; c < this.nClasses; ++c) {
                    res[index++] = nextWordCount[i][c];
                }
            }
        }
        if (this.useBeginAndEndPairs) {
            int beginSum = 0;
            int endSum = 0;
            for (i = 0; i < beginPairsCount.length; ++i) {
                beginSum += ArrayUtil.sum(beginPairsCount[i]);
            }
            for (i = 0; i < endPairsCount.length; ++i) {
                endSum += ArrayUtil.sum(endPairsCount[i]);
            }
            System.out.println("Number of begin pairs: " + beginSum);
            System.out.println("Number of end pairs: " + endSum);
            for (i = 0; i < beginPairsCount.length; ++i) {
                for (c = 0; c < this.nClasses; ++c) {
                    res[index++] = beginPairsCount[i][c];
                }
            }
            for (i = 0; i < endPairsCount.length; ++i) {
                for (c = 0; c < this.nClasses; ++c) {
                    res[index++] = endPairsCount[i][c];
                }
            }
        }
        if (this.usePunctuation) {
            for (int i2 = 0; i2 < punctuationCount.length; ++i2) {
                for (int c3 = 0; c3 < this.nClasses; ++c3) {
                    res[index++] = punctuationCount[i2][c3];
                }
            }
        }
        return res;
    }

    private void countGoldSpanFeaturesHelper(Tree<StateSet> tree, List<StateSet> words, int[][] firstWordCount, int[][] lastWordCount, int[][] previousWordCount, int[][] nextWordCount, int[][] beginPairsCount, int[][] endPairsCount, int[][] punctuationCount, int[][] punctuationSignatures) {
        int punctSig;
        StateSet node = tree.getLabel();
        if (node.to - node.from < 3) {
            return;
        }
        short state = node.getState();
        int thisClass = this.stateClass[state];
        StateSet stateSet = words.get(node.from);
        int firstWord = stateSet.sigIndex < 0 ? stateSet.wordIndex : stateSet.sigIndex;
        firstWord = stateSet.wordIndex;
        stateSet = words.get(node.to - 1);
        int lastWord = stateSet.sigIndex < 0 ? stateSet.wordIndex : stateSet.sigIndex;
        lastWord = stateSet.wordIndex;
        int previousWord = 0;
        int nextWord = 0;
        if (node.from > 0) {
            stateSet = words.get(node.from - 1);
            previousWord = stateSet.sigIndex < 0 ? stateSet.wordIndex : stateSet.sigIndex;
            previousWord = stateSet.wordIndex;
        }
        if (node.to < words.size()) {
            stateSet = words.get(node.to);
            nextWord = stateSet.sigIndex < 0 ? stateSet.wordIndex : stateSet.sigIndex;
            nextWord = stateSet.wordIndex;
        }
        if (this.useFirstAndLast) {
            int[] nArray = firstWordCount[firstWord];
            int n = thisClass;
            nArray[n] = nArray[n] + 1;
            int[] nArray2 = lastWordCount[lastWord];
            int n2 = thisClass;
            nArray2[n2] = nArray2[n2] + 1;
        }
        if (this.usePreviousAndNext) {
            if (node.from > 0) {
                int[] nArray = previousWordCount[previousWord];
                int n = thisClass;
                nArray[n] = nArray[n] + 1;
            }
            if (node.to < words.size()) {
                int[] nArray = nextWordCount[nextWord];
                int n = thisClass;
                nArray[n] = nArray[n] + 1;
            }
        }
        if (this.useBeginAndEndPairs) {
            int endIndex;
            int beginIndex;
            if (node.from > 0 && (beginIndex = this.getBeginIndex(previousWord, firstWord)) >= 0) {
                int[] nArray = beginPairsCount[beginIndex];
                int n = thisClass;
                nArray[n] = nArray[n] + 1;
            }
            if (node.to < words.size() && (endIndex = this.getEndIndex(lastWord, nextWord)) >= 0) {
                int[] nArray = endPairsCount[endIndex];
                int n = thisClass;
                nArray[n] = nArray[n] + 1;
            }
        }
        if (this.usePunctuation && (punctSig = punctuationSignatures[node.from][node.to]) >= 0) {
            int[] nArray = punctuationCount[punctSig];
            int n = thisClass;
            nArray[n] = nArray[n] + 1;
        }
        for (Tree<StateSet> child : tree.getChildren()) {
            this.countGoldSpanFeaturesHelper(child, words, firstWordCount, lastWordCount, previousWordCount, nextWordCount, beginPairsCount, endPairsCount, punctuationCount, punctuationSignatures);
        }
    }

    private void initPunctuations(StateSetTreeList trainTrees) {
        this.punctuationSignatures = new Indexer();
        this.isPunctuation = new boolean[this.nWords];
        Counter<String> punctSigCounter = new Counter<String>();
        for (int word = 0; word < this.nWords; ++word) {
            this.isPunctuation[word] = this.isPunctuation(this.wordIndexer.get(word));
        }
        for (Tree<StateSet> tree : trainTrees) {
            this.getPunctuationSignatures(tree.getYield(), true, punctSigCounter);
        }
        Indexer<String> newPunctuationSignatures = new Indexer<String>();
        for (String sig : punctSigCounter.keySet()) {
            if (!(punctSigCounter.getCount(sig) >= (double)this.minFeatureFrequency)) continue;
            newPunctuationSignatures.add(sig);
        }
        this.punctuationSignatures = newPunctuationSignatures;
        this.punctuationScores = new double[this.punctuationSignatures.size()][this.nClasses];
        ArrayUtil.fill(this.punctuationScores, 1.0);
        this.nFeatures += this.nClasses * this.punctuationScores.length;
    }

    private boolean isPunctuation(String word) {
        if (word.length() > 2) {
            return false;
        }
        if (Character.isLetterOrDigit(word.charAt(0))) {
            return false;
        }
        if (word.length() == 1) {
            return true;
        }
        return !Character.isLetterOrDigit(word.charAt(1));
    }

    private int appendItem(StringBuilder sb, String maskedWord, int nWordsBefore) {
        if (maskedWord != this.X) {
            sb.append(maskedWord);
            nWordsBefore = 0;
        } else if (nWordsBefore == 0) {
            sb.append("x");
            ++nWordsBefore;
        } else if (nWordsBefore == 1) {
            sb.append("+");
            ++nWordsBefore;
        }
        return nWordsBefore;
    }

    public int[][] getPunctuationSignatures(List<StateSet> sentence) {
        return this.getPunctuationSignatures(sentence, false, null);
    }

    public int[][] getPunctuationSignatures(List<StateSet> sentence, boolean update, Counter<String> punctSigCounter) {
        int length = sentence.size();
        String[] masked = new String[length];
        for (int i = 0; i < length; ++i) {
            StateSet thisStateSet = sentence.get(i);
            masked[i] = thisStateSet.wordIndex > 0 && this.isPunctuation[thisStateSet.wordIndex] ? thisStateSet.getWord() : this.X;
        }
        int[][] result = new int[length][length + 1];
        ArrayUtil.fill(result, -1);
        for (int start = 0; start <= length - 3; ++start) {
            StringBuilder sb = new StringBuilder();
            String prev = "";
            if (start <= 1) {
                sb.append("<S>");
            }
            int nWordsBefore = 0;
            if (start > 0) {
                this.appendItem(sb, masked[start - 1], nWordsBefore);
            }
            sb.append("[");
            nWordsBefore = this.appendItem(sb, masked[start], 0);
            for (int end = start + 3; end <= length; ++end) {
                nWordsBefore = this.appendItem(sb, masked[end - 1], nWordsBefore);
                prev = sb.toString();
                sb.append("]");
                if (end < length) {
                    this.appendItem(sb, masked[end], 0);
                }
                if (end < length - 1) {
                    sb.append("<E>");
                }
                String sig = sb.toString();
                if (update) {
                    this.punctuationSignatures.add(sig);
                    punctSigCounter.incrementCount(sig, 1.0);
                }
                result[start][end] = this.punctuationSignatures.indexOf(sig);
                sb = new StringBuilder(prev);
            }
        }
        return result;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(Indexer<String> wordIndexer) {
        StringBuffer sb = new StringBuffer();
        if (this.useFirstAndLast || this.usePreviousAndNext) {
            sb.append("word");
            if (this.useFirstAndLast) {
                sb.append("\tfirst\t\tlast\t");
            }
            if (this.usePreviousAndNext) {
                sb.append("\tprevious\tfollowing");
            }
            sb.append("\n");
            for (int word = 0; word < this.nWords; ++word) {
                String w = wordIndexer != null ? wordIndexer.get(word) : word + "";
                sb.append(w);
                if (this.useFirstAndLast) {
                    sb.append("\t" + Arrays.toString(this.firstWordScore[word]) + "\t" + Arrays.toString(this.lastWordScore[word]));
                }
                if (this.usePreviousAndNext) {
                    sb.append("\t" + Arrays.toString(this.previousWordScore[word]) + "\t" + Arrays.toString(this.nextWordScore[word]));
                }
                sb.append("\n");
            }
            if (this.useFirstAndLast) {
                PriorityQueue<String> pQf = new PriorityQueue<String>();
                PriorityQueue<String> pQl = new PriorityQueue<String>();
                PriorityQueue<String> pQp = null;
                PriorityQueue<String> pQn = null;
                if (this.usePreviousAndNext) {
                    pQp = new PriorityQueue<String>();
                    pQn = new PriorityQueue<String>();
                }
                for (int word = 0; word < this.nWords; ++word) {
                    String w = wordIndexer != null ? wordIndexer.get(word) : word + "";
                    pQf.add(w, this.firstWordScore[word][0]);
                    pQl.add(w, this.lastWordScore[word][0]);
                    if (!this.usePreviousAndNext) continue;
                    pQp.add(w, this.previousWordScore[word][0]);
                    pQn.add(w, this.nextWordScore[word][0]);
                }
                sb.append("First word weights\tLast word weights");
                if (this.usePreviousAndNext) {
                    sb.append("\tPrevious word weights\tNext word weights");
                }
                sb.append("\n");
                while (pQf.hasNext()) {
                    double weight = pQf.getPriority();
                    sb.append((String)pQf.next() + " " + weight + "\t");
                    weight = pQl.getPriority();
                    sb.append((String)pQl.next() + " " + weight + "\t");
                    if (this.usePreviousAndNext) {
                        weight = pQp.getPriority();
                        sb.append((String)pQp.next() + " " + weight + "\t");
                        weight = pQn.getPriority();
                        sb.append((String)pQn.next() + " " + weight);
                    }
                    sb.append("\n");
                }
            }
        }
        if (this.useBeginAndEndPairs) {
            String w2;
            sb.append("Begin pairs\t\t\t\tEnd pairs\n");
            PriorityQueue<String> pQb = new PriorityQueue<String>();
            PriorityQueue<String> pQe = new PriorityQueue<String>();
            for (Pair<Integer, Integer> p : this.beginMap.keySet()) {
                String w1 = wordIndexer.get(p.getFirst());
                w2 = wordIndexer.get(p.getSecond());
                pQb.add("(" + w1 + " | " + w2 + "),", this.beginPairScore[this.beginMap.get(p)][0]);
            }
            for (Pair<Integer, Integer> p : this.endMap.keySet()) {
                String w1 = wordIndexer.get(p.getFirst());
                w2 = wordIndexer.get(p.getSecond());
                pQe.add("(" + w1 + " | " + w2 + "),", this.endPairScore[this.endMap.get(p)][0]);
            }
            while (pQb.hasNext() || pQe.hasNext()) {
                double weight = 0.0;
                if (pQb.hasNext()) {
                    weight = pQb.getPriority();
                    sb.append((String)pQb.next() + " " + weight + "\t");
                } else {
                    sb.append("\t\t\t\t");
                }
                if (pQe.hasNext()) {
                    weight = pQe.getPriority();
                    sb.append((String)pQe.next() + " " + weight + "\n");
                    continue;
                }
                sb.append("\n");
            }
        }
        if (this.usePunctuation) {
            sb.append("Punctuation features:\n");
            PriorityQueue<String> pQp = new PriorityQueue<String>();
            for (int f = 0; f < this.punctuationSignatures.size(); ++f) {
                String w = this.punctuationSignatures.get(f);
                pQp.add(w, this.punctuationScores[f][0]);
            }
            while (pQp.hasNext()) {
                double weight = pQp.getPriority();
                String word = (String)pQp.next();
                sb.append(word + "\t");
                if (word.length() < 8) {
                    sb.append("\t");
                }
                sb.append(weight + "\n");
            }
        }
        return sb.toString();
    }

    public int getBeginIndex(int previousIndex, int currIndex) {
        Pair<Integer, Integer> pair = new Pair<Integer, Integer>(previousIndex, currIndex);
        if (!this.beginMap.containsKey(pair)) {
            return -1;
        }
        return this.beginMap.get(pair);
    }

    public int getEndIndex(int previousIndex, int currIndex) {
        Pair<Integer, Integer> pair = new Pair<Integer, Integer>(previousIndex, currIndex);
        if (!this.endMap.containsKey(pair)) {
            return -1;
        }
        return this.endMap.get(pair);
    }

    public int[] getStateClass() {
        return this.stateClass;
    }

    public final int getNClasses() {
        return this.nClasses;
    }
}

