/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.CoarseToFineMaxRuleParser;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.Option;
import edu.berkeley.nlp.PCFGLA.OptionParser;
import edu.berkeley.nlp.PCFGLA.ParserData;
import edu.berkeley.nlp.PCFGLA.Posterior;
import edu.berkeley.nlp.PCFGLA.TreeAnnotations;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.ScalingTools;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PosteriorMerger {
    static double[][][] maxcScore;
    static int[][][] maxcSplit;
    static int[][][] maxcChild;
    static int[][][] maxcLeftChild;
    static int[][][] maxcRightChild;

    public static void main(String[] args) {
        OptionParser optParser = new OptionParser(Options.class);
        Options opts = (Options)optParser.parse(args, true);
        System.err.println("Calling with " + optParser.getPassedInOptions());
        String inFileName = opts.grammarFiles;
        if (inFileName == null) {
            throw new Error("Did not provide a grammar.");
        }
        short[][] numSubstates = new short[opts.nGrammars][];
        Grammar[] grammars = new Grammar[opts.nGrammars];
        Lexicon[] lexicons = new Lexicon[opts.nGrammars];
        for (int gr = 0; gr < opts.nGrammars; ++gr) {
            System.err.println("Loading grammar from " + inFileName + "." + (gr + 1));
            ParserData pData = ParserData.Load(inFileName + "." + (gr + 1));
            if (pData == null) {
                System.out.println("Failed to load grammar from file" + inFileName + ".");
                System.exit(1);
            }
            numSubstates[gr] = pData.getGrammar().numSubStates;
            Numberer.setNumberers(pData.getNumbs());
            grammars[gr] = pData.getGrammar();
            lexicons[gr] = pData.getLexicon();
        }
        int nGrammars = numSubstates.length;
        CoarseToFineMaxRuleParser parser = new CoarseToFineMaxRuleParser(grammars[0], lexicons[0], 1.0, -1, false, false, false, true, false, false, false);
        try {
            BufferedReader inputData = opts.inputFile == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(opts.inputFile), "UTF-8"));
            PrintWriter outputData = opts.outputFile == null ? new PrintWriter(new OutputStreamWriter(System.out)) : new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(opts.outputFile), "UTF-8"), true);
            String line = "";
            int blockIndex = 0;
            int lineIndex = 0;
            ArrayList[] posteriors = null;
            while ((line = inputData.readLine()) != null) {
                int length;
                List<String> sentence = Arrays.asList(line.split(" "));
                if (posteriors == null || lineIndex == posteriors[0].size()) {
                    posteriors = new ArrayList[nGrammars];
                    for (int gr = 0; gr < nGrammars; ++gr) {
                        String fileName = opts.grammarFiles + "." + (gr + 1) + ".posteriors." + blockIndex;
                        posteriors[gr] = PosteriorMerger.loadPosteriors(fileName);
                    }
                    lineIndex = 0;
                    ++blockIndex;
                }
                if ((length = sentence.size()) > opts.maxLength) {
                    outputData.write("(())\n");
                    continue;
                }
                ArrayList<double[][][][]> iScores = new ArrayList<double[][][][]>(nGrammars);
                ArrayList<double[][][][]> oScores = new ArrayList<double[][][][]>(nGrammars);
                ArrayList<int[][][]> iScales = new ArrayList<int[][][]>(nGrammars);
                ArrayList<int[][][]> oScales = new ArrayList<int[][][]>(nGrammars);
                boolean[][][] allowedStates = null;
                boolean skip = false;
                for (int gr = 0; gr < nGrammars; ++gr) {
                    Posterior posterior = (Posterior)posteriors[gr].get(lineIndex);
                    iScores.add(posterior.iScore);
                    oScores.add(posterior.oScore);
                    iScales.add(posterior.iScale);
                    oScales.add(posterior.oScale);
                    allowedStates = PosteriorMerger.mergeAllowedStates(allowedStates, posterior.allowedStates);
                    PosteriorMerger.countAllowedStates(allowedStates);
                    if (posterior.iScale == null) continue;
                    skip = true;
                    System.err.println("Scaling will be used.");
                    if (length == posterior.iScale.length) continue;
                    System.err.println("G: " + gr + " sentence " + lineIndex + " Length mismatch. Expected: " + length + " Got: " + posterior.iScale.length);
                }
                ++lineIndex;
                if (skip) {
                    outputData.write("(()) \n");
                    continue;
                }
                PosteriorMerger.doCombinedMaxCScores(sentence, iScores, oScores, iScales, oScales, allowedStates, grammars, lexicons, numSubstates, iScales.get(0) != null);
                System.err.println("Done with scores");
                if (maxcScore[0][sentence.size()][0] == Double.NEGATIVE_INFINITY) {
                    System.err.println("MaxCscore for ROOT is -Inf.");
                    outputData.write("(()) \n");
                    continue;
                }
                parser.maxcScore = maxcScore;
                parser.maxcChild = maxcChild;
                parser.maxcLeftChild = maxcLeftChild;
                parser.maxcRightChild = maxcRightChild;
                parser.maxcSplit = maxcSplit;
                parser.allowedStates = allowedStates;
                Tree<String> parsedTree = parser.extractBestMaxRuleParse(0, sentence.size(), sentence);
                parsedTree = TreeAnnotations.unAnnotateTree(parsedTree, false);
                outputData.write(parsedTree + "\n");
                outputData.flush();
            }
            outputData.flush();
            outputData.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        System.exit(0);
    }

    private static boolean[][][] mergeAllowedStates(boolean[][][] allowedStates, boolean[][][] allowedStates2) {
        if (allowedStates == null) {
            return allowedStates2;
        }
        for (int i = 0; i < allowedStates.length; ++i) {
            for (int j = i + 1; j < allowedStates[i].length; ++j) {
                for (int k = 0; k < allowedStates[i][j].length; ++k) {
                    if (allowedStates2[i][j][k] || !allowedStates[i][j][k]) continue;
                    allowedStates[i][j][k] = false;
                }
            }
        }
        return allowedStates;
    }

    private static void countAllowedStates(boolean[][][] allowedStates) {
        int total = 0;
        int allowed = 0;
        for (int i = 0; i < allowedStates.length; ++i) {
            for (int j = i + 1; j < allowedStates[i].length; ++j) {
                for (int k = 0; k < allowedStates[i][j].length; ++k) {
                    if (allowedStates[i][j][k]) {
                        ++allowed;
                    }
                    ++total;
                }
            }
        }
        System.err.println(allowed + "/" + total + " allowed for sentence of length " + allowedStates.length);
    }

    static void doCombinedMaxCScores(List<String> sentence, List<double[][][][]> iScores, List<double[][][][]> oScores, List<int[][][]> iScales, List<int[][][]> oScales, boolean[][][] allowedStates, Grammar[] grammars, Lexicon[] lexicons, short[][] numSubstates, boolean scale) {
        int length = sentence.size();
        int nGrammars = numSubstates.length;
        int numStates = numSubstates[0].length;
        boolean[] grammarTags = grammars[0].isGrammarTag;
        Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
        maxcScore = new double[length][length + 1][numStates];
        maxcSplit = new int[length][length + 1][numStates];
        maxcChild = new int[length][length + 1][numStates];
        maxcLeftChild = new int[length][length + 1][numStates];
        maxcRightChild = new int[length][length + 1][numStates];
        ArrayUtil.fill(maxcScore, Double.NEGATIVE_INFINITY);
        double[] logNormalizer = new double[nGrammars];
        for (int i = 0; i < nGrammars; ++i) {
            logNormalizer[i] = iScores.get(i)[0][length][0][0];
        }
        for (int diff = 1; diff <= length; ++diff) {
            for (int start = 0; start < length - diff + 1; ++start) {
                int end = start + diff;
                Arrays.fill(maxcSplit[start][end], -1);
                Arrays.fill(maxcChild[start][end], -1);
                Arrays.fill(maxcLeftChild[start][end], -1);
                Arrays.fill(maxcRightChild[start][end], -1);
                if (diff > 1) {
                    for (int pState = 0; pState < numStates; pState = (int)((short)(pState + 1))) {
                        if (!allowedStates[start][end][pState]) continue;
                        BinaryRule[] parentRules = grammars[0].splitRulesWithP(pState);
                        for (int i = 0; i < parentRules.length; ++i) {
                            BinaryRule r = parentRules[i];
                            short lState = r.leftChildState;
                            short rState = r.rightChildState;
                            double scoreToBeat = maxcScore[start][end][pState];
                            for (int split = start + 1; split <= end - 1; ++split) {
                                double gScore;
                                if (!allowedStates[start][split][lState] || !allowedStates[split][end][rState]) continue;
                                double leftChildScore = maxcScore[start][split][lState];
                                double rightChildScore = maxcScore[split][end][rState];
                                if (leftChildScore == Double.NEGATIVE_INFINITY || rightChildScore == Double.NEGATIVE_INFINITY) continue;
                                double scalingFactor = 0.0;
                                if (scale) {
                                    for (int gr = 0; gr < nGrammars; ++gr) {
                                        scalingFactor += (double)(oScales.get(gr)[start][end][pState] + iScales.get(gr)[start][split][lState] + iScales.get(gr)[split][end][rState] - iScales.get(gr)[0][length][0]);
                                    }
                                    scalingFactor = Math.log(ScalingTools.calcScaleFactor(scalingFactor));
                                }
                                if ((gScore = leftChildScore + scalingFactor + rightChildScore) < scoreToBeat) continue;
                                for (int gr = 0; gr < nGrammars; ++gr) {
                                    double ruleScore = 0.0;
                                    BinaryRule rule = grammars[gr].getBinaryRule((short)pState, lState, rState);
                                    if (rule == null) {
                                        System.err.println("Dont have rule " + (String)tagNumberer.object(pState) + " -> " + (String)tagNumberer.object(lState) + " " + (String)tagNumberer.object(rState) + " in grammar " + gr);
                                        continue;
                                    }
                                    double[][][] scores = rule.getScores2();
                                    int nParentStates = numSubstates[gr][pState];
                                    int nLeftChildStates = numSubstates[gr][lState];
                                    int nRightChildStates = numSubstates[gr][rState];
                                    for (int lp = 0; lp < nLeftChildStates; ++lp) {
                                        double lIS = iScores.get(gr)[start][split][lState][lp];
                                        if (lIS == 0.0) continue;
                                        for (int rp = 0; rp < nRightChildStates; ++rp) {
                                            double rIS;
                                            if (scores[lp][rp] == null || (rIS = iScores.get(gr)[split][end][rState][rp]) == 0.0) continue;
                                            for (int np = 0; np < nParentStates; ++np) {
                                                double ruleS;
                                                double pOS = oScores.get(gr)[start][end][pState][np];
                                                if (pOS == 0.0 || (ruleS = scores[lp][rp][np]) == 0.0) continue;
                                                ruleScore += pOS * ruleS * lIS * rIS / logNormalizer[gr];
                                            }
                                        }
                                    }
                                    gScore += Math.log(ruleScore);
                                }
                                if (!(gScore > scoreToBeat)) continue;
                                scoreToBeat = gScore;
                                PosteriorMerger.maxcScore[start][end][pState] = gScore;
                                PosteriorMerger.maxcSplit[start][end][pState] = split;
                                PosteriorMerger.maxcLeftChild[start][end][pState] = lState;
                                PosteriorMerger.maxcRightChild[start][end][pState] = rState;
                            }
                        }
                    }
                } else {
                    for (int tag = 0; tag < numStates; ++tag) {
                        if (!allowedStates[start][end][tag]) continue;
                        String word = sentence.get(start);
                        if (grammarTags[tag]) continue;
                        double lexiconScores = 0.0;
                        for (int gr = 0; gr < nGrammars; ++gr) {
                            double ruleScore = 0.0;
                            double[] lexiconScoreArray = lexicons[gr].score(word, (short)tag, start, false, false);
                            for (int tp = 0; tp < numSubstates[gr][tag]; ++tp) {
                                double pOS = oScores.get(gr)[start][end][tag][tp];
                                double ruleS = lexiconScoreArray[tp];
                                ruleScore += pOS * ruleS / logNormalizer[gr];
                            }
                            lexiconScores += Math.log(ruleScore);
                        }
                        if (length != iScores.get(0).length) {
                            System.err.println("Length mismatch. Expected: " + length + " Got: " + iScores.get(0).length);
                            System.err.println(sentence);
                        }
                        double scalingFactor = 0.0;
                        if (scale) {
                            for (int gr = 0; gr < nGrammars; ++gr) {
                                try {
                                    scalingFactor += (double)(oScales.get(gr)[start][end][tag] - iScales.get(gr)[0][length][0]);
                                    continue;
                                }
                                catch (ArrayIndexOutOfBoundsException e) {
                                    System.err.println("Start " + start);
                                    System.err.println("End " + end);
                                    System.err.println("Length " + length);
                                    System.err.println("Tag " + tag);
                                    System.err.println("Grammar " + gr);
                                    int[][][] oS = oScales.get(gr);
                                    System.err.println("oS.l " + oS.length);
                                    System.err.println("oS[].l " + oS[start].length);
                                    System.err.println("oS[][].l " + oS[start][end].length);
                                    int[][][] iS = iScales.get(gr);
                                    System.err.println("iS.l " + iS.length);
                                    System.err.println("iS[].l " + iS[start].length);
                                    System.err.println("iS[][].l " + iS[start][end].length);
                                    double[][][][] isS = iScores.get(gr);
                                    System.err.println("iS.l " + isS.length);
                                    System.err.println("iS[].l " + isS[start].length);
                                    System.err.println("iS[][].l " + isS[start][end].length);
                                    System.err.println("Length mismatch. Expected: " + length + " Got: " + iScales.get(gr).length);
                                    System.err.println(sentence);
                                }
                            }
                            scalingFactor = Math.log(ScalingTools.calcScaleFactor(scalingFactor));
                        }
                        PosteriorMerger.maxcScore[start][end][tag] = lexiconScores + scalingFactor;
                    }
                }
                double[] maxcScoreStartEnd = new double[numStates];
                for (int i = 0; i < numStates; ++i) {
                    maxcScoreStartEnd[i] = maxcScore[start][end][i];
                }
                for (int pState = 0; pState < numStates; pState = (int)((short)(pState + 1))) {
                    if (!allowedStates[start][end][pState]) continue;
                    UnaryRule[] unaries = grammars[0].getClosedSumUnaryRulesByParent(pState);
                    for (int r = 0; r < unaries.length; ++r) {
                        double gScore;
                        double childScore;
                        UnaryRule ur = unaries[r];
                        short cState = ur.childState;
                        if (pState == cState || !allowedStates[start][end][cState] || (childScore = maxcScore[start][end][cState]) == Double.NEGATIVE_INFINITY) continue;
                        double scalingFactor = 0.0;
                        if (scale) {
                            for (int gr = 0; gr < nGrammars; ++gr) {
                                scalingFactor += (double)(oScales.get(gr)[start][end][pState] + iScales.get(gr)[start][end][cState] - iScales.get(gr)[0][length][0]);
                            }
                            scalingFactor = Math.log(ScalingTools.calcScaleFactor(scalingFactor));
                        }
                        if ((gScore = scalingFactor + childScore) < maxcScoreStartEnd[pState]) continue;
                        for (int gr = 0; gr < nGrammars; ++gr) {
                            double ruleScore = 0.0;
                            UnaryRule rule = grammars[gr].getUnaryRule((short)pState, cState);
                            if (rule == null) {
                                System.err.println("Dont have rule " + (String)tagNumberer.object(pState) + " -> " + (String)tagNumberer.object(cState) + " in grammar " + gr);
                                continue;
                            }
                            double[][] scores = rule.getScores2();
                            int nChildStates = numSubstates[gr][cState];
                            int nParentStates = numSubstates[gr][pState];
                            for (int cp = 0; cp < nChildStates; ++cp) {
                                double cIS = iScores.get(gr)[start][end][cState][cp];
                                if (cIS == 0.0 || scores[cp] == null) continue;
                                for (int np = 0; np < nParentStates; ++np) {
                                    double ruleS;
                                    double pOS = oScores.get(gr)[start][end][pState][np];
                                    if (pOS < 0.0 || (ruleS = scores[cp][np]) == 0.0) continue;
                                    ruleScore += pOS * ruleS * cIS / logNormalizer[gr];
                                }
                            }
                            gScore += Math.log(ruleScore);
                        }
                        if (!(gScore > maxcScoreStartEnd[pState])) continue;
                        maxcScoreStartEnd[pState] = gScore;
                        PosteriorMerger.maxcChild[start][end][pState] = cState;
                    }
                }
                PosteriorMerger.maxcScore[start][end] = maxcScoreStartEnd;
            }
        }
    }

    public static List<Posterior> loadPosteriors(String fileName) {
        List posteriors = null;
        try {
            FileInputStream fis = new FileInputStream(fileName);
            GZIPInputStream gzis = new GZIPInputStream(fis);
            ObjectInputStream in = new ObjectInputStream(gzis);
            posteriors = (List)in.readObject();
            in.close();
            gzis.close();
            fis.close();
        }
        catch (IOException e) {
            System.out.println("IOException\n" + e);
            return null;
        }
        catch (ClassNotFoundException e) {
            System.out.println("Class not found!");
            return null;
        }
        return posteriors;
    }

    public static class Options {
        @Option(name="-grammarFiles", required=true, usage="Input Files for Grammars.")
        public String grammarFiles;
        @Option(name="-inputFile", usage="Read input from this file instead of reading it from STDIN.")
        public String inputFile;
        @Option(name="-outputFile", usage="Store output in this file instead of printing it to STDOUT.")
        public String outputFile;
        @Option(name="-nGrammars", usage="Number of Grammars")
        public int nGrammars;
        @Option(name="-maxLength", usage="Maximum sentence length (Default = 200).")
        public int maxLength = 200;
    }
}

