/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.ConstrainedArrayParser;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.PriorityQueue;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiThreadedParserWrapper {
    int nThreads;
    boolean allBusy;
    PriorityQueue<List<Tree<String>>> queue;
    int lastReturned;
    int lastSubmitted;
    ConstrainedArrayParser[] parsers;
    ExecutorService pool;
    Future[] submits;

    public MultiThreadedParserWrapper(ConstrainedArrayParser parser, int threads) {
        this.nThreads = threads;
        this.pool = Executors.newFixedThreadPool(this.nThreads);
        this.submits = new Future[this.nThreads];
        this.parsers = new ConstrainedArrayParser[this.nThreads];
        this.queue = new PriorityQueue();
        this.parsers[0] = parser;
        this.parsers[0].setID(0, this.queue);
        for (int i = 0; i < this.nThreads; ++i) {
            this.parsers[i] = parser.newInstance();
            this.parsers[i].setID(i, this.queue);
        }
        this.lastSubmitted = 0;
        this.lastReturned = -1;
    }

    public boolean isDone() {
        return this.lastSubmitted - 1 == this.lastReturned;
    }

    public boolean hasNext() {
        if (!this.queue.hasNext()) {
            return false;
        }
        double next = -this.queue.getPriority();
        return next == (double)(this.lastReturned + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Tree<String>> getNext() {
        if (!this.hasNext()) {
            return null;
        }
        ++this.lastReturned;
        PriorityQueue<List<Tree<String>>> priorityQueue = this.queue;
        synchronized (priorityQueue) {
            List<Tree<String>> result = this.queue.next();
            this.queue.notifyAll();
            return result;
        }
    }

    public void parseThisSentence(List<String> sentence) {
        PriorityQueue<List<Tree<String>>> priorityQueue = this.queue;
        synchronized (priorityQueue) {
            while (true) {
                for (int i = 0; i < this.nThreads; ++i) {
                    if (this.submits[i] != null && !this.submits[i].isDone()) continue;
                    this.parsers[i].setNextSentence(sentence, this.lastSubmitted++);
                    this.submits[i] = this.pool.submit(this.parsers[i]);
                    return;
                }
                try {
                    this.queue.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

