/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.HierarchicalAdaptiveLexicalRule;
import edu.berkeley.nlp.PCFGLA.HierarchicalFullyConnectedLexicon;
import edu.berkeley.nlp.PCFGLA.HierarchicalLexicon;
import edu.berkeley.nlp.PCFGLA.StateSetTreeList;
import edu.berkeley.nlp.PCFGLA.smoothing.Smoother;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Numberer;
import java.util.Arrays;

public class HierarchicalFullyConnectedAdaptiveLexicon
extends HierarchicalFullyConnectedLexicon {
    private static final long serialVersionUID = 1L;
    public HierarchicalAdaptiveLexicalRule[][] rules;

    public HierarchicalFullyConnectedAdaptiveLexicon(short[] numSubStates, int smoothingCutoff, double[] smoothParam, Smoother smoother, StateSetTreeList trainTrees, int knownWordCount) {
        super(numSubStates, knownWordCount);
        super.init(trainTrees);
        this.init();
    }

    public HierarchicalFullyConnectedAdaptiveLexicon(short[] numSubStates, int knownWordCount) {
        super(numSubStates, knownWordCount);
    }

    private void init() {
        this.scores = null;
        this.hierarchicalScores = null;
        this.finalLevels = null;
        this.rules = new HierarchicalAdaptiveLexicalRule[this.numStates][];
        for (int tag = 0; tag < this.numStates; ++tag) {
            if (this.tagWordIndexer[tag] == null) {
                this.rules[tag] = new HierarchicalAdaptiveLexicalRule[0];
                continue;
            }
            this.rules[tag] = new HierarchicalAdaptiveLexicalRule[this.tagWordIndexer[tag].size()];
            for (int word = 0; word < this.rules[tag].length; ++word) {
                this.rules[tag][word] = new HierarchicalAdaptiveLexicalRule();
            }
        }
    }

    public double[] score(int globalWordIndex, int globalSigIndex, short tag, int loc, boolean noSmoothing, boolean isSignature) {
        int i;
        int tagSpecificWordIndex;
        double[] res = new double[this.numSubStates[tag]];
        if (this.tagWordIndexer[tag] == null) {
            return res;
        }
        if (globalWordIndex != -1) {
            tagSpecificWordIndex = this.tagWordIndexer[tag].indexOf(globalWordIndex);
            if (tagSpecificWordIndex != -1) {
                for (i = 0; i < this.numSubStates[tag]; ++i) {
                    res[i] = this.rules[tag][tagSpecificWordIndex].scores[i];
                }
            } else if (this.knownWordCount > 0) {
                Arrays.fill(res, 1.0);
            }
        } else if (this.knownWordCount > 0) {
            Arrays.fill(res, 1.0);
        }
        if (globalWordIndex >= 0 && this.wordCounter[globalWordIndex] > this.knownWordCount) {
            if (this.smoother != null) {
                // empty if block
            }
            return res;
        }
        if (globalSigIndex > -1 && (tagSpecificWordIndex = this.tagWordIndexer[tag].indexOf(globalSigIndex)) != -1) {
            for (i = 0; i < this.numSubStates[tag]; ++i) {
                int n = i;
                res[n] = res[n] * this.rules[tag][tagSpecificWordIndex].scores[i];
            }
        }
        if (this.smoother != null) {
            // empty if block
        }
        return res;
    }

    public HierarchicalLexicon copyLexicon() {
        return this;
    }

    public HierarchicalLexicon splitAllStates(int[] counts, boolean moreSubstatesThanCounts, int mode) {
        int finalLevel = (int)(Math.log((int)ArrayUtil.max(this.numSubStates)) / Math.log(2.0)) + 1;
        for (int tag = 0; tag < this.numStates; ++tag) {
            int n = tag;
            this.numSubStates[n] = (short)(this.numSubStates[n] * 2);
            for (int word = 0; word < this.rules[tag].length; ++word) {
                this.rules[tag][word].splitRule(this.numSubStates[tag]);
                this.rules[tag][word].explicitlyComputeScores(finalLevel, false);
            }
        }
        return this;
    }

    public void mergeLexicon() {
        int removedParam = 0;
        for (int tag = 0; tag < this.numStates; ++tag) {
            for (int word = 0; word < this.rules[tag].length; ++word) {
                removedParam += this.rules[tag][word].mergeRule();
            }
        }
        System.out.println("Removed " + removedParam + " parameters from the lexicon.");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Numberer tagNumberer = Numberer.getGlobalNumberer("tags");
        for (int tag = 0; tag < this.rules.length; ++tag) {
            int[] counts = new int[7];
            String tagS = (String)tagNumberer.object(tag);
            if (this.rules[tag].length == 0) continue;
            for (int word = 0; word < this.rules[tag].length; ++word) {
                sb.append(tagS + " " + (String)this.wordIndexer.get(this.tagWordIndexer[tag].get(word)) + "\n");
                sb.append(this.rules[tag][word].toString());
                sb.append("\n\n");
                int n = this.rules[tag][word].hierarchy.getDepth();
                counts[n] = counts[n] + 1;
            }
            System.out.print(tagNumberer.object(tag) + ", lexical rules per level: ");
            for (int i = 1; i < 6; ++i) {
                System.out.print(counts[i] + " ");
            }
            System.out.print("\n");
        }
        return sb.toString();
    }

    public void explicitlyComputeScores(int finalLevel) {
        for (int tag = 0; tag < this.rules.length; tag = (int)((short)(tag + 1))) {
            for (int word = 0; word < this.rules[tag].length; ++word) {
                this.rules[tag][word].explicitlyComputeScores(finalLevel, false);
            }
        }
    }
}

