/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.PCFGLA;

import edu.berkeley.nlp.PCFGLA.BinaryRule;
import edu.berkeley.nlp.PCFGLA.ConstrainedArrayParser;
import edu.berkeley.nlp.PCFGLA.Grammar;
import edu.berkeley.nlp.PCFGLA.Lexicon;
import edu.berkeley.nlp.PCFGLA.SpanPredictor;
import edu.berkeley.nlp.PCFGLA.UnaryRule;
import edu.berkeley.nlp.discPCFG.Linearizer;
import edu.berkeley.nlp.math.DoubleArrays;
import edu.berkeley.nlp.math.SloppyMath;
import edu.berkeley.nlp.syntax.StateSet;
import edu.berkeley.nlp.syntax.Tree;
import edu.berkeley.nlp.util.ArrayUtil;
import edu.berkeley.nlp.util.Numberer;
import edu.berkeley.nlp.util.ScalingTools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstrainedTwoChartsParser
extends ConstrainedArrayParser {
    protected double[][][][] iScorePreU;
    protected double[][][][] iScorePostU;
    protected double[][][][] oScorePreU;
    protected double[][][][] oScorePostU;
    protected int[][][] iScale;
    protected int[][][] oScale;
    protected double[][][] maxcScore;
    protected double[][][] maxsScore;
    protected int[][][] maxcSplit;
    protected int[][][] maxcChild;
    protected int[][][] maxcLeftChild;
    protected int[][][] maxcRightChild;
    public boolean[][][][] allowedSubStates;
    double[] tmpCountsArray;
    boolean[] grammarTags;
    double[] unscaledScoresToAdd;
    int[][] goldBinaryProduction;
    int[][] goldUnaryParent;
    int[][] goldUnaryChild;
    int[] goldPOS;
    SpanPredictor spanPredictor;
    public double[][][] spanScores;
    int[] stateClass;

    public ConstrainedTwoChartsParser(Grammar gr, Lexicon lex, SpanPredictor sp) {
        this.grammar = gr;
        this.lexicon = lex;
        this.spanPredictor = sp;
        if (this.spanPredictor != null) {
            this.stateClass = this.spanPredictor.getStateClass();
        }
        this.numSubStatesArray = (short[])this.grammar.numSubStates.clone();
        this.grammarTags = this.grammar.isGrammarTag;
        this.numStates = this.grammar.numStates;
        this.scoresToAdd = new double[(int)ArrayUtil.max(this.numSubStatesArray)];
        this.unscaledScoresToAdd = new double[this.scoresToAdd.length];
        this.tmpCountsArray = new double[this.scoresToAdd.length * this.scoresToAdd.length * this.scoresToAdd.length];
        this.tagNumberer = Numberer.getGlobalNumberer("tags");
        this.arraySize = 0;
    }

    void doConstrainedInsideScores(boolean viterbi) {
        double initVal = 0.0;
        for (int diff = 1; diff <= this.length; ++diff) {
            for (int start = 0; start < this.length - diff + 1; ++start) {
                int nParentStates;
                int pState;
                int end = start + diff;
                for (pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                    if (diff == 1 || this.allowedSubStates[start][end][pState] == null) continue;
                    BinaryRule[] parentRules = this.grammar.splitRulesWithP(pState);
                    nParentStates = this.numSubStatesArray[pState];
                    boolean somethingChanged = false;
                    for (int i = 0; i < parentRules.length; ++i) {
                        int max;
                        int min;
                        boolean iPossibleR;
                        boolean iPossibleL;
                        BinaryRule r = parentRules[i];
                        short lState = r.leftChildState;
                        short rState = r.rightChildState;
                        int narrowR = this.narrowRExtent[start][lState];
                        boolean bl = iPossibleL = narrowR < end;
                        if (!iPossibleL) continue;
                        int narrowL = this.narrowLExtent[end][rState];
                        boolean bl2 = iPossibleR = narrowL >= narrowR;
                        if (!iPossibleR) continue;
                        int min1 = narrowR;
                        int min2 = this.wideLExtent[end][rState];
                        int n = min = min1 > min2 ? min1 : min2;
                        if (min > narrowL) continue;
                        int max1 = this.wideRExtent[start][lState];
                        int max2 = narrowL;
                        int n2 = max = max1 < max2 ? max1 : max2;
                        if (min > max) continue;
                        double[][][] scores = r.getScores2();
                        int nLeftChildStates = this.numSubStatesArray[lState];
                        int nRightChildStates = this.numSubStatesArray[rState];
                        int nRuleStates = scores[0][0] == null ? nParentStates : scores[0][0].length;
                        int divisor = nParentStates / nRuleStates;
                        for (int split = min; split <= max; ++split) {
                            boolean changeThisRound = false;
                            if (this.allowedSubStates[start][split][lState] == null || this.allowedSubStates[split][end][rState] == null) continue;
                            for (int lp = 0; lp < nLeftChildStates; ++lp) {
                                double lS = this.iScorePostU[start][split][lState][lp];
                                if (lS == initVal) continue;
                                for (int rp = 0; rp < nRightChildStates; ++rp) {
                                    double thisRound;
                                    double pS;
                                    int np;
                                    double rS = this.iScorePostU[split][end][rState][rp];
                                    if (rS == initVal) continue;
                                    double tmp = lS * rS;
                                    if (nRuleStates == nParentStates) {
                                        if (scores[lp][rp] == null) continue;
                                        for (np = 0; np < nParentStates; ++np) {
                                            if (!this.allowedSubStates[start][end][pState][np] || (pS = scores[lp][rp][np]) == initVal) continue;
                                            thisRound = pS * tmp;
                                            if (viterbi) {
                                                this.unscaledScoresToAdd[np] = Math.max(this.unscaledScoresToAdd[np], thisRound);
                                            } else {
                                                int n3 = np;
                                                this.unscaledScoresToAdd[n3] = this.unscaledScoresToAdd[n3] + thisRound;
                                            }
                                            changeThisRound = true;
                                        }
                                        continue;
                                    }
                                    for (np = 0; np < nRuleStates; ++np) {
                                        pS = scores[lp / divisor][rp / divisor][np];
                                        if (pS == initVal) continue;
                                        thisRound = pS * tmp;
                                        for (int nnp = 0; nnp < divisor; ++nnp) {
                                            int p = np * divisor + nnp;
                                            if (!this.allowedSubStates[start][end][pState][p]) continue;
                                            if (viterbi) {
                                                this.unscaledScoresToAdd[p] = Math.max(this.unscaledScoresToAdd[p], thisRound);
                                                continue;
                                            }
                                            int n4 = p;
                                            this.unscaledScoresToAdd[n4] = this.unscaledScoresToAdd[n4] + thisRound;
                                        }
                                        changeThisRound = true;
                                    }
                                }
                            }
                            if (!changeThisRound) continue;
                            somethingChanged = true;
                            int parentScale = this.iScale[start][end][pState];
                            int currentScale = this.iScale[start][split][lState] + this.iScale[split][end][rState];
                            if (parentScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                                if (parentScale == Integer.MIN_VALUE) {
                                    this.iScale[start][end][pState] = currentScale;
                                } else {
                                    int newScale = Math.max(currentScale, parentScale);
                                    ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                    ScalingTools.scaleArrayToScale(this.iScorePreU[start][end][pState], parentScale, newScale);
                                    this.iScale[start][end][pState] = newScale;
                                }
                            }
                            for (int np = 0; np < nParentStates; ++np) {
                                if (viterbi) {
                                    this.iScorePreU[start][end][pState][np] = Math.max(this.iScorePreU[start][end][pState][np], this.unscaledScoresToAdd[np]);
                                    continue;
                                }
                                double[] dArray = this.iScorePreU[start][end][pState];
                                int n5 = np;
                                dArray[n5] = dArray[n5] + this.unscaledScoresToAdd[np];
                            }
                            Arrays.fill(this.unscaledScoresToAdd, 0.0);
                        }
                    }
                    if (!somethingChanged) continue;
                    if (start > this.narrowLExtent[end][pState]) {
                        this.narrowLExtent[end][pState] = start;
                        this.wideLExtent[end][pState] = start;
                    } else if (start < this.wideLExtent[end][pState]) {
                        this.wideLExtent[end][pState] = start;
                    }
                    if (end < this.narrowRExtent[start][pState]) {
                        this.narrowRExtent[start][pState] = end;
                        this.wideRExtent[start][pState] = end;
                        continue;
                    }
                    if (end <= this.wideRExtent[start][pState]) continue;
                    this.wideRExtent[start][pState] = end;
                }
                for (pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                    int parentScale;
                    if (this.allowedSubStates[start][end][pState] == null || this.iScorePreU[start][end][pState] == null) continue;
                    UnaryRule[] unaries = this.grammar.getClosedSumUnaryRulesByParent(pState);
                    nParentStates = this.numSubStatesArray[pState];
                    int scaleBeforeUnaries = parentScale = this.iScale[start][end][pState];
                    boolean somethingChanged = false;
                    for (int r = 0; r < unaries.length; ++r) {
                        UnaryRule ur = unaries[r];
                        short cState = ur.childState;
                        if (pState == cState || this.allowedSubStates[start][end][cState] == null || this.iScorePreU[start][end][cState] == null) continue;
                        double[][] scores = ur.getScores2();
                        boolean changeThisRound = false;
                        int nChildStates = this.numSubStatesArray[cState];
                        for (int cp = 0; cp < nChildStates; ++cp) {
                            double iS;
                            if (scores[cp] == null || (iS = this.iScorePreU[start][end][cState][cp]) == initVal) continue;
                            for (int np = 0; np < nParentStates; ++np) {
                                double pS;
                                if (!this.allowedSubStates[start][end][pState][np]) continue;
                                if (np > scores[cp].length) {
                                    System.out.println("how come?");
                                }
                                if ((pS = scores[cp][np]) == initVal) continue;
                                double thisRound = iS * pS;
                                if (viterbi) {
                                    this.unscaledScoresToAdd[np] = Math.max(this.unscaledScoresToAdd[np], thisRound);
                                } else {
                                    int n = np;
                                    this.unscaledScoresToAdd[n] = this.unscaledScoresToAdd[n] + thisRound;
                                }
                                somethingChanged = true;
                                changeThisRound = true;
                            }
                        }
                        if (!changeThisRound) continue;
                        int currentScale = this.iScale[start][end][cState];
                        if (parentScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                            if (parentScale == Integer.MIN_VALUE) {
                                parentScale = currentScale;
                            } else {
                                int newScale = Math.max(currentScale, parentScale);
                                ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                ScalingTools.scaleArrayToScale(this.iScorePostU[start][end][pState], parentScale, newScale);
                                parentScale = newScale;
                            }
                        }
                        for (int np = 0; np < nParentStates; ++np) {
                            if (viterbi) {
                                this.iScorePostU[start][end][pState][np] = Math.max(this.iScorePostU[start][end][pState][np], this.unscaledScoresToAdd[np]);
                                continue;
                            }
                            double[] dArray = this.iScorePostU[start][end][pState];
                            int n = np;
                            dArray[n] = dArray[n] + this.unscaledScoresToAdd[np];
                        }
                        Arrays.fill(this.unscaledScoresToAdd, 0.0);
                    }
                    if (somethingChanged) {
                        int newScale = Math.max(scaleBeforeUnaries, parentScale);
                        ScalingTools.scaleArrayToScale(this.iScorePreU[start][end][pState], scaleBeforeUnaries, newScale);
                        ScalingTools.scaleArrayToScale(this.iScorePostU[start][end][pState], parentScale, newScale);
                        this.iScale[start][end][pState] = newScale;
                        if (start > this.narrowLExtent[end][pState]) {
                            this.narrowLExtent[end][pState] = start;
                            this.wideLExtent[end][pState] = start;
                        } else if (start < this.wideLExtent[end][pState]) {
                            this.wideLExtent[end][pState] = start;
                        }
                        if (end < this.narrowRExtent[start][pState]) {
                            this.narrowRExtent[start][pState] = end;
                            this.wideRExtent[start][pState] = end;
                        } else if (end > this.wideRExtent[start][pState]) {
                            this.wideRExtent[start][pState] = end;
                        }
                    }
                    for (int np = 0; np < nParentStates; ++np) {
                        double val = this.iScorePreU[start][end][pState][np];
                        if (!(val > 0.0)) continue;
                        if (viterbi) {
                            this.iScorePostU[start][end][pState][np] = Math.max(this.iScorePostU[start][end][pState][np], val);
                            continue;
                        }
                        double[] dArray = this.iScorePostU[start][end][pState];
                        int n = np;
                        dArray[n] = dArray[n] + val;
                    }
                }
            }
        }
    }

    void doConstrainedOutsideScores(boolean viterbi) {
        double initVal = 0.0;
        for (int diff = this.length; diff >= 1; --diff) {
            int start = 0;
            while (start + diff <= this.length) {
                int end = start + diff;
                for (int cState = 0; cState < this.numSubStatesArray.length; ++cState) {
                    int childScale;
                    if (this.allowedSubStates[start][end][cState] == null || end - start > 1 && !this.grammarTags[cState] || this.iScorePostU[start][end][cState] == null) continue;
                    UnaryRule[] rules = this.grammar.getClosedSumUnaryRulesByChild(cState);
                    int nChildStates = this.numSubStatesArray[cState];
                    boolean somethingChanged = false;
                    int scaleBeforeUnaries = childScale = this.oScale[start][end][cState];
                    for (int r = 0; r < rules.length; ++r) {
                        UnaryRule ur = rules[r];
                        short pState = ur.parentState;
                        if (pState == cState || this.allowedSubStates[start][end][pState] == null || this.iScorePostU[start][end][pState] == null) continue;
                        int nParentStates = this.numSubStatesArray[pState];
                        double[][] scores = ur.getScores2();
                        boolean changeThisRound = false;
                        for (int cp = 0; cp < nChildStates; ++cp) {
                            if (scores[cp] == null || !this.allowedSubStates[start][end][cState][cp]) continue;
                            for (int np = 0; np < nParentStates; ++np) {
                                double oS;
                                double pS;
                                if (!this.allowedSubStates[start][end][pState][np] || (pS = scores[cp][np]) == initVal || (oS = this.oScorePreU[start][end][pState][np]) == initVal) continue;
                                double thisRound = oS * pS;
                                if (viterbi) {
                                    this.unscaledScoresToAdd[cp] = Math.max(this.unscaledScoresToAdd[cp], thisRound);
                                } else {
                                    int n = cp;
                                    this.unscaledScoresToAdd[n] = this.unscaledScoresToAdd[n] + thisRound;
                                }
                                somethingChanged = true;
                                changeThisRound = true;
                            }
                        }
                        if (!changeThisRound) continue;
                        int currentScale = this.oScale[start][end][pState];
                        if (childScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                            if (childScale == Integer.MIN_VALUE) {
                                childScale = currentScale;
                            } else {
                                int newScale = Math.max(currentScale, childScale);
                                ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                ScalingTools.scaleArrayToScale(this.oScorePostU[start][end][cState], childScale, newScale);
                                childScale = newScale;
                            }
                        }
                        for (int cp = 0; cp < nChildStates; ++cp) {
                            if (viterbi) {
                                this.oScorePostU[start][end][cState][cp] = Math.max(this.oScorePostU[start][end][cState][cp], this.unscaledScoresToAdd[cp]);
                                continue;
                            }
                            double[] dArray = this.oScorePostU[start][end][cState];
                            int n = cp;
                            dArray[n] = dArray[n] + this.unscaledScoresToAdd[cp];
                        }
                        Arrays.fill(this.unscaledScoresToAdd, initVal);
                    }
                    if (somethingChanged) {
                        int newScale = Math.max(scaleBeforeUnaries, childScale);
                        ScalingTools.scaleArrayToScale(this.oScorePreU[start][end][cState], scaleBeforeUnaries, newScale);
                        ScalingTools.scaleArrayToScale(this.oScorePostU[start][end][cState], childScale, newScale);
                        this.oScale[start][end][cState] = newScale;
                    }
                    for (int cp = 0; cp < nChildStates; ++cp) {
                        double val = this.oScorePreU[start][end][cState][cp];
                        if (!(val > 0.0)) continue;
                        if (viterbi) {
                            this.oScorePostU[start][end][cState][cp] = Math.max(this.oScorePostU[start][end][cState][cp], val);
                            continue;
                        }
                        double[] dArray = this.oScorePostU[start][end][cState];
                        int n = cp;
                        dArray[n] = dArray[n] + val;
                    }
                }
                if (diff != 1) {
                    for (int pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                        if (this.allowedSubStates[start][end][pState] == null) continue;
                        int nParentStates = this.numSubStatesArray[pState];
                        BinaryRule[] rules = this.grammar.splitRulesWithP(pState);
                        for (int r = 0; r < rules.length; ++r) {
                            short rState;
                            int max1;
                            BinaryRule br = rules[r];
                            short lState = br.leftChildState;
                            int min1 = this.narrowRExtent[start][lState];
                            if (end < min1 || (max1 = this.narrowLExtent[end][rState = br.rightChildState]) < min1) continue;
                            int max = max1;
                            int min = min1;
                            if (max - min > 2) {
                                int min2 = this.wideLExtent[end][rState];
                                int n = min = min1 > min2 ? min1 : min2;
                                if (max1 < min) continue;
                                int max2 = this.wideRExtent[start][lState];
                                int n2 = max = max1 < max2 ? max1 : max2;
                                if (max < min) continue;
                            }
                            double[][][] scores = br.getScores2();
                            int nLeftChildStates = this.numSubStatesArray[lState];
                            int nRightChildStates = this.numSubStatesArray[rState];
                            int nRuleStates = scores[0][0] == null ? nParentStates : scores[0][0].length;
                            int divisor = nParentStates / nRuleStates;
                            for (int split = min; split <= max; ++split) {
                                int cp;
                                int newScale;
                                if (this.allowedSubStates[start][split][lState] == null || this.allowedSubStates[split][end][rState] == null || split - start > 1 && !this.grammarTags[lState] || end - split > 1 && !this.grammarTags[rState]) continue;
                                boolean somethingChanged = false;
                                for (int lp = 0; lp < nLeftChildStates; ++lp) {
                                    double lS = this.iScorePostU[start][split][lState][lp];
                                    if (lS == initVal) continue;
                                    for (int rp = 0; rp < nRightChildStates; ++rp) {
                                        double thisRoundR;
                                        double thisRoundL;
                                        double oS;
                                        double pS;
                                        int np;
                                        double rS = this.iScorePostU[split][end][rState][rp];
                                        if (rS == initVal) continue;
                                        if (nRuleStates == nParentStates) {
                                            if (scores[lp][rp] == null) continue;
                                            for (np = 0; np < nParentStates; ++np) {
                                                pS = scores[lp][rp][np];
                                                if (pS == initVal || (oS = this.oScorePostU[start][end][pState][np]) == initVal) continue;
                                                thisRoundL = pS * rS * oS;
                                                thisRoundR = pS * lS * oS;
                                                if (viterbi) {
                                                    this.scoresToAdd[lp] = Math.max(this.scoresToAdd[lp], thisRoundL);
                                                    this.unscaledScoresToAdd[rp] = Math.max(this.unscaledScoresToAdd[rp], thisRoundR);
                                                } else {
                                                    int n = lp;
                                                    this.scoresToAdd[n] = this.scoresToAdd[n] + thisRoundL;
                                                    int n3 = rp;
                                                    this.unscaledScoresToAdd[n3] = this.unscaledScoresToAdd[n3] + thisRoundR;
                                                }
                                                somethingChanged = true;
                                            }
                                            continue;
                                        }
                                        for (np = 0; np < nParentStates; ++np) {
                                            pS = scores[lp / divisor][rp / divisor][np / divisor];
                                            if (pS == initVal || (oS = this.oScorePostU[start][end][pState][np]) == initVal) continue;
                                            thisRoundL = pS * rS * oS;
                                            thisRoundR = pS * lS * oS;
                                            if (viterbi) {
                                                this.scoresToAdd[lp] = Math.max(this.scoresToAdd[lp], thisRoundL);
                                                this.unscaledScoresToAdd[rp] = Math.max(this.unscaledScoresToAdd[rp], thisRoundR);
                                            } else {
                                                int n = lp;
                                                this.scoresToAdd[n] = this.scoresToAdd[n] + thisRoundL;
                                                int n4 = rp;
                                                this.unscaledScoresToAdd[n4] = this.unscaledScoresToAdd[n4] + thisRoundR;
                                            }
                                            somethingChanged = true;
                                        }
                                    }
                                }
                                if (!somethingChanged) continue;
                                if (DoubleArrays.max(this.scoresToAdd) != 0.0) {
                                    int leftScale = this.oScale[start][split][lState];
                                    int currentScale = this.oScale[start][end][pState] + this.iScale[split][end][rState];
                                    if (leftScale != (currentScale = ScalingTools.scaleArray(this.scoresToAdd, currentScale))) {
                                        if (leftScale == Integer.MIN_VALUE) {
                                            this.oScale[start][split][lState] = currentScale;
                                        } else {
                                            newScale = Math.max(currentScale, leftScale);
                                            ScalingTools.scaleArrayToScale(this.scoresToAdd, currentScale, newScale);
                                            ScalingTools.scaleArrayToScale(this.oScorePreU[start][split][lState], leftScale, newScale);
                                            this.oScale[start][split][lState] = newScale;
                                        }
                                    }
                                    for (cp = 0; cp < nLeftChildStates; ++cp) {
                                        if (!(this.scoresToAdd[cp] > initVal)) continue;
                                        if (viterbi) {
                                            this.oScorePreU[start][split][lState][cp] = Math.max(this.oScorePreU[start][split][lState][cp], this.scoresToAdd[cp]);
                                            continue;
                                        }
                                        double[] dArray = this.oScorePreU[start][split][lState];
                                        int n = cp;
                                        dArray[n] = dArray[n] + this.scoresToAdd[cp];
                                    }
                                    Arrays.fill(this.scoresToAdd, 0.0);
                                }
                                if (DoubleArrays.max(this.unscaledScoresToAdd) == 0.0) continue;
                                int rightScale = this.oScale[split][end][rState];
                                int currentScale = this.oScale[start][end][pState] + this.iScale[start][split][lState];
                                if (currentScale == Integer.MIN_VALUE) {
                                    System.out.println("shhaaa");
                                }
                                if (rightScale != (currentScale = ScalingTools.scaleArray(this.unscaledScoresToAdd, currentScale))) {
                                    if (rightScale == Integer.MIN_VALUE) {
                                        this.oScale[split][end][rState] = currentScale;
                                    } else {
                                        newScale = Math.max(currentScale, rightScale);
                                        ScalingTools.scaleArrayToScale(this.unscaledScoresToAdd, currentScale, newScale);
                                        ScalingTools.scaleArrayToScale(this.oScorePreU[split][end][rState], rightScale, newScale);
                                        this.oScale[split][end][rState] = newScale;
                                    }
                                }
                                for (cp = 0; cp < nRightChildStates; ++cp) {
                                    if (!(this.unscaledScoresToAdd[cp] > initVal)) continue;
                                    if (viterbi) {
                                        this.oScorePreU[split][end][rState][cp] = Math.max(this.oScorePreU[split][end][rState][cp], this.unscaledScoresToAdd[cp]);
                                        continue;
                                    }
                                    double[] dArray = this.oScorePreU[split][end][rState];
                                    int n = cp;
                                    dArray[n] = dArray[n] + this.unscaledScoresToAdd[cp];
                                }
                                Arrays.fill(this.unscaledScoresToAdd, 0.0);
                            }
                        }
                    }
                }
                ++start;
            }
        }
    }

    void initializeChart(List<StateSet> sentence, boolean noSmoothing, List<String> posTags) {
        boolean useGoldPOS = posTags != null;
        int start = 0;
        int end = start + 1;
        for (StateSet word : sentence) {
            end = start + 1;
            short goldTag = -1;
            if (useGoldPOS) {
                goldTag = this.tagNumberer.number(posTags.get(start));
            }
            for (short tag = 0; tag < this.numSubStatesArray.length; tag = (short)((short)(tag + 1))) {
                if (this.allowedSubStates[start][end][tag] == null || this.grammarTags[tag] || useGoldPOS && tag != goldTag) continue;
                this.narrowRExtent[start][tag] = end;
                this.narrowLExtent[end][tag] = start;
                this.wideRExtent[start][tag] = end;
                this.wideLExtent[end][tag] = start;
                double[] lexiconScores = this.lexicon.score(word, tag, noSmoothing, false);
                this.iScale[start][end][tag] = 0;
                for (int n = 0; n < lexiconScores.length; n = (int)((short)(n + 1))) {
                    double prob;
                    if (!this.allowedSubStates[start][end][tag][n]) continue;
                    this.iScorePreU[start][end][tag][n] = prob = lexiconScores[n];
                }
            }
            ++start;
        }
    }

    @Override
    protected void createArrays() {
        if (this.arraySize < this.length) {
            this.arraySize = this.length;
            this.iScorePreU = new double[this.length][this.length + 1][][];
            this.iScorePostU = new double[this.length][this.length + 1][][];
            this.oScorePreU = new double[this.length][this.length + 1][][];
            this.oScorePostU = new double[this.length][this.length + 1][][];
            this.iScale = new int[this.length][this.length + 1][];
            this.oScale = new int[this.length][this.length + 1][];
            for (int start = 0; start < this.length; ++start) {
                for (int end = start + 1; end <= this.length; ++end) {
                    this.iScorePreU[start][end] = new double[this.numStates][];
                    this.iScorePostU[start][end] = new double[this.numStates][];
                    this.oScorePreU[start][end] = new double[this.numStates][];
                    this.oScorePostU[start][end] = new double[this.numStates][];
                    this.iScale[start][end] = new int[this.numStates];
                    this.oScale[start][end] = new int[this.numStates];
                    Arrays.fill(this.iScale[start][end], Integer.MIN_VALUE);
                    Arrays.fill(this.oScale[start][end], Integer.MIN_VALUE);
                    for (int state = 0; state < this.numSubStatesArray.length; ++state) {
                        if (end - start > 1 && !this.grammarTags[state]) continue;
                        this.iScorePreU[start][end][state] = new double[this.numSubStatesArray[state]];
                        this.iScorePostU[start][end][state] = new double[this.numSubStatesArray[state]];
                        this.oScorePreU[start][end][state] = new double[this.numSubStatesArray[state]];
                        this.oScorePostU[start][end][state] = new double[this.numSubStatesArray[state]];
                    }
                }
            }
            this.narrowRExtent = new int[this.length + 1][this.numStates];
            this.wideRExtent = new int[this.length + 1][this.numStates];
            this.narrowLExtent = new int[this.length + 1][this.numStates];
            this.wideLExtent = new int[this.length + 1][this.numStates];
            for (int loc = 0; loc <= this.length; ++loc) {
                Arrays.fill(this.narrowLExtent[loc], -1);
                Arrays.fill(this.wideLExtent[loc], this.length + 1);
                Arrays.fill(this.narrowRExtent[loc], this.length + 1);
                Arrays.fill(this.wideRExtent[loc], -1);
            }
        }
    }

    @Override
    public Tree<String> getBestConstrainedParse(List<String> sentence, List<String> posTags, boolean[][][][] allowedStates) {
        boolean noSmoothing = false;
        List<StateSet> testSentenceStateSet = this.convertToTestSet(sentence);
        double ll = this.doConstrainedInsideOutsideScores(testSentenceStateSet, allowedStates, noSmoothing, null, posTags, this.viterbi);
        Tree<String> bestTree = null;
        if (ll == Double.NEGATIVE_INFINITY) {
            return new Tree<String>("ROOT");
        }
        if (this.viterbi) {
            bestTree = this.extractBestViterbiParse(0, 0, 0, this.length, sentence, true);
        } else {
            if (this.spanScores == null) {
                this.doConstrainedMaxCScores(testSentenceStateSet);
            } else {
                this.doConstrainedMaxCScores(testSentenceStateSet, this.spanScores);
            }
            bestTree = this.extractBestMaxRuleParse(0, this.length, sentence);
        }
        this.maxcScore = null;
        this.maxcSplit = null;
        this.maxcChild = null;
        this.maxcLeftChild = null;
        this.maxcRightChild = null;
        return bestTree;
    }

    void doConstrainedMaxCScores(List<StateSet> sentence) {
        this.maxcScore = new double[this.length][this.length + 1][this.numStates];
        this.maxcSplit = new int[this.length][this.length + 1][this.numStates];
        this.maxcChild = new int[this.length][this.length + 1][this.numStates];
        this.maxcLeftChild = new int[this.length][this.length + 1][this.numStates];
        this.maxcRightChild = new int[this.length][this.length + 1][this.numStates];
        double tree_score = this.iScorePostU[0][this.length][0][0];
        int tree_scale = this.iScale[0][this.length][0];
        for (int diff = 1; diff <= this.length; ++diff) {
            for (int start = 0; start < this.length - diff + 1; ++start) {
                int end = start + diff;
                Arrays.fill(this.maxcSplit[start][end], -1);
                Arrays.fill(this.maxcChild[start][end], -1);
                Arrays.fill(this.maxcLeftChild[start][end], -1);
                Arrays.fill(this.maxcRightChild[start][end], -1);
                if (diff > 1) {
                    for (int pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                        if (this.allowedSubStates[start][end][pState] == null) continue;
                        BinaryRule[] parentRules = this.grammar.splitRulesWithP(pState);
                        int nParentStates = this.numSubStatesArray[pState];
                        for (int i = 0; i < parentRules.length; ++i) {
                            int max;
                            int min;
                            boolean iPossibleR;
                            boolean iPossibleL;
                            BinaryRule r = parentRules[i];
                            short lState = r.leftChildState;
                            short rState = r.rightChildState;
                            int narrowR = this.narrowRExtent[start][lState];
                            boolean bl = iPossibleL = narrowR < end;
                            if (!iPossibleL) continue;
                            int narrowL = this.narrowLExtent[end][rState];
                            boolean bl2 = iPossibleR = narrowL >= narrowR;
                            if (!iPossibleR) continue;
                            int min1 = narrowR;
                            int min2 = this.wideLExtent[end][rState];
                            int n = min = min1 > min2 ? min1 : min2;
                            if (min > narrowL) continue;
                            int max1 = this.wideRExtent[start][lState];
                            int max2 = narrowL;
                            int n2 = max = max1 < max2 ? max1 : max2;
                            if (min > max) continue;
                            double[][][] scores = r.getScores2();
                            int nLeftChildStates = this.numSubStatesArray[lState];
                            int nRightChildStates = this.numSubStatesArray[rState];
                            for (int split = min; split <= max; ++split) {
                                double rightChildScore;
                                double leftChildScore;
                                double gScore;
                                double scalingFactor;
                                double ruleScore = 0.0;
                                if (this.allowedSubStates[start][split][lState] == null || this.allowedSubStates[split][end][rState] == null || (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][pState] + this.iScale[start][split][lState] + this.iScale[split][end][rState] - tree_scale)) == 0.0) continue;
                                for (int lp = 0; lp < nLeftChildStates; ++lp) {
                                    double lIS = this.iScorePostU[start][split][lState][lp];
                                    if (lIS == 0.0) continue;
                                    for (int rp = 0; rp < nRightChildStates; ++rp) {
                                        double rIS;
                                        if (scores[lp][rp] == null || (rIS = this.iScorePostU[split][end][rState][rp]) == 0.0) continue;
                                        for (int np = 0; np < nParentStates; ++np) {
                                            double ruleS;
                                            double pOS = this.oScorePostU[start][end][pState][np];
                                            if (pOS == 0.0 || (ruleS = scores[lp][rp][np]) == 0.0) continue;
                                            ruleScore += pOS * scalingFactor * ruleS / tree_score * lIS * rIS;
                                        }
                                    }
                                }
                                if (ruleScore == 0.0 || !((gScore = ruleScore * (leftChildScore = this.maxcScore[start][split][lState]) * (rightChildScore = this.maxcScore[split][end][rState])) > this.maxcScore[start][end][pState])) continue;
                                this.maxcScore[start][end][pState] = gScore;
                                this.maxcSplit[start][end][pState] = split;
                                this.maxcLeftChild[start][end][pState] = lState;
                                this.maxcRightChild[start][end][pState] = rState;
                            }
                        }
                    }
                } else {
                    for (short tag = 0; tag < this.numSubStatesArray.length; tag = (short)((short)(tag + 1))) {
                        double scalingFactor;
                        if (this.allowedSubStates[start][end][tag] == null || this.grammar.isGrammarTag(tag) || (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][tag] - tree_scale)) == 0.0) continue;
                        int nTagStates = this.numSubStatesArray[tag];
                        StateSet word = sentence.get(start);
                        double[] lexiconScoreArray = this.lexicon.score(word, tag, false, false);
                        double lexiconScores = 0.0;
                        for (int tp = 0; tp < nTagStates; ++tp) {
                            double ruleS;
                            double pOS = this.oScorePostU[start][end][tag][tp];
                            if (pOS == 0.0 || (ruleS = lexiconScoreArray[tp]) == 0.0) continue;
                            lexiconScores += pOS * ruleS / tree_score;
                        }
                        if (lexiconScores == 0.0) continue;
                        this.maxcScore[start][end][tag] = lexiconScores * scalingFactor;
                    }
                }
                double[] maxcScoreStartEnd = new double[this.numStates];
                for (int i = 0; i < this.numStates; ++i) {
                    maxcScoreStartEnd[i] = this.maxcScore[start][end][i];
                }
                for (int pState = 0; pState < this.numSubStatesArray.length; ++pState) {
                    if (this.allowedSubStates[start][end][pState] == null) continue;
                    UnaryRule[] unaries = this.grammar.getClosedSumUnaryRulesByParent(pState);
                    int nParentStates = this.numSubStatesArray[pState];
                    for (int r = 0; r < unaries.length; ++r) {
                        double childScore;
                        double gScore;
                        UnaryRule ur = unaries[r];
                        short cState = ur.childState;
                        if (pState == cState || this.allowedSubStates[start][end][cState] == null) continue;
                        double[][] scores = ur.getScores2();
                        int nChildStates = this.numSubStatesArray[cState];
                        double ruleScore = 0.0;
                        double scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][pState] + this.iScale[start][end][cState] - tree_scale);
                        if (scalingFactor == 0.0) continue;
                        for (int cp = 0; cp < nChildStates; ++cp) {
                            double cIS = this.iScorePreU[start][end][cState][cp];
                            if (cIS == 0.0 || scores[cp] == null) continue;
                            for (int np = 0; np < nParentStates; ++np) {
                                double ruleS;
                                double pOS = this.oScorePreU[start][end][pState][np];
                                if (pOS == 0.0 || (ruleS = scores[cp][np]) == 0.0) continue;
                                ruleScore += pOS * scalingFactor * ruleS / tree_score * cIS;
                            }
                        }
                        if (ruleScore == 0.0 || !((gScore = ruleScore * (childScore = this.maxcScore[start][end][cState])) > maxcScoreStartEnd[pState])) continue;
                        maxcScoreStartEnd[pState] = gScore;
                        this.maxcChild[start][end][pState] = cState;
                    }
                }
                this.maxcScore[start][end] = maxcScoreStartEnd;
            }
        }
    }

    public double doConstrainedInsideOutsideScores(List<StateSet> sentence, boolean[][][][] allowed, boolean noSmoothing, Tree<StateSet> goldTree, List<String> posTags, boolean viterbi) {
        this.scrubArrays();
        this.length = (short)sentence.size();
        if (allowed != null) {
            this.allowedSubStates = allowed;
        } else {
            this.setConstraints(null, false);
        }
        this.createArrays();
        this.initializeChart(sentence, noSmoothing, posTags);
        double logLikelihood = Double.NEGATIVE_INFINITY;
        if (this.spanPredictor != null) {
            this.spanScores = this.spanPredictor.predictSpans(sentence);
            this.doConstrainedInsideScores(viterbi, this.spanScores);
            logLikelihood = this.getLikelihoodAndSetRootOutsideScore();
            this.doConstrainedOutsideScores(viterbi, this.spanScores);
        } else {
            this.doConstrainedInsideScores(viterbi);
            logLikelihood = this.getLikelihoodAndSetRootOutsideScore();
            this.doConstrainedOutsideScores(viterbi);
        }
        return logLikelihood;
    }

    void doConstrainedMaxCScores(List<StateSet> testSentenceStateSet, double[][][] spanScores2) {
        throw new Error("Currently not supported");
    }

    void doConstrainedOutsideScores(boolean viterbi, double[][][] spanScores2) {
        throw new Error("Currently not supported");
    }

    void doConstrainedInsideScores(boolean viterbi, double[][][] spanScores2) {
        throw new Error("Currently not supported");
    }

    protected double getLikelihoodAndSetRootOutsideScore() {
        this.oScorePreU[0][this.length][0][0] = 1.0;
        this.oScale[0][this.length][0] = 0;
        return Math.log(this.iScorePostU[0][this.length][0][0]) + (double)(100 * this.iScale[0][this.length][0]);
    }

    protected void scrubArrays() {
        if (this.iScorePostU == null) {
            return;
        }
        for (int start = 0; start < this.length; ++start) {
            for (int end = start + 1; end <= this.length; ++end) {
                for (int state = 0; state < this.numSubStatesArray.length; ++state) {
                    if (this.allowedSubStates[start][end][state] == null || end - start > 1 && !this.grammarTags[state]) continue;
                    Arrays.fill(this.iScorePreU[start][end][state], 0.0);
                    Arrays.fill(this.iScorePostU[start][end][state], 0.0);
                    Arrays.fill(this.oScorePreU[start][end][state], 0.0);
                    Arrays.fill(this.oScorePostU[start][end][state], 0.0);
                    Arrays.fill(this.iScale[start][end], Integer.MIN_VALUE);
                    Arrays.fill(this.oScale[start][end], Integer.MIN_VALUE);
                }
            }
        }
        for (int loc = 0; loc <= this.length; ++loc) {
            Arrays.fill(this.narrowLExtent[loc], -1);
            Arrays.fill(this.wideLExtent[loc], this.length + 1);
            Arrays.fill(this.narrowRExtent[loc], this.length + 1);
            Arrays.fill(this.wideRExtent[loc], -1);
        }
    }

    protected void setConstraints(boolean[][][][] allowedSubStates2, boolean allSubstates) {
        this.allowedSubStates = new boolean[this.length][this.length + 1][][];
        for (int start = 0; start < this.length; ++start) {
            for (int end = start + 1; end <= this.length; ++end) {
                this.allowedSubStates[start][end] = new boolean[this.numStates][];
                for (int state = 0; state < this.numStates; ++state) {
                    if (allowedSubStates2 == null) {
                        if (end - start > 1 && !this.grammarTags[state]) continue;
                        boolean[] tmp = new boolean[this.numSubStatesArray[state]];
                        Arrays.fill(tmp, true);
                        this.allowedSubStates[start][end][state] = tmp;
                        continue;
                    }
                    if (allowedSubStates2[start][end][state] == null) continue;
                    this.allowedSubStates[start][end][state] = new boolean[this.numSubStatesArray[state]];
                    if (allSubstates) {
                        Arrays.fill(this.allowedSubStates[start][end][state], true);
                        continue;
                    }
                    for (int substate = 0; substate < allowedSubStates2[start][end][state].length; ++substate) {
                        if (!allowedSubStates2[start][end][state][substate]) continue;
                        this.allowedSubStates[start][end][state][2 * substate] = true;
                        if (state == 0) continue;
                        this.allowedSubStates[start][end][state][2 * substate + 1] = true;
                    }
                }
            }
        }
    }

    public void incrementExpectedCounts(Linearizer linearizer, double[] probs, List<StateSet> sentence) {
        double tree_score = this.iScorePostU[0][this.length][0][0];
        int tree_scale = this.iScale[0][this.length][0];
        if (SloppyMath.isDangerous(tree_score)) {
            System.out.println("Training tree has zero probability - presumably underflow!");
            return;
        }
        for (int start = 0; start < this.length; ++start) {
            int lastState = this.numSubStatesArray.length;
            StateSet currentStateSet = sentence.get(start);
            for (int tag = 0; tag < lastState; ++tag) {
                double scalingFactor;
                if (this.grammar.isGrammarTag(tag) || this.allowedSubStates[start][start + 1][tag] == null || (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][start + 1][tag] + this.iScale[start][start + 1][tag] - tree_scale)) == 0.0) continue;
                short nSubStates = this.numSubStatesArray[tag];
                for (short substate = 0; substate < nSubStates; substate = (short)(substate + 1)) {
                    double weight;
                    double oS;
                    double iS = this.iScorePreU[start][start + 1][tag][substate];
                    if (iS == 0.0 || (oS = this.oScorePostU[start][start + 1][tag][substate]) == 0.0 || !this.isValidExpectation(weight = iS / tree_score * scalingFactor * oS)) continue;
                    this.tmpCountsArray[substate] = weight;
                }
                linearizer.increment(probs, currentStateSet, tag, this.tmpCountsArray, false);
            }
        }
        for (int diff = 1; diff <= this.length; ++diff) {
            for (int start = 0; start < this.length - diff + 1; ++start) {
                int end = start + diff;
                int lastState = this.numSubStatesArray.length;
                for (int pState = 0; pState < lastState; pState = (int)((short)(pState + 1))) {
                    if (diff == 1 || this.allowedSubStates[start][end][pState] == null) continue;
                    int nParentSubStates = this.numSubStatesArray[pState];
                    BinaryRule[] parentRules = this.grammar.splitRulesWithP(pState);
                    for (int i = 0; i < parentRules.length; ++i) {
                        int max;
                        int min;
                        boolean iPossibleR;
                        boolean iPossibleL;
                        BinaryRule r = parentRules[i];
                        short lState = r.leftChildState;
                        short rState = r.rightChildState;
                        int narrowR = this.narrowRExtent[start][lState];
                        boolean bl = iPossibleL = narrowR < end;
                        if (!iPossibleL) continue;
                        int narrowL = this.narrowLExtent[end][rState];
                        boolean bl2 = iPossibleR = narrowL >= narrowR;
                        if (!iPossibleR) continue;
                        int min1 = narrowR;
                        int min2 = this.wideLExtent[end][rState];
                        int n = min = min1 > min2 ? min1 : min2;
                        if (min > narrowL) continue;
                        int max1 = this.wideRExtent[start][lState];
                        int max2 = narrowL;
                        int n2 = max = max1 < max2 ? max1 : max2;
                        if (min > max) continue;
                        double[][][] scores = r.getScores2();
                        boolean foundSomething = false;
                        int nRuleStates = scores[0][0].length;
                        int divisor = nParentSubStates / nRuleStates;
                        for (int split = min; split <= max; ++split) {
                            double scalingFactor;
                            if (this.allowedSubStates[start][split][lState] == null || this.allowedSubStates[split][end][rState] == null || (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][pState] + this.iScale[start][split][lState] + this.iScale[split][end][rState] - tree_scale)) == 0.0) continue;
                            int curInd = 0;
                            for (int lp = 0; lp < scores.length; ++lp) {
                                double lcIS = this.iScorePostU[start][split][lState][lp];
                                if (lcIS == 0.0) {
                                    curInd += scores[0].length * nParentSubStates;
                                    continue;
                                }
                                double tmpA = lcIS / tree_score;
                                for (int rp = 0; rp < scores[0].length; ++rp) {
                                    double ruleCount;
                                    double rS;
                                    double pOS;
                                    int np;
                                    double rcIS = this.iScorePostU[split][end][rState][rp];
                                    if (rcIS == 0.0) {
                                        curInd += nParentSubStates;
                                        continue;
                                    }
                                    double tmpB = tmpA * rcIS * scalingFactor;
                                    if (nRuleStates == nParentSubStates) {
                                        for (np = 0; np < nParentSubStates; ++np) {
                                            pOS = this.oScorePostU[start][end][pState][np];
                                            if (pOS == 0.0) {
                                                ++curInd;
                                                continue;
                                            }
                                            rS = scores[lp][rp][np];
                                            ruleCount = rS * tmpB * pOS;
                                            if (this.isValidExpectation(ruleCount)) {
                                                int n3 = curInd;
                                                this.tmpCountsArray[n3] = this.tmpCountsArray[n3] + ruleCount;
                                                foundSomething = true;
                                            }
                                            ++curInd;
                                        }
                                        continue;
                                    }
                                    for (np = 0; np < nParentSubStates; ++np) {
                                        pOS = this.oScorePostU[start][end][pState][np];
                                        if (pOS == 0.0) {
                                            ++curInd;
                                            continue;
                                        }
                                        rS = scores[lp / divisor][rp / divisor][np / divisor];
                                        ruleCount = rS * tmpB * pOS;
                                        if (this.isValidExpectation(ruleCount)) {
                                            int n4 = curInd;
                                            this.tmpCountsArray[n4] = this.tmpCountsArray[n4] + ruleCount;
                                            foundSomething = true;
                                        }
                                        ++curInd;
                                    }
                                }
                            }
                        }
                        if (!foundSomething) continue;
                        linearizer.increment(probs, r, this.tmpCountsArray, false);
                    }
                }
                int lastStateU = this.numSubStatesArray.length;
                for (int pState = 0; pState < lastStateU; pState = (int)((short)(pState + 1))) {
                    UnaryRule[] unaries;
                    if (this.allowedSubStates[start][end][pState] == null) continue;
                    int nParentSubStates = this.numSubStatesArray[pState];
                    for (UnaryRule ur : unaries = this.grammar.getClosedSumUnaryRulesByParent(pState)) {
                        double scalingFactor;
                        short cState = ur.childState;
                        if (pState == cState || this.allowedSubStates[start][end][cState] == null || (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][pState] + this.iScale[start][end][cState] - tree_scale)) == 0.0) continue;
                        double[][] scores = ur.getScores2();
                        int curInd = 0;
                        for (int cp = 0; cp < scores.length; ++cp) {
                            if (scores[cp] == null) continue;
                            double cIS = this.iScorePreU[start][end][cState][cp];
                            if (cIS == 0.0) {
                                curInd += nParentSubStates;
                                continue;
                            }
                            double tmpA = cIS / tree_score * scalingFactor;
                            for (int np = 0; np < nParentSubStates; ++np) {
                                double pOS = this.oScorePreU[start][end][pState][np];
                                if (pOS == 0.0) {
                                    ++curInd;
                                    continue;
                                }
                                double rS = scores[cp][np];
                                double ruleCount = rS * tmpA * pOS;
                                if (this.isValidExpectation(ruleCount)) {
                                    this.tmpCountsArray[curInd] = ruleCount;
                                }
                                ++curInd;
                            }
                        }
                        linearizer.increment(probs, ur, this.tmpCountsArray, false);
                    }
                }
            }
        }
    }

    public boolean isValidExpectation(double val) {
        return val > 0.0 && val < 1.01;
    }

    public void updateGrammarAndLexicon(Grammar grammar2, Lexicon lexicon2) {
        this.grammar = grammar2;
        this.lexicon = lexicon2;
    }

    public boolean[][][][] getPossibleStates(List<String> testSentence, Tree<StateSet> tree, double threshold, boolean[][][][] previousConstraints, StringBuilder sb) {
        int possibleSubStates2;
        boolean noSmoothing = false;
        int previouslyPossibleSub = (this.countPossibleSubStates(previousConstraints) - 1) / 2;
        int previouslyPossible = this.countPossibleStates(previousConstraints);
        List<StateSet> testSentenceStateSet = this.convertToTestSet(testSentence);
        this.doConstrainedInsideOutsideScores(testSentenceStateSet, previousConstraints, noSmoothing, null, null, true);
        boolean[][][][] allowedStates = this.computeAllowedStates(threshold);
        if (allowedStates[0][testSentence.size()][0] == null) {
            System.out.println("Root got pruned!");
        }
        int possibleStates = this.countPossibleStates(allowedStates);
        int possibleSubStates = this.countPossibleSubStates(allowedStates);
        if (tree != null) {
            if (possibleSubStates == 0) {
                sb.append("Only gold tree is left!");
            }
            this.putGoldTreeBackIn(tree, allowedStates);
        }
        if (possibleSubStates != (possibleSubStates2 = this.countPossibleSubStates(allowedStates))) {
            sb.append(", saved gold tree");
            possibleSubStates = possibleSubStates2;
            possibleStates = this.countPossibleStates(allowedStates);
        }
        if (possibleSubStates2 == 0) {
            sb.append(", Parse failure! No pruning!");
            allowedStates = previousConstraints;
            possibleSubStates = previouslyPossible;
        }
        sb.append(", from: " + previouslyPossibleSub + " (" + previouslyPossible + ") to: " + possibleSubStates + " (" + possibleStates + ") substates.");
        return allowedStates;
    }

    protected List<StateSet> convertToTestSet(List<String> testSentence) {
        ArrayList<StateSet> list = new ArrayList<StateSet>(testSentence.size());
        short ind = 0;
        for (String word : testSentence) {
            StateSet stateSet = new StateSet(-1, 1, word, ind, (short)(ind + 1));
            ind = (short)(ind + 1);
            stateSet.wordIndex = -2;
            stateSet.sigIndex = -2;
            list.add(stateSet);
        }
        return list;
    }

    private int countPossibleSubStates(boolean[][][][] allowedStates) {
        if (allowedStates == null) {
            return 0;
        }
        int possibleStates = 0;
        for (int start = 0; start < allowedStates.length; ++start) {
            for (int end = start + 1; end <= allowedStates.length; ++end) {
                int lastState = this.numSubStatesArray.length;
                for (int state = 0; state < lastState; ++state) {
                    if (allowedStates[start][end][state] == null) continue;
                    for (int substate = 0; substate < allowedStates[start][end][state].length; ++substate) {
                        if (!allowedStates[start][end][state][substate]) continue;
                        ++possibleStates;
                    }
                }
            }
        }
        return possibleStates;
    }

    private int countPossibleStates(boolean[][][][] allowedStates) {
        if (allowedStates == null) {
            return 0;
        }
        int possibleStates = 0;
        for (int start = 0; start < allowedStates.length; ++start) {
            for (int end = start + 1; end <= allowedStates.length; ++end) {
                int lastState = this.numSubStatesArray.length;
                block2: for (int state = 0; state < lastState; ++state) {
                    if (allowedStates[start][end][state] == null) continue;
                    for (int substate = 0; substate < allowedStates[start][end][state].length; ++substate) {
                        if (!allowedStates[start][end][state][substate]) continue;
                        ++possibleStates;
                        continue block2;
                    }
                }
            }
        }
        return possibleStates;
    }

    private void putGoldTreeBackIn(Tree<StateSet> tree, boolean[][][][] allowedStates) {
        StateSet node = tree.getLabel();
        short state = node.getState();
        if (state < this.numStates) {
            boolean[] tmp = new boolean[this.numSubStatesArray[state]];
            Arrays.fill(tmp, true);
            allowedStates[node.from][node.to][state] = tmp;
        } else {
            System.out.println("Haven't seen state " + node);
        }
        for (Tree<StateSet> child : tree.getChildren()) {
            if (child.isLeaf()) continue;
            this.putGoldTreeBackIn(child, allowedStates);
        }
    }

    boolean[][][][] computeAllowedStates(double threshold) {
        double tree_score = this.iScorePostU[0][this.length][0][0];
        int tree_scale = this.iScale[0][this.length][0];
        boolean[][][][] result = new boolean[this.length][this.length + 1][][];
        for (int start = 0; start < this.length; ++start) {
            for (int end = start + 1; end <= this.length; ++end) {
                result[start][end] = new boolean[this.numStates][];
                int lastState = this.numSubStatesArray.length;
                for (int state = 0; state < lastState; ++state) {
                    if (this.allowedSubStates[start][end][state] == null) continue;
                    boolean atLeastOnePossible = false;
                    for (int substate = 0; substate < this.numSubStatesArray[state]; ++substate) {
                        double tmp;
                        double posterior;
                        double scalingFactor;
                        double oS;
                        double iS;
                        if (!this.allowedSubStates[start][end][state][substate] || (iS = this.iScorePostU[start][end][state][substate]) == 0.0 || (oS = this.oScorePostU[start][end][state][substate]) == 0.0 || (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][state] + this.iScale[start][end][state] - tree_scale)) == 0.0 || !((posterior = (tmp = Math.max(iS * this.oScorePreU[start][end][state][substate], this.iScorePreU[start][end][state][substate] * oS)) / tree_score * scalingFactor) > threshold)) continue;
                        if (result[start][end][state] == null) {
                            result[start][end][state] = new boolean[this.numSubStatesArray[state]];
                        }
                        result[start][end][state][substate] = true;
                        atLeastOnePossible = true;
                    }
                    if (atLeastOnePossible) continue;
                    result[start][end][state] = null;
                }
            }
        }
        return result;
    }

    public Tree<String> extractBestMaxRuleParse(int start, int end, List<String> sentence) {
        return this.extractBestMaxRuleParse1(start, end, 0, sentence);
    }

    public Tree<String> extractBestMaxRuleParse1(int start, int end, int state, List<String> sentence) {
        int intermediateNode;
        int cState = this.maxcChild[start][end][state];
        if (cState == -1) {
            return this.extractBestMaxRuleParse2(start, end, state, sentence);
        }
        ArrayList child = new ArrayList();
        child.add(this.extractBestMaxRuleParse2(start, end, cState, sentence));
        String stateStr = (String)this.tagNumberer.object(state);
        if (stateStr.endsWith("^g")) {
            stateStr = stateStr.substring(0, stateStr.length() - 2);
        }
        if ((intermediateNode = this.grammar.getUnaryIntermediate((short)state, (short)cState)) == 0) {
            // empty if block
        }
        if (intermediateNode > 0) {
            ArrayList restoredChild = new ArrayList();
            String stateStr2 = (String)this.tagNumberer.object(intermediateNode);
            if (stateStr2.endsWith("^g")) {
                stateStr2 = stateStr2.substring(0, stateStr2.length() - 2);
            }
            restoredChild.add(new Tree<String>(stateStr2, child));
            return new Tree<String>(stateStr, restoredChild);
        }
        return new Tree<String>(stateStr, child);
    }

    public Tree<String> extractBestMaxRuleParse2(int start, int end, int state, List<String> sentence) {
        boolean posLevel;
        ArrayList children = new ArrayList();
        String stateStr = (String)this.tagNumberer.object(state);
        if (stateStr.endsWith("^g")) {
            stateStr = stateStr.substring(0, stateStr.length() - 2);
        }
        boolean bl = posLevel = end - start == 1;
        if (posLevel) {
            if (this.grammar.isGrammarTag(state)) {
                ArrayList childs = new ArrayList();
                childs.add(new Tree<String>(sentence.get(start)));
                String stateStr2 = (String)this.tagNumberer.object(this.maxcChild[start][end][state]);
                children.add(new Tree<String>(stateStr2, childs));
            } else {
                children.add(new Tree<String>(sentence.get(start)));
            }
        } else {
            int split = this.maxcSplit[start][end][state];
            if (split == -1) {
                System.err.println("Warning: no symbol can generate the span from " + start + " to " + end + ".");
                System.err.println("The score is " + this.maxcScore[start][end][state] + " and the state is supposed to be " + stateStr);
                System.err.println("The insideScores are " + Arrays.toString(this.iScorePostU[start][end][state]) + " and the outsideScores are " + Arrays.toString(this.oScorePostU[start][end][state]));
                System.err.println("The maxcScore is " + this.maxcScore[start][end][state]);
                for (short start2 = 0; start2 < this.length; start2 = (short)(start2 + 1)) {
                    for (int tag = 0; tag < this.numSubStatesArray.length; tag = (int)((short)(tag + 1))) {
                        if (this.grammar.isGrammarTag(tag) || !(this.maxcScore[start2][start2 + 1][tag] > 0.0)) continue;
                        System.err.println("The maxcScore for word " + start2 + " is " + this.maxcScore[start2][start2 + 1][tag]);
                    }
                }
                return new Tree<String>("ROOT");
            }
            int lState = this.maxcLeftChild[start][end][state];
            int rState = this.maxcRightChild[start][end][state];
            Tree<String> leftChildTree = this.extractBestMaxRuleParse1(start, split, lState, sentence);
            Tree<String> rightChildTree = this.extractBestMaxRuleParse1(split, end, rState, sentence);
            children.add(leftChildTree);
            children.add(rightChildTree);
        }
        return new Tree<String>(stateStr, children);
    }

    @Override
    public void projectConstraints(boolean[][][][] allowed, boolean allSubstatesAllowed) {
        if (allowed == null) {
            return;
        }
        for (int start = 0; start < allowed.length; ++start) {
            for (int end = start + 1; end <= allowed.length; ++end) {
                for (int state = 0; state < this.numStates; ++state) {
                    if (allowed[start][end][state] == null || this.numSubStatesArray[state] == allowed[start][end][state].length) continue;
                    boolean[] tmp = new boolean[this.numSubStatesArray[state]];
                    if (allSubstatesAllowed) {
                        Arrays.fill(tmp, true);
                    } else {
                        for (int substate = 0; substate < allowed[start][end][state].length; ++substate) {
                            if (!allowed[start][end][state][substate]) continue;
                            if (2 * substate >= tmp.length) {
                                System.out.println("too long");
                            }
                            tmp[2 * substate] = true;
                            if (this.grammar.numSubStates[state] == 1) continue;
                            tmp[2 * substate + 1] = true;
                        }
                    }
                    allowed[start][end][state] = tmp;
                }
            }
        }
    }

    public void checkScores(Tree<StateSet> tree) {
        int newS;
        StateSet node;
        short from = node.from;
        short to = node.to;
        node = tree.getLabel();
        short state = node.getState();
        int oldS = this.iScale[from][to][state];
        if (oldS > (newS = ScalingTools.scaleArray(this.iScorePostU[from][to][state], oldS))) {
            System.out.println("why?? iscale");
        }
        if ((oldS = this.oScale[from][to][state]) > (newS = ScalingTools.scaleArray(this.oScorePostU[from][to][state], oldS))) {
            ScalingTools.scaleArrayToScale(this.oScorePostU[from][to][state], newS, oldS);
            System.out.println("why?? oscale");
        }
        for (int substate = 0; substate < this.numSubStatesArray[state]; ++substate) {
            if (node.getIScale() == this.iScale[from][to][state] && !SloppyMath.isGreater(this.iScorePostU[from][to][state][substate], node.getIScore(substate))) {
                if (!this.allowedSubStates[from][to][state][substate]) {
                    System.out.println("This state was pruned!");
                } else {
                    System.out.println("Gold iScore is higher for state " + state + " from " + from + " to " + to + "!");
                    System.out.println("Gold " + node.getIScore(substate) + " all " + this.iScorePostU[from][to][state][substate]);
                }
            }
            double tmpA = node.getOScore(substate);
            double tmpB = this.oScorePostU[from][to][state][substate];
            if (node.getOScale() != this.oScale[from][to][state] || SloppyMath.isGreater(tmpB, tmpA)) continue;
            if (!this.allowedSubStates[from][to][state][substate]) {
                System.out.println("This state was pruned!");
                continue;
            }
            System.out.println("Gold oScore is higher for state " + state + " from " + from + " to " + to + "!");
            System.out.println("Gold " + node.getOScore(substate) + " all " + this.oScorePostU[from][to][state][substate]);
        }
        for (Tree<StateSet> child : tree.getChildren()) {
            if (child.isLeaf()) continue;
            this.checkScores(child);
        }
    }

    public void tallyConditionalLoss(Tree<StateSet> tree, double[][][] deltas, double[][] mergeWeights) {
        int i;
        if (tree.isLeaf()) {
            return;
        }
        for (Tree<StateSet> child : tree.getChildren()) {
            this.tallyConditionalLoss(child, deltas, mergeWeights);
        }
        StateSet label = tree.getLabel();
        short state = label.getState();
        if (state == 0) {
            return;
        }
        short start = label.from;
        short end = label.to;
        if (this.allowedSubStates[start][end][state] == null) {
            System.out.println("Gold state was pruned!!!");
        }
        double[] goldScores = new double[label.numSubStates()];
        double[] allScores = new double[label.numSubStates()];
        double separatedGoldScoreSum = 0.0;
        double separatedAllScoreSum = 0.0;
        for (i = 0; i < label.numSubStates(); ++i) {
            double tmp;
            goldScores[i] = tmp = label.getIScore(i) * label.getOScore(i);
            separatedGoldScoreSum += tmp;
            allScores[i] = tmp = this.iScorePostU[start][end][state][i] * this.oScorePostU[start][end][state][i];
            separatedAllScoreSum += tmp;
        }
        if (separatedAllScoreSum == 0.0) {
            return;
        }
        for (i = 0; i < this.numSubStatesArray[state]; i += 2) {
            int k;
            int j = i + 1;
            double lossInGold = 0.0;
            double lossInAll = 0.0;
            int[] map = new int[]{i, j};
            double[] tmp1 = new double[2];
            double[] tmp2 = new double[2];
            double mergeWeightSum = 0.0;
            for (k = 0; k < 2; ++k) {
                mergeWeightSum += mergeWeights[state][map[k]];
            }
            if (mergeWeightSum == 0.0) {
                mergeWeightSum = 1.0;
            }
            for (k = 0; k < 2; ++k) {
                tmp1[k] = label.getIScore(map[k]) * mergeWeights[state][map[k]] / mergeWeightSum;
                tmp2[k] = label.getOScore(map[k]);
            }
            double combinedGoldScore = (tmp1[0] + tmp1[1]) * (tmp2[0] + tmp2[1]);
            double combinedGoldScoreSum = separatedGoldScoreSum - goldScores[i] - goldScores[j] + combinedGoldScore;
            if (combinedGoldScore != 0.0 && separatedGoldScoreSum != 0.0) {
                lossInGold = separatedGoldScoreSum / combinedGoldScoreSum;
            }
            for (int k2 = 0; k2 < 2; ++k2) {
                tmp1[k2] = this.iScorePostU[start][end][state][map[k2]] * mergeWeights[state][map[k2]] / mergeWeightSum;
                tmp2[k2] = this.oScorePostU[start][end][state][map[k2]];
            }
            double combinedAllScore = (tmp1[0] + tmp1[1]) * (tmp2[0] + tmp2[1]);
            double combinedAllScoreSum = separatedAllScoreSum - allScores[i] - allScores[j] + combinedAllScore;
            if (combinedGoldScore != 0.0 && separatedGoldScoreSum != 0.0) {
                lossInAll = separatedAllScoreSum / combinedAllScoreSum;
            }
            if (SloppyMath.isDangerous(lossInAll) || SloppyMath.isDangerous(lossInGold)) {
                System.out.println("too many zeros ");
                System.out.println("tmp1: " + Arrays.toString(tmp1) + "\ntmp2: " + Arrays.toString(tmp2) + "\ngoldScores: " + Arrays.toString(goldScores) + "\nallScores: " + Arrays.toString(allScores) + "\nmergeWeights: " + Arrays.toString(mergeWeights[state]) + "\nseparatedGoldScoreSum: " + separatedGoldScoreSum + "\nseparatedAllScoreSum: " + separatedAllScoreSum + "\ncombinedGoldScoreSum: " + combinedGoldScoreSum + "\ncombinedAllScoreSum: " + combinedAllScoreSum);
            } else {
                double[] dArray = deltas[state][i];
                int n = j;
                dArray[n] = dArray[n] + Math.log(lossInGold / lossInAll);
            }
            if (!Double.isNaN(deltas[state][i][j])) continue;
            System.out.println(" deltas[" + this.tagNumberer.object(state) + "][" + i + "][" + j + "] = NaN");
            System.out.println(Arrays.toString(tmp1) + " " + Arrays.toString(tmp2) + " " + combinedGoldScore + " " + Arrays.toString(mergeWeights[state]));
        }
    }

    private void setGoldProductions(Tree<StateSet> tree, boolean isBinaryChild) {
        StateSet node = tree.getLabel();
        short parentState = node.getState();
        if (parentState == 0) {
            this.goldBinaryProduction = new int[this.length][this.length + 1];
            ArrayUtil.fill(this.goldBinaryProduction, -1);
            this.goldUnaryParent = new int[this.length][this.length + 1];
            ArrayUtil.fill(this.goldUnaryParent, -1);
            this.goldUnaryChild = new int[this.length][this.length + 1];
            ArrayUtil.fill(this.goldUnaryChild, -1);
            this.goldPOS = new int[this.length];
            Arrays.fill(this.goldPOS, -1);
            this.goldUnaryParent[0][this.length] = 0;
        }
        if (isBinaryChild) {
            this.goldBinaryProduction[node.from][node.to] = parentState;
        } else if (parentState != 0) {
            this.goldUnaryChild[node.from][node.to] = parentState;
        }
        List<Tree<StateSet>> children = tree.getChildren();
        if (children.size() == 2) {
            this.goldBinaryProduction[node.from][node.to] = parentState;
            this.setGoldProductions(children.get(0), true);
            this.setGoldProductions(children.get(1), true);
        } else {
            Tree<StateSet> child = children.get(0);
            if (child.isLeaf()) {
                this.goldPOS[node.from] = parentState;
            } else {
                this.goldUnaryParent[node.from][node.to] = parentState;
                this.setGoldProductions(child, false);
            }
        }
    }

    public void doPreParses(List<String> sentence, List<String> posTags, Grammar[] grammarCascade, Lexicon[] lexiconCascade, boolean accurate, int startLevel, int endLevel, boolean isBaseline) {
        throw new Error("currently not supported");
    }

    protected void pruneChart(double threshold, int level) {
        int startDiff;
        int totalStates = 0;
        int previouslyPossible = 0;
        int nowPossible = 0;
        double sentenceProb = this.iScorePostU[0][this.length][0][0];
        double sentenceScale = this.iScale[0][this.length][0];
        if (level < 1) {
            totalStates = previouslyPossible = this.length;
            nowPossible = previouslyPossible;
        }
        for (int diff = startDiff = level < 0 ? 2 : 1; diff <= this.length; ++diff) {
            for (int start = 0; start < this.length - diff + 1; ++start) {
                int end = start + diff;
                int lastState = level < 0 ? 1 : this.numSubStatesArray.length;
                for (int state = 0; state < lastState; ++state) {
                    if (diff > 1 && !this.grammarTags[state] || this.allowedSubStates[start][end][state] == null) continue;
                    boolean nonePossible = true;
                    int thisScale = this.iScale[start][end][state] + this.oScale[start][end][state];
                    double scalingFactor = 1.0;
                    if ((double)thisScale != sentenceScale) {
                        scalingFactor *= Math.pow(ScalingTools.SCALE, (double)thisScale - sentenceScale);
                    }
                    for (int substate = 0; substate < this.numSubStatesArray[state]; ++substate) {
                        ++totalStates;
                        if (!this.allowedSubStates[start][end][state][substate]) continue;
                        ++previouslyPossible;
                        double iS = this.iScorePostU[start][end][state][substate];
                        double oS = this.oScorePostU[start][end][state][substate];
                        if (iS == 0.0 || oS == 0.0) {
                            this.allowedSubStates[start][end][state][substate] = false;
                            continue;
                        }
                        double posterior = iS * scalingFactor * oS / sentenceProb;
                        if (posterior > threshold) {
                            this.allowedSubStates[start][end][state][substate] = true;
                            ++nowPossible;
                            nonePossible = false;
                            continue;
                        }
                        this.allowedSubStates[start][end][state][substate] = false;
                    }
                    if (!nonePossible) continue;
                    this.allowedSubStates[start][end][state] = null;
                }
            }
        }
        String parse = "";
        parse = level == -1 ? "Pre-Parse" : (level == 0 ? "X-Bar" : (int)Math.pow(2.0, level) + "-Substates");
    }

    public double[][] getBracketPosteriors() {
        double tree_score = this.iScorePostU[0][this.length][0][0];
        int tree_scale = this.iScale[0][this.length][0];
        double[][] result = new double[this.length][this.length + 1];
        for (int start = 0; start < this.length; ++start) {
            for (int end = start + 1; end <= this.length; ++end) {
                int lastState = this.numSubStatesArray.length;
                for (int state = 0; state < lastState; ++state) {
                    if (this.allowedSubStates[start][end][state] == null) continue;
                    for (int substate = 0; substate < this.numSubStatesArray[state]; ++substate) {
                        double scalingFactor;
                        double oS;
                        double iS;
                        if (!this.allowedSubStates[start][end][state][substate] || (iS = this.iScorePostU[start][end][state][substate]) == 0.0 || (oS = this.oScorePostU[start][end][state][substate]) == 0.0 || (scalingFactor = ScalingTools.calcScaleFactor(this.oScale[start][end][state] + this.iScale[start][end][state] - tree_scale)) == 0.0) continue;
                        double tmp = Math.max(iS * this.oScorePreU[start][end][state][substate], this.iScorePreU[start][end][state][substate] * oS);
                        double posterior = tmp / tree_score * scalingFactor;
                        double[] dArray = result[start];
                        int n = end;
                        dArray[n] = dArray[n] + posterior;
                    }
                }
            }
        }
        return result;
    }

    public Tree<String> extractBestViterbiParse(int gState, int gp, int start, int end, List<String> sentence, boolean unaryAllowed) {
        double bestScore = unaryAllowed ? this.iScorePostU[start][end][gState][gp] : this.iScorePreU[start][end][gState][gp];
        String goalStr = (String)this.tagNumberer.object(gState);
        if (end - start == 1) {
            if (!this.grammar.isGrammarTag[gState]) {
                ArrayList child = new ArrayList();
                child.add(new Tree<String>(sentence.get(start)));
                return new Tree<String>(goalStr, child);
            }
            double veryBestScore = Double.NEGATIVE_INFINITY;
            int newIndex = -1;
            UnaryRule[] unaries = this.grammar.getClosedViterbiUnaryRulesByParent(gState);
            for (int r = 0; r < unaries.length; ++r) {
                UnaryRule ur = unaries[r];
                short cState = ur.childState;
                double[][] scores = ur.getScores2();
                for (int cp = 0; cp < scores.length; ++cp) {
                    double ruleScore;
                    if (scores[cp] == null || !((ruleScore = this.iScorePreU[start][end][cState][cp] * scores[cp][gp]) >= veryBestScore) || gState == cState && gp == cp || this.grammar.isGrammarTag[ur.getChildState()]) continue;
                    veryBestScore = ruleScore;
                    newIndex = cState;
                }
            }
            ArrayList child1 = new ArrayList();
            child1.add(new Tree<String>(sentence.get(start)));
            String goalStr1 = (String)this.tagNumberer.object(newIndex);
            if (goalStr1 == null) {
                System.out.println("goalStr1==null with newIndex==" + newIndex + " goalStr==" + goalStr);
            }
            ArrayList child = new ArrayList();
            child.add(new Tree<String>(goalStr1, child1));
            return new Tree<String>(goalStr, child);
        }
        for (int split = start + 1; split < end; ++split) {
            BinaryRule[] parentRules = this.grammar.splitRulesWithP(gState);
            for (int i = 0; i < parentRules.length; ++i) {
                short rState;
                BinaryRule br = parentRules[i];
                short lState = br.leftChildState;
                if (this.iScorePostU[start][split][lState] == null || this.iScorePostU[split][end][rState = br.rightChildState] == null) continue;
                double[][][] scores = br.getScores2();
                for (int lp = 0; lp < scores.length; ++lp) {
                    for (int rp = 0; rp < scores[lp].length; ++rp) {
                        double score;
                        if (scores[lp][rp] == null || !this.matches(score = ScalingTools.scaleToScale(scores[lp][rp][gp] * this.iScorePostU[start][split][lState][lp] * this.iScorePostU[split][end][rState][rp], this.iScale[start][split][lState] + this.iScale[split][end][rState], this.iScale[start][end][gState]), bestScore)) continue;
                        Tree<String> leftChildTree = this.extractBestViterbiParse(lState, lp, start, split, sentence, true);
                        Tree<String> rightChildTree = this.extractBestViterbiParse(rState, rp, split, end, sentence, true);
                        ArrayList children = new ArrayList();
                        children.add(leftChildTree);
                        children.add(rightChildTree);
                        Tree<String> result = new Tree<String>(goalStr, children);
                        return result;
                    }
                }
            }
        }
        UnaryRule[] unaries = this.grammar.getClosedViterbiUnaryRulesByParent(gState);
        for (int r = 0; r < unaries.length; ++r) {
            UnaryRule ur = unaries[r];
            short cState = ur.childState;
            if (this.iScorePostU[start][end][cState] == null) continue;
            double[][] scores = ur.getScores2();
            for (int cp = 0; cp < scores.length; ++cp) {
                if (scores[cp] == null) continue;
                double score = ScalingTools.scaleToScale(scores[cp][gp] * this.iScorePreU[start][end][cState][cp], this.iScale[start][end][cState], this.iScale[start][end][gState]);
                if (cState == ur.parentState && cp == gp || !this.matches(score, bestScore)) continue;
                Tree<String> childTree = this.extractBestViterbiParse(cState, cp, start, end, sentence, false);
                ArrayList children = new ArrayList();
                children.add(childTree);
                Tree<String> result = new Tree<String>(goalStr, children);
                return result;
            }
        }
        System.err.println("Warning: could not find the optimal way to build state " + goalStr + " spanning from " + start + " to " + end + ".");
        return null;
    }

    public double[][][][] getPreUnaryInsideScores() {
        return this.iScorePreU;
    }

    public double[][][][] getPostUnaryInsideScores() {
        return this.iScorePostU;
    }

    public double[][][][] getPreUnaryOutsideScores() {
        return this.oScorePreU;
    }

    public double[][][][] getPostUnaryOutsideScores() {
        return this.oScorePostU;
    }

    public int[][][] getInsideScalingFactors() {
        return this.iScale;
    }

    public int[][][] getOutsideScalingFactors() {
        return this.oScale;
    }
}

